/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.type;

import com.sapportals.htmlb.rendering.IPageContext;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.SortedMap;
import java.util.TreeMap;

public class DayRanges {
    public static final int SELECTION_MODE_NONE = -1;
    public static final int SELECTION_MODE_SELNOT = 0;
    public static final int SELECTION_MODE_IT1EMP = 1;
    public static final int SELECTION_MODE_IT2EMP = 2;
    public static final int SELECTION_MODE_IT3EMP = 3;
    public static final int SELECTION_MODE_IT4EMP = 4;
    private SortedMap days = new TreeMap();
    private Calendar calendar;
    private boolean localeUnknown = false;
    static final Comparator DATE_ORDER = new Comparator(){

        public int compare(Object o1, Object o2) {
            Date d1 = ((DayInfo)o1).date;
            Date d2 = ((DayInfo)o2).date;
            return d2.compareTo(d1);
        }
    };

    public DayRanges(IPageContext pc) {
        this.init(pc.getLocale());
    }

    public DayRanges() {
        this.init(Locale.getDefault());
        this.setLocaleUnknown(true);
    }

    public void setLocale(Locale l) {
        this.init(l);
    }

    private void init(Locale l) {
        this.calendar = Calendar.getInstance(l);
        this.calendar.set(2000, 1, 1, 0, 0, 0);
        this.calendar.set(14, 0);
    }

    public boolean isInRange(int day, int month, int year) {
        Date d = DayRanges.normalizeDate(this.calendar, this.getDate(day, month, year));
        return this.days.containsKey(d);
    }

    public boolean isInRange(Date date) {
        return this.days.containsKey(DayRanges.normalizeDate(this.calendar, date));
    }

    public Date getDate(int day, int month, int year) {
        this.calendar.set(year, month, day);
        return this.calendar.getTime();
    }

    public void add(Date day) {
        this.add(day, (String)null);
    }

    public void add(Date day, String tooltip) {
        this.add(day, day, tooltip, 1);
    }

    public void add(Date day, int selection) {
        this.add(day, day, null, selection);
    }

    public void add(Date day, String tooltip, int selection) {
        this.add(day, day, tooltip, selection);
    }

    public void add(Date begin, Date end) {
        this.add(begin, end, null, 1);
    }

    public void add(Date begin, Date end, String tooltip) {
        this.add(begin, end, tooltip, 1);
    }

    public void add(Date begin, Date end, int selection) {
        this.add(begin, end, null, selection);
    }

    public void add(Date begin, Date end, String tooltip, int selection) {
        Date cur = begin;
        this.calendar.setTime(cur);
        DayRanges.deleteTimeInfo(this.calendar);
        cur = this.calendar.getTime();
        while (cur.compareTo(end) <= 0) {
            this.days.put(cur, new DayInfo(cur, tooltip, selection));
            this.calendar.setTime(cur);
            this.calendar.add(5, 1);
            cur = this.calendar.getTime();
        }
    }

    public void addMonth(int month, int year) {
        this.addMonth(month, year, null, 1);
    }

    public void addMonth(int month, int year, String tooltip) {
        this.addMonth(month, year, tooltip, 1);
    }

    public void addMonth(int month, int year, int selection) {
        this.addMonth(month, year, null, selection);
    }

    public void addMonth(int month, int year, String tooltip, int selection) {
        Date cur = this.getDate(1, month, year);
        this.calendar.setTime(cur);
        do {
            this.days.put(this.calendar.getTime(), new DayInfo(this.calendar.getTime(), tooltip, selection));
            this.calendar.add(5, 1);
        } while (this.calendar.get(2) == month);
    }

    public void addWeek(int week, int year) {
        this.addWeek(week, year, null, 1);
    }

    public void addWeek(int week, int year, int selection) {
        this.addWeek(week, year, null, selection);
    }

    public void addWeek(int week, int year, String tooltip) {
        this.addWeek(week, year, tooltip, 1);
    }

    public void addWeek(int week, int year, String tooltip, int selection) {
        this.calendar.set(1, year);
        this.calendar.set(7, this.calendar.getFirstDayOfWeek());
        this.calendar.set(3, week);
        do {
            this.days.put(this.calendar.getTime(), new DayInfo(this.calendar.getTime(), tooltip, selection));
            this.calendar.add(5, 1);
        } while (this.calendar.get(3) == week);
    }

    public static void deleteTimeInfo(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    public static Date normalizeDate(Calendar calendar, Date date) {
        Date old = calendar.getTime();
        calendar.setTime(date);
        DayRanges.deleteTimeInfo(calendar);
        Date normalized = calendar.getTime();
        calendar.setTime(old);
        return normalized;
    }

    public int getSelectionMode(Date date) {
        DayInfo di = (DayInfo)this.days.get(date = DayRanges.normalizeDate(this.calendar, date));
        if (di == null) {
            return -1;
        }
        return di.selection;
    }

    public String getTooltip(Date date) {
        DayInfo di = (DayInfo)this.days.get(date = DayRanges.normalizeDate(this.calendar, date));
        if (di == null) {
            return null;
        }
        return di.tooltip;
    }

    void setTooltip(Date date, String tooltip) {
        if (!this.isInRange(date = DayRanges.normalizeDate(this.calendar, date))) {
            return;
        }
        this.add(date, tooltip);
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public boolean isLocaleUnknown() {
        return this.localeUnknown;
    }

    protected void setLocaleUnknown(boolean localeUnknown) {
        this.localeUnknown = localeUnknown;
    }

    private class DayInfo {
        public Date date;
        public String tooltip;
        public int selection;

        public DayInfo(Date date, String tooltip, int selection) {
            this.date = date;
            this.tooltip = tooltip;
            this.selection = selection;
        }
    }
}

