/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.type;

import com.sapportals.htmlb.util.Log;
import java.io.Serializable;
import java.util.GregorianCalendar;

public class Date
implements Comparable,
Serializable {
    int year;
    int month;
    int day;
    boolean valid = true;
    protected static int[] max_days_per_month = new int[]{0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    public Date() {
        GregorianCalendar currentDate = new GregorianCalendar();
        this.set(currentDate.get(1), currentDate.get(2) + 1, currentDate.get(5));
    }

    public Date(int year, int month, int day) {
        this.set(year, month, day);
    }

    public Date(long millisSinceEpoch) {
        this.set(millisSinceEpoch);
    }

    public Date(String dateString) {
        this.set(dateString);
    }

    public void set(java.util.Date utilDate) {
        if (utilDate != null) {
            this.set(utilDate.getTime());
        } else {
            this.set(0, 0, 0);
        }
    }

    public void set(long millisSinceEpoch) {
        GregorianCalendar date = new GregorianCalendar();
        date.setTime(new java.util.Date(millisSinceEpoch));
        this.set(date.get(1), date.get(2) + 1, date.get(5));
    }

    public void set(String dateString) {
        int year = -1;
        int month = -1;
        int day = -1;
        try {
            if (dateString.indexOf(45) >= 0) {
                year = Integer.parseInt(dateString.substring(0, 4));
                month = Integer.parseInt(dateString.substring(5, 7));
                day = Integer.parseInt(dateString.substring(8, 10));
            } else if (dateString.indexOf(47) >= 0) {
                int sep1 = dateString.indexOf(47);
                int sep2 = dateString.lastIndexOf(47);
                year = Integer.parseInt(dateString.substring(sep2 + 1));
                month = Integer.parseInt(dateString.substring(0, sep1));
                day = Integer.parseInt(dateString.substring(sep1 + 1, sep2));
            } else if (dateString.indexOf(46) >= 0) {
                int sep1 = dateString.indexOf(46);
                int sep2 = dateString.lastIndexOf(46);
                year = Integer.parseInt(dateString.substring(sep2 + 1));
                month = Integer.parseInt(dateString.substring(sep1 + 1, sep2));
                day = Integer.parseInt(dateString.substring(0, sep1));
            } else if (dateString.length() == 8) {
                year = Integer.parseInt(dateString.substring(0, 4));
                month = Integer.parseInt(dateString.substring(4, 6));
                day = Integer.parseInt(dateString.substring(6, 8));
            }
        }
        catch (NumberFormatException e) {
            Log.getLogLocation(false).debugT("Date", "set " + e.getMessage());
        }
        catch (StringIndexOutOfBoundsException e) {
            Log.getLogLocation(false).debugT("Date", "set" + e.getMessage());
        }
        this.set(year, month, day);
    }

    public static boolean isLeapYear(int year) {
        if (year % 400 == 0) {
            return true;
        }
        if (year % 100 == 0) {
            return false;
        }
        return year % 4 == 0;
    }

    private void set(int year, int month, int day) {
        try {
            if (year < 51) {
                year += 2000;
            } else if (year >= 51 && year < 100) {
                year += 1900;
            }
            if (year < 1800 || year > 9999) {
                throw new IllegalArgumentException("Argument year=" + year + " out of range.");
            }
            if (month < 1 || month > 12) {
                throw new IllegalArgumentException("Argument month=" + month + " out of range.");
            }
            if (day < 1 || day > max_days_per_month[month]) {
                throw new IllegalArgumentException("Argument day=" + day + " out of range.");
            }
            if (day == 29 && month == 2 && !Date.isLeapYear(year)) {
                throw new IllegalArgumentException("Argument day=" + day + " out of range (Feb, 29th but no leap year).");
            }
            this.year = year;
            this.month = month;
            this.day = day;
        }
        catch (IllegalArgumentException e) {
            this.year = 0;
            this.month = 0;
            this.day = 0;
            this.valid = false;
        }
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean useShort) {
        StringBuffer result = new StringBuffer(10);
        if (this.year < 1000) {
            result.append('0');
            if (this.year < 100) {
                result.append('0');
                if (this.year < 10) {
                    result.append('0');
                }
            }
        }
        result.append(this.year);
        if (!useShort) {
            result.append('-');
        }
        if (this.month < 10) {
            result.append('0');
        }
        result.append(this.month);
        if (!useShort) {
            result.append('-');
        }
        if (this.day < 10) {
            result.append('0');
        }
        result.append(this.day);
        return result.toString();
    }

    public String toShortString() {
        return this.toString(true);
    }

    public boolean equals(Object dateObject) {
        if (!(dateObject instanceof Date)) {
            return false;
        }
        return this.compareTo(dateObject) == 0;
    }

    public int compareTo(Object o) throws ClassCastException {
        if (o == null) {
            throw new ClassCastException("Given date must not be null");
        }
        Date that = (Date)o;
        if (!this.isValid()) {
            return -2;
        }
        if (!that.isValid()) {
            return -3;
        }
        if (this.year < that.year) {
            return -1;
        }
        if (this.year > that.year) {
            return 1;
        }
        if (this.month < that.month) {
            return -1;
        }
        if (this.month > that.month) {
            return 1;
        }
        if (this.day < that.day) {
            return -1;
        }
        if (this.day > that.day) {
            return 1;
        }
        return 0;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public java.util.Date getUtilDate() {
        return new GregorianCalendar(this.year, this.month - 1, this.day).getTime();
    }

    public boolean isValid() {
        return this.valid;
    }
}

