/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.type;

import com.sapportals.htmlb.enum.DataType;
import com.sapportals.htmlb.type.AbstractRangeType;
import com.sapportals.htmlb.type.Time;
import com.sapportals.htmlb.type.TypeFormatter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class DataTime
extends AbstractRangeType
implements Comparable,
Serializable {
    String userInput;
    Time value;

    public DataTime() {
    }

    public DataTime(String value) {
        this.setValue(value);
    }

    public DataTime(Time value) {
        this.setValue(value);
    }

    public DataTime(Date value) {
        this.setValue(value);
    }

    public boolean isLocaleSpecific() {
        return true;
    }

    public DataType getType() {
        return DataType.TIME;
    }

    public Time getValueAsTime() {
        return this.value;
    }

    public String toString() {
        if (this.value == null) {
            return "";
        }
        return this.value.toString();
    }

    public String toString(Locale locale) {
        if (this.value != null) {
            SimpleDateFormat formatter = (SimpleDateFormat)TypeFormatter.getFormat(locale, DataType.TIME);
            return formatter.format(this.value.getUtilDate());
        }
        return null;
    }

    public String getValueAsString() {
        if (this.value != null && this.value.isValid()) {
            return this.value.toString();
        }
        if (this.userInput != null) {
            return this.userInput;
        }
        return "00:00:00";
    }

    public void setValue(String value) {
        this.userInput = value;
        if (this.value == null) {
            this.value = new Time(value);
        } else {
            this.value.set(value);
        }
    }

    public void setValue(Date value) {
        if (this.value == null) {
            this.value = new Time();
        }
        this.value.set(value);
    }

    public void setValue(Time value) {
        this.value = value;
    }

    public boolean isValid() {
        if (this.value != null) {
            return this.value.isValid();
        }
        return false;
    }

    public void setValue(Object value) {
        if (value instanceof String) {
            this.setValue((String)value);
        } else if (value instanceof Time) {
            this.setValue((Time)value);
        } else if (value instanceof Date) {
            this.setValue((Date)value);
        } else {
            throw new IllegalArgumentException("DataTime doesn't support values of " + value.getClass().toString());
        }
    }

    public void setValue(Object value, Locale locale) {
        this.setValue(value);
    }

    public int compareTo(Object o) {
        if (o instanceof DataTime) {
            DataTime str = (DataTime)o;
            Time myValue = this.getValueAsTime();
            if (myValue != null) {
                return myValue.compareTo(str.getValueAsTime());
            }
            return 1;
        }
        throw new ClassCastException("DataTime can only be compared to objects of class DataTime");
    }
}

