/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.type;

import com.sapportals.htmlb.enum.DataType;
import com.sapportals.htmlb.type.AbstractRangeType;
import java.io.Serializable;

public class DataInteger
extends AbstractRangeType
implements Comparable,
Serializable {
    boolean valid;
    int value;
    String userValue;

    public DataInteger() {
    }

    public DataInteger(String value) {
        this.setValue(value);
    }

    public DataInteger(int value) {
        this.setValue(value);
    }

    public DataInteger(Integer value) {
        this.setValue(value);
    }

    public boolean isLocaleSpecific() {
        return false;
    }

    public DataType getType() {
        return DataType.INTEGER;
    }

    public String getValueAsString() {
        if (this.userValue != null) {
            return this.userValue;
        }
        return Integer.toString(this.value);
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.userValue = value;
        try {
            this.value = Integer.parseInt(value);
            this.valid = true;
        }
        catch (NumberFormatException nfe) {
            this.value = 0;
            this.valid = false;
        }
    }

    public void setValue(int value) {
        this.value = value;
        this.userValue = null;
        this.valid = true;
    }

    public void setValue(Integer value) {
        this.value = value;
        this.userValue = null;
        this.valid = true;
    }

    public void setValue(Object value) {
        if (value instanceof String) {
            this.setValue((String)value);
        } else if (value instanceof Integer) {
            this.setValue((Integer)value);
        } else {
            throw new IllegalArgumentException("DataInteger doesn't support values of " + value.getClass().toString());
        }
    }

    public String toString() {
        return this.getValueAsString();
    }

    public boolean isValid() {
        return this.valid;
    }

    public int compareTo(Object o) {
        if (o instanceof DataInteger) {
            int otherValue;
            int thisValue = this.getValue();
            if (thisValue == (otherValue = ((DataInteger)o).getValue())) {
                return 0;
            }
            if (thisValue < otherValue) {
                return -1;
            }
            return 1;
        }
        throw new ClassCastException("DataInteger can only be compared to objects of class DataInteger");
    }
}

