/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.type;

import com.sapportals.htmlb.enum.DataType;
import com.sapportals.htmlb.type.AbstractRangeType;
import com.sapportals.htmlb.type.Date;
import com.sapportals.htmlb.type.TypeFormatter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class DataDate
extends AbstractRangeType
implements Comparable,
Serializable {
    String userInput;
    Date value;

    public DataDate() {
    }

    public DataDate(String value) {
        this.setValue(value);
    }

    public DataDate(java.util.Date value) {
        this.setValue(value);
    }

    public DataDate(Date value) {
        this.setValue(value);
    }

    public boolean isLocaleSpecific() {
        return true;
    }

    public DataType getType() {
        return DataType.DATE;
    }

    public String toString() {
        return this.getValueAsString();
    }

    public String toString(Locale locale) {
        if (this.value != null) {
            if (this.value.isValid()) {
                SimpleDateFormat formatter = (SimpleDateFormat)TypeFormatter.getFormat(locale, DataType.DATE);
                return formatter.format(this.value.getUtilDate());
            }
            return null;
        }
        return null;
    }

    public Date getValue() {
        return this.value;
    }

    public String getValueAsString() {
        if (this.value != null) {
            return this.value.toString();
        }
        return "";
    }

    public String getValueAsShortString() {
        if (this.value != null) {
            return this.value.toShortString();
        }
        return "00000000";
    }

    public void setValue(String value) {
        this.userInput = value;
        if (this.value == null) {
            this.value = new Date(value);
        } else {
            this.value.set(value);
        }
    }

    public void setValue(java.util.Date value) {
        this.userInput = null;
        if (this.value == null) {
            this.value = new Date();
        }
        this.value.set(value);
    }

    public void setValue(Date value) {
        this.userInput = null;
        this.value = value;
    }

    public boolean isValid() {
        if (this.value != null) {
            return this.value.isValid();
        }
        return false;
    }

    public void setValue(Object value) {
        if (value instanceof String) {
            this.setValue((String)value);
        } else if (value instanceof java.util.Date) {
            this.setValue((java.util.Date)value);
        } else if (value instanceof Date) {
            this.setValue((Date)value);
        } else if (value == null) {
            this.setValue((Date)null);
        } else {
            throw new IllegalArgumentException("DataDate doesn't support values of " + value.getClass());
        }
    }

    public int compareTo(Object o) {
        if (o instanceof DataDate) {
            DataDate myDate = (DataDate)o;
            return this.getValueAsShortString().compareTo(myDate.getValueAsShortString());
        }
        throw new ClassCastException("A DataDate cannot be compared to " + o);
    }

    public String getInvalidUserInput() {
        if (this.isValid()) {
            return null;
        }
        return this.userInput;
    }
}

