/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.type;

import com.sapportals.htmlb.enum.DataType;
import com.sapportals.htmlb.type.AbstractRangeType;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public class DataBCD
extends AbstractRangeType
implements Comparable,
Serializable {
    BigDecimal value;
    String userValue;
    boolean valid = true;
    boolean localeSpecific = true;
    int fixedDecimals = -1;
    static final String NULLSTRING = "00000000000000000000000000000000000000000000000000";

    public DataBCD() {
    }

    public DataBCD(String value) {
        this.setValue(value);
    }

    public DataBCD(String value, Locale loc) {
        this.setValue(value, loc);
    }

    public DataBCD(double value) {
        this.setValue(value);
    }

    public DataBCD(BigDecimal value) {
        this.setValue(value);
    }

    public boolean isLocaleSpecific() {
        return this.localeSpecific;
    }

    public DataType getType() {
        return DataType.BCD;
    }

    public String getStringValue() {
        return this.userValue;
    }

    public String getValueAsString() {
        return this.userValue;
    }

    public BigDecimal getValueAsBigDecimal() {
        if (this.value != null) {
            return this.value;
        }
        return new BigDecimal("0");
    }

    public double getValueAsDouble() {
        return this.value.doubleValue();
    }

    public void setValue(String value) {
        this.userValue = value;
        try {
            this.value = new BigDecimal(value);
            this.valid = true;
        }
        catch (Exception e) {
            try {
                NumberFormat nf = NumberFormat.getInstance(Locale.US);
                Number n = nf.parse(value);
                this.setValue(n.doubleValue());
            }
            catch (ParseException e1) {
                try {
                    NumberFormat nf = NumberFormat.getInstance(Locale.GERMAN);
                    Number n = nf.parse(value);
                    this.setValue(n.doubleValue());
                }
                catch (ParseException e2) {
                    this.valid = false;
                }
            }
        }
    }

    public void setValue(String value, Locale loc) {
        this.userValue = value;
        try {
            NumberFormat nf = NumberFormat.getInstance(loc);
            Number n = nf.parse(value);
            this.setValue(n.doubleValue());
        }
        catch (ParseException e2) {
            try {
                this.value = new BigDecimal(value);
                this.valid = true;
            }
            catch (Exception e) {
                this.valid = false;
            }
        }
    }

    public void setValue(BigDecimal value) {
        this.value = value;
        this.valid = true;
        this.fixedDecimals = value.scale();
    }

    public void setValue(double value) {
        this.value = new BigDecimal(value);
        this.valid = true;
    }

    public void setValue(Double value) {
        this.setValue((double)value);
    }

    public void setValue(Object value) {
        if (value instanceof String) {
            this.setValue((String)value);
        } else if (value instanceof BigDecimal) {
            this.setValue((BigDecimal)value);
        } else if (value instanceof Double) {
            this.setValue((Double)value);
        } else {
            throw new IllegalArgumentException("DataBCD doesn't support values of " + value.getClass().toString());
        }
    }

    public String toString(Locale locale) {
        if (this.value != null) {
            if (this.localeSpecific) {
                NumberFormat nf = NumberFormat.getInstance(locale);
                nf.setMinimumFractionDigits(this.value.scale());
                return nf.format(this.value.doubleValue());
            }
            String string = this.value.toString();
            if (this.fixedDecimals > 0) {
                while (string.length() < this.fixedDecimals) {
                    string = NULLSTRING + string;
                }
                string = string.substring(string.length() - this.fixedDecimals);
            }
            return string;
        }
        return null;
    }

    public String toString() {
        if (this.value != null) {
            return this.value.toString();
        }
        return "0";
    }

    public boolean isValid() {
        return this.valid;
    }

    public int compareTo(Object o) {
        if (o instanceof DataBCD) {
            DataBCD myBCD = (DataBCD)o;
            return this.getValueAsBigDecimal().compareTo(myBCD.getValueAsBigDecimal());
        }
        throw new ClassCastException("DataBCD can only be compared to objects of class DataBCD");
    }
}

