/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.toolbar;

import com.sapportals.htmlb.EventValidationComponent;
import com.sapportals.htmlb.Form;
import com.sapportals.htmlb.enum.DataType;
import com.sapportals.htmlb.enum.ForcedTextDirection;
import com.sapportals.htmlb.enum.HorizontalTextAlignment;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.type.AbstractDataType;
import com.sapportals.htmlb.type.DataBCD;
import com.sapportals.htmlb.type.DataDate;
import com.sapportals.htmlb.type.DataInteger;
import com.sapportals.htmlb.type.DataString;
import com.sapportals.htmlb.type.DataTime;
import com.sapportals.htmlb.type.TypeFormatter;
import com.sapportals.htmlb.util.Log;
import com.sapportals.htmlb.validation.LengthValidator;
import com.sapportals.htmlb.validation.Validator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class ToolbarInputField
extends EventValidationComponent {
    public static final String UI_ID = "ToolbarInputField";
    private String id;
    private int maxLength;
    private String width;
    private Object value;
    private String labelText;
    boolean valueEncode;
    private HorizontalTextAlignment align;
    private ForcedTextDirection textDirection = ForcedTextDirection.INHERIT;

    public ToolbarInputField(String name) {
        this.setId(name);
        this.setHAlign(HorizontalTextAlignment.LEFT);
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    protected String getEncodedIdForForm(Form theForm) {
        String result = super.getEncodedIdForForm(theForm);
        if (this.value instanceof AbstractDataType) {
            String dataTypeId = Integer.toString(theForm.getIdForClass(this.value.getClass()));
            return result + "_" + dataTypeId;
        }
        return result;
    }

    protected void initFromShortId(IPageContext pc, String id) {
        int index;
        if (id != null && (index = id.indexOf("_")) >= 0) {
            this.value = null;
            String dataTypeId = id.substring(index + 1);
            try {
                int intId = Integer.parseInt(dataTypeId);
                Class dataClass = pc.getOldForm().getClassForId(intId);
                this.value = (AbstractDataType)dataClass.newInstance();
            }
            catch (NumberFormatException e) {
                Log.getLogLocation(false).debugT("TollbarInputField", "initFromShortId NumberFormatException " + e.getMessage());
            }
            catch (InstantiationException e) {
                Log.getLogLocation(false).debugT("TollbarInputField", "initFromShortId InstantiationException " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                Log.getLogLocation(false).debugT("TollbarInputField", "initFromShortId IllegalAccessException " + e.getMessage());
            }
        }
    }

    protected void initFromPageContext(IPageContext pc, String baseId) {
        String value = pc.getParameter(baseId);
        if (value != null) {
            if (this.value instanceof DataBCD) {
                ((DataBCD)this.value).setValue(value, pc.getLocale());
            } else if (this.value instanceof DataDate) {
                SimpleDateFormat sdf = (SimpleDateFormat)TypeFormatter.getFormat(pc.getLocale(), DataType.DATE);
                try {
                    Date d = sdf.parse(value);
                    ((DataDate)this.value).setValue(d);
                }
                catch (ParseException e) {
                    this.setValue(value);
                }
            } else {
                this.setValue(value);
            }
        }
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        if (this.value instanceof AbstractDataType) {
            ((AbstractDataType)this.value).setValue(value);
        } else if (value instanceof AbstractDataType) {
            if (this.value == null) {
                this.value = value;
            } else if (this.value.getClass().equals(value.getClass())) {
                this.value = value;
            } else {
                this.throwNewIllegalDataState();
            }
        } else {
            this.getString().setValue(value);
        }
    }

    public void setType(DataType type) {
        if (this.value == null) {
            this.value = AbstractDataType.getInstance(type);
        } else if (this.value instanceof AbstractDataType) {
            if (!type.equals(((AbstractDataType)this.value).getType())) {
                AbstractDataType newValue = AbstractDataType.getInstance(type);
                newValue.setValue(((AbstractDataType)this.value).toString());
                this.value = newValue;
            }
        } else {
            AbstractDataType newValue = AbstractDataType.getInstance(type);
            newValue.setValue(this.value);
            this.value = newValue;
        }
    }

    public DataType getType() {
        if (this.value instanceof AbstractDataType) {
            return ((AbstractDataType)this.value).getType();
        }
        return null;
    }

    public void setString(Object value) {
        if (value instanceof DataString && (this.value == null || this.value instanceof DataString)) {
            this.value = value;
            return;
        }
        this.getString().setValue(value);
    }

    public DataString getString() {
        if (this.value == null) {
            this.value = new DataString();
        }
        if (this.value instanceof DataString) {
            return (DataString)this.value;
        }
        this.throwNewIllegalDataState();
        return null;
    }

    public void setDate(Object date) {
        if (date instanceof DataDate && (this.value == null || this.value instanceof DataDate)) {
            this.value = date;
            return;
        }
        this.getDate().setValue(date);
    }

    public DataDate getDate() {
        if (this.value == null) {
            this.value = new DataDate();
        }
        if (this.value instanceof DataDate) {
            return (DataDate)this.value;
        }
        this.throwNewIllegalDataState();
        return null;
    }

    public void setTime(Object time) {
        if (time instanceof DataTime && (this.value == null || this.value instanceof DataTime)) {
            this.value = time;
            return;
        }
        this.getTime().setValue(time);
    }

    public DataTime getTime() {
        if (this.value == null) {
            this.value = new DataTime();
        }
        if (this.value instanceof DataTime) {
            return (DataTime)this.value;
        }
        this.throwNewIllegalDataState();
        return null;
    }

    public void setBCD(Object bcd) {
        if (bcd instanceof DataBCD && (this.value == null || this.value instanceof DataBCD)) {
            this.value = bcd;
            return;
        }
        this.getBCD().setValue(bcd);
    }

    public DataBCD getBCD() {
        if (this.value == null) {
            this.value = new DataBCD();
        }
        if (this.value instanceof DataBCD) {
            return (DataBCD)this.value;
        }
        this.throwNewIllegalDataState();
        return null;
    }

    public void setInteger(Object integer) {
        if (integer instanceof DataInteger && (this.value == null || this.value instanceof DataInteger)) {
            this.value = integer;
            return;
        }
        this.getInteger().setValue(integer);
    }

    public DataInteger getInteger() {
        if (this.value == null) {
            this.value = new DataInteger();
        }
        if (this.value instanceof DataInteger) {
            return (DataInteger)this.value;
        }
        this.throwNewIllegalDataState();
        return null;
    }

    private void throwNewIllegalDataState() {
        String name = null;
        if (this.value instanceof AbstractDataType) {
            name = "type " + ((AbstractDataType)this.value).getType().toString();
        } else if (this.value != null) {
            name = this.value.getClass().getName();
        }
        String s = "InputField is already defined for value of ";
        throw new IllegalStateException(s);
    }

    public AbstractDataType getValueAsDataType() {
        return (AbstractDataType)this.value;
    }

    public ArrayList getAllValidators() {
        Validator typeValidator = null;
        Validator appValidator = this.getValidator();
        int maxlength = this.getMaxLength();
        if (maxlength == 0 && this.getType() == DataType.STRING) {
            DataString string = (DataString)this.getValue();
            maxlength = string.getLength();
        }
        try {
            typeValidator = this.getValueAsDataType().getValidator();
        }
        catch (Exception ex) {
            Log.getLogLocation(false).debugT("TollbarInputField", "getAllValidators " + ex.getMessage());
        }
        if (typeValidator != null || appValidator != null) {
            ArrayList<Validator> list = new ArrayList<Validator>();
            if (maxlength > 0) {
                list.add(new LengthValidator(maxlength));
            }
            if (typeValidator != null) {
                list.add(typeValidator);
            }
            if (appValidator != null) {
                list.add(appValidator);
            }
            return list;
        }
        return null;
    }

    public String getLabelText() {
        return this.labelText;
    }

    public void setLabelText(String labelText) {
        this.labelText = labelText;
    }

    public String getUI() {
        return UI_ID;
    }

    public boolean getValueEncode() {
        return this.valueEncode;
    }

    public HorizontalTextAlignment getHAlign() {
        return this.align;
    }

    public void setHAlign(HorizontalTextAlignment align) {
        this.align = align;
    }

    public ForcedTextDirection getTextDirection() {
        return this.textDirection;
    }

    public void setTextDirection(ForcedTextDirection textDirection) {
        this.textDirection = textDirection;
    }
}

