/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.toolbar;

import com.sapportals.htmlb.DefaultListModel;
import com.sapportals.htmlb.EventValidationComponent;
import com.sapportals.htmlb.IListModel;
import com.sapportals.htmlb.enum.EventTrigger;
import com.sapportals.htmlb.event.Event;
import com.sapportals.htmlb.event.ListSelectEvent;
import com.sapportals.htmlb.rendering.IPageContext;
import java.util.Iterator;

public class ToolbarDropDownListBox
extends EventValidationComponent {
    public static final String UI_ID = "ToolbarDropDownListBox";
    private IListModel model;
    private String labelText;
    private boolean invalid;
    private String width;
    String onSelect;
    String onClientSelect;

    public ToolbarDropDownListBox(String name) {
        this.setId(name);
        this.setModel(this.createDefaultModel());
    }

    protected IListModel createDefaultModel() {
        DefaultListModel myModel = new DefaultListModel();
        myModel.setSingleSelection(true);
        return myModel;
    }

    public IListModel getModel() {
        return this.model;
    }

    public void setModel(IListModel model) {
        if (!model.isSingleSelection()) {
            throw new IllegalArgumentException("ToolbarDropdownListBox supports only single selection models");
        }
        this.model = model;
    }

    public boolean isSelected(String key) {
        return this.model.isSelected(key);
    }

    public String getSelection() {
        return this.model.getSingleSelection();
    }

    public void setSelection(String selection) {
        this.model.setSelection(selection);
    }

    public String getNameOfKeyColumn() {
        return this.model.getNameOfKeyColumn();
    }

    public void setNameOfKeyColumn(String nameOfKeyColumn) {
        this.model.setNameOfKeyColumn(nameOfKeyColumn);
    }

    public String getNameOfValueColumn() {
        return this.model.getNameOfTextColumn();
    }

    public void setNameOfValueColumn(String nameOfValueColumn) {
        this.model.setNameOfTextColumn(nameOfValueColumn);
    }

    public void addItem(String key, String text) {
        this.model.addItem(key, text);
    }

    public String getTextForKey(String key) {
        return this.model.getTextForKey(key);
    }

    public Iterator getKeys() {
        return this.model.getKeys();
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public Iterator getKeySet() {
        return this.model.getKeys();
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public void setInvalid(boolean invalid) {
        this.invalid = invalid;
    }

    public String getLabelText() {
        return this.labelText;
    }

    public void setLabelText(String labelText) {
        this.labelText = labelText;
    }

    public String getOnSelect() {
        Event event = this.getServerEvent(EventTrigger.ON_CHANGE);
        return event == null ? null : event.getAction();
    }

    public void setOnSelect(String onSelect) {
        ListSelectEvent listSelectEvent = new ListSelectEvent();
        listSelectEvent.setAction(onSelect);
        this.setServerEvent(EventTrigger.ON_CHANGE, listSelectEvent);
    }

    public String getOnClientSelect() {
        return this.getClientEvent(EventTrigger.ON_CHANGE);
    }

    public void setOnClientSelect(String onClientSelect) {
        this.setClientEvent(EventTrigger.ON_CHANGE, onClientSelect);
        this.setJsObjectNeeded(true);
    }

    public String getUI() {
        return UI_ID;
    }

    protected void initFromPageContext(IPageContext pc, String baseId) {
        this.setSelection(pc.getParameter(baseId));
    }
}

