/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.toolbar;

import com.sapportals.htmlb.EventValidationComponent;
import com.sapportals.htmlb.enum.EventTrigger;
import com.sapportals.htmlb.enum.ForcedTextDirection;
import com.sapportals.htmlb.event.ButtonClickEvent;
import com.sapportals.htmlb.event.Event;

public class ToolbarButton
extends EventValidationComponent {
    public static final String UI_ID = "ToolbarButton";
    private String id;
    private String text;
    private String tooltip;
    private boolean down;
    private String onClick;
    private String onClientClick;
    private String width;
    private String imageAlt = "";
    private ForcedTextDirection textDirection = ForcedTextDirection.INHERIT;

    public ToolbarButton(String id) {
        this.setId(id);
    }

    public ToolbarButton(String id, String text) {
        this.setId(id);
        this.setText(text);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public boolean getEnabled() {
        return this.isEnabled();
    }

    public String getOnClick() {
        Event event = this.getServerEvent(EventTrigger.ON_CLICK);
        return event == null ? null : event.getAction();
    }

    public void setOnClick(String onClick) {
        ButtonClickEvent buttonClickEvent = new ButtonClickEvent(onClick);
        buttonClickEvent.setAction(onClick);
        this.setServerEvent(EventTrigger.ON_CLICK, buttonClickEvent);
    }

    public String getOnClientClick() {
        return this.getClientEvent(EventTrigger.ON_CLICK);
    }

    public void setOnClientClick(String onClientClick) {
        this.setClientEvent(EventTrigger.ON_CLICK, onClientClick);
        this.setJsObjectNeeded(true);
    }

    public String getUI() {
        return UI_ID;
    }

    public String getImageAlt() {
        return this.imageAlt;
    }

    public void setImageAlt(String imageAlt) {
        this.imageAlt = imageAlt;
    }

    public ForcedTextDirection getTextDirection() {
        return this.textDirection;
    }

    public void setTextDirection(ForcedTextDirection textDirection) {
        this.textDirection = textDirection;
    }
}

