/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.toolbar;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.Container;
import com.sapportals.htmlb.enum.ToolbarDesign;
import com.sapportals.htmlb.toolbar.ToolbarButton;
import com.sapportals.htmlb.toolbar.ToolbarDropDownListBox;
import com.sapportals.htmlb.toolbar.ToolbarInputField;
import com.sapportals.htmlb.toolbar.ToolbarSeparator;

public class Toolbar
extends Container {
    public static final String UI_ID = "Toolbar";
    private String id;
    private ToolbarDesign design = ToolbarDesign.STANDARD;
    private String accessibilityDescription = "";

    public Toolbar(String name) {
        this.setId(name);
    }

    public Component addComponent(Component component) {
        if (component instanceof ToolbarButton || component instanceof ToolbarDropDownListBox || component instanceof ToolbarInputField || component instanceof ToolbarSeparator) {
            this.elements.add(component);
            component.setParent(this);
            return component;
        }
        throw new IllegalStateException("Only toolbaritems can be added to the toolbar.");
    }

    public ToolbarButton addToolbarButton(String id, String text) {
        return (ToolbarButton)this.addComponent(new ToolbarButton(id, text));
    }

    public ToolbarInputField addToolbarInputField(String id) {
        return (ToolbarInputField)this.addComponent(new ToolbarInputField(id));
    }

    public ToolbarSeparator addToolbarSeparator() {
        return (ToolbarSeparator)this.addComponent(new ToolbarSeparator());
    }

    public ToolbarDropDownListBox addToolbarDropDownListBox(String id) {
        return (ToolbarDropDownListBox)this.addComponent(new ToolbarDropDownListBox(id));
    }

    public ToolbarDesign getDesign() {
        return this.design;
    }

    public void setDesign(ToolbarDesign design) {
        this.design = design;
    }

    public String getUI() {
        return UI_ID;
    }

    public String getAccessibilityDescription() {
        return this.accessibilityDescription;
    }

    public void setAccessibilityDescription(String accessibilityDescription) {
        this.accessibilityDescription = accessibilityDescription == null ? "" : accessibilityDescription;
    }
}

