/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.taglib;

import com.sapportals.htmlb.HTMLFragment;
import com.sapportals.htmlb.Tree;
import com.sapportals.htmlb.TreeNode;
import com.sapportals.htmlb.enum.ForcedTextDirection;
import com.sapportals.htmlb.hovermenu.HoverMenu;
import com.sapportals.htmlb.taglib.AbstractContainerTag;
import com.sapportals.htmlb.taglib.TreeTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.TagSupport;

public final class TreeNodeTag
extends AbstractContainerTag {
    private String text;
    private boolean isOpen;
    private String tooltip;
    private Tree tree;
    private TreeNode node;
    private String hoverMenuId;

    public void setText(String text) {
        this.text = text;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public void setIsOpen(String isOpen) {
        this.isOpen = isOpen != null ? isOpen.toLowerCase().equals("true") : false;
    }

    public TreeNode getNode() {
        return this.node;
    }

    public String getHoverMenuId() {
        return this.hoverMenuId;
    }

    public void setHoverMenuId(String hoverMenuId) {
        this.hoverMenuId = hoverMenuId;
    }

    public void setTextDirection(String direction) {
        this.node.setTextDirection((ForcedTextDirection)this.convertToEnum("treeNode", "textDirection", direction, "com.sapportals.htmlb.enum.ForcedTextDirection", (Object)this));
    }

    public int doStartTag() throws JspException {
        TagSupport parentTagHandler = (TagSupport)this.getParent();
        this.node = new TreeNode(this.getId(), this.text, null, this.isOpen);
        if (this.tooltip != null && this.tooltip.length() > 0) {
            this.node.setTooltip(this.tooltip);
        }
        if (this.hoverMenuId != null) {
            HoverMenu menu = (HoverMenu)((TagSupport)this).pageContext.getAttribute(this.hoverMenuId);
            if (menu == null) {
                throw new JspException("cannot find a hover menu with the specified id " + this.hoverMenuId);
            }
            this.node.setHoverMenu(menu);
        }
        if (parentTagHandler instanceof TreeTag) {
            TreeTag treeTag = (TreeTag)parentTagHandler;
            this.tree = treeTag.getTree();
            this.tree.setRootNode(this.node);
        } else if (parentTagHandler instanceof TreeNodeTag) {
            TreeNodeTag treeNodeTag = (TreeNodeTag)parentTagHandler;
            TreeNode parentNode = treeNodeTag.getNode();
            parentNode.addChildNode(this.node);
        } else {
            throw new JspException("A treeNode must be nested in a tree!");
        }
        if (this.getId() != null && this.getId().length() > 0) {
            ((TagSupport)this).pageContext.setAttribute(this.getId(), (Object)this.node);
        }
        return 2;
    }

    public int doEndTag() throws JspTagException {
        BodyContent bc = this.getBodyContent();
        String htmlContent = null;
        if (bc != null) {
            htmlContent = bc.getString();
        }
        boolean isNoComponent = true;
        char myChar = ' ';
        char nonBSP = '\u00a0';
        int i = 1;
        while (isNoComponent && htmlContent.length() > i) {
            if (htmlContent.charAt(i) > myChar && htmlContent.charAt(i) != nonBSP) {
                isNoComponent = false;
            }
            ++i;
        }
        if (htmlContent != null && htmlContent.length() > 0 && !isNoComponent) {
            HTMLFragment component = new HTMLFragment(htmlContent);
            this.node.setComponent(component);
        }
        return 6;
    }
}

