/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.taglib;

import com.sapportals.htmlb.util.HtmlbRuntimeException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.servlet.jsp.PageContext;

final class TagUtil {
    private static Hashtable tagMetaData = new Hashtable(97);
    static /* synthetic */ Class class$java$lang$String;

    TagUtil() {
    }

    public static Class getControlClassForTagHandler(String tagHandlerClass, Object myObject) {
        String controlClassName = TagUtil.getControlClassNameForTagHandler(tagHandlerClass);
        if (controlClassName == null || controlClassName.length() == 0) {
            return null;
        }
        try {
            return Class.forName(controlClassName);
        }
        catch (Exception ex) {
            throw new HtmlbRuntimeException(ex, "Internal error: control class '" + controlClassName + "' not found");
        }
    }

    public static String getControlClassNameForTagHandler(String tagHandlerClass) {
        if (tagHandlerClass == null || tagHandlerClass.length() <= 28) {
            throw new HtmlbRuntimeException("Internal error: unknown tag handler class '" + tagHandlerClass + "'");
        }
        String className = tagHandlerClass.substring(28);
        if (className.equals("RendererContextTag") || className.equals("PageTag") || className.equals("HeadTag") || className.equals("DocumentTag") || className.equals("BodyTag") || className.equals("HeadIncludeTag")) {
            return null;
        }
        className = className.equals("TableViewTag") ? "com.sapportals.htmlb.table." + className.substring(0, className.length() - 3) : (className.equals("ToolbarTag") || className.equals("ToolbarSeparatorTag") || className.equals("ToolbarDropDownListBoxTag") || className.equals("ToolbarInputFieldTag") || className.equals("ToolbarButtonTag") ? "com.sapportals.htmlb.toolbar." + className.substring(0, className.length() - 3) : (className.equals("IsolatedHtmlContainerTag") || className.equals("NonIsolatedHtmlContainerTag") ? "com.sapportals.htmlb.htmlcontainer." + className.substring(0, className.length() - 3) : (className.equals("HoverMenuTag") || className.equals("HoverMenuItemTag") || className.equals("LinkForHoverMenuTag") ? "com.sapportals.htmlb.hovermenu." + className.substring(0, className.length() - 3) : "com.sapportals.htmlb." + className.substring(0, className.length() - 3))));
        return className;
    }

    public static boolean isValidJavaIdentifier(String myString) {
        if (myString != null && myString.length() > 0 && Character.isJavaIdentifierStart(myString.charAt(0))) {
            int i = 1;
            while (i < myString.length()) {
                if (!Character.isJavaIdentifierPart(myString.charAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static boolean convertToBoolean(String tagName, String propertyName, String propertyValue) {
        if (propertyValue.equalsIgnoreCase("true")) {
            return true;
        }
        if (propertyValue.equalsIgnoreCase("false")) {
            return false;
        }
        throw new HtmlbRuntimeException("Tag '" + tagName + "', attribute '" + propertyName + "': invalid value '" + propertyValue + "', must be an boolean");
    }

    public static int convertToInteger(String tagName, String propertyName, String propertyValue) {
        int value;
        try {
            value = Integer.parseInt(propertyValue);
        }
        catch (NumberFormatException ex) {
            throw new HtmlbRuntimeException(ex, "Tag '" + tagName + "', attribute '" + propertyName + "': invalid value '" + propertyValue + "', must be an integer");
        }
        if (value <= 0) {
            throw new HtmlbRuntimeException("Tag '" + tagName + "', attribute '" + propertyName + "': invalid value '" + propertyValue + "', must be > 0");
        }
        return value;
    }

    public static double convertToDouble(String tagName, String propertyName, String propertyValue) {
        double value;
        try {
            value = Double.parseDouble(propertyValue);
        }
        catch (NumberFormatException ex) {
            throw new HtmlbRuntimeException("Tag '" + tagName + "', attribute '" + propertyName + "': invalid value '" + propertyValue + "', must be a double");
        }
        return value;
    }

    public static Object convertToEnum(String tagName, String propertyName, String propertyValue, String enumClassName, Object myObject) {
        Object enumVal;
        try {
            Method getMethod = Class.forName(enumClassName).getMethod("getEnumByString", class$java$lang$String == null ? (class$java$lang$String = TagUtil.class$("java.lang.String")) : class$java$lang$String);
            enumVal = getMethod.invoke(null, (Object[])new String[]{propertyValue});
        }
        catch (Exception ex) {
            throw new HtmlbRuntimeException("Tag '" + tagName + "',attribute '" + propertyName + "': invalid value '" + propertyValue + "', must be a " + enumClassName);
        }
        if (enumVal == null) {
            throw new HtmlbRuntimeException("Tag '" + tagName + "',attribute '" + propertyName + "': invalid value '" + propertyValue + "', must be a " + enumClassName);
        }
        return enumVal;
    }

    public static Object getModel(PageContext tagPageContext, String tagName, String modelName) {
        Object model;
        String contextAttrName;
        int separatorIndex = modelName.indexOf(".");
        String propertyName = null;
        String methodName = null;
        if (separatorIndex > 0) {
            String beanName = modelName.substring(0, separatorIndex);
            propertyName = modelName.substring(separatorIndex + 1);
            methodName = "get" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
            contextAttrName = beanName;
        } else {
            contextAttrName = modelName;
        }
        Object contextAttr = tagPageContext.getAttribute(contextAttrName, 1);
        if (contextAttr == null && (contextAttr = tagPageContext.getAttribute(contextAttrName, 2)) == null && (contextAttr = tagPageContext.getAttribute(contextAttrName, 3)) == null && (contextAttr = tagPageContext.getAttribute(contextAttrName, 4)) == null) {
            throw new HtmlbRuntimeException("Tag '" + tagName + "', attribute 'model': Attribute '" + contextAttrName + "' not found in the context (page context, request, session, application)");
        }
        if (separatorIndex > 0) {
            Object myBean = contextAttr;
            try {
                Method getMethod = myBean.getClass().getMethod(methodName, new Class[0]);
                if (getMethod != null) {
                    model = getMethod.invoke(myBean, new Object[0]);
                }
                Field publicField = myBean.getClass().getField(propertyName);
                model = publicField.get(myBean);
            }
            catch (Exception ex) {
                throw new HtmlbRuntimeException(ex, "Tag '" + tagName + "', attribute 'model': Exception when accessing bean property '" + modelName + "'");
            }
        } else {
            model = contextAttr;
        }
        return model;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

