/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.taglib;

import com.sapportals.htmlb.GridLayout;
import com.sapportals.htmlb.GridLayoutCell;
import com.sapportals.htmlb.enum.CellHAlign;
import com.sapportals.htmlb.enum.CellVAlign;
import com.sapportals.htmlb.taglib.GridLayoutTag;
import com.sapportals.htmlb.taglib.TagUtil;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.TagSupport;

public final class GridLayoutCellTag
extends BodyTagSupport {
    private int rowIndex;
    private int columnIndex;
    private String verticalAlignment;
    private String horizontalAlignment;
    private String style;
    private String width;
    private String colSpan;
    private String id;
    private GridLayout gridLayout;
    private GridLayoutCell cell;

    public void setId(String id) {
        this.id = id;
    }

    public void setRowIndex(String rowIndex) {
        this.rowIndex = Integer.parseInt(rowIndex);
    }

    public void setColumnIndex(String columnIndex) {
        this.columnIndex = Integer.parseInt(columnIndex);
    }

    public void setVerticalAlignment(String verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public void setHorizontalAlignment(String horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public void setColSpan(String colspan) {
        this.colSpan = colspan;
    }

    public int doStartTag() throws JspException {
        TagSupport parentTagHandler;
        this.cell = new GridLayoutCell("");
        if (this.id != null) {
            this.cell.setId(this.id);
        }
        if (this.verticalAlignment != null) {
            this.cell.setVAlignment(CellVAlign.getEnumByString(this.verticalAlignment));
        }
        if (this.horizontalAlignment != null) {
            this.cell.setHAlignment(CellHAlign.getEnumByString(this.horizontalAlignment));
        }
        if (this.style != null) {
            this.cell.setStyle(this.style);
        }
        if (this.width != null) {
            this.cell.setWidth(this.width);
        }
        if (this.colSpan != null) {
            this.cell.setColSpan(TagUtil.convertToInteger("GridLayoutCell", "colspan", this.colSpan));
        }
        if (!((parentTagHandler = (TagSupport)this.getParent()) instanceof GridLayoutTag)) {
            throw new JspException("A gridLayoutCell must be nested in a gridLayout!");
        }
        GridLayoutTag gridLayoutTag = (GridLayoutTag)parentTagHandler;
        this.gridLayout = gridLayoutTag.getGridLayout();
        if (this.cell.getId() != null && this.cell.getId().length() > 0) {
            ((TagSupport)this).pageContext.setAttribute(this.cell.getId(), (Object)this.cell);
        }
        return 2;
    }

    public int doAfterBody() throws JspTagException {
        BodyContent bodyContent = this.getBodyContent();
        if (bodyContent != null) {
            this.cell.setContent(bodyContent.getString());
        }
        this.gridLayout.addCell(this.rowIndex, this.columnIndex, this.cell);
        return 0;
    }

    public int doEndTag() throws JspTagException {
        return 6;
    }
}

