/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.table;

import com.sapportals.htmlb.EventValidationContainer;
import com.sapportals.htmlb.enum.CellHAlign;
import com.sapportals.htmlb.enum.CellVAlign;
import com.sapportals.htmlb.enum.TableCellStyle;
import com.sapportals.htmlb.enum.TableColumnType;
import com.sapportals.htmlb.enum.TableNavigationMode;
import com.sapportals.htmlb.enum.TableSelectionMode;
import com.sapportals.htmlb.enum.TableViewDesign;
import com.sapportals.htmlb.event.EventModifierData;
import com.sapportals.htmlb.event.IEventModifier;
import com.sapportals.htmlb.hovermenu.HoverMenu;
import com.sapportals.htmlb.hovermenu.HoverMenuItem;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.table.DefaultCellRenderer;
import com.sapportals.htmlb.table.DefaultFooterRenderer;
import com.sapportals.htmlb.table.DefaultHeaderCellRenderer;
import com.sapportals.htmlb.table.DefaultHeaderRenderer;
import com.sapportals.htmlb.table.DefaultRowRenderer;
import com.sapportals.htmlb.table.ICellRenderer;
import com.sapportals.htmlb.table.IFooterRenderer;
import com.sapportals.htmlb.table.IHeaderCellRenderer;
import com.sapportals.htmlb.table.IHeaderRenderer;
import com.sapportals.htmlb.table.IRowRenderer;
import com.sapportals.htmlb.table.ReconstructedTableModel;
import com.sapportals.htmlb.table.SpanInfo;
import com.sapportals.htmlb.table.TableColumn;
import com.sapportals.htmlb.table.TableViewEventData;
import com.sapportals.htmlb.table.TableViewModel;
import com.sapportals.htmlb.toolbar.Toolbar;
import com.sapportals.htmlb.type.AbstractDataType;
import com.sapportals.htmlb.util.DefaultHtmlbEncoder;
import com.sapportals.htmlb.util.IndexedLinkedList;
import com.sapportals.htmlb.util.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

public class TableView
extends EventValidationContainer
implements IEventModifier {
    public static final String UI_ID = "TableView";
    public static final int VAR_BEGIN = 1;
    public static final int VAR_BEGINHEAD = 2;
    public static final int VAR_BEGINHEADCELL = 3;
    public static final int VAR_ENDHEADCELL = 4;
    public static final int VAR_ENDHEAD = 5;
    public static final int VAR_BEGINCONTENT = 6;
    public static final int VAR_BEGINCONTROW = 7;
    public static final int VAR_BEGINCONTCELL = 8;
    public static final int VAR_ENDCONTCELL = 9;
    public static final int VAR_ENDCONTROW = 10;
    public static final int VAR_ENDCONTENT = 11;
    public static final int VAR_BEGINFOOTER = 12;
    public static final int VAR_FOOTERNAVIGATION = 13;
    public static final int VAR_FOOTERPOSITION = 14;
    public static final int VAR_ENDFOOTER = 15;
    public static final int VAR_END = 16;
    public static final int VAR_BEGINHEADTITLE = 17;
    public static final int VAR_ENDHEADTITLE = 18;
    public static final int VAR_BEGINCOLUMNHEADERS = 19;
    public static final int VAR_ENDCOLUMNHEADERS = 20;
    public static final String selectAll = "selectAll";
    public static final String deselectAll = "deselectAll";
    public static final String invertSelection = "invertSelection";
    public static final String tableViewOptionMenuModifier = "_TABLEVIEW_OPTIONMENU";
    private static final ICellRenderer cvDefaultCellRenderer = new DefaultCellRenderer();
    private static final IHeaderRenderer cvDefaultHeaderRenderer = new DefaultHeaderRenderer();
    private static final IHeaderCellRenderer cvDefaultHeaderCellRenderer = new DefaultHeaderCellRenderer();
    private static final IRowRenderer cvDefaultRowRenderer = new DefaultRowRenderer();
    private static final IFooterRenderer cvDefaultFooterRenderer = new DefaultFooterRenderer();
    TableViewModel tableViewModel;
    TableViewDesign design;
    boolean headerVisible;
    boolean footerVisible;
    boolean cellHeaderVisible;
    boolean fillUpEmptyRows;
    boolean hasKeyColumn;
    TableNavigationMode navigationMode;
    TableSelectionMode selectionMode;
    int visibleFirstRow;
    int visibleRowCount;
    int rowCount;
    int columnCount;
    String headerText;
    String width;
    String onNavigate;
    String onHeaderClick;
    String onRowSelection;
    String onClientRowSelection;
    private String emptyTableText;
    private String summary;
    private HoverMenu optionMenu;
    private String onSelectAll = "selectAll";
    private String onDeselectAll = "deselectAll";
    private String onInvertSelection = "invertSelection";
    private CellHAlign tableHAlignment;
    protected ArrayList columns;
    transient int colspanForCurrentColumn;
    transient int currentRowIndex;
    transient int currentColumnIndex;
    IRowRenderer tableRowRenderer;
    ICellRenderer tableCellRenderer;
    ICellRenderer userTypeCellRenderer;
    IHeaderRenderer headerRenderer;
    IHeaderCellRenderer headerCellRenderer;
    IFooterRenderer footerRenderer;
    private String formId;
    private HashSet rowsToSelect;
    private HashSet selectableRows;
    HashMap colspanBuffer;
    HashMap rowspanBuffer;
    HashMap spanInfoBuffer;
    HashMap styleBuffer;
    private Toolbar toolbar;
    private boolean isHeaderCellWrapping = true;
    private String accessibilityDescription = "";
    private HashMap rowDescription = new HashMap(25);

    public TableView(String id) {
        super(id);
        this.initializeTable();
    }

    public TableView(String id, TableViewModel tableViewModel) {
        super(id);
        this.tableViewModel = tableViewModel;
        this.initializeTable();
    }

    public String getUI() {
        return UI_ID;
    }

    public IRowRenderer getRowRenderer(int rowIndex) {
        if (this.tableRowRenderer == null) {
            this.tableRowRenderer = cvDefaultRowRenderer;
        }
        return this.tableRowRenderer;
    }

    public void setRowRenderer(IRowRenderer tableRowRenderer) {
        this.tableRowRenderer = tableRowRenderer;
    }

    public ICellRenderer getCellRenderer(int row, int column) {
        if (this.getColumn(column).getCellType(row).equals(TableColumnType.USER) && this.userTypeCellRenderer != null) {
            return this.userTypeCellRenderer;
        }
        if (this.tableCellRenderer == null) {
            this.tableCellRenderer = cvDefaultCellRenderer;
        }
        return this.tableCellRenderer;
    }

    public void setCellRenderer(ICellRenderer tableCellRenderer) {
        this.tableCellRenderer = tableCellRenderer;
    }

    public IHeaderCellRenderer getHeaderCellRenderer(int column) {
        if (this.headerCellRenderer == null) {
            this.headerCellRenderer = cvDefaultHeaderCellRenderer;
        }
        return this.headerCellRenderer;
    }

    public void setHeaderCellRenderer(IHeaderCellRenderer headerCellRenderer) {
        this.headerCellRenderer = headerCellRenderer;
    }

    public void setFooterRenderer(IFooterRenderer footerRenderer) {
        this.footerRenderer = footerRenderer;
    }

    public void setUserTypeCellRenderer(ICellRenderer userTypeCellRenderer) {
        this.userTypeCellRenderer = userTypeCellRenderer;
    }

    public IHeaderRenderer getHeaderRenderer() {
        if (this.headerRenderer == null) {
            this.headerRenderer = cvDefaultHeaderRenderer;
        }
        return this.headerRenderer;
    }

    public void setHeaderRenderer(IHeaderRenderer headerRenderer) {
        this.headerRenderer = headerRenderer;
    }

    public IFooterRenderer getFooterRenderer() {
        if (this.footerRenderer == null) {
            this.footerRenderer = cvDefaultFooterRenderer;
        }
        return this.footerRenderer;
    }

    public Vector getColumns() {
        return this.tableViewModel.getColumns();
    }

    public void setColumnAt(TableColumn column, int columnIndex) {
        this.getColumns().setElementAt(column, columnIndex);
    }

    public TableColumn getColumn(int columnIndex) {
        Vector columns = this.getColumns();
        if (!columns.isEmpty()) {
            return (TableColumn)columns.get(columnIndex - 1);
        }
        return null;
    }

    public TableColumn getColumn(String columnKey) {
        int columnCount = this.getColumnCount();
        if (!this.getColumns().isEmpty()) {
            int index = this.getColumnIndex(columnKey);
            if (index > 0) {
                return this.getColumn(index);
            }
            return null;
        }
        return null;
    }

    private int getColumnIndex(String columnKey) {
        int columnCount = this.getColumnCount();
        if (!this.getColumns().isEmpty()) {
            String columnIdentifier;
            int i = 0;
            do {
                columnIdentifier = this.getColumnIdentifier(++i);
            } while (i < columnCount && !columnIdentifier.equals(columnKey));
            if (i == columnCount && !columnIdentifier.equals(columnKey)) {
                return 0;
            }
            return i;
        }
        return 0;
    }

    public String getColumnName(int columnIndex) {
        return this.tableViewModel.getColumnName(columnIndex);
    }

    public void setColumnName(String columnName, int columnIndex) {
        this.tableViewModel.setColumnName(columnName, columnIndex);
    }

    public TableColumnType getColumnType(int columnIndex) {
        return this.getColumn(columnIndex).getType();
    }

    public void setColumnType(TableColumnType columnType, int columnIndex) {
        this.getColumn(columnIndex).setType(columnType);
    }

    public TableViewDesign getDesign() {
        if (this.design == null) {
            return TableViewDesign.STANDARD;
        }
        return this.design;
    }

    public void setDesign(TableViewDesign design) {
        this.design = design;
    }

    public String getHeaderText() {
        if (this.headerText == null) {
            return "";
        }
        return this.headerText;
    }

    public void setHeaderText(String headerText) {
        this.headerText = headerText;
    }

    public boolean isFillUpEmptyRows() {
        return this.fillUpEmptyRows;
    }

    public String getEmptyTableText() {
        return this.emptyTableText;
    }

    public void setEmptyTableText(String emptyTableText) {
        this.emptyTableText = emptyTableText;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public CellHAlign getTableHAlignment() {
        return this.tableHAlignment;
    }

    public void setTableHAlignment(CellHAlign tableHAlignment) {
        this.tableHAlignment = tableHAlignment;
    }

    public void setFillUpEmptyRows(boolean fillUpEmptyRows) {
        this.fillUpEmptyRows = fillUpEmptyRows;
    }

    public int getColumnCount() {
        return this.tableViewModel.getColumnCount();
    }

    public void setColumnCount(int columnCount) {
        this.columnCount = columnCount;
    }

    public int getRowCount() {
        if (this.tableViewModel != null) {
            return this.tableViewModel.getRowCount();
        }
        return 0;
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    public int getVisibleFirstRow() {
        return this.visibleFirstRow;
    }

    public void setVisibleFirstRow(int visibleFirstRow) {
        this.visibleFirstRow = visibleFirstRow > 0 ? visibleFirstRow : 1;
    }

    public int getVisibleRowCount() {
        if (this.visibleRowCount != 0) {
            return this.visibleRowCount;
        }
        return this.getRowCount();
    }

    public void setVisibleRowCount(int visibleRowCount) {
        this.visibleRowCount = visibleRowCount > 0 ? visibleRowCount : this.getRowCount();
    }

    public boolean isHeaderVisible() {
        return this.headerVisible;
    }

    public void setHeaderVisible(boolean headerVisible) {
        this.headerVisible = headerVisible;
    }

    public boolean isFooterVisible() {
        return this.footerVisible;
    }

    public void setFooterVisible(boolean footerVisible) {
        this.footerVisible = footerVisible;
    }

    public boolean isCellHeaderVisible() {
        return this.cellHeaderVisible;
    }

    public void setCellHeaderVisible(boolean cellHeaderVisible) {
        this.cellHeaderVisible = cellHeaderVisible;
    }

    public boolean isCellDisabled(int rowIndex, int columnIndex) {
        return this.getColumn(columnIndex).isCellDisabled(rowIndex);
    }

    public void setCellDisabled(int rowIndex, int columnIndex, boolean disabled) {
        if (columnIndex <= 0) {
            throw new IllegalArgumentException("The parameter columnIndex should be greater than 0");
        }
        TableColumn tc = this.getColumn(columnIndex);
        tc.setCellDisabled(rowIndex, disabled);
    }

    public boolean isCellInvalid(int rowIndex, int columnIndex) {
        return this.getColumn(columnIndex).isCellInvalid(rowIndex);
    }

    public void setCellInvalid(int rowIndex, int columnIndex, boolean invalid) {
        if (columnIndex <= 0) {
            throw new IllegalArgumentException("The parameter columnIndex should be greater than 0");
        }
        TableColumn tc = this.getColumn(columnIndex);
        tc.setCellInvalid(rowIndex, invalid);
    }

    public void setColumnInvisible(String columnKey) {
        this.getModel().removeColumn(columnKey);
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public TableViewModel getModel() {
        return this.tableViewModel;
    }

    public void setModel(TableViewModel tableViewModel) {
        this.tableViewModel = tableViewModel;
    }

    public AbstractDataType getValueAt(int row, int column) {
        return this.tableViewModel.getValueAt(row, column);
    }

    public AbstractDataType getValueAt(int row, String columnName) {
        return this.tableViewModel.getValueAt(row, columnName);
    }

    public int getVisibleLastRow() {
        return this.visibleFirstRow + this.visibleRowCount - 1;
    }

    public String getOnNavigate() {
        return this.onNavigate;
    }

    public void setOnHeaderClick(String onHeaderClick) {
        this.onHeaderClick = onHeaderClick;
    }

    public String getOnRowSelection() {
        return this.onRowSelection;
    }

    public void setOnRowSelection(String onRowSelection) {
        this.onRowSelection = onRowSelection;
    }

    public String getOnClientRowSelection() {
        return this.onClientRowSelection;
    }

    public void setOnClientRowSelection(String onClientRowSelection) {
        this.onClientRowSelection = onClientRowSelection;
    }

    public void setOnCellClick(int columnIndex, String onCellClick) {
        TableColumn tc = this.getColumn(columnIndex);
        if (tc != null) {
            tc.setOnCellClick(onCellClick);
        }
    }

    public void setOnCellClick(String columnKey, String onCellClick) {
        TableColumn tc = this.getColumn(columnKey);
        if (tc != null) {
            tc.setOnCellClick(onCellClick);
        }
    }

    public void setOnClientCellClick(int columnIndex, String onClientCellClick) {
        TableColumn tc = this.getColumn(columnIndex);
        if (tc != null) {
            tc.setOnClientCellClick(onClientCellClick);
        }
    }

    public void setOnClientCellClick(String columnKey, String onClientCellClick) {
        TableColumn tc = this.getColumn(columnKey);
        if (tc != null) {
            tc.setOnClientCellClick(onClientCellClick);
        }
    }

    public String getOnHeaderClick() {
        return this.onHeaderClick;
    }

    public void setOnNavigate(String onNavigate) {
        this.onNavigate = onNavigate;
    }

    public TableNavigationMode getNavigationMode() {
        return this.navigationMode;
    }

    public void setNavigationMode(TableNavigationMode navigationMode) {
        this.navigationMode = navigationMode;
    }

    public TableSelectionMode getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionMode(TableSelectionMode selectionMode) {
        this.selectionMode = selectionMode;
    }

    private void setFormId(String formId) {
        this.formId = formId;
    }

    public String getFormId() {
        return this.formId;
    }

    protected void initFromPageContext(IPageContext pc, String baseId) {
        String oldFormId = pc.getParamIdForComponent(this.getId());
        try {
            int selectedRowCount;
            boolean lHasKeyColumn;
            DefaultHtmlbEncoder encoder = new DefaultHtmlbEncoder();
            String paramValue = pc.getParameter(oldFormId + "-keys");
            encoder.prepareDecoding(paramValue);
            int visibleRowCount = encoder.getIntProperty();
            int firstVisible = encoder.getIntProperty();
            int rowCount = encoder.getIntProperty();
            String selectionMode = encoder.getStringProperty();
            this.setVisibleFirstRow(firstVisible);
            this.setVisibleRowCount(visibleRowCount);
            if (selectionMode.equals(TableSelectionMode.MULTISELECT.toString()) || selectionMode.equals(TableSelectionMode.MULTISELECTWITHOPTIONS.toString()) || selectionMode.equals(TableSelectionMode.MULTISELECTWITHDEFAULTOPTIONS.toString())) {
                this.hasKeyColumn = lHasKeyColumn = encoder.getBooleanProperty();
                selectedRowCount = encoder.getIntProperty();
                int i = 0;
                while (i < selectedRowCount) {
                    int selectedRow = encoder.getIntProperty();
                    this.selectRow(selectedRow, true);
                    ++i;
                }
                int i2 = 1;
                while (i2 <= visibleRowCount) {
                    paramValue = pc.getParameter(oldFormId + "-chk" + Integer.toString(i2));
                    if (paramValue != null) {
                        int row;
                        if (paramValue.equalsIgnoreCase("true")) {
                            row = i2 + firstVisible - 1;
                            if (!this.isRowSelected(row)) {
                                this.selectRow(row, true);
                            }
                        } else {
                            row = i2 + firstVisible - 1;
                            if (this.isRowSelected(row)) {
                                this.selectRow(row, false);
                            }
                        }
                    }
                    ++i2;
                }
            } else if (selectionMode.equals(TableSelectionMode.SINGLESELECT.toString())) {
                this.hasKeyColumn = lHasKeyColumn = encoder.getBooleanProperty();
                selectedRowCount = encoder.getIntProperty();
                if (selectedRowCount > 0) {
                    int oldSelectedRow = encoder.getIntProperty();
                    paramValue = pc.getParameter(oldFormId + "-chk");
                    if (paramValue != null && paramValue.length() > 0) {
                        int row = Integer.parseInt(paramValue) + firstVisible - 1;
                        if (row != oldSelectedRow) {
                            this.selectRow(row, true);
                            this.selectRow(oldSelectedRow, false);
                        } else {
                            this.selectRow(oldSelectedRow, true);
                        }
                    } else {
                        this.selectRow(oldSelectedRow, true);
                    }
                } else {
                    paramValue = pc.getParameter(oldFormId + "-chk");
                    if (paramValue != null && paramValue.length() > 0) {
                        int row = Integer.parseInt(paramValue) + firstVisible - 1;
                        this.selectRow(row, true);
                    }
                }
            }
            ReconstructedTableModel reconstructedModel = new ReconstructedTableModel();
            reconstructedModel.rowCount = rowCount;
            IndexedLinkedList keyColumn = reconstructedModel.getKeyColumn();
            Vector columns = reconstructedModel.getColumns();
            int visibleColumnCount = encoder.getIntProperty();
            reconstructedModel.setVisibleColumnCount(visibleColumnCount);
            int i = 1;
            while (i <= visibleColumnCount) {
                String columnName = encoder.getStringProperty();
                reconstructedModel.addColumnName(columnName);
                ++i;
            }
            int numKeys = encoder.getIntProperty();
            if (numKeys == 0) {
                int i3 = 1;
                while (i3 <= numKeys) {
                    keyColumn.put(i3, Integer.toString(i3));
                    ++i3;
                }
            } else if (numKeys == rowCount) {
                int i4 = 1;
                while (i4 <= numKeys) {
                    String key = encoder.getStringProperty();
                    keyColumn.put(i4, key);
                    ++i4;
                }
            } else {
                int i5 = 1;
                while (i5 <= numKeys) {
                    String key = encoder.getStringProperty();
                    keyColumn.put(i5 + this.visibleFirstRow - 1, key);
                    ++i5;
                }
            }
            encoder.finishDecoding();
            this.tableViewModel = reconstructedModel;
        }
        catch (IOException e) {
            Log.getLogLocation(false).debugT(UI_ID, "IOException " + e.getMessage());
        }
    }

    public String encodeInternalData() {
        try {
            DefaultHtmlbEncoder encoder = new DefaultHtmlbEncoder();
            Vector columns = this.getColumns();
            int rowCount = this.getRowCount();
            encoder.prepareEncoding();
            int visibleRowCount = this.getVisibleRowCount();
            int firstVisible = this.getVisibleFirstRow();
            int visibleColumnCount = this.getColumns() != null ? this.getColumns().size() : 0;
            encoder.addProperty(visibleRowCount);
            encoder.addProperty(firstVisible);
            encoder.addProperty(rowCount);
            TableSelectionMode selectionMode = this.getSelectionMode();
            encoder.addProperty(selectionMode.toString());
            if (!selectionMode.equals(TableSelectionMode.NONE)) {
                if (this.hasKeyColumn) {
                    encoder.addProperty(true);
                } else {
                    encoder.addProperty(false);
                }
                if (this.rowsToSelect != null && !this.rowsToSelect.isEmpty()) {
                    Iterator rowIterator = this.rowsToSelect.iterator();
                    if (selectionMode.equals(TableSelectionMode.SINGLESELECT)) {
                        encoder.addProperty(1);
                        encoder.addProperty((Integer)rowIterator.next());
                    } else {
                        encoder.addProperty(this.rowsToSelect.size());
                        while (rowIterator.hasNext()) {
                            encoder.addProperty((Integer)rowIterator.next());
                        }
                    }
                } else {
                    encoder.addProperty(0);
                }
            }
            encoder.addProperty(visibleColumnCount);
            if (columns != null && columns.size() != 0) {
                int i = 1;
                while (i <= visibleColumnCount) {
                    encoder.addProperty(this.getColumn(i).getIdentifier());
                    ++i;
                }
            }
            this.visibleFirstRow = firstVisible;
            this.visibleRowCount = visibleRowCount;
            IndexedLinkedList keyColumn = this.getKeyColumn();
            if (keyColumn != null) {
                if (this.getSelectionMode().equals(TableSelectionMode.NONE)) {
                    encoder.addProperty(visibleRowCount);
                    int i = 1;
                    while (i <= visibleRowCount) {
                        int rowIndex = i + firstVisible - 1;
                        String value = null;
                        if (rowIndex <= rowCount) {
                            value = keyColumn.get(rowIndex).toString();
                        }
                        encoder.addProperty(value);
                        ++i;
                    }
                } else {
                    encoder.addProperty(rowCount);
                    int i = 1;
                    while (i <= rowCount) {
                        String value = null;
                        value = keyColumn.get(i).toString();
                        encoder.addProperty(value);
                        ++i;
                    }
                }
            } else {
                encoder.addProperty(0);
            }
            return encoder.getEncodedString();
        }
        catch (IOException e) {
            Log.getLogLocation(false).debugT(UI_ID, "IOException " + e.getMessage());
            return null;
        }
    }

    public String getRowKey(int rowIndex) {
        Object result = null;
        IndexedLinkedList keyColumn = this.getKeyColumn();
        if (keyColumn != null && !keyColumn.isEmpty()) {
            result = keyColumn.get(rowIndex);
        }
        if (result != null) {
            return result.toString();
        }
        return Integer.toString(rowIndex);
    }

    public void setLinkColumnKey(String linkRefColumnName, int columnIndex) {
        this.getColumn(columnIndex).setLinkColumnKey(linkRefColumnName);
    }

    public void setLinkColumnKey(String linkRefColumnName, String columnName) {
        this.getColumn(columnName).setLinkColumnKey(linkRefColumnName);
    }

    public CellHAlign getCellHAlignment(int rowIndex, int columnIndex) {
        TableColumn tc = this.getColumn(columnIndex);
        return tc.getCellHAlignment(rowIndex);
    }

    public void setCellHAlignment(int rowIndex, int columnIndex, CellHAlign hAlignment) {
        if (columnIndex >= 0) {
            TableColumn tc = this.getColumn(columnIndex);
            tc.setCellHAlignment(rowIndex, hAlignment);
        } else {
            Vector cols = this.getColumns();
            int i = 0;
            while (i < cols.size()) {
                TableColumn column = (TableColumn)cols.elementAt(i);
                column.setCellHAlignment(rowIndex, hAlignment);
                ++i;
            }
        }
    }

    public TableColumnType getCellType(int rowIndex, int columnIndex) {
        TableColumn tc = this.getColumn(columnIndex);
        return tc.getCellType(rowIndex);
    }

    public void setCellType(int rowIndex, int columnIndex, TableColumnType type) {
        if (columnIndex >= 0) {
            TableColumn tc = this.getColumn(columnIndex);
            tc.setCellType(rowIndex, type);
        }
    }

    public void setColumnHAlignment(int columnIndex, CellHAlign hAlignment) {
        this.setCellHAlignment(-1, columnIndex, hAlignment);
    }

    public CellVAlign getCellVAlignment(int rowIndex, int columnIndex) {
        TableColumn tc = this.getColumn(columnIndex);
        return tc.getCellVAlignment(rowIndex);
    }

    public void setCellVAlignment(int rowIndex, int columnIndex, CellVAlign vAlignment) {
        if (columnIndex >= 0) {
            this.getColumn(columnIndex).setCellVAlignment(rowIndex, vAlignment);
        } else {
            Vector cols = this.getColumns();
            int i = 0;
            while (i < cols.size()) {
                TableColumn column = (TableColumn)cols.elementAt(i);
                column.setCellVAlignment(rowIndex, vAlignment);
                ++i;
            }
        }
    }

    public void setRowVAlignment(int rowIndex, CellVAlign vAlignment) {
        this.setCellVAlignment(rowIndex, -1, vAlignment);
    }

    public void setColumnVAlignment(int columnIndex, CellVAlign vAlignment) {
        if (columnIndex > 0) {
            TableColumn column = this.getColumn(columnIndex);
            int rowCount = this.getRowCount();
            int i = 1;
            while (i <= rowCount) {
                column.setCellVAlignment(i, vAlignment);
                ++i;
            }
        }
    }

    public int getColspanForCell(int rowIndex, int columnIndex) {
        if (this.colspanBuffer == null) {
            return 1;
        }
        Integer result = null;
        String row = Integer.toString(rowIndex);
        String col = Integer.toString(columnIndex);
        String key = "R" + row + "C" + col;
        result = (Integer)this.colspanBuffer.get(key);
        if (result == null) {
            return 1;
        }
        return result;
    }

    public void setColspanForCell(int rowIndex, int columnIndex, int colspan) {
        if (this.colspanBuffer == null) {
            this.colspanBuffer = new HashMap();
        }
        String key = "R";
        if (rowIndex <= 0) {
            throw new IllegalArgumentException("Row index must be greater than 0");
        }
        key = key.concat(Integer.toString(rowIndex));
        if (columnIndex <= 0) {
            throw new IllegalArgumentException("Column index must be greater than 0");
        }
        key = key.concat("C" + Integer.toString(columnIndex));
        this.colspanBuffer.put(key, new Integer(colspan));
    }

    public int getRowspanForCell(int rowIndex, int columnIndex) {
        if (this.rowspanBuffer == null) {
            return 1;
        }
        Integer result = null;
        String row = Integer.toString(rowIndex);
        String col = Integer.toString(columnIndex);
        String key = "R" + row + "C" + col;
        result = (Integer)this.rowspanBuffer.get(key);
        if (result == null) {
            return 1;
        }
        return result;
    }

    public void setRowspanForCell(int rowIndex, int columnIndex, int rowspan) {
        if (this.rowspanBuffer == null) {
            this.rowspanBuffer = new HashMap();
        }
        if (this.spanInfoBuffer == null) {
            this.spanInfoBuffer = new HashMap();
        }
        String key = "R";
        if (rowIndex <= 0) {
            throw new IllegalArgumentException("Row index must be greater than 0");
        }
        key = key.concat(Integer.toString(rowIndex));
        if (columnIndex <= 0) {
            throw new IllegalArgumentException("Column index must be greater than 0");
        }
        key = key.concat("C" + Integer.toString(columnIndex));
        this.rowspanBuffer.put(key, new Integer(rowspan));
    }

    public TableCellStyle getStyleForCell(int rowIndex, int columnIndex) {
        if (this.styleBuffer == null) {
            return null;
        }
        TableCellStyle result = null;
        String row = Integer.toString(rowIndex);
        String col = Integer.toString(columnIndex);
        String key = "R" + row + "C" + col;
        result = (TableCellStyle)this.styleBuffer.get(key);
        if (result == null && (result = (TableCellStyle)this.styleBuffer.get("RC" + col)) == null) {
            result = (TableCellStyle)this.styleBuffer.get("R" + row);
        }
        return result;
    }

    public void setStyleForCell(int rowIndex, int columnIndex, TableCellStyle style) {
        if (this.styleBuffer == null) {
            this.styleBuffer = new HashMap();
        }
        String key = "R";
        if (rowIndex >= 0) {
            key = key.concat(Integer.toString(rowIndex));
        }
        if (columnIndex >= 0) {
            key = key.concat("C" + Integer.toString(columnIndex));
        }
        this.styleBuffer.put(key, style);
    }

    public void setRowSelectable(int rowIndex, boolean selectable) {
        if (!selectable) {
            if (this.selectableRows == null) {
                this.selectableRows = new HashSet();
            }
            this.selectableRows.add(new Integer(rowIndex));
        } else if (this.selectableRows != null) {
            this.selectableRows.remove(new Integer(rowIndex));
        }
    }

    public boolean isRowSelectable(int rowIndex) {
        if (this.selectableRows == null) {
            return true;
        }
        return !this.selectableRows.contains(new Integer(rowIndex));
    }

    public void setRowSelection(int rowIndex) {
        this.selectRow(rowIndex, true);
    }

    public void selectRow(int rowIndex, boolean isSelected) {
        if (isSelected) {
            if (this.rowsToSelect == null) {
                this.rowsToSelect = new HashSet();
            }
            this.rowsToSelect.add(new Integer(rowIndex));
        } else if (this.rowsToSelect != null) {
            this.rowsToSelect.remove(new Integer(rowIndex));
        }
    }

    public boolean isRowSelected(int rowIndex) {
        if (this.rowsToSelect != null) {
            return this.rowsToSelect.contains(new Integer(rowIndex));
        }
        return false;
    }

    public void setKeyColumn(int columnIndex) {
        this.getModel().setKeyColumn(columnIndex);
        this.hasKeyColumn = true;
    }

    public void addKeyColumn(int columnIndex) {
        this.getModel().addKeyColumn(columnIndex);
        this.hasKeyColumn = true;
    }

    public SpanInfo getSpanInfoForCell(int rowIndex, int columnIndex) {
        if (this.spanInfoBuffer != null && !this.spanInfoBuffer.isEmpty()) {
            String key = "R" + rowIndex + "C" + columnIndex;
            return (SpanInfo)this.spanInfoBuffer.get(key);
        }
        return null;
    }

    public void prepareSpanInfoBuffer() {
        HashMap rowspanBuffer;
        if (this.spanInfoBuffer == null) {
            this.spanInfoBuffer = new HashMap();
        }
        if ((rowspanBuffer = this.getRowspanBuffer()) != null && !rowspanBuffer.isEmpty()) {
            HashMap colspanBuffer = this.getColspanBuffer();
            Iterator iterator = rowspanBuffer.keySet().iterator();
            while (iterator.hasNext()) {
                String key = iterator.next().toString();
                int indexR = key.indexOf("R");
                int indexC = key.indexOf("C");
                int rowIndex = Integer.parseInt(key.substring(indexR + 1, indexC));
                int columnIndex = Integer.parseInt(key.substring(indexC + 1));
                int rowspan = (Integer)rowspanBuffer.get(key);
                if (rowspan <= 1) continue;
                if (colspanBuffer != null && colspanBuffer.get(key) != null) {
                    int colspan;
                    int tempColspan = colspan = ((Integer)colspanBuffer.get(key)).intValue();
                    int tempRowspan = rowspan;
                    if (colspan <= 1) continue;
                    int i = 0;
                    while (i < tempRowspan) {
                        int j = 0;
                        while (j < tempColspan) {
                            SpanInfo spanInfo = new SpanInfo(rowspan, colspan, rowIndex, columnIndex);
                            --colspan;
                            String newKey = "R" + (rowIndex + i) + "C" + (columnIndex + j);
                            if (this.spanInfoBuffer.put(newKey, spanInfo) != null) {
                                throw new IllegalStateException("rowspan and colspan must not overlap");
                            }
                            ++j;
                        }
                        --rowspan;
                        colspan = tempColspan;
                        ++i;
                    }
                    continue;
                }
                int tempRowspan = rowspan;
                int i = 0;
                while (i < tempRowspan) {
                    SpanInfo spanInfo = new SpanInfo(rowspan, 1, rowIndex, columnIndex);
                    --rowspan;
                    String newKey = "R" + (rowIndex + i) + "C" + columnIndex;
                    if (this.spanInfoBuffer.put(newKey, spanInfo) != null) {
                        throw new IllegalStateException("rowspan and colspan must not overlap");
                    }
                    ++i;
                }
            }
        }
    }

    private IndexedLinkedList getKeyColumn() {
        return this.getModel().getKeyColumn();
    }

    private void initializeTable() {
        this.visibleFirstRow = 1;
        this.setNavigationMode(TableNavigationMode.BYPAGE);
        this.setSelectionMode(TableSelectionMode.NONE);
        this.setHeaderVisible(true);
        this.setFooterVisible(true);
        this.setCellHeaderVisible(true);
        this.setHeaderText("");
    }

    public EventModifierData getEventModifierData() {
        int row = this.getCurrentRowIndex();
        if (row >= 0) {
            TableViewEventData result = new TableViewEventData();
            result.setRow(row);
            return result;
        }
        return null;
    }

    private String getColumnIdentifier(int columnIndex) {
        return this.getColumn(columnIndex).getIdentifier();
    }

    public String getComponentIdModifier() {
        int row = this.getCurrentRowIndex();
        if (row >= 0) {
            return "_a" + row;
        }
        return "";
    }

    public int getCurrentRowIndex() {
        return this.currentRowIndex;
    }

    public void setCurrentRowIndex(int currentRowIndex) {
        this.currentRowIndex = currentRowIndex;
    }

    public int getCurrentColumnIndex() {
        return this.currentColumnIndex;
    }

    public void setCurrentColumnIndex(int currentColumnIndex) {
        this.currentColumnIndex = currentColumnIndex;
    }

    public int getColspanForCurrentColumn() {
        return this.colspanForCurrentColumn;
    }

    public void setColspanForCurrentColumn(int colspanForCurrentColumn) {
        this.colspanForCurrentColumn = colspanForCurrentColumn;
    }

    private HashMap getRowspanBuffer() {
        return this.rowspanBuffer;
    }

    private HashMap getColspanBuffer() {
        return this.colspanBuffer;
    }

    public int getCurrentPageIndex() {
        boolean isLastRowVisible;
        int rowCount = this.getRowCount();
        boolean bl = isLastRowVisible = this.getVisibleLastRow() == rowCount;
        if (!isLastRowVisible) {
            return (this.getVisibleFirstRow() - 1) / this.getVisibleRowCount() + 1;
        }
        if (rowCount % this.visibleRowCount == 0) {
            return rowCount / this.visibleRowCount;
        }
        return rowCount / this.visibleRowCount + 1;
    }

    HashSet getRowSelection() {
        return this.rowsToSelect;
    }

    public void useRowSelection(TableView table) {
        if (table != null) {
            HashSet oldSelection = table.getRowSelection();
            if (this.hasKeyColumn && table.hasKeyColumn && oldSelection != null) {
                Iterator it = oldSelection.iterator();
                while (it.hasNext()) {
                    this.selectRow(table.getRowKey((Integer)it.next()));
                }
            } else {
                this.rowsToSelect = oldSelection;
            }
        } else {
            this.rowsToSelect = null;
        }
    }

    private void selectRow(String rowKey) {
        int i = 1;
        while (i <= this.getRowCount() && !this.getRowKey(i).equals(rowKey)) {
            ++i;
        }
        this.selectRow(i, true);
    }

    public String getOnSelectAll() {
        return this.onSelectAll;
    }

    public void setOnSelectAll(String onSelectAll) {
        this.onSelectAll = onSelectAll;
    }

    public String getOnDeselectAll() {
        return this.onDeselectAll;
    }

    public void setOnDeselectAll(String onDeselectAll) {
        this.onDeselectAll = onDeselectAll;
    }

    public String getOnInvertSelection() {
        return this.onInvertSelection;
    }

    public void setOnInvertSelection(String onInvertSelection) {
        this.onInvertSelection = onInvertSelection;
    }

    public HoverMenu getOptionMenu(Locale locale) {
        TableSelectionMode selectionMode = this.getSelectionMode();
        if (selectionMode == TableSelectionMode.MULTISELECTWITHOPTIONS || selectionMode == TableSelectionMode.MULTISELECTWITHDEFAULTOPTIONS) {
            if (this.optionMenu == null) {
                ResourceBundle bundle = this.getResourceBundle(locale);
                String tableId = this.getId();
                this.optionMenu = new HoverMenu(tableId + tableViewOptionMenuModifier);
                HoverMenuItem item = this.optionMenu.addMenuItem(tableId + "_" + selectAll, bundle.getString("TXT_HTMLB_TBV_SELECT_ALL"));
                item.setOnItemClick(this.getOnSelectAll());
                HoverMenuItem item2 = this.optionMenu.addMenuItem(tableId + "_" + deselectAll, bundle.getString("TXT_HTMLB_TBV_DESELECT_ALL"));
                item2.setOnItemClick(this.getOnDeselectAll());
                if (selectionMode == TableSelectionMode.MULTISELECTWITHOPTIONS) {
                    HoverMenuItem item3 = this.optionMenu.addMenuItem(tableId + "_" + invertSelection, bundle.getString("TXT_HTMLB_TBV_INVERTSELECT"));
                    item3.setOnItemClick(this.getOnInvertSelection());
                    item3.setHoverItemDivider(true);
                }
                this.optionMenu.setFirstLevelVisible(false);
            }
            return this.optionMenu;
        }
        return null;
    }

    private ResourceBundle getResourceBundle(Locale locale) {
        ResourceBundle result = null;
        try {
            result = ResourceBundle.getBundle("com.sapportals.htmlb.Localization", locale);
        }
        catch (Exception e) {
            Log.getLogLocation(false).debugT(UI_ID, "MissingResourceException " + e.getMessage());
        }
        return result;
    }

    public void setToolbar(Toolbar toolbar) {
        this.toolbar = toolbar;
    }

    public Toolbar getToolbar() {
        return this.toolbar;
    }

    public boolean isHeaderCellWrapping() {
        return this.isHeaderCellWrapping;
    }

    public void setHeaderCellWrapping(boolean headerCellWrapping) {
        this.isHeaderCellWrapping = headerCellWrapping;
    }

    public String getAccessibilityDescription() {
        return this.accessibilityDescription;
    }

    public void setAccessibilityDescription(String accessibilityDescription) {
        this.accessibilityDescription = accessibilityDescription == null ? "" : accessibilityDescription;
    }

    public void setRowDescription(String accessibilityDescription, int row) {
        this.rowDescription.put("r" + row, accessibilityDescription);
    }

    public String getRowDescription(int row) {
        String description = null;
        if (this.rowDescription.containsKey("r" + row)) {
            description = (String)this.rowDescription.get("r" + row);
        }
        if (description == null) {
            description = "";
        }
        return description;
    }
}

