/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.table;

import com.sapportals.htmlb.DragSource;
import com.sapportals.htmlb.DropTarget;
import com.sapportals.htmlb.enum.CellHAlign;
import com.sapportals.htmlb.enum.CellVAlign;
import com.sapportals.htmlb.enum.DataType;
import com.sapportals.htmlb.enum.DropTargetDesign;
import com.sapportals.htmlb.enum.Scope;
import com.sapportals.htmlb.enum.TableColumnType;
import com.sapportals.htmlb.enum.TableSortState;
import com.sapportals.htmlb.table.TableViewModel;
import com.sapportals.htmlb.type.AbstractDataType;
import com.sapportals.htmlb.type.DataString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class TableColumn {
    private TableViewModel model;
    private String identifier;
    private String title;
    private String width;
    private String linkColumnKey;
    private String tooltipColumnKey;
    private String onCellClick;
    private String onClientCellClick;
    private String onItemClick;
    private String unitColumnKey;
    private boolean isAppendUnit;
    private String linkClickTarget;
    private DataType dataType;
    private boolean wrapping;
    private boolean encode;
    private boolean encodeHeaderCell;
    private String tooltipForColumnHeader;
    HashMap alignmentBuffer;
    HashSet disabledCellsBuffer;
    HashSet invalidCellsBuffer;
    HashMap typeBuffer;
    private boolean isMonospaced;
    private DragSource dragSource = new DragSource("");
    private DropTarget dropTarget = new DropTarget("");
    private boolean dragable = false;
    private TableSortState sortState;
    private String onHeaderSort;

    public TableColumn(TableViewModel model, String title) {
        this(model, title, title, TableColumnType.TEXT);
    }

    public TableColumn(TableViewModel model, String title, String identifier) {
        this(model, title, identifier, TableColumnType.TEXT);
    }

    public TableColumn(TableViewModel model, String title, String identifier, TableColumnType type) {
        this(model, title, identifier, type, DataType.STRING);
    }

    public TableColumn(TableViewModel model, String title, String identifier, TableColumnType type, DataType dataType) {
        this(model, title, identifier, type, dataType, null);
    }

    public TableColumn(TableViewModel model, String title, String identifier, TableColumnType type, DataType dataType, String width) {
        this(model, title, identifier, type, dataType, width, null);
    }

    public TableColumn(TableViewModel model, String title, String identifier, TableColumnType type, DataType dataType, String width, String linkColumnKey) {
        this(model, title, identifier, type, dataType, width, linkColumnKey, true);
    }

    public TableColumn(TableViewModel model, String title, String identifier, TableColumnType type, DataType dataType, String width, String linkColumnKey, boolean wrapping) {
        this(model, title, identifier, type, dataType, width, linkColumnKey, wrapping, null);
    }

    public TableColumn(TableViewModel model, String title, String identifier, TableColumnType type, DataType dataType, String width, String linkColumnKey, boolean wrapping, String onItemClick) {
        this.model = model;
        this.setTitle(title);
        this.setIdentifier(identifier);
        this.setType(type);
        this.setDataType(dataType);
        this.setWidth(width);
        this.setLinkColumnKey(linkColumnKey);
        this.setWrapping(wrapping);
        this.setOnItemClick(onItemClick);
        this.setEncode(true);
        this.setEncodeHeaderCell(true);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public TableColumnType getType() {
        return this.getCellType(-1);
    }

    public void setType(TableColumnType type) {
        this.setCellType(-1, type);
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getLinkColumnKey() {
        return this.linkColumnKey;
    }

    public void setLinkColumnKey(String linkColumnKey) {
        this.linkColumnKey = linkColumnKey;
    }

    public String getTooltipColumnKey() {
        return this.tooltipColumnKey;
    }

    public void setTooltipColumnKey(String tooltipColumnKey) {
        this.tooltipColumnKey = tooltipColumnKey;
    }

    public String getUnitColumnKey() {
        return this.unitColumnKey;
    }

    public void setUnitColumnKey(String unitColumnKey) {
        this.unitColumnKey = unitColumnKey;
    }

    public void setAppendUnit(boolean useIt) {
        this.isAppendUnit = useIt;
        if (useIt) {
            this.model.removeColumn(this.unitColumnKey);
        }
    }

    public boolean isEncode() {
        return this.encode;
    }

    public void setEncode(boolean encode) {
        this.encode = encode;
    }

    public boolean isEncodeHeaderCell() {
        return this.encodeHeaderCell;
    }

    public void setEncodeHeaderCell(boolean encodeHeaderCell) {
        this.encodeHeaderCell = encodeHeaderCell;
    }

    public String getLinkClickTarget() {
        return this.linkClickTarget;
    }

    public void setLinkClickTarget(String linkClickTarget) {
        this.linkClickTarget = linkClickTarget;
    }

    public String getOnCellClick() {
        return this.onCellClick;
    }

    public void setOnCellClick(String onCellClick) {
        this.onCellClick = onCellClick;
    }

    public void setOnClientCellClick(String onClientCellClick) {
        this.onClientCellClick = onClientCellClick;
    }

    public String getOnClientCellClick() {
        return this.onClientCellClick;
    }

    public boolean isWrapping() {
        return this.wrapping;
    }

    public void setWrapping(boolean wrapping) {
        this.wrapping = wrapping;
    }

    public String getOnItemClick() {
        return this.onItemClick;
    }

    public void setOnItemClick(String onItemClick) {
        this.onItemClick = onItemClick;
    }

    public AbstractDataType getValueAt(int row) {
        if (this.isAppendUnit && this.unitColumnKey != null) {
            return new DataString(this.model.getValueAt(row, this.identifier).toString() + this.model.getValueAt(row, this.unitColumnKey).toString());
        }
        return this.model.getValueAt(row, this.identifier);
    }

    public CellVAlign getCellVAlignment(int rowIndex) {
        if (this.alignmentBuffer == null) {
            return null;
        }
        CellVAlign result = null;
        String row = Integer.toString(rowIndex);
        String key = "V" + row;
        result = (CellVAlign)this.alignmentBuffer.get(key);
        if (result == null) {
            result = (CellVAlign)this.alignmentBuffer.get("V");
        }
        return result;
    }

    public void setCellVAlignment(int rowIndex, CellVAlign vAlignment) {
        if (this.alignmentBuffer == null) {
            this.alignmentBuffer = new HashMap();
        }
        String key = "V";
        if (rowIndex >= 0) {
            key = key.concat(Integer.toString(rowIndex));
        }
        this.alignmentBuffer.put(key, vAlignment);
    }

    public CellHAlign getCellHAlignment(int rowIndex) {
        if (this.alignmentBuffer == null) {
            return null;
        }
        CellHAlign result = null;
        String row = Integer.toString(rowIndex);
        String key = "H" + row;
        result = (CellHAlign)this.alignmentBuffer.get(key);
        if (result == null) {
            result = (CellHAlign)this.alignmentBuffer.get("H");
        }
        return result;
    }

    public void setCellHAlignment(int rowIndex, CellHAlign hAlignment) {
        if (this.alignmentBuffer == null) {
            this.alignmentBuffer = new HashMap();
        }
        String key = "H";
        if (rowIndex >= 0) {
            key = key.concat(Integer.toString(rowIndex));
        }
        this.alignmentBuffer.put(key, hAlignment);
    }

    public TableColumnType getCellType(int rowIndex) {
        if (this.typeBuffer == null) {
            return null;
        }
        TableColumnType result = null;
        String row = Integer.toString(rowIndex);
        String key = "C" + row;
        result = (TableColumnType)this.typeBuffer.get(key);
        if (result == null) {
            result = (TableColumnType)this.typeBuffer.get("C");
        }
        return result;
    }

    public void setCellType(int rowIndex, TableColumnType type) {
        if (this.typeBuffer == null) {
            this.typeBuffer = new HashMap();
        }
        String key = "C";
        if (rowIndex >= 0) {
            key = key.concat(Integer.toString(rowIndex));
        }
        this.typeBuffer.put(key, type);
    }

    public boolean isCellDisabled(int rowIndex) {
        if (this.disabledCellsBuffer == null) {
            return false;
        }
        String row = Integer.toString(rowIndex);
        String key = "H" + row;
        return this.disabledCellsBuffer.contains(key);
    }

    public void setCellDisabled(int rowIndex, boolean disabled) {
        if (rowIndex > 0) {
            if (disabled) {
                if (this.disabledCellsBuffer == null) {
                    this.disabledCellsBuffer = new HashSet();
                }
                String key = "H";
                key = key.concat(Integer.toString(rowIndex));
                this.disabledCellsBuffer.add(key);
            } else if (this.disabledCellsBuffer != null && this.disabledCellsBuffer.size() != 0) {
                String key = "H";
                key = key.concat(Integer.toString(rowIndex));
                this.disabledCellsBuffer.remove(key);
            }
        } else {
            throw new IllegalArgumentException("The parameter rowIndex must be greater than 0");
        }
    }

    public boolean isCellInvalid(int rowIndex) {
        if (this.invalidCellsBuffer == null) {
            return false;
        }
        String row = Integer.toString(rowIndex);
        String key = "H" + row;
        return this.invalidCellsBuffer.contains(key);
    }

    public void setCellInvalid(int rowIndex, boolean invalid) {
        if (rowIndex > 0) {
            if (invalid) {
                if (this.invalidCellsBuffer == null) {
                    this.invalidCellsBuffer = new HashSet();
                }
                String key = "H";
                key = key.concat(Integer.toString(rowIndex));
                this.invalidCellsBuffer.add(key);
            } else if (this.invalidCellsBuffer != null && this.invalidCellsBuffer.size() != 0) {
                String key = "H";
                key = key.concat(Integer.toString(rowIndex));
                this.invalidCellsBuffer.remove(key);
            }
        } else {
            throw new IllegalArgumentException("The parameter rowIndex must be greater than 0");
        }
    }

    public String getTooltipForColumnHeader() {
        return this.tooltipForColumnHeader;
    }

    public void setTooltipForColumnHeader(String tooltipForColumnHeader) {
        this.tooltipForColumnHeader = tooltipForColumnHeader;
    }

    public int getIndex() {
        String columnId;
        int i = 0;
        int visibleColumnCount = this.model.getColumns().size();
        do {
            columnId = this.model.getColumnAt(++i).getIdentifier();
        } while (i < visibleColumnCount && !columnId.equals(this.identifier));
        if (i == visibleColumnCount && !columnId.equals(this.identifier)) {
            return -1;
        }
        return i;
    }

    public void setCellsDragable(boolean dragable) {
        this.dragable = dragable;
    }

    public boolean isCellsDragable() {
        return this.dragable;
    }

    public void setDragScope(Scope scope) {
        this.dragSource.setScope(scope);
    }

    public Scope getDragScope() {
        return this.dragSource.getScope();
    }

    public void addSourceFlavour(String flavour) {
        this.dragSource.addFlavour(flavour);
    }

    public void removeSourceFlavour(String flavour) {
        this.dragSource.removeFlavour(flavour);
    }

    public void removeAllSourceFlavours() {
        this.dragSource.removeAllFlavours();
    }

    public ArrayList getSourceFlavours() {
        return this.dragSource.getFlavours();
    }

    public void addTargetFlavour(String flavour) {
        this.dropTarget.addFlavour(flavour);
    }

    public void removeTargetFlavour(String flavour) {
        this.dropTarget.removeFlavour(flavour);
    }

    public void removeAllTargetFlavours() {
        this.dropTarget.removeAllFlavours();
    }

    public ArrayList getTargetFlavours() {
        return this.dropTarget.getFlavours();
    }

    public void setDropTargetDesign(DropTargetDesign dropTargetDesign) {
        this.dragSource.setDropTargetDesign(dropTargetDesign);
    }

    public DropTargetDesign getDropTargetDesign() {
        return this.dragSource.getDropTargetDesign();
    }

    public void setOnDrop(String onDrop) {
        this.dropTarget.setOnDrop(onDrop);
    }

    public String getOnDrop() {
        return this.dropTarget.getOnDrop();
    }

    public boolean isMonospaced() {
        return this.isMonospaced;
    }

    public void setMonospaced(boolean monospaced) {
        this.isMonospaced = monospaced;
    }

    public TableSortState getSortState() {
        return this.sortState;
    }

    public void setSortState(TableSortState sortState) {
        this.sortState = sortState;
    }

    public String getOnHeaderSort() {
        return this.onHeaderSort;
    }

    public void setOnHeaderSort(String onHeaderSort) {
        this.onHeaderSort = onHeaderSort;
    }
}

