/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.table;

import com.sap.aii.proxy.framework.core.AbstractList;
import com.sap.aii.proxy.framework.core.AbstractType;
import com.sap.aii.proxy.framework.core.BaseTypeData;
import com.sapportals.htmlb.enum.DataType;
import com.sapportals.htmlb.enum.TableColumnType;
import com.sapportals.htmlb.table.TableColumn;
import com.sapportals.htmlb.table.TableViewModel;
import com.sapportals.htmlb.type.AbstractDataType;
import com.sapportals.htmlb.type.DataString;
import com.sapportals.htmlb.type.JavaTypeUtil;
import com.sapportals.htmlb.util.IndexedLinkedList;
import java.util.Vector;

public class ProxyListTableViewModel
implements TableViewModel {
    private AbstractList list;
    private Vector columns;
    private Vector visibleColumns;
    private IndexedLinkedList keyColumn;

    public ProxyListTableViewModel(AbstractList list, boolean columnAutoCreated) {
        this.list = list;
        int columnCount = Integer.parseInt(list.getFieldCount().toString());
        this.columns = new Vector(columnCount);
        int i = 0;
        while (i < columnCount) {
            TableColumn column = new TableColumn(this, list.getFieldName(i).toString());
            this.columns.addElement(column);
            ++i;
        }
        if (columnAutoCreated) {
            this.visibleColumns = (Vector)this.columns.clone();
        }
    }

    public int getRowCount() {
        return this.list.size();
    }

    public int getColumnCount() {
        if (this.visibleColumns != null) {
            return this.visibleColumns.size();
        }
        return Integer.parseInt(this.list.getFieldCount().toString());
    }

    public String getColumnName(int columnIndex) {
        return this.getColumnAt(columnIndex).getTitle();
    }

    public void setColumnName(String columnName, int columnIndex) {
        this.getColumnAt(columnIndex).setTitle(columnName);
    }

    public AbstractDataType getValueAt(int rowIndex, int columnIndex) {
        AbstractType listItem = (AbstractType)this.list.get(rowIndex - 1);
        BaseTypeData listItemData = (BaseTypeData)listItem.dataSet();
        Object fieldValue = listItemData.getElementValue(columnIndex - 1);
        if (fieldValue != null) {
            return JavaTypeUtil.convertJavaTypeToDataType(fieldValue);
        }
        return new DataString("");
    }

    public AbstractDataType getValueAt(int rowIndex, String columnKey) {
        AbstractType listItem = (AbstractType)this.list.get(rowIndex - 1);
        BaseTypeData listItemData = (BaseTypeData)listItem.dataSet();
        int columnCount = Integer.parseInt(this.list.getFieldCount().toString());
        int columnIndex = 1;
        while (!this.list.getFieldName(columnIndex - 1).equals(columnKey)) {
            ++columnIndex;
        }
        return this.getValueAt(rowIndex, columnIndex);
    }

    public void setValueAt(AbstractDataType aValue, int rowIndex, int columnIndex) {
        throw new UnsupportedOperationException("It's impossible to change the values in a Proxy List table.");
    }

    public void setKeyColumn(int columnIndex) {
        int rowCount = this.getRowCount();
        this.keyColumn = new IndexedLinkedList();
        int i = 1;
        while (i <= rowCount) {
            this.keyColumn.put(i, this.getValueAt(i, columnIndex));
            ++i;
        }
    }

    public void addKeyColumn(int columnIndex) {
        int rowCount = this.getRowCount();
        if (this.keyColumn == null) {
            this.setKeyColumn(columnIndex);
        } else {
            int i = 1;
            while (i <= rowCount) {
                this.keyColumn.put(i, this.keyColumn.get(i).toString() + this.getValueAt(i, columnIndex).toString());
                ++i;
            }
        }
    }

    public IndexedLinkedList getKeyColumn() {
        return this.keyColumn;
    }

    public Vector getColumns() {
        return this.visibleColumns;
    }

    public TableColumn getColumnAt(int columnIndex) {
        return (TableColumn)this.visibleColumns.get(columnIndex - 1);
    }

    public TableColumn addColumn(String columnKey) {
        int i = this.getIndexForColumnInModel(columnKey);
        if (i > 0) {
            TableColumn column;
            if (!this.list.isEmpty()) {
                DataType dataType = this.getValueAt(1, i).getType();
                column = new TableColumn(this, columnKey, columnKey, TableColumnType.TEXT, dataType);
            } else {
                column = new TableColumn(this, columnKey, columnKey);
            }
            if (this.visibleColumns == null) {
                this.visibleColumns = new Vector();
            }
            this.visibleColumns.addElement(column);
            return column;
        }
        return null;
    }

    public void removeColumn(String columnKey) {
        int i = this.getIndexForColumn(columnKey);
        if (i > 0) {
            this.visibleColumns.removeElementAt(i - 1);
        }
    }

    private int getIndexForColumn(String columnKey) {
        String key;
        int i = 1;
        int columnCount = this.getColumnCount();
        while (!columnKey.equals(key = this.getColumnAt(i).getIdentifier()) && ++i <= columnCount) {
        }
        if (i > columnCount + 1) {
            return -1;
        }
        return i - 1;
    }

    private int getIndexForColumnInModel(String columnKey) {
        String key;
        int i = 1;
        int columnCount = this.getColumnCountForWholeTable();
        while (!columnKey.equals(key = ((TableColumn)this.columns.get(i - 1)).getIdentifier()) && ++i <= columnCount) {
        }
        if (i > columnCount + 1) {
            return -1;
        }
        return i - 1;
    }

    private int getColumnCountForWholeTable() {
        return Integer.parseInt(this.list.getFieldCount().toString());
    }
}

