/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.table;

import com.sap.mw.jco.IMetaData;
import com.sap.mw.jco.JCO;
import com.sapportals.htmlb.enum.DataType;
import com.sapportals.htmlb.enum.TableColumnType;
import com.sapportals.htmlb.table.TableColumn;
import com.sapportals.htmlb.table.TableViewModel;
import com.sapportals.htmlb.type.AbstractDataType;
import com.sapportals.htmlb.type.JCOTypeUtil;
import com.sapportals.htmlb.util.IndexedLinkedList;
import java.util.ArrayList;
import java.util.Vector;

public class JCOTableViewModel
implements TableViewModel {
    protected Vector columns;
    private JCO.Table table;
    private int currentColumnCount;
    private IndexedLinkedList keyColumn;
    protected boolean columnAutoCreated;
    protected ArrayList colspanForCells;

    public JCOTableViewModel(JCO.Table table) {
        this(table, true);
    }

    public JCOTableViewModel(JCO.Table table, boolean columnAutoCreated) {
        if (columnAutoCreated) {
            this.table = table;
            int rowCount = table.getNumRows();
            int columnCount = table.getNumColumns();
            this.columns = new Vector(table.getNumColumns());
            if (rowCount > 0) {
                int i = 0;
                while (i < columnCount) {
                    String columnName = table.getName(i);
                    TableColumnType columnType = TableColumnType.TEXT;
                    JCO.Field f = table.getField(i);
                    DataType dataType = JCOTypeUtil.convertJCOFieldToDataType(f).getType();
                    TableColumn tableColumn = new TableColumn(this, columnName, columnName, columnType, dataType);
                    this.columns.addElement(tableColumn);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < columnCount) {
                    String columnName = table.getName(i);
                    TableColumnType columnType = TableColumnType.TEXT;
                    TableColumn tableColumn = new TableColumn(this, columnName, columnName, columnType);
                    this.columns.addElement(tableColumn);
                    ++i;
                }
            }
        } else {
            this.table = table;
            this.columns = new Vector();
        }
    }

    public TableColumn addColumn(String columnName) {
        int j = 0;
        int columnCount = this.table.getNumColumns();
        String name = this.table.getName(j);
        ++this.currentColumnCount;
        do {
            name = this.table.getName(j);
        } while (++j < columnCount && !name.equals(columnName));
        if (j > columnCount || j == columnCount && !name.equals(columnName)) {
            TableColumnType columnType = TableColumnType.USER;
            TableColumn column = new TableColumn(this, columnName, columnName, columnType);
            this.columns.addElement(column);
            return column;
        }
        IMetaData md = this.table.getMetaData();
        TableColumnType columnType = TableColumnType.TEXT;
        JCO.Field f = this.table.getField(j - 1);
        DataType dataType = JCOTypeUtil.convertJCOFieldToDataType(f, md, j - 1).getType();
        TableColumn tableColumn = new TableColumn(this, columnName, columnName, columnType, dataType);
        tableColumn.setDataType(dataType);
        this.columns.addElement(tableColumn);
        return tableColumn;
    }

    public void removeColumn(String columnName) {
        int i = 0;
        int columnCount = this.getColumnCount();
        while (i < columnCount && !this.getColumnName(i + 1).equals(columnName)) {
            ++i;
        }
        if (i < columnCount) {
            this.columns.remove(i);
        }
    }

    public int getRowCount() {
        return this.table.getNumRows();
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public String getColumnName(int columnIndex) {
        return ((TableColumn)this.columns.elementAt(columnIndex - 1)).getTitle();
    }

    public void setColumnName(String columnName, int columnIndex) {
        ((TableColumn)this.columns.elementAt(columnIndex - 1)).setTitle(columnName);
    }

    public AbstractDataType getValueAt(int rowIndex, int columnIndex) {
        this.table.setRow(rowIndex - 1);
        JCO.Field f = this.table.getField(columnIndex - 1);
        return JCOTypeUtil.convertJCOFieldToDataType(f);
    }

    public AbstractDataType getValueAt(int rowIndex, String columnKey) {
        this.table.setRow(rowIndex - 1);
        JCO.Field f = this.table.getField(columnKey);
        return JCOTypeUtil.convertJCOFieldToDataType(f);
    }

    public void setValueAt(AbstractDataType aValue, int rowIndex, int columnIndex) {
        throw new UnsupportedOperationException("It's impossible to change the values in a JCO table.");
    }

    public Vector getColumns() {
        return this.columns;
    }

    public TableColumn getColumnAt(int columnIndex) {
        return (TableColumn)this.columns.get(columnIndex - 1);
    }

    public void setColumnAt(TableColumn column, int columnIndex) {
        this.columns.setElementAt(column, columnIndex);
    }

    public boolean isColumnAutoCreated() {
        return this.columnAutoCreated;
    }

    public void setKeyColumn(int columnIndex) {
        int rowCount = this.getRowCount();
        this.keyColumn = new IndexedLinkedList();
        int i = 1;
        while (i <= rowCount) {
            this.keyColumn.put(i, this.getValueAt(i, columnIndex));
            ++i;
        }
    }

    public IndexedLinkedList getKeyColumn() {
        return this.keyColumn;
    }

    public void addKeyColumn(int columnIndex) {
        int rowCount = this.getRowCount();
        if (this.keyColumn == null) {
            this.setKeyColumn(columnIndex);
        } else {
            int i = 1;
            while (i <= rowCount) {
                String oldValue = this.keyColumn.get(i).toString();
                this.keyColumn.put(i, this.getValueAt(i, columnIndex).toString() + oldValue);
                ++i;
            }
        }
    }
}

