/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.table;

import com.sapportals.htmlb.enum.DataType;
import com.sapportals.htmlb.enum.TableColumnType;
import com.sapportals.htmlb.table.TableColumn;
import com.sapportals.htmlb.table.TableViewModel;
import com.sapportals.htmlb.type.AbstractDataType;
import com.sapportals.htmlb.type.JavaTypeUtil;
import com.sapportals.htmlb.util.IndexedLinkedList;
import java.util.Enumeration;
import java.util.Vector;

public class DefaultTableViewModel
implements TableViewModel {
    protected Vector dataVector;
    protected Vector columns;
    protected Vector visibleColumns;
    protected IndexedLinkedList keyColumn;

    public DefaultTableViewModel() {
    }

    public DefaultTableViewModel(Vector columnNames) {
        this(new Vector(), columnNames);
    }

    public DefaultTableViewModel(Vector data, Vector columnNames) {
        this(data, columnNames, true);
    }

    public DefaultTableViewModel(Vector data, Vector columnNames, boolean columnAutoCreated) {
        this.columns = new Vector(columnNames.size());
        this.dataVector = data;
        Enumeration columnNamesEnum = columnNames.elements();
        while (columnNamesEnum.hasMoreElements()) {
            TableColumn column = new TableColumn(this, columnNamesEnum.nextElement().toString());
            this.columns.addElement(column);
        }
        if (columnAutoCreated) {
            this.visibleColumns = (Vector)this.columns.clone();
        }
    }

    public DefaultTableViewModel(Object[] columnNames) {
        Object[][] data = new Object[][]{};
        this.setDataVector(data, columnNames);
    }

    public DefaultTableViewModel(Object[][] data, Object[] columnNames) {
        this.setDataVector(data, columnNames);
    }

    public DefaultTableViewModel(Object[][] data, Object[] columnNames, boolean columnAutoCreated) {
        this.setDataVector(data, columnNames, columnAutoCreated);
    }

    public void setDataVector(Object[][] data, Object[] columnNames) {
        this.setDataVector(data, columnNames, true);
    }

    public void setDataVector(Object[][] data, Object[] columnNames, boolean columnAutoCreated) {
        this.dataVector = DefaultTableViewModel.convertToVector(data);
        if (columnNames != null) {
            this.columns = new Vector(columnNames.length);
            if (data.length > 0) {
                int i = 0;
                while (i < columnNames.length) {
                    DataType dataType = this.getValueAt(1, i + 1).getType();
                    String columnName = columnNames[i].toString();
                    TableColumn column = new TableColumn(this, columnName, columnName, TableColumnType.TEXT, dataType);
                    this.columns.addElement(column);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < columnNames.length) {
                    String columnName = columnNames[i].toString();
                    TableColumn column = new TableColumn(this, columnName, columnName, TableColumnType.TEXT);
                    this.columns.addElement(column);
                    ++i;
                }
            }
            if (columnAutoCreated) {
                this.visibleColumns = (Vector)this.columns.clone();
            }
        }
    }

    public int getRowCount() {
        if (this.dataVector != null) {
            return this.dataVector.size();
        }
        return 0;
    }

    public int getColumnCount() {
        if (this.visibleColumns != null) {
            return this.visibleColumns.size();
        }
        return 0;
    }

    public String getColumnName(int columnIndex) {
        return ((TableColumn)this.visibleColumns.elementAt(columnIndex - 1)).getTitle();
    }

    public void setColumnName(String columnName, int columnIndex) {
        ((TableColumn)this.visibleColumns.elementAt(columnIndex - 1)).setTitle(columnName);
    }

    public void setColumnName(String columnName, String columnKey) {
        int columnIndex = this.getIndexForColumn(columnKey);
        this.getColumnAt(columnIndex).setTitle(columnName);
    }

    public AbstractDataType getValueAt(int rowIndex, int columnIndex) {
        Vector rowVector = (Vector)this.dataVector.elementAt(rowIndex - 1);
        return JavaTypeUtil.convertJavaTypeToDataType(rowVector.elementAt(columnIndex - 1));
    }

    public AbstractDataType getValueAt(int rowIndex, String columnKey) {
        int columnIndex = this.getIndexForColumnInModel(columnKey);
        return this.getValueAt(rowIndex, columnIndex);
    }

    public void setValueAt(AbstractDataType aValue, int rowIndex, int columnIndex) {
        Vector rowVector = (Vector)this.dataVector.elementAt(rowIndex - 1);
        rowVector.setElementAt(aValue, columnIndex - 1);
    }

    public Vector getColumns() {
        return this.visibleColumns;
    }

    public TableColumn getColumnAt(int columnIndex) {
        return (TableColumn)this.visibleColumns.elementAt(columnIndex - 1);
    }

    public TableColumn getColumn(String columnID) {
        return this.getColumnAt(this.getIndexForColumn(columnID));
    }

    public void setKeyColumn(int columnIndex) {
        int rowCount = this.getRowCount();
        this.keyColumn = new IndexedLinkedList();
        int i = 1;
        while (i <= rowCount) {
            this.keyColumn.put(i, this.getValueAt(i, columnIndex));
            ++i;
        }
    }

    public void addKeyColumn(int columnIndex) {
        int rowCount = this.getRowCount();
        if (this.keyColumn == null) {
            this.setKeyColumn(columnIndex);
        } else {
            int i = 1;
            while (i <= rowCount) {
                this.keyColumn.put(i, this.keyColumn.get(i).toString() + this.getValueAt(i, columnIndex).toString());
                ++i;
            }
        }
    }

    public TableColumn addColumn(String columnKey) {
        int i = this.getIndexForColumnInModel(columnKey);
        if (i > 0) {
            TableColumn column;
            if (!this.dataVector.isEmpty()) {
                DataType dataType = this.getValueAt(1, i + 1).getType();
                column = new TableColumn(this, columnKey, columnKey, TableColumnType.TEXT, dataType);
            } else {
                column = new TableColumn(this, columnKey, columnKey);
            }
            if (this.visibleColumns == null) {
                this.visibleColumns = new Vector();
            }
            this.visibleColumns.addElement(column);
            return column;
        }
        return null;
    }

    public void removeColumn(String columnKey) {
        int i = this.getIndexForColumn(columnKey);
        if (i > 0) {
            this.visibleColumns.removeElementAt(i - 1);
        }
    }

    public IndexedLinkedList getKeyColumn() {
        return this.keyColumn;
    }

    private static Vector convertToVector(Object[][] anArray) {
        if (anArray == null) {
            return null;
        }
        Vector<Vector> v = new Vector<Vector>(anArray.length);
        int i = 0;
        while (i < anArray.length) {
            v.addElement(DefaultTableViewModel.convertToVector(anArray[i]));
            ++i;
        }
        return v;
    }

    private static Vector convertToVector(Object[] anArray) {
        if (anArray == null) {
            return null;
        }
        Vector<Object> v = new Vector<Object>(anArray.length);
        int i = 0;
        while (i < anArray.length) {
            v.addElement(anArray[i]);
            ++i;
        }
        return v;
    }

    private int getIndexForColumn(String columnKey) {
        String key;
        int i = 1;
        int columnCount = this.getColumnCount();
        while (!columnKey.equals(key = this.getColumnAt(i).getIdentifier()) && ++i <= columnCount) {
        }
        if (i > columnCount + 1) {
            return -1;
        }
        return i - 1;
    }

    private int getIndexForColumnInModel(String columnKey) {
        String key;
        int i = 1;
        int columnCount = this.columns.size();
        while (!columnKey.equals(key = ((TableColumn)this.columns.get(i - 1)).getIdentifier()) && ++i <= columnCount) {
        }
        if (i > columnCount + 1) {
            return -1;
        }
        return i - 1;
    }
}

