/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.table;

import com.sapportals.htmlb.Button;
import com.sapportals.htmlb.DragSource;
import com.sapportals.htmlb.DropTarget;
import com.sapportals.htmlb.Image;
import com.sapportals.htmlb.InputField;
import com.sapportals.htmlb.Link;
import com.sapportals.htmlb.TextView;
import com.sapportals.htmlb.enum.TableColumnType;
import com.sapportals.htmlb.enum.TextViewDesign;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.table.ICellRenderer;
import com.sapportals.htmlb.table.TableColumn;
import com.sapportals.htmlb.table.TableView;
import com.sapportals.htmlb.type.AbstractDataType;
import com.sapportals.htmlb.type.DataString;
import java.util.Hashtable;

public class DefaultCellRenderer
implements ICellRenderer {
    private static final Hashtable table = new Hashtable();

    public void renderCell(int row, int column, TableView tableView, IPageContext rendererContext) {
        TableColumn myTableColumn = tableView.getColumn(column);
        TableColumnType colType = myTableColumn.getCellType(row);
        String colKey = myTableColumn.getIdentifier();
        String tooltipColumn = myTableColumn.getTooltipColumnKey();
        String tooltip = null;
        boolean wrapping = myTableColumn.isWrapping();
        if (tooltipColumn != null && !tooltipColumn.equals("")) {
            tooltip = tableView.getValueAt(row, tooltipColumn).toString();
        }
        DragSource dragSource = new DragSource(colKey);
        if (myTableColumn.isCellsDragable()) {
            dragSource.setFlavours(myTableColumn.getSourceFlavours());
            dragSource.setDropTargetDesign(myTableColumn.getDropTargetDesign());
            dragSource.setValue(tableView.getRowKey(row));
            dragSource.setColumnKey(tableView.getColumnName(column));
            dragSource.setSourceContainerName(tableView.getId());
            dragSource.setScope(myTableColumn.getDragScope());
        }
        DropTarget dropTarget = new DropTarget(colKey);
        if (myTableColumn.getOnDrop() != null && myTableColumn.getOnDrop() != "") {
            dropTarget.setFlavours(myTableColumn.getTargetFlavours());
            dropTarget.setOnDrop(myTableColumn.getOnDrop());
            dropTarget.setValue(tableView.getRowKey(row));
        }
        if (colType == TableColumnType.BUTTON) {
            String value = myTableColumn.getValueAt(row).toString();
            Button myButton = new Button(colKey, value);
            String linkClickHandler = myTableColumn.getOnItemClick();
            myButton.setOnClick(linkClickHandler);
            myButton.setWidth("100%");
            myButton.setTooltip(tooltip);
            myButton.setDisabled(myTableColumn.isCellDisabled(row));
            if (myTableColumn.isCellsDragable()) {
                dragSource.addComponent(myButton);
                if (myTableColumn.getOnDrop() != null && myTableColumn.getOnDrop() != "") {
                    dropTarget.addComponent(dragSource);
                    dropTarget.render(rendererContext);
                } else {
                    dragSource.render(rendererContext);
                }
            } else if (myTableColumn.getOnDrop() != null && myTableColumn.getOnDrop() != "") {
                dropTarget.addComponent(myButton);
                dropTarget.render(rendererContext);
            } else {
                myButton.render(rendererContext);
            }
        } else if (colType == TableColumnType.IMAGE) {
            String name = myTableColumn.getValueAt(row).toString();
            if (name != null && !"".equals(name)) {
                Image myImage = new Image(name, tooltip);
                if (myTableColumn.isCellsDragable()) {
                    dragSource.addComponent(myImage);
                    if (myTableColumn.getOnDrop() != null && myTableColumn.getOnDrop() != "") {
                        dropTarget.addComponent(dragSource);
                        dropTarget.render(rendererContext);
                    } else {
                        dragSource.render(rendererContext);
                    }
                } else if (myTableColumn.getOnDrop() != null && myTableColumn.getOnDrop() != "") {
                    dropTarget.addComponent(myImage);
                    dropTarget.render(rendererContext);
                } else {
                    myImage.render(rendererContext);
                }
            } else {
                TextView emptyImage = new TextView("&nbsp;");
                emptyImage.setEncode(false);
                emptyImage.render(rendererContext);
            }
        } else if (colType == TableColumnType.LINK || colType == TableColumnType.IMAGELINK) {
            String name = myTableColumn.getValueAt(row).toString();
            String columnKey = myTableColumn.getLinkColumnKey();
            String linkReference = null;
            if (columnKey != null) {
                linkReference = tableView.getValueAt(row, columnKey).toString();
            }
            String itemClick = myTableColumn.getOnItemClick();
            if (!(linkReference != null && linkReference.length() != 0 || itemClick != null && itemClick.length() != 0)) {
                if (colType == TableColumnType.LINK) {
                    TextView myTextView = new TextView();
                    myTextView.setNested(true);
                    AbstractDataType myValue = myTableColumn.getValueAt(row);
                    if (myValue instanceof DataString) {
                        DataString stringValue = (DataString)myValue;
                        myTextView.setEncode(stringValue.isEncode());
                    }
                    myTextView.setText(myValue.toString(rendererContext));
                    myTextView.setTooltip(tooltip);
                    myTextView.setWrapping(wrapping);
                    if (myTableColumn.isMonospaced()) {
                        myTextView.setDesign(TextViewDesign.MONOSPACE);
                    }
                    if (myTableColumn.isCellsDragable()) {
                        dragSource.addComponent(myTextView);
                        if (myTableColumn.getOnDrop() != null && myTableColumn.getOnDrop() != "") {
                            dropTarget.addComponent(dragSource);
                            dropTarget.render(rendererContext);
                        } else {
                            dragSource.render(rendererContext);
                        }
                    } else if (myTableColumn.getOnDrop() != null && myTableColumn.getOnDrop() != "") {
                        dropTarget.addComponent(myTextView);
                        dropTarget.render(rendererContext);
                    } else if (myTextView.getText() != null && myTextView.getText().length() > 0) {
                        myTextView.render(rendererContext);
                    } else {
                        myTextView.setText("&nbsp;");
                        myTextView.setEncode(false);
                        myTextView.render(rendererContext);
                    }
                } else if (colType == TableColumnType.IMAGELINK) {
                    if (name != null && !"".equals(name)) {
                        Image myImage = new Image(name, tooltip);
                        if (myTableColumn.isCellsDragable()) {
                            dragSource.addComponent(myImage);
                            if (myTableColumn.getOnDrop() != null && myTableColumn.getOnDrop() != "") {
                                dropTarget.addComponent(dragSource);
                                dropTarget.render(rendererContext);
                            } else {
                                dragSource.render(rendererContext);
                            }
                        } else if (myTableColumn.getOnDrop() != null && myTableColumn.getOnDrop() != "") {
                            dropTarget.addComponent(myImage);
                            dropTarget.render(rendererContext);
                        } else {
                            myImage.render(rendererContext);
                        }
                    } else {
                        TextView emptyImageLink = new TextView("&nbsp;");
                        emptyImageLink.setEncode(false);
                        emptyImageLink.render(rendererContext);
                    }
                }
            } else {
                String linkTarget = myTableColumn.getLinkClickTarget();
                Link myLink = new Link(colKey);
                if (colType == TableColumnType.LINK) {
                    boolean encode = myTableColumn.isEncode();
                    if (name == null || name.length() < 1) {
                        name = "&nbsp;";
                        encode = false;
                    }
                    if (!encode) {
                        TextView traw = new TextView();
                        traw.setNested(true);
                        traw.setEncode(false);
                        traw.setText(name);
                        myLink.addComponent(traw);
                    } else {
                        TextView t = new TextView(name);
                        t.setNested(true);
                        myLink.addComponent(t);
                    }
                } else {
                    Image linkImage = new Image(name, null);
                    linkImage.setTooltip(tooltip);
                    linkImage.setNested(true);
                    myLink.addComponent(linkImage);
                }
                myLink.setReference(linkReference);
                String myClick = myTableColumn.getOnItemClick();
                myLink.setOnClick(myClick);
                if (myClick == null && columnKey == null) {
                    myLink.setReference(name);
                }
                if (linkTarget != null && linkTarget.length() != 0) {
                    myLink.setTarget(linkTarget);
                }
                myLink.setTooltip(tooltip);
                if (myLink.getInnerText() != null) {
                    myLink.getInnerText().setWrapping(wrapping);
                }
                if (myTableColumn.isCellsDragable()) {
                    dragSource.addComponent(myLink);
                    if (myTableColumn.getOnDrop() != null && myTableColumn.getOnDrop() != "") {
                        dropTarget.addComponent(dragSource);
                        dropTarget.render(rendererContext);
                    } else {
                        dragSource.render(rendererContext);
                    }
                } else if (myTableColumn.getOnDrop() != null && myTableColumn.getOnDrop() != "") {
                    dropTarget.addComponent(myLink);
                    dropTarget.render(rendererContext);
                } else {
                    myLink.render(rendererContext);
                }
            }
        } else if (colType == TableColumnType.INPUT) {
            InputField myInputField = new InputField(colKey);
            myInputField.setValue(myTableColumn.getValueAt(row));
            myInputField.setWidth("100%");
            myInputField.setTooltip(tooltip);
            myInputField.setDisabled(myTableColumn.isCellDisabled(row));
            myInputField.setInvalid(myTableColumn.isCellInvalid(row));
            if (myTableColumn.isCellsDragable()) {
                dragSource.addComponent(myInputField);
                if (myTableColumn.getOnDrop() != null && myTableColumn.getOnDrop() != "") {
                    dropTarget.addComponent(dragSource);
                    dropTarget.render(rendererContext);
                } else {
                    dragSource.render(rendererContext);
                }
            } else if (myTableColumn.getOnDrop() != null && myTableColumn.getOnDrop() != "") {
                dropTarget.addComponent(myInputField);
                dropTarget.render(rendererContext);
            } else {
                myInputField.render(rendererContext);
            }
        } else if (colType == TableColumnType.TEXT || colType == TableColumnType.USER) {
            AbstractDataType myValue = myTableColumn.getValueAt(row);
            TextView t1 = new TextView();
            t1.setTooltip(tooltip);
            t1.setWrapping(wrapping);
            if (myTableColumn.isMonospaced()) {
                t1.setDesign(TextViewDesign.MONOSPACE);
            }
            if (myValue instanceof DataString) {
                DataString stringValue = (DataString)myValue;
                if (stringValue.isEncode() || myTableColumn.isEncode()) {
                    String result = stringValue.toString();
                    if (result != null && result.length() > 0) {
                        t1.setText(result);
                        t1.setEncode(true);
                    } else {
                        t1.setText("&nbsp;");
                        t1.setEncode(false);
                    }
                } else {
                    String result = myValue.toString(rendererContext.getLocale());
                    if (result != null && result.length() > 0) {
                        t1.setText(result);
                    } else {
                        t1.setText("&nbsp;");
                    }
                    t1.setEncode(false);
                }
            } else {
                if (myValue.toString(rendererContext.getLocale()) != null && myValue.toString(rendererContext.getLocale()).length() > 0) {
                    t1.setText(myValue.toString(rendererContext.getLocale()));
                } else {
                    t1.setText("&nbsp;");
                }
                t1.setEncode(false);
            }
            if (myTableColumn.isCellsDragable()) {
                dragSource.addComponent(t1);
                if (myTableColumn.getOnDrop() != null && myTableColumn.getOnDrop() != "") {
                    dropTarget.addComponent(dragSource);
                    dropTarget.render(rendererContext);
                } else {
                    dragSource.render(rendererContext);
                }
            } else if (myTableColumn.getOnDrop() != null && myTableColumn.getOnDrop() != "") {
                dropTarget.addComponent(t1);
                dropTarget.render(rendererContext);
            } else {
                t1.render(rendererContext);
            }
        }
    }
}

