/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.statusicons;

import com.sapportals.htmlb.statusicons.MimeInfoLoader;
import java.util.Enumeration;
import java.util.Hashtable;

public class Mimes {
    static boolean cvInitialized = false;
    private static Hashtable cvGroupHash = null;
    private static Hashtable cvIconHashByID = null;
    private static Hashtable cvIconHashByName = null;
    private static String cvBaseUrl = MimeInfoLoader.getBaseUrl();
    private static String cvDefaultNotFoundUrl = "";

    private static void checkLoaded() {
        if (!cvInitialized) {
            cvGroupHash = new Hashtable();
            cvIconHashByName = new Hashtable();
            cvIconHashByID = new Hashtable();
            MimeInfoLoader.loadRepositoryContent();
            cvInitialized = true;
        }
    }

    public static String getMimeUrl(String id) {
        Mimes.checkLoaded();
        Object result = null;
        Mime myMime = null;
        if (cvIconHashByID != null) {
            myMime = (Mime)cvIconHashByID.get(id);
        }
        if (myMime == null && cvIconHashByName != null) {
            myMime = (Mime)cvIconHashByName.get(id);
        }
        if (myMime != null) {
            return cvBaseUrl + myMime.url;
        }
        return cvDefaultNotFoundUrl;
    }

    public static String getIdByName(String name) {
        Mimes.checkLoaded();
        Mime myMime = (Mime)cvIconHashByName.get(name);
        if (myMime != null) {
            return myMime.mimeID;
        }
        return null;
    }

    public static String getShortTextByName(String name) {
        Mimes.checkLoaded();
        Mime myMime = (Mime)cvIconHashByName.get(name);
        if (myMime != null) {
            return myMime.shorttext;
        }
        return null;
    }

    public static void refresh() {
        cvInitialized = false;
        Mimes.checkLoaded();
    }

    public static String[] getAvailableNames() {
        Mimes.checkLoaded();
        int n = cvIconHashByName.size();
        int i = 0;
        String[] result = new String[n];
        Enumeration names = cvIconHashByName.keys();
        while (names.hasMoreElements()) {
            String key = (String)names.nextElement();
            result[i++] = key;
        }
        return result;
    }

    public static void setNotFoundUrl(String url) {
        cvDefaultNotFoundUrl = url;
    }

    static void addGroup(String id, String title) {
        cvGroupHash.put(id, title);
    }

    static void addMime(Mime mime) {
        cvIconHashByID.put(mime.mimeID, mime);
        cvIconHashByName.put(mime.name, mime);
    }

    static class Mime {
        String groupID;
        String mimeID;
        String name;
        String shorttext;
        String url;

        Mime() {
        }
    }
}

