/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.statusicons;

import com.sapportals.htmlb.statusicons.Mimes;
import com.sapportals.htmlb.util.Log;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MimeInfoLoader {
    private static final boolean DEBUG = false;
    private static final String NAME_PROPERTY = "statusicons.mimes.name";
    private static final String URL_PROPERTY = "statusicons.mimes.url";
    private static final String HOST_PROPERTY = "statusicons.mimes.host";
    private static final String PROTOCOL_PROPERTY = "statusicons.mimes.protocol";
    private static final String DEFAULT_NAME = "mimesinfo.xml";
    private static final String DEFAULT_URL = "/htmlb/mimes/common/";
    private static final String DEFAULT_PROTOCOL = "http://";

    static String getInfoFileName() {
        String repositoryName = System.getProperty(NAME_PROPERTY);
        if (repositoryName == null) {
            repositoryName = DEFAULT_NAME;
        }
        return repositoryName;
    }

    static String getUrl() {
        String repositoryURL = System.getProperty(URL_PROPERTY);
        if (repositoryURL == null) {
            repositoryURL = DEFAULT_URL;
        }
        return repositoryURL;
    }

    static String getHost() {
        String repositoryHost = System.getProperty(HOST_PROPERTY);
        return repositoryHost;
    }

    static String getProtocol() {
        String repositoryProtocol = System.getProperty(PROTOCOL_PROPERTY);
        if (repositoryProtocol == null) {
            repositoryProtocol = DEFAULT_PROTOCOL;
        }
        return repositoryProtocol;
    }

    public static String getBaseUrl() {
        String myHost = MimeInfoLoader.getHost();
        String myUrl = MimeInfoLoader.getUrl();
        if (myHost != null) {
            return MimeInfoLoader.getProtocol() + myHost + myUrl;
        }
        return myUrl;
    }

    private static Document getRepositoryData() {
        String repositoryName;
        Document result = null;
        String myInputSource = repositoryName = MimeInfoLoader.getInfoFileName();
        try {
            URL myURL = new URL(repositoryName);
            if (myURL.getHost() == null) {
                myInputSource = MimeInfoLoader.getBaseUrl() + myInputSource;
            }
        }
        catch (MalformedURLException e) {
            Log.getLogLocation(false).debugT("MimeInfoLoader", "MalformedURLException " + e.getMessage());
        }
        try {
            DocumentBuilderFactory myFactory = DocumentBuilderFactory.newInstance();
            myFactory.setNamespaceAware(false);
            myFactory.setValidating(false);
            DocumentBuilder myBuilder = myFactory.newDocumentBuilder();
            result = myBuilder.parse(myInputSource);
        }
        catch (ParserConfigurationException e) {
            Log.getLogLocation(false).debugT("MimeInfoLoader", "Parser Config " + e.getMessage());
        }
        catch (SAXException e) {
            Log.getLogLocation(false).debugT("MimeInfoLoader", "SAXException " + e.getMessage());
        }
        catch (IOException e) {
            Log.getLogLocation(false).debugT("MimeInfoLoader", "IOException " + e.getMessage());
        }
        return result;
    }

    static void loadRepositoryContent() {
        Document data = MimeInfoLoader.getRepositoryData();
        if (data != null) {
            NodeList groupNodes = data.getElementsByTagName("group");
            MimeInfoLoader.loadGroupNodes(groupNodes);
            NodeList mimeNodes = data.getElementsByTagName("icon");
            MimeInfoLoader.loadMimeNodes(mimeNodes);
        }
    }

    private static void loadGroupNodes(NodeList nodes) {
        int i = 0;
        while (i < nodes.getLength()) {
            Node group = nodes.item(i);
            MimeInfoLoader.loadGroup(group);
            ++i;
        }
    }

    private static void loadGroup(Node group) {
        if (group instanceof Element) {
            Element element = (Element)group;
            String groupId = MimeInfoLoader.getChildValue(element, "groupid");
            String groupTitle = MimeInfoLoader.getChildValue(element, "title");
            Mimes.addGroup(groupId, groupTitle);
        }
    }

    private static void loadMimeNodes(NodeList nodes) {
        int i = 0;
        while (i < nodes.getLength()) {
            Node mimeNode = nodes.item(i);
            MimeInfoLoader.loadMime(mimeNode);
            ++i;
        }
    }

    private static void loadMime(Node mimeNode) {
        if (mimeNode instanceof Element) {
            Element mimeElement = (Element)mimeNode;
            Mimes.Mime mime = new Mimes.Mime();
            mime.groupID = "";
            mime.mimeID = MimeInfoLoader.getChildValue(mimeElement, "iconid");
            mime.url = MimeInfoLoader.getChildValue(mimeElement, "url");
            mime.name = MimeInfoLoader.getChildValue(mimeElement, "abapname");
            mime.shorttext = MimeInfoLoader.getChildValue(mimeElement, "shorttext");
            Mimes.addMime(mime);
        }
    }

    private static String getChildValue(Element base, String elementName) {
        Node child = base.getFirstChild();
        while (child != null) {
            Node valueNode;
            if (elementName.equals(child.getNodeName()) && (valueNode = child.getFirstChild()) != null && valueNode.getNodeType() == 3) {
                return valueNode.getNodeValue();
            }
            child = child.getNextSibling();
        }
        return null;
    }
}

