/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.serialize;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.serialize.DefaultListBoxSerializer;
import com.sapportals.htmlb.serialize.ISerializer;
import com.sapportals.htmlb.util.Log;
import java.util.Hashtable;

public class SerializeManager {
    static Object[] uiDefaults = new Object[]{"ListBox", "com.sapportals.htmlb.serialize.DefaultListBoxSerializer"};
    static Hashtable m_serializeClasses = null;
    private static DefaultListBoxSerializer listBoxSerializer = new DefaultListBoxSerializer();

    private static void initialize() {
        m_serializeClasses = SerializeManager.createUIDefaults(uiDefaults);
    }

    private static Hashtable createUIDefaults(Object[] keyValueList) {
        Hashtable result = new Hashtable(keyValueList.length / 2);
        int i = 0;
        while (i < keyValueList.length) {
            try {
                Class<?> serializerClass = Class.forName((String)keyValueList[i + 1]);
                result.put(keyValueList[i], serializerClass.newInstance());
            }
            catch (ClassNotFoundException e) {
                Log.getLogLocation(false).debugT("SerializerManager", "createUIDefaults failed " + e.getMessage());
            }
            catch (InstantiationException e) {
                Log.getLogLocation(false).debugT("SerializerManager", "createUIDefaults failed " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                Log.getLogLocation(false).debugT("SerializerManager", "createUIDefaults failed " + e.getMessage());
            }
            i += 2;
        }
        return result;
    }

    private static ISerializer getSerializerX(Component comp) {
        String uiId;
        Object serializerClass;
        if (m_serializeClasses == null) {
            SerializeManager.initialize();
        }
        if ((serializerClass = m_serializeClasses.get(uiId = comp.getUI())) instanceof ISerializer) {
            return (ISerializer)serializerClass;
        }
        return null;
    }

    public static ISerializer getSerializer(Component comp) {
        String uiId = comp.getUI();
        if ("ListBox".equals(uiId)) {
            return listBoxSerializer;
        }
        return null;
    }
}

