/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.serialize;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.DefaultListModel;
import com.sapportals.htmlb.ListBox;
import com.sapportals.htmlb.serialize.AbstractDefaultSerializer;
import com.sapportals.htmlb.util.DefaultHtmlbEncoder;
import com.sapportals.htmlb.util.Log;
import java.io.IOException;
import java.util.Iterator;
import java.util.StringTokenizer;

public class DefaultListBoxSerializer
extends AbstractDefaultSerializer {
    private String SEPARATOR = ":";
    private String FINALIZER = ";";

    public String serialize(Component component) {
        try {
            if (component instanceof ListBox) {
                String state = "";
                ListBox lb = (ListBox)component;
                this.encoder.prepareEncoding();
                Iterator keys = lb.getKeys();
                state = lb.getModel().isSingleSelection() ? "selection" + this.SEPARATOR + "single" + this.FINALIZER : "selection" + this.SEPARATOR + "multi" + this.FINALIZER;
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    String text = lb.getTextForKey(key);
                    state = state + this.encode(key) + this.SEPARATOR + this.encode(text) + this.FINALIZER;
                }
                this.encoder.addProperty(state);
                return this.encoder.getEncodedString();
            }
        }
        catch (IOException e) {
            Log.getLogLocation(false).debugT("DefaultListBoxSerializer", "serialize");
        }
        return "";
    }

    public void deserialize(Component component, String encodedData) {
        try {
            if (component instanceof ListBox) {
                String state = null;
                ListBox lb = (ListBox)component;
                DefaultListModel model = new DefaultListModel();
                model.setSingleSelection(false);
                this.encoder.prepareDecoding(encodedData);
                state = this.encoder.getStringProperty();
                StringTokenizer tok = new StringTokenizer(state, this.FINALIZER, false);
                boolean isFirst = true;
                while (tok.hasMoreTokens()) {
                    String entry = tok.nextToken();
                    StringTokenizer innerTok = new StringTokenizer(entry, this.SEPARATOR, false);
                    while (innerTok.hasMoreTokens()) {
                        String key = innerTok.nextToken();
                        String text = innerTok.nextToken();
                        if (isFirst) {
                            if (key.equalsIgnoreCase("selection")) {
                                if (text.equalsIgnoreCase("single")) {
                                    model.setSingleSelection(true);
                                } else {
                                    model.setSingleSelection(false);
                                }
                            }
                            isFirst = false;
                            continue;
                        }
                        key = this.decode(key);
                        text = this.decode(text);
                        model.addItem(key, text);
                        if (!lb.isSelected(key)) continue;
                        model.addSelection(key);
                    }
                }
                lb.setModel(model);
            }
        }
        catch (IOException e) {
            Log.getLogLocation(false).debugT("DefaultListBoxSerializer", "deserialize");
        }
    }

    private String encode(String data) {
        return DefaultHtmlbEncoder.escape(data);
    }

    private String decode(String encodedData) {
        return DefaultHtmlbEncoder.unEscape(encodedData);
    }
}

