/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering.nn6;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.Tray;
import com.sapportals.htmlb.enum.TrayDesign;
import com.sapportals.htmlb.event.TrayHeaderClickEvent;
import com.sapportals.htmlb.rendering.HtmlbRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.RenderUtil;
import com.sapportals.htmlb.rendering.Section508Utils;
import com.sapportals.htmlb.util.Log;

public class NN6TrayRenderer
implements HtmlbRenderer {
    static int idcounter;

    public void render(Component component, int selector, IPageContext renderContext) {
        if (component instanceof Tray) {
            Tray myTray = (Tray)component;
            switch (selector) {
                case 0: {
                    this.renderBegin(myTray, renderContext);
                    break;
                }
                case 1: {
                    this.renderEnd(myTray, renderContext);
                }
            }
        }
    }

    public void render(Component component, IPageContext renderContext) {
        if (component instanceof Tray) {
            Tray myTray = (Tray)component;
            this.renderBegin(myTray, renderContext);
            RenderUtil.renderContainerContent(myTray, renderContext);
            this.renderEnd(myTray, renderContext);
        }
    }

    public void renderBegin(Tray tray, IPageContext renderContext) {
        String fullSuffix;
        String suffix;
        String openClosed;
        TrayDesign design = tray.getDesign();
        String trayId = renderContext.getParamIdForComponent(tray);
        boolean collapsed = tray.isCollapsed();
        String string = openClosed = collapsed ? "Closed" : "Open";
        if (design == TrayDesign.BORDERLESS) {
            fullSuffix = suffix = "Hdr";
        } else if (design == TrayDesign.FORM) {
            fullSuffix = suffix = "Frm";
        } else if (design == TrayDesign.TEXT) {
            suffix = "Bg";
            fullSuffix = suffix + openClosed;
        } else {
            fullSuffix = suffix = "Box";
        }
        renderContext.write("<input type=\"hidden\" name=\"");
        renderContext.write(trayId);
        renderContext.write("-es\" value=\"-1\">");
        renderContext.write("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"");
        if (tray.getWidth() != null) {
            renderContext.write("width:");
            renderContext.write(tray.getWidth());
            try {
                Integer.parseInt(tray.getWidth());
                renderContext.write("px");
            }
            catch (NumberFormatException e) {
                Log.getLogLocation(false).debugT("NN6TrayRenderer", "renderBegin");
            }
        }
        if (tray.getHeight() != null) {
            renderContext.write(";height:");
            renderContext.write(tray.getHeight());
            try {
                Integer.parseInt(tray.getHeight());
                renderContext.write("px");
            }
            catch (NumberFormatException e) {
                Log.getLogLocation(false).debugT("NN6TrayRenderer", "renderBegin");
            }
        }
        renderContext.write(";\" cols=\"1\" class=\"sapTrcWhl");
        renderContext.write(suffix);
        renderContext.write("\"><col width=\"100%\"><tr><td valign=\"top\"><table width=\"100%");
        renderContext.write("\" id=\"");
        renderContext.write(trayId);
        renderContext.write("-hd\" tabindex=\"0\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" class=\"sapTrcHd");
        renderContext.write(fullSuffix);
        String tooltip = tray.getTooltip();
        renderContext.write("\" title=\"");
        String tooltip508 = Section508Utils.getTrayTooltip(tray, renderContext);
        if (tooltip508 != null) {
            renderContext.writeEncoded(tooltip508);
        }
        if (tooltip508 != null && tooltip != null) {
            renderContext.write(" ");
        }
        if (tooltip != null) {
            renderContext.writeEncoded(tooltip);
        }
        renderContext.write("\"><tr valign=\"top\"><td valign=\"top\" nowrap class=\"sapTrcTit");
        renderContext.write(fullSuffix);
        renderContext.write("\">");
        renderContext.write(tray.getTitle());
        renderContext.write("</td><td align=\"left\"><span class=\"sapTrcTitEnd");
        renderContext.write(fullSuffix);
        renderContext.write("\">&nbsp;</span></td>");
        renderContext.write("<TD class=\"sapTrcHdCtrl");
        renderContext.write(fullSuffix);
        renderContext.write("\"><SPAN class=\"sapTxtStd\">&nbsp;</SPAN></TD>");
        renderContext.write("<td style=\"width:100%\" class=\"sapTrcIcons");
        renderContext.write(fullSuffix);
        renderContext.write("\" nowrap=\"\">");
        String onEdit = tray.getOnEdit();
        if (onEdit != null) {
            renderContext.write("<span tabindex=\"0\" class=\"sapTrcEd");
            renderContext.write(fullSuffix);
            tooltip508 = Section508Utils.getTrayIconTooltip(tray, renderContext, "PERSONALIZE");
            if (tooltip508 != null) {
                renderContext.write("\" title=\"");
                renderContext.writeEncoded(tooltip508);
            }
            renderContext.write("\" onkeypress=\"htmlbInvokeClick()");
            renderContext.write("\" onclick=\"");
            renderContext.write(TrayHeaderClickEvent.renderEventCall(renderContext, tray, "ed", onEdit));
            renderContext.write("\">&nbsp;</span>");
        }
        renderContext.write("<span tabindex=\"0\"");
        renderContext.write("\" onkeypress=\"htmlbInvokeClick()");
        renderContext.write("\" onclick=\"");
        String onCollapse = tray.getOnCollapse();
        String onExpand = tray.getOnExpand();
        if (collapsed) {
            if (onExpand != null) {
                renderContext.write(TrayHeaderClickEvent.renderEventCall(renderContext, tray, "exp", onExpand));
            } else if (onCollapse != null) {
                renderContext.write("if(htmlbToggleTray('");
                renderContext.write(trayId);
                renderContext.write("',1)){");
                renderContext.write(TrayHeaderClickEvent.renderEventCall(renderContext, tray, "col", onCollapse));
                renderContext.write("}");
            } else {
                renderContext.write("htmlbToggleTray('");
                renderContext.write(trayId);
                renderContext.write("',0)");
            }
            tooltip508 = Section508Utils.getTrayIconTooltip(tray, renderContext, "OPEN");
            if (tooltip508 != null) {
                renderContext.write("\" title=\"");
                renderContext.writeEncoded(tooltip508);
            }
        } else {
            if (onCollapse != null) {
                renderContext.write(TrayHeaderClickEvent.renderEventCall(renderContext, tray, "col", onCollapse));
            } else if (onExpand != null) {
                renderContext.write("if(htmlbToggleTray('");
                renderContext.write(trayId);
                renderContext.write("',2)){");
                renderContext.write(TrayHeaderClickEvent.renderEventCall(renderContext, tray, "exp", onExpand));
                renderContext.write("}");
            } else {
                renderContext.write("htmlbToggleTray('");
                renderContext.write(trayId);
                renderContext.write("',0)");
            }
            tooltip508 = Section508Utils.getTrayIconTooltip(tray, renderContext, "CLOSE");
            if (tooltip508 != null) {
                renderContext.write("\" title=\"");
                renderContext.writeEncoded(tooltip508);
            }
        }
        renderContext.write("\" class=\"sapTrcExp");
        renderContext.write(openClosed);
        renderContext.write(suffix);
        renderContext.write("\" id=\"");
        renderContext.write(trayId);
        renderContext.write("-exp\">&nbsp;</span>");
        String onRemove = tray.getOnRemove();
        if (onRemove != null) {
            renderContext.write("<span tabindex=\"0\" class=\"sapTrcRem");
            renderContext.write(fullSuffix);
            tooltip508 = Section508Utils.getTrayIconTooltip(tray, renderContext, "REMOVE");
            if (tooltip508 != null) {
                renderContext.write("\" title=\"");
                renderContext.writeEncoded(tooltip508);
            }
            renderContext.write("\" onkeypress=\"htmlbInvokeClick()");
            renderContext.write("\" onclick=\"");
            renderContext.write(TrayHeaderClickEvent.renderEventCall(renderContext, tray, "rm", onRemove));
            renderContext.write("\">&nbsp;</span>");
        }
        renderContext.write("</td></tr></table></td></tr><tr><td valign=\"top\" height=\"100%\"><table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" height=\"100%\"><tr><td valign=\"top\" width=\"100%\" height=\"100%\" id=\"");
        renderContext.write(trayId);
        renderContext.write("-bd\" class=\"sapTrcBody");
        renderContext.write(suffix);
        if (collapsed) {
            renderContext.write("\" style=\"display: none;");
        }
        renderContext.write("\">");
    }

    public void renderEnd(Tray tray, IPageContext renderContext) {
        TrayDesign design = tray.getDesign();
        String suffix = design.equals(TrayDesign.BORDERLESS) ? "Hdr" : (design.equals(TrayDesign.FORM) ? "Frm" : (design.equals(TrayDesign.TEXT) ? "Bg" : "Box"));
        renderContext.write("</td></tr></table></td></tr><tr><td><span class=\"sapTrcFt");
        renderContext.write(suffix);
        renderContext.write("\"></td></tr></table>");
    }
}

