/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering.nn6;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.enum.CellHAlign;
import com.sapportals.htmlb.enum.CellVAlign;
import com.sapportals.htmlb.enum.DataType;
import com.sapportals.htmlb.enum.TableCellStyle;
import com.sapportals.htmlb.enum.TableColumnType;
import com.sapportals.htmlb.enum.TableNavigationMode;
import com.sapportals.htmlb.enum.TableSelectionMode;
import com.sapportals.htmlb.enum.TableViewDesign;
import com.sapportals.htmlb.event.TableCellClickEvent;
import com.sapportals.htmlb.event.TableHeaderClickEvent;
import com.sapportals.htmlb.event.TableNavigationEvent;
import com.sapportals.htmlb.event.TableRowSelectionEvent;
import com.sapportals.htmlb.rendering.HtmlbRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.RenderUtil;
import com.sapportals.htmlb.table.IFooterRenderer;
import com.sapportals.htmlb.table.IHeaderCellRenderer;
import com.sapportals.htmlb.table.IHeaderRenderer;
import com.sapportals.htmlb.table.IRowRenderer;
import com.sapportals.htmlb.table.SpanInfo;
import com.sapportals.htmlb.table.TableColumn;
import com.sapportals.htmlb.table.TableView;

public class NN6TableViewRenderer
implements HtmlbRenderer {
    public void render(Component component, IPageContext rendererContext) {
        if (component instanceof TableView) {
            IHeaderRenderer headerRenderer;
            TableView tableView = (TableView)component;
            int columnCount = tableView.getColumnCount();
            int rowCount = tableView.getRowCount();
            int visibleRowCount = tableView.getVisibleRowCount();
            int visibleFirstRow = tableView.getVisibleFirstRow();
            boolean fillUpEmptyRows = tableView.isFillUpEmptyRows();
            this.renderBegin(tableView, rendererContext, true);
            this.renderHeadBegin(tableView, rendererContext);
            if (tableView.isHeaderVisible() && (headerRenderer = tableView.getHeaderRenderer()).willRenderHeader(tableView, rendererContext)) {
                this.renderHeadBeginTitle(tableView, rendererContext);
                headerRenderer.renderHeader(tableView, rendererContext);
                this.renderHeadEndTitle(tableView, rendererContext);
            }
            if (tableView.isCellHeaderVisible()) {
                this.renderBeginColumnHeaders(tableView, rendererContext);
                int i = 1;
                while (i <= columnCount) {
                    this.renderHeadCellBegin(tableView, rendererContext);
                    IHeaderCellRenderer myHeaderCellRenderer = tableView.getHeaderCellRenderer(i);
                    myHeaderCellRenderer.renderHeaderCell(i, tableView, rendererContext);
                    this.renderHeadCellEnd(tableView, rendererContext);
                    ++i;
                }
                this.renderEndColumnHeaders(tableView, rendererContext);
            }
            this.renderHeadEnd(tableView, rendererContext);
            this.renderContentBegin(tableView, rendererContext);
            int startRow = visibleFirstRow;
            int endRow = startRow + visibleRowCount - 1;
            if (endRow > rowCount) {
                endRow = rowCount;
            }
            if (rowCount == 0) {
                if (fillUpEmptyRows) {
                    startRow = 1;
                    endRow = visibleRowCount;
                    int i = startRow;
                    while (i < endRow) {
                        this.renderContRowBegin(tableView, rendererContext);
                        IRowRenderer myRowRenderer = tableView.getRowRenderer(i);
                        myRowRenderer.renderRow(i, tableView, rendererContext);
                        this.renderContRowEnd(tableView, rendererContext);
                        ++i;
                    }
                } else {
                    String emptyTableText = tableView.getEmptyTableText();
                    if (emptyTableText != null && !emptyTableText.equals("")) {
                        this.renderEmptyTableText(tableView, rendererContext, emptyTableText);
                    }
                }
            } else {
                int i = startRow;
                while (i <= endRow) {
                    this.renderContRowBegin(tableView, rendererContext);
                    IRowRenderer myRowRenderer = tableView.getRowRenderer(i);
                    myRowRenderer.renderRow(i, tableView, rendererContext);
                    this.renderContRowEnd(tableView, rendererContext);
                    ++i;
                }
                if (fillUpEmptyRows) {
                    int oldStartRow = startRow;
                    startRow = endRow + 1;
                    endRow = oldStartRow + visibleRowCount;
                    int i2 = startRow;
                    while (i2 < endRow) {
                        this.renderContRowBegin(tableView, rendererContext);
                        IRowRenderer myRowRenderer = tableView.getRowRenderer(i2);
                        myRowRenderer.renderRow(i2, tableView, rendererContext);
                        this.renderContRowEnd(tableView, rendererContext);
                        ++i2;
                    }
                }
            }
            this.renderContentEnd(tableView, rendererContext);
            if (tableView.isFooterVisible()) {
                this.renderFooterBegin(tableView, rendererContext);
                IFooterRenderer myFooterRenderer = tableView.getFooterRenderer();
                myFooterRenderer.renderFooter(tableView, rendererContext);
                this.renderFooterEnd(tableView, rendererContext);
            }
            this.renderEnd(tableView, rendererContext, true);
        }
    }

    public void render(Component component, int selector, IPageContext renderContext) {
        TableView myTableView = (TableView)component;
        switch (selector) {
            case 1: {
                this.renderBegin(myTableView, renderContext, true);
                break;
            }
            case 8: {
                this.renderContCellBegin(myTableView, renderContext);
                break;
            }
            case 6: {
                this.renderContentBegin(myTableView, renderContext);
                break;
            }
            case 7: {
                this.renderContRowBegin(myTableView, renderContext);
                break;
            }
            case 12: {
                this.renderFooterBegin(myTableView, renderContext);
                break;
            }
            case 2: {
                this.renderHeadBegin(myTableView, renderContext);
                break;
            }
            case 17: {
                this.renderHeadBeginTitle(myTableView, renderContext);
                break;
            }
            case 18: {
                this.renderHeadEndTitle(myTableView, renderContext);
                break;
            }
            case 19: {
                this.renderBeginColumnHeaders(myTableView, renderContext);
                break;
            }
            case 20: {
                this.renderEndColumnHeaders(myTableView, renderContext);
                break;
            }
            case 3: {
                this.renderHeadCellBegin(myTableView, renderContext);
                break;
            }
            case 16: {
                this.renderEnd(myTableView, renderContext, true);
                break;
            }
            case 9: {
                this.renderContCellEnd(myTableView, renderContext);
                break;
            }
            case 11: {
                this.renderContentEnd(myTableView, renderContext);
                break;
            }
            case 10: {
                this.renderContRowEnd(myTableView, renderContext);
                break;
            }
            case 15: {
                this.renderFooterEnd(myTableView, renderContext);
                break;
            }
            case 5: {
                this.renderHeadEnd(myTableView, renderContext);
                break;
            }
            case 4: {
                this.renderHeadCellEnd(myTableView, renderContext);
                break;
            }
            case 13: {
                this.renderFooterNavigation(myTableView, renderContext);
                break;
            }
            case 14: {
                this.renderFooterPositionIndicator(myTableView, renderContext);
            }
        }
    }

    public boolean tableRequiresOnClickHandler(TableView tableView) {
        int columnCount = tableView.getColumnCount();
        int i = 1;
        while (i <= columnCount) {
            String onCellClick = tableView.getColumn(i).getOnCellClick();
            if (onCellClick != null && onCellClick.length() > 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void renderBegin(TableView tableView, IPageContext rc, boolean generateOuterTable) {
        TableViewDesign design = tableView.getDesign();
        String width = tableView.getWidth();
        if (generateOuterTable) {
            rc.write("<table ");
            if (design.equals(TableViewDesign.ALTERNATING)) {
                rc.write(" class=\"sapTbvAlt\"");
            } else if (design.equals(TableViewDesign.TRANSPARENT)) {
                rc.write(" class=\"sapTbvTrans\"");
            } else {
                rc.write(" class=\"sapTbvStd\"");
            }
            if (width != null) {
                rc.write(" width=\"");
                rc.write(width);
                rc.write("\"");
            }
            rc.write(" cellspacing=\"0\" cellpadding=\"0\" border=\"0\"><tr><td>");
        }
        rc.write("<table");
        if (tableView.getSummary() != null) {
            rc.write(" summary=\"" + tableView.getSummary() + "\"");
        }
        rc.write(" onclick=\"");
        if (this.tableRequiresOnClickHandler(tableView)) {
            rc.write(TableCellClickEvent.renderEventCall(rc, tableView));
        } else {
            rc.write("\"");
        }
        int columnCount = tableView.getColumnCount();
        int i = 1;
        while (i <= columnCount) {
            String onCellClick = tableView.getColumn(i).getOnCellClick();
            if (onCellClick != null && onCellClick.length() > 0) {
                rc.write(" colEvt");
                rc.write(i);
                rc.write("=\"");
                rc.write(rc.getCurrentForm().getIdForEvent(onCellClick));
                rc.write("\"");
            }
            ++i;
        }
        rc.write(" height=\"\"");
        if (width != null) {
            rc.write(" width=\"");
            rc.write(width);
            rc.write("\"");
        }
        rc.write(" cellspacing=\"1\">");
        String fullFormId = rc.getParamIdForComponent(tableView);
    }

    public void renderHeadBegin(TableView tableView, IPageContext rc) {
        rc.write("<thead>");
    }

    public void renderHeadBeginTitle(TableView tableView, IPageContext rc) {
        rc.write("<tr>");
        rc.write("<td colspan=\"");
        if (tableView.getSelectionMode().equals(TableSelectionMode.NONE)) {
            rc.write(tableView.getColumnCount());
        } else {
            rc.write(tableView.getColumnCount() + 1);
        }
        TableViewDesign design = tableView.getDesign();
        if (design.equals(TableViewDesign.ALTERNATING)) {
            rc.write("\" class=\"sapTbvTitAlt\" align=\"left\">");
        } else if (design.equals(TableViewDesign.TRANSPARENT)) {
            rc.write("\" class=\"sapTbvTitTrans\" align=\"left\">");
        } else {
            rc.write("\" class=\"sapTbvTitStd\" align=\"left\">");
        }
    }

    public void renderHeadEndTitle(TableView tableView, IPageContext rc) {
        rc.write("</td></tr>");
    }

    public void renderBeginColumnHeaders(TableView tableView, IPageContext rc) {
        rc.write("<tr>");
        if (!tableView.getSelectionMode().equals(TableSelectionMode.NONE) && (tableView.getRowCount() != 0 || tableView.isFillUpEmptyRows())) {
            this.renderHeadCellBegin(tableView, rc);
            rc.write("&nbsp;");
            this.renderHeadCellEnd(tableView, rc);
        }
        tableView.setCurrentColumnIndex(0);
    }

    public void renderEndColumnHeaders(TableView tableView, IPageContext rc) {
        rc.write("</tr>");
    }

    public void renderHeadEnd(TableView tableView, IPageContext rc) {
        rc.write("</thead>");
    }

    public void renderHeadCellBegin(TableView tableView, IPageContext rc) {
        int currentColumnIndex = tableView.getCurrentColumnIndex() + 1;
        TableViewDesign design = tableView.getDesign();
        tableView.setCurrentColumnIndex(currentColumnIndex);
        rc.write("<td");
        String onHeaderClick = tableView.getOnHeaderClick();
        if (onHeaderClick != null) {
            rc.write(" style=\"cursor:pointer\" onClick=\"");
            rc.write(TableHeaderClickEvent.renderEventCall(rc, tableView, currentColumnIndex));
            rc.write("\"");
        }
        if (design.equals(TableViewDesign.ALTERNATING)) {
            rc.write(" class=\"sapTbvHdrAlt\">");
        } else if (design.equals(TableViewDesign.TRANSPARENT)) {
            rc.write(" class=\"sapTbvHdrTrans\">");
        } else {
            rc.write(" class=\"sapTbvHdrStd\">");
        }
    }

    public void renderHeadCellEnd(TableView tableView, IPageContext rc) {
        int currentCol = tableView.getCurrentColumnIndex();
        if (tableView.getColumnName(currentCol) == "" || tableView.getColumnName(currentCol) == null) {
            RenderUtil.renderOneByOneGif(rc);
        }
        rc.write("</td>");
    }

    public void renderContentBegin(TableView tableView, IPageContext rc) {
        tableView.setCurrentColumnIndex(0);
        tableView.setColspanForCurrentColumn(1);
        tableView.setCurrentRowIndex(0);
        int columnCount = tableView.getColumnCount();
        tableView.prepareSpanInfoBuffer();
        rc.write("<tbody>");
    }

    public void renderContRowBegin(TableView tableView, IPageContext rc) {
        int currentRow = tableView.getCurrentRowIndex() + 1;
        tableView.setCurrentRowIndex(currentRow);
        tableView.setCurrentColumnIndex(1);
        tableView.setColspanForCurrentColumn(0);
        TableViewDesign design = tableView.getDesign();
        int firstVisibleRow = tableView.getVisibleFirstRow();
        rc.write("<TR rr=\"");
        rc.write(currentRow + "\">");
        TableSelectionMode mySelectionMode = tableView.getSelectionMode();
        int rowCount = tableView.getRowCount();
        if (rowCount != 0 || tableView.isFillUpEmptyRows()) {
            int rowIndexInModel = currentRow + firstVisibleRow - 1;
            if (mySelectionMode.equals(TableSelectionMode.MULTISELECT)) {
                String id = rc.getParamIdForComponent(tableView);
                rc.write("<td style=\"width:1\"");
                if (design.equals(TableViewDesign.ALTERNATING)) {
                    if ((firstVisibleRow + currentRow) % 2 == 0) {
                        rc.write(" class=\"sapTbvCellAlt\">");
                    } else {
                        rc.write(" class=\"sapTbvCellStd\">");
                    }
                } else if (design.equals(TableViewDesign.TRANSPARENT)) {
                    rc.write(" class=\"sapTbvCellTrans\">");
                } else {
                    rc.write(" class=\"sapTbvCellStd\">");
                }
                rc.write("<input type='checkbox' name='");
                rc.write(id);
                rc.write("-chk");
                rc.write(currentRow);
                rc.write("'");
                if (!tableView.isRowSelectable(rowIndexInModel) || rowIndexInModel > rowCount) {
                    rc.write(" disabled=\"\"");
                } else if (tableView.isRowSelected(rowIndexInModel)) {
                    rc.write(" checked=\"\"");
                }
                rc.write("></td>");
            } else if (mySelectionMode.equals(TableSelectionMode.SINGLESELECT)) {
                String id = rc.getParamIdForComponent(tableView);
                rc.write("<td style=\"width:1\"");
                currentRow = tableView.getCurrentRowIndex();
                if (design.equals(TableViewDesign.ALTERNATING)) {
                    if ((firstVisibleRow + currentRow) % 2 == 0) {
                        rc.write(" class=\"sapTbvCellAlt\">");
                    } else {
                        rc.write(" class=\"sapTbvCellStd\">");
                    }
                } else if (design.equals(TableViewDesign.TRANSPARENT)) {
                    rc.write(" class=\"sapTbvCellTrans\">");
                } else {
                    rc.write(" class=\"sapTbvCellStd\">");
                }
                rc.write("<input type='radio' name='");
                rc.write(id);
                rc.write("-chk' value='");
                rc.write(currentRow);
                rc.write("'");
                if (!tableView.isRowSelectable(rowIndexInModel) || rowIndexInModel > rowCount) {
                    rc.write(" disabled=\"\"");
                } else {
                    String rowSelection = tableView.getOnRowSelection();
                    if (rowSelection != null && rowSelection.length() > 0) {
                        rc.write(" onClick=\"");
                        rc.write(TableRowSelectionEvent.renderEventCall(rc, tableView, currentRow));
                        rc.write("\"");
                    }
                    if (tableView.isRowSelected(rowIndexInModel)) {
                        rc.write(" checked=\"\"");
                    }
                }
                rc.write("></td>");
            }
        }
        rc.getCurrentForm().pushEventModifier(tableView);
    }

    public void renderContCellBegin(TableView tableView, IPageContext rc) {
        int currentRow = tableView.getCurrentRowIndex() + 1;
        int colIndex = tableView.getCurrentColumnIndex() + tableView.getColspanForCurrentColumn();
        int firstVisibleRow = tableView.getVisibleFirstRow();
        tableView.setCurrentColumnIndex(colIndex);
        int rowIndex = tableView.getCurrentRowIndex() + tableView.getVisibleFirstRow() - 1;
        int colspan = tableView.getColspanForCell(rowIndex, colIndex);
        int rowspan = tableView.getRowspanForCell(rowIndex, colIndex);
        SpanInfo spanInfo = tableView.getSpanInfoForCell(rowIndex, colIndex);
        CellHAlign hAlignment = tableView.getCellHAlignment(rowIndex, colIndex);
        if (hAlignment == null && spanInfo != null) {
            hAlignment = tableView.getCellHAlignment(spanInfo.originalRow, spanInfo.originalColumn);
        }
        CellVAlign vAlignment = tableView.getCellVAlignment(rowIndex, colIndex);
        tableView.setColspanForCurrentColumn(colspan);
        TableColumn column = tableView.getColumn(colIndex);
        rc.write("<td ");
        if (!column.isWrapping()) {
            rc.write("nowrap=\"\" ");
        }
        TableColumnType columnType = column.getType();
        DataType columnDataType = column.getDataType();
        if (hAlignment != null) {
            rc.write("align=\"" + hAlignment + "\" ");
        } else if (columnType != TableColumnType.USER && columnDataType.equals(DataType.BCD)) {
            rc.write("align=\"right\" ");
        } else if (columnType != TableColumnType.USER && columnDataType.equals(DataType.INTEGER)) {
            rc.write("align=\"right\" ");
        } else {
            rc.write("align=\"left\" ");
        }
        if (vAlignment != null) {
            rc.write("valign=\"" + vAlignment + "\" ");
        }
        if (colspan > 1) {
            rc.write("colspan=\"" + colspan + "\"");
        } else if (spanInfo != null && spanInfo.colspan > 1 && rowIndex == tableView.getVisibleFirstRow()) {
            rc.write("colspan=\"" + spanInfo.colspan + "\"");
        }
        if (rowspan > 1) {
            rc.write(" rowspan=\"" + rowspan + "\"");
        } else if (spanInfo != null && spanInfo.rowspan > 1 && rowIndex == tableView.getVisibleFirstRow()) {
            rc.write(" rowspan=\"" + spanInfo.rowspan + "\"");
        }
        TableCellStyle style = tableView.getStyleForCell(rowIndex, colIndex);
        if (TableCellStyle.NEGATIVE.equals(style)) {
            rc.write(" class=\"sapTbvCellNeg\"");
        } else if (TableCellStyle.POSITIVE.equals(style)) {
            rc.write(" class=\"sapTbvCellPos\"");
        } else if (TableCellStyle.SUBTOTAL.equals(style)) {
            rc.write(" class=\"sapTbvCellSubtot\"");
        } else if (TableCellStyle.TOTAL.equals(style)) {
            rc.write(" class=\"sapTbvCellTot\"");
        } else {
            TableViewDesign design = tableView.getDesign();
            if (design.equals(TableViewDesign.ALTERNATING)) {
                if ((firstVisibleRow + currentRow) % 2 == 0) {
                    rc.write(" class=\"sapTbvCellAlt\"");
                } else {
                    rc.write(" class=\"sapTbvCellStd\"");
                }
            } else if (design.equals(TableViewDesign.TRANSPARENT)) {
                rc.write(" class=\"sapTbvCellTrans\"");
            } else {
                rc.write(" class=\"sapTbvCellStd\"");
            }
        }
        String onClick = column.getOnCellClick();
        String width = column.getWidth();
        if (onClick != null) {
            rc.write(" style=\"cursor:pointer;");
            if (columnType == TableColumnType.IMAGE || columnType == TableColumnType.IMAGELINK) {
                rc.write("width:1;");
            } else if (width != null && width.length() <= 0) {
                rc.write("width:" + width + ";");
            }
            rc.write("\" cc=\"");
            rc.write(colIndex);
            rc.write("\"");
        } else if (columnType == TableColumnType.IMAGE || columnType == TableColumnType.IMAGELINK) {
            rc.write(" style=\"width:1;\"");
        } else if (width != null && !width.equals("")) {
            rc.write(" style=\"width:" + width + ";\"");
        }
        rc.write(">");
    }

    public void renderContCellEnd(TableView tableView, IPageContext rc) {
        if (tableView.getModel().getValueAt(tableView.getCurrentRowIndex(), tableView.getCurrentColumnIndex()) == null) {
            RenderUtil.renderOneByOneGif(rc);
        }
        rc.write("</td>");
    }

    public void renderContRowEnd(TableView tableView, IPageContext rc) {
        rc.write("</tr>");
        rc.getCurrentForm().popEventModifier();
    }

    public void renderContentEnd(TableView tableView, IPageContext rc) {
        rc.write("</tbody>");
    }

    public void renderFooterBegin(TableView tableView, IPageContext rc) {
        TableViewDesign design = tableView.getDesign();
        if (design.equals(TableViewDesign.ALTERNATING)) {
            rc.write("<tr><td align=\"left\" class=\"sapTbvHdrAlt\" colspan=\"");
        } else if (design.equals(TableViewDesign.TRANSPARENT)) {
            rc.write("<tr><td align=\"left\" class=\"sapTbvHdrTrans\" colspan=\"");
        } else {
            rc.write("<tr><td align=\"left\" class=\"sapTbvHdrStd\" colspan=\"");
        }
        if (tableView.getSelectionMode().equals(TableSelectionMode.NONE)) {
            rc.write(tableView.getColumnCount());
        } else {
            rc.write(tableView.getColumnCount() + 1);
        }
        rc.write("\" nowrap>");
        rc.write("<table border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\"><tr>");
    }

    public void renderFooterNavigation(TableView tableView, IPageContext rc) {
        int rowCount = tableView.getRowCount();
        int visibleRowCount = tableView.getVisibleRowCount();
        boolean navByLine = tableView.getNavigationMode().equals(TableNavigationMode.BYLINE);
        boolean isLastPage = visibleRowCount == rowCount;
        boolean isFirstRowVisible = tableView.getVisibleFirstRow() == 1;
        boolean isLastRowVisible = tableView.getVisibleLastRow() >= rowCount;
        rc.write("<TD class=\"sapTbvBtnTop");
        if (isFirstRowVisible) {
            rc.write("Dsbl\">&nbsp;</TD>");
        } else {
            rc.write("\" onClick=\"");
            rc.write(TableNavigationEvent.renderEventCall(rc, tableView, "top"));
            rc.write("\">&nbsp;</TD>");
        }
        rc.write("<td class=\"sapTbvBtnPgUp");
        if (isFirstRowVisible) {
            rc.write("Dsbl\">&nbsp;</td>");
        } else {
            rc.write("\" onClick=\"");
            rc.write(TableNavigationEvent.renderEventCall(rc, tableView, "pageUp"));
            rc.write("\">&nbsp;</td>");
        }
        if (navByLine) {
            if (isFirstRowVisible) {
                rc.write("<td class=\"sapTbvBtnUpDsbl\"></td>");
            } else {
                rc.write("<td class=\"sapTbvBtnUp\" onClick=\"");
                rc.write(TableNavigationEvent.renderEventCall(rc, tableView, "lineUp"));
                rc.write("\">&nbsp;</td>");
            }
            if (isLastRowVisible) {
                rc.write("<td class=\"sapTbvBtnDownDsbl\"></td>");
            } else {
                rc.write("<td class=\"sapTbvBtnDown\" onClick=\"");
                rc.write(TableNavigationEvent.renderEventCall(rc, tableView, "lineDown"));
                rc.write("\">&nbsp;</TD>");
            }
        }
        if (isLastPage || isLastRowVisible) {
            rc.write("<TD class=\"sapTbvBtnPgDownDsbl\"></TD>");
        } else {
            rc.write("<TD class=\"sapTbvBtnPgDown\" onClick=\"");
            rc.write(TableNavigationEvent.renderEventCall(rc, tableView, "pageDown"));
            rc.write("\">&nbsp;</TD>");
        }
        if (isLastPage || isLastRowVisible) {
            rc.write("<TD class=\"sapTbvBtnBottomDsbl\">&nbsp;</TD>");
        } else {
            rc.write("<TD class=\"sapTbvBtnBottom\" onClick=\"");
            rc.write(TableNavigationEvent.renderEventCall(rc, tableView, "bottom"));
            rc.write("\">&nbsp;</TD>");
        }
    }

    public void renderFooterPositionIndicator(TableView tableView, IPageContext rc) {
        int visibleRowCount = tableView.getVisibleRowCount();
        int visibleFirstRow = tableView.getVisibleFirstRow();
        TableViewDesign design = tableView.getDesign();
        if (design.equals(TableViewDesign.ALTERNATING)) {
            rc.write("<TD align=\"right\" class=\"sapTbvHdrAlt\">");
        } else if (design.equals(TableViewDesign.TRANSPARENT)) {
            rc.write("<TD align=\"right\" class=\"sapTbvHdrTrans\">");
        } else {
            rc.write("<TD align=\"right\" class=\"sapTbvHdrStd\">");
        }
        TableNavigationMode navigationMode = tableView.getNavigationMode();
        if (navigationMode.equals(TableNavigationMode.BYLINE)) {
            if (tableView.getRowCount() != 0) {
                rc.write(visibleFirstRow);
            } else {
                rc.write("0");
            }
            rc.write("/");
            rc.write(tableView.getRowCount());
        } else if (visibleRowCount != 0) {
            int pageCount = tableView.getRowCount() % visibleRowCount != 0 ? tableView.getRowCount() / visibleRowCount + 1 : tableView.getRowCount() / visibleRowCount;
            int currentPageIndex = tableView.getCurrentPageIndex();
            rc.write(currentPageIndex);
            rc.write("/");
            rc.write(pageCount);
        }
        rc.write("</TD>");
    }

    public void renderFooterEnd(TableView tableView, IPageContext rc) {
        rc.write("</tr></table></td></tr>");
    }

    public void renderEnd(TableView tableView, IPageContext rc, boolean generateOuterTable) {
        rc.write("</table>");
        if (generateOuterTable) {
            rc.write("</td></tr></table>");
        }
        String encodedKeys = tableView.encodeInternalData();
        rc.write("<input type=\"hidden\" name=\"");
        rc.write(rc.getParamIdForComponent(tableView));
        rc.write("-keys\" value=\"");
        rc.write(encodedKeys);
        rc.write("\">");
    }

    public void renderEmptyTableText(TableView tableView, IPageContext rc, String emptyTableText) {
        rc.write("<tr class=\"sapTbvCellAlt\">");
        rc.write("<td colspan=\"");
        if (tableView.getSelectionMode().equals(TableSelectionMode.NONE)) {
            rc.write(tableView.getColumnCount());
        } else {
            rc.write(tableView.getColumnCount() + 1);
        }
        rc.write("\">");
        rc.write(emptyTableText);
        rc.write("</td></tr>");
    }
}

