/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering.nn6;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.TextView;
import com.sapportals.htmlb.enum.HoverMenuTrigger;
import com.sapportals.htmlb.enum.LinkDesign;
import com.sapportals.htmlb.enum.LinkFontSize;
import com.sapportals.htmlb.enum.TextViewDesign;
import com.sapportals.htmlb.hovermenu.HoverMenu;
import com.sapportals.htmlb.hovermenu.LinkForHoverMenu;
import com.sapportals.htmlb.rendering.AtomHtmlbRenderer;
import com.sapportals.htmlb.rendering.IPageContext;

public class NN6LinkForHoverMenuRenderer
extends AtomHtmlbRenderer {
    public void render(Component component, IPageContext renderContext) {
        if (component instanceof LinkForHoverMenu) {
            LinkForHoverMenu link = (LinkForHoverMenu)component;
            HoverMenu menu = link.getHoverMenu();
            renderContext.write("<A href=\"javascript:void(0);\" class=\"sapLnk");
            if (!link.getLinkDesign().equals(LinkDesign.DRILLDOWN)) {
                if (link.getLinkDesign().equals(LinkDesign.FUNCTION)) {
                    renderContext.write("Function");
                } else if (link.getLinkDesign().equals(LinkDesign.REPORTING)) {
                    renderContext.write("Report");
                } else if (link.getLinkDesign().equals(LinkDesign.RESULT)) {
                    renderContext.write("Result");
                }
            }
            renderContext.write("\" id=\"");
            renderContext.write(link.getId());
            String tooltip = link.getTooltip();
            if (tooltip != null && !tooltip.equals("")) {
                renderContext.write("\" title=\"");
                renderContext.write(tooltip);
            }
            String componentId = renderContext.getParamIdForComponent(menu);
            if (menu.getMenuTrigger() == null) {
                renderContext.write("\" onmouseover=\"htmlbShowFirstMenu('");
            } else if (menu.getMenuTrigger().equals(HoverMenuTrigger.ONLRCLICK)) {
                renderContext.write("\" onclick=\"htmlbShowFirstMenu('");
                renderContext.write(componentId);
                renderContext.write("', this, 1); return false;\" oncontextmenu=\"htmlbShowFirstMenu('");
            } else {
                renderContext.write("\" ");
                renderContext.write(menu.getMenuTrigger().toString().toLowerCase());
                renderContext.write("=\"htmlbShowFirstMenu('");
            }
            renderContext.write(componentId);
            renderContext.write("', this, 1); return false;\">");
            TextViewDesign design = link.getDesign();
            TextView text = new TextView(link.getText());
            if (design != null) {
                text.setDesign(design);
            } else {
                LinkFontSize fontSize = link.getFontSize();
                if (fontSize != null && fontSize.equals(LinkFontSize.SMALL)) {
                    text.setDesign(TextViewDesign.LEGEND);
                }
            }
            text.setWrapping(link.isWrapping());
            renderContext.render(text);
            renderContext.write("</A>");
            if (menu != null) {
                if (menu.requiresForm()) {
                    renderContext.getCurrentForm().registerHoverMenu(menu);
                } else {
                    renderContext.getDocument().registerHoverMenu(menu);
                }
            }
        }
    }
}

