/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering.nn6;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.DragSource;
import com.sapportals.htmlb.enum.DropTargetDesign;
import com.sapportals.htmlb.rendering.AtomHtmlbRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.RenderUtil;

public class NN6DragSourceRenderer
extends AtomHtmlbRenderer {
    public void render(Component component, IPageContext rc) {
        if (component instanceof DragSource) {
            DragSource dragSource = (DragSource)component;
            this.renderBegin(dragSource, rc);
            this.renderElement(dragSource, rc);
            this.renderEnd(dragSource, rc);
        }
    }

    public void renderElement(DragSource dragSource, IPageContext rc) {
        RenderUtil.renderContainerContent(dragSource, rc);
    }

    public void renderBegin(DragSource dragSource, IPageContext rc) {
        rc.write("<span id=\"" + rc.getParamIdForComponent(dragSource) + "\" ");
        if (dragSource.getWidth() != null && dragSource.getWidth() != "") {
            rc.write("width=\"" + dragSource.getWidth() + "\" ");
        }
        rc.write("componentName=\"" + dragSource.getId() + "\" ");
        rc.write("DragContainer=\"X\" ");
        rc.write("SourceValue=\"" + dragSource.getValue() + "\" ");
        if (dragSource.getColumnKey() != null) {
            rc.write("columnKey=\"" + dragSource.getColumnKey() + "\" ");
        }
        if (dragSource.getSourceContainerName() != null) {
            rc.write("sourceContainerName=\"" + dragSource.getSourceContainerName() + "\" ");
        }
        rc.write("flavour=\"" + dragSource.getFlavoursAsString() + "\" ");
        if (dragSource.getDropTargetDesign() == DropTargetDesign.BORDERED) {
            rc.write("targetClass=\"urDDSelDropTargBrd\" ");
        }
        if (dragSource.getDropTargetDesign() == DropTargetDesign.UNDERLINED) {
            rc.write("targetClass=\"urDDSelDropTargUl\" ");
        }
        if (dragSource.getDropTargetDesign() == DropTargetDesign.NONE) {
            rc.write("targetClass=\"urDDUnselectDropTargets\" ");
        }
        rc.write(">");
    }

    public void renderEnd(DragSource dragSource, IPageContext rc) {
        rc.write("</span>");
        rc.write("<SCRIPT>");
        rc.write("document.getElementById(\"" + rc.getParamIdForComponent(dragSource) + "\").addEventListener(\"mousedown\",htmlbStartDrag, true);");
        rc.write("document.getElementById(\"" + rc.getParamIdForComponent(dragSource) + "\").addEventListener(\"mouseover\",htmlbDragMouseOver, true);");
        rc.write("document.getElementById(\"" + rc.getParamIdForComponent(dragSource) + "\").addEventListener(\"mouseout\",htmlbDragMouseOut, true);");
        rc.write("</SCRIPT>");
    }
}

