/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering.nn6;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.Document;
import com.sapportals.htmlb.hovermenu.HoverMenu;
import com.sapportals.htmlb.rendering.HtmlbRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.RenderUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class NN6DocumentRenderer
implements HtmlbRenderer {
    public void render(Component component, int selector, IPageContext renderContext) {
        if (component instanceof Document) {
            Document myDocument = (Document)component;
            switch (selector) {
                case 0: {
                    this.renderBegin(myDocument, renderContext);
                    break;
                }
                case 1: {
                    this.renderEnd(myDocument, renderContext);
                    break;
                }
                case 5: {
                    this.renderDocBegin(myDocument, renderContext);
                    break;
                }
                case 6: {
                    this.renderDocEnd(myDocument, renderContext);
                    break;
                }
                case 7: {
                    this.renderHeadBegin(myDocument, renderContext);
                    break;
                }
                case 8: {
                    this.renderHeadEnd(myDocument, renderContext);
                    break;
                }
                case 9: {
                    this.renderBodyBegin(myDocument, renderContext);
                    break;
                }
                case 10: {
                    this.renderBodyEnd(myDocument, renderContext);
                    break;
                }
                case 11: {
                    this.renderHead(myDocument, renderContext);
                    break;
                }
                case 12: {
                    this.renderDocType(myDocument, renderContext);
                }
            }
        }
    }

    public void render(Component component, IPageContext renderContext) {
        if (component instanceof Document) {
            Document myDocument = (Document)component;
            this.renderBegin(myDocument, renderContext);
            renderContext.write("<table cellspacing=\"0\" cellpadding=\"0\" width=\"100%\"><tr><td>");
            RenderUtil.renderContainerContent(myDocument, renderContext);
            renderContext.write("</td></tr><tr><td>");
            this.renderHoverMenus(myDocument, renderContext);
            this.renderClientTexts(myDocument, renderContext);
            renderContext.registerStylesheet("ur_fc");
            renderContext.write("</td></tr></table>");
            this.renderEnd(myDocument, renderContext);
        }
    }

    public void renderDocType(Document document, IPageContext rc) {
    }

    public void renderBegin(Document document, IPageContext rc) {
        rc.startDocument();
        rc.startDocumentHead(document.getTitle());
        rc.writeHeadIncludes();
        String rawHeadText = document.getHeadRawText();
        if (rawHeadText != null) {
            rc.writeHeadBegin(rawHeadText);
        }
        rc.endDocumentHead();
        rc.startDocumentBody();
    }

    public void renderEnd(Document document, IPageContext rc) {
        rc.endDocumentBody();
        rc.endDocument();
    }

    public void renderDocBegin(Document document, IPageContext pc) {
        pc.startDocument();
    }

    public void renderDocEnd(Document document, IPageContext pc) {
        pc.endDocument();
    }

    public void renderHeadBegin(Document document, IPageContext pc) {
        String myTitle = document.getTitle();
        pc.startDocumentHead(myTitle);
    }

    public void renderHeadEnd(Document document, IPageContext pc) {
        pc.endDocumentHead();
    }

    public void renderHead(Document document, IPageContext rc) {
        rc.startDocumentHead(document.getTitle());
        rc.writeHeadIncludes();
        String rawHeadText = document.getHeadRawText();
        if (rawHeadText != null) {
            rc.write(rawHeadText);
        }
        rc.endDocumentHead();
    }

    public void renderBodyBegin(Document document, IPageContext pc) {
        pc.startDocumentBody();
    }

    public void renderBodyEnd(Document document, IPageContext pc) {
        this.renderHoverMenus(document, pc);
        this.renderClientTexts(document, pc);
        pc.endDocumentBody();
    }

    private void renderHoverMenus(Document document, IPageContext pc) {
        HashSet hoverMenus = document.getHoverMenus();
        if (hoverMenus != null) {
            Iterator hoverIt = hoverMenus.iterator();
            while (hoverIt.hasNext()) {
                HoverMenu menu = (HoverMenu)hoverIt.next();
                pc.render(menu);
            }
        }
    }

    private void renderClientTexts(Document document, IPageContext pc) {
        ResourceBundle messages = ResourceBundle.getBundle("com.sapportals.htmlb.Localization", pc.getLocale());
        document.registerStandardText("SAPUR_FIELD");
        document.registerStandardText("SAPUR_SEPARATOR");
        document.registerStandardText("SAPUR_FIELD_DATE");
        document.registerStandardText("SAPUR_FIELD_NUMBER");
        document.registerStandardText("SAPUR_FIELD_TIME");
        document.registerStandardText("SAPUR_DISABLED");
        document.registerStandardText("SAPUR_INVALID");
        document.registerStandardText("SAPUR_READOLNY");
        document.registerStandardText("SAPUR_REQUIRED");
        HashSet allTexts = document.getStandardTexts();
        if (pc.requiresSection508Rendering() && document.get508Texts() != null) {
            if (allTexts != null && document.get508Texts() != null) {
                allTexts.addAll(document.get508Texts());
            } else {
                allTexts = document.get508Texts();
            }
        }
        if (allTexts != null) {
            pc.write("<script>");
            Iterator allTextsIt = allTexts.iterator();
            StringBuffer jsVar = new StringBuffer("htmlb_addTexts('" + pc.getLocale().toString() + "',{");
            while (allTextsIt.hasNext()) {
                String value;
                String key = (String)allTextsIt.next();
                try {
                    value = messages.getString(key);
                }
                catch (MissingResourceException ex) {
                    value = "";
                }
                jsVar.append(key + ":\"" + RenderUtil.encodeForHtml(value, true) + "\"");
                if (!allTextsIt.hasNext()) continue;
                jsVar.append(",");
            }
            jsVar.append("});");
            pc.write(jsVar.toString());
            pc.write("</script>");
        }
    }
}

