/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering.nn4;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.Tree;
import com.sapportals.htmlb.TreeNode;
import com.sapportals.htmlb.event.TreeNodeSelectEvent;
import com.sapportals.htmlb.rendering.HtmlbRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.RenderUtil;
import com.sapportals.htmlb.rendering.Section508Utils;
import java.util.Enumeration;

public class NN4TreeRenderer
implements HtmlbRenderer {
    public void render(Component component, int selector, IPageContext renderContext) {
        if (component instanceof Tree) {
            Tree tree = (Tree)component;
            switch (selector) {
                case 0: {
                    this.renderTreeBegin(tree, renderContext);
                    break;
                }
                case 1: {
                    this.renderTreeEnd(tree, renderContext);
                }
            }
        }
    }

    public void render(Component component, IPageContext renderContext) {
        if (component instanceof Tree) {
            String componentID = renderContext.getParamIdForComponent(component);
            Tree tree = (Tree)component;
            tree.setCurrentNodeId(1);
            String nodeID = this.getNodeID(tree, componentID);
            this.renderTreeBegin(tree, renderContext);
            int startLevel = 1;
            if (tree.isRootNodeVisible()) {
                this.renderRootNodeBegin(tree, nodeID, renderContext);
                startLevel = 2;
            }
            this.renderTreeLevel(tree, tree.getRootNode(), nodeID, startLevel, renderContext);
            if (tree.isRootNodeVisible()) {
                this.renderRootNodeEnd(tree, renderContext);
            }
            this.renderTreeEnd(tree, renderContext);
        }
    }

    private void renderTreeBegin(Tree tree, IPageContext renderContext) {
        String tooltip;
        String componentID = renderContext.getParamIdForComponent(tree);
        renderContext.write("<input type=\"hidden\" name=\"" + componentID + "Eln" + "\" value=\"" + tree.getRootNode().getNodeStatus() + "\">");
        String nodes = tree.getEncodedTreeHierachy();
        int charsPerLine = 120;
        int i = 0;
        int len = nodes.length();
        String part = null;
        int counter = 0;
        i = 0;
        while (i < len) {
            part = nodes.substring(i, i + charsPerLine > len ? len : i + charsPerLine);
            renderContext.write("<input type=\"hidden\" name=\"" + componentID + "Nodes" + "_" + counter + "\" value=\"" + part + "\">");
            ++counter;
            i += charsPerLine;
        }
        renderContext.write("<TABLE cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tr><td valign=\"top\" class=\"sapTreWhl\" width=\"100% ");
        if (tree.getHeight() != null) {
            renderContext.write("\" height=\"");
            renderContext.write(tree.getHeight());
        }
        if ((tooltip = tree.getTooltip()) != null) {
            renderContext.write("\" title=\"");
            renderContext.writeEncoded(tooltip);
        }
        renderContext.write("\">");
        renderContext.write("  <TABLE width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tr><td nowrap class=\"sapTreTit\">" + tree.getTitle() + "</td></tr></table>");
    }

    private void renderTreeEnd(Tree tree, IPageContext renderContext) {
        renderContext.write("</td></tr></table>");
    }

    private void renderRootNodeBegin(Tree tree, String nodeID, IPageContext renderContext) {
        TreeNode root = tree.getRootNode();
        renderContext.write("<TABLE cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tr><td id=\"" + nodeID + "\" status=\"" + this.getStatus(root) + "\" nowrap>");
        String tooltip = Section508Utils.getTreeNodeTooltip(root, renderContext, 0);
        RenderUtil.renderGif(renderContext, "treeview", this.getImageName(root), nodeID, tooltip);
        renderContext.write("   <SPAN nowrap class=\"sapTreNoDsbl\"><a href=\"#\" ");
        renderContext.write(this.getOnClick(renderContext, tree, root));
        renderContext.write(" class=\"sapTxtStd\" >");
        if (root.isEncode()) {
            renderContext.writeEncoded(this.getContent(renderContext, root));
        } else {
            renderContext.write(this.getContent(renderContext, root));
        }
        renderContext.write("</a></SPAN>");
        renderContext.write("</td></tr></table>");
    }

    private void renderRootNodeEnd(Tree tree, IPageContext renderContext) {
    }

    private void renderTreeLevelBegin(int level, String nodeID, String status, IPageContext renderContext) {
        String style = "style=\" display:none;\"";
        if (status.equals("open")) {
            style = "";
        }
        String levelClass = this.levelClass(level);
        renderContext.write("<table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tr><td id=\"" + nodeID.concat(":children") + "\" class=\"" + levelClass + "\"" + style + ">");
    }

    private void renderTreeLevelEnd(int level, IPageContext renderContext) {
        renderContext.write("</td></tr></table>");
    }

    private String levelClass(int level) {
        String lC = level == 1 ? "" : (level == 2 ? "sapTreNl2" : (level == 3 ? "sapTreNl3" : "sapTreNl4"));
        return lC;
    }

    private void renderTreeNodeBegin(Tree tree, TreeNode node, String nodeID, int level, IPageContext renderContext) {
        String offset = String.valueOf(20 + (level - 2) * 20);
        String levelClass = this.levelClass(level);
        renderContext.write("<TABLE cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tr><td id=\"" + nodeID + "\" status=\"" + this.getStatus(node) + "\" nowrap>");
        renderContext.write("<TABLE  cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tr><td id=\"" + nodeID.concat(":exp") + "\" onclick=\"sapTreExpClk(this)");
        renderContext.write("\">");
        RenderUtil.renderPixelGifSpan(offset, renderContext, 0);
        renderContext.write("</td><td>");
        String tooltip = Section508Utils.getTreeNodeTooltip(node, renderContext, level);
        RenderUtil.renderGif(renderContext, "treeview", this.getImageName(node), nodeID, tooltip);
        renderContext.write("    </td><td nowrap class=\"sapTreNoDsbl\"> <a href=\"#\"" + this.getOnClick(renderContext, tree, node) + " class=\"sapTxtStd\">");
        if (node.isEncode()) {
            renderContext.writeEncoded(this.getContent(renderContext, node));
        } else {
            renderContext.write(this.getContent(renderContext, node));
        }
        renderContext.write("</a></td></tr></table>");
        renderContext.write("</td></tr></table>");
    }

    private void renderTreeNodeEnd(TreeNode node, int level, IPageContext renderContext) {
    }

    private void renderTreeLevel(Tree tree, TreeNode parent, String nodeID, int level, IPageContext renderContext) {
        this.renderTreeLevelBegin(level, nodeID, this.getStatus(parent), renderContext);
        String componentID = renderContext.getParamIdForComponent(tree);
        Enumeration children = parent.getChildNodes();
        while (children.hasMoreElements()) {
            TreeNode child = (TreeNode)children.nextElement();
            String childNodeID = this.getNodeID(tree, componentID);
            child.setOpen(true);
            this.renderTreeNodeBegin(tree, child, childNodeID, level, renderContext);
            this.renderTreeLevel(tree, child, childNodeID, level + 1, renderContext);
            this.renderTreeNodeEnd(child, level, renderContext);
        }
        this.renderTreeLevelEnd(level, renderContext);
    }

    private String getNodeID(Tree tree, String componentID) {
        int nodeId = tree.getCurrentNodeId();
        tree.setCurrentNodeId(nodeId + 1);
        String id = String.valueOf(nodeId);
        return componentID.concat("-").concat(id);
    }

    private String getStatus(TreeNode node) {
        if (node.isOpen()) {
            return "open";
        }
        return "closed";
    }

    private String getImageName(TreeNode node) {
        if (!node.hasChildren()) {
            return "expander_none.gif";
        }
        if (node.isOpen()) {
            return "expander_open.gif";
        }
        return "expander_close.gif";
    }

    private String getContent(IPageContext renderContext, TreeNode node) {
        Object content = node.getContent();
        if (content instanceof String) {
            return content.toString();
        }
        Component c = (Component)content;
        return c.renderAsString(renderContext);
    }

    private String getOnClick(IPageContext renderContext, Tree tree, TreeNode node) {
        String onTreeClick = tree.getOnTreeClick();
        String onNodeClick = node.getOnNodeClick();
        if (onNodeClick != null || onTreeClick != null) {
            StringBuffer onClick = new StringBuffer();
            onClick.append(" onclick=\"");
            onClick.append(TreeNodeSelectEvent.renderEventCall(renderContext, tree, node));
            onClick.append("\" style=\"text-decoration:none\"");
            return onClick.toString();
        }
        return "";
    }
}

