/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering.nn4;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.Tray;
import com.sapportals.htmlb.enum.TrayDesign;
import com.sapportals.htmlb.event.TrayHeaderClickEvent;
import com.sapportals.htmlb.rendering.HtmlbRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.RenderUtil;

public class NN4TrayRenderer
implements HtmlbRenderer {
    static int idcounter;

    public void render(Component component, int selector, IPageContext renderContext) {
        if (component instanceof Tray) {
            Tray myTray = (Tray)component;
            switch (selector) {
                case 0: {
                    this.renderBegin(myTray, renderContext);
                    break;
                }
                case 1: {
                    this.renderEnd(myTray, renderContext);
                }
            }
        }
    }

    public void render(Component component, IPageContext renderContext) {
        if (component instanceof Tray) {
            Tray myTray = (Tray)component;
            this.renderBegin(myTray, renderContext);
            if (!myTray.isCollapsed()) {
                RenderUtil.renderContainerContent(myTray, renderContext);
            }
            this.renderEnd(myTray, renderContext);
        }
    }

    public void renderBegin(Tray tray, IPageContext renderContext) {
        String fullSuffix;
        String suffix;
        String openClosedImage;
        TrayDesign design = tray.getDesign();
        String trayId = renderContext.getParamIdForComponent(tray);
        boolean collapsed = tray.isCollapsed();
        String openClosed = collapsed ? "Closed" : "Open";
        String string = openClosedImage = collapsed ? "icon_open.gif" : "icon_close.gif";
        if (design == TrayDesign.BORDERLESS) {
            fullSuffix = suffix = "Hdr";
        } else if (design == TrayDesign.FORM) {
            fullSuffix = suffix = "Frm";
        } else if (design == TrayDesign.TEXT) {
            suffix = "Bg";
            fullSuffix = suffix + openClosed;
        } else {
            fullSuffix = suffix = "Box";
        }
        renderContext.write("<input type=\"hidden\" name=\"");
        renderContext.write(trayId);
        renderContext.write("_es\" value=\"");
        renderContext.write(String.valueOf(tray.isCollapsed()));
        renderContext.write("\">");
        renderContext.write("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" class=\"sapTrcWhl");
        renderContext.write(suffix);
        renderContext.write("\" id=\"");
        renderContext.write(trayId);
        renderContext.write("\" width=\"");
        renderContext.write(tray.getWidth());
        String tooltip = tray.getTooltip();
        if (tooltip != null) {
            renderContext.write("\" title=\"");
            renderContext.writeEncoded(tooltip);
        }
        renderContext.write("\"><tr><td width=\"100%\">");
        renderContext.write("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" class=\"sapTrcHd");
        renderContext.write(fullSuffix);
        renderContext.write("\">");
        renderContext.write("<tr><td width=\"100%\" class=\"sapTrcTit");
        renderContext.write(fullSuffix);
        renderContext.write("\" nobr>");
        RenderUtil.renderPixelGifSpan("5", renderContext, 0);
        String tmpTitle = tray.getTitle();
        if (tmpTitle == "" || tmpTitle == null) {
            tmpTitle = "&nbsp;&nbsp;&nbsp;";
        }
        renderContext.write(tmpTitle);
        renderContext.write("</td><td align=\"left\" class=\"sapTrcTitEnd");
        renderContext.write(fullSuffix);
        renderContext.write("\">&nbsp;</td>");
        renderContext.write("<TD class=\"sapTrcHdCtrl");
        renderContext.write(fullSuffix);
        renderContext.write("\">&nbsp;</TD>");
        renderContext.write("<td align=\"right\" class=\"sapTrcIcons");
        renderContext.write(fullSuffix);
        renderContext.write("\" nowrap>");
        String onEdit = tray.getOnEdit();
        if (onEdit != null) {
            renderContext.write("<a href=\"#\" onclick=\"");
            renderContext.write(TrayHeaderClickEvent.renderEventCall(renderContext, tray, "ed", onEdit));
            renderContext.write("\">");
            String img = "tray/icon_personalize.gif";
            RenderUtil.renderGif(renderContext, "tray", img, "img_1", "");
            renderContext.write("</a>");
        }
        renderContext.write("<a href=\"#\" onclick=\"");
        if (collapsed) {
            renderContext.write(TrayHeaderClickEvent.renderEventCall(renderContext, tray, "exp", tray.getOnExpand()));
        } else {
            renderContext.write(TrayHeaderClickEvent.renderEventCall(renderContext, tray, "col", tray.getOnCollapse()));
        }
        renderContext.write("\">");
        RenderUtil.renderGif(renderContext, "tray", openClosedImage, "img_tog", "");
        renderContext.write("</a>");
        String onRemove = tray.getOnRemove();
        if (onRemove != null) {
            renderContext.write("<a onclick=\"");
            renderContext.write(TrayHeaderClickEvent.renderEventCall(renderContext, tray, "rm", onRemove));
            renderContext.write("\">");
            RenderUtil.renderGif(renderContext, "tray", "icon_remove.gif", "img_2", "");
            renderContext.write("</a>");
        }
        renderContext.write("</td></tr></table></td></tr>");
        if (!collapsed) {
            if (design == TrayDesign.BORDER) {
                renderContext.write("<tr><td>");
                renderContext.write("<div width=\"100%\" class=\"sapTrcBodyBorder\">");
            }
            if (design == TrayDesign.FORM) {
                renderContext.write("<tr><td class=\"sapTrcBodyFrmCol\">");
                renderContext.write("<div width=\"100%\" class=\"sapTrcBodyFrm\">");
            }
            if (design == TrayDesign.TEXT) {
                renderContext.write("<tr><td class=\"sapTrcBodyBgCol\">");
                renderContext.write("<div width=\"100%\" class=\"sapTrcBodyBg\">");
            }
            if (design == TrayDesign.BORDERLESS) {
                renderContext.write("<tr><td class=\"sapTrcBodyHdrCol\">");
                renderContext.write("<div width=\"100%\" class=\"sapTrcBodyHdr\">");
            }
        }
    }

    public void renderEnd(Tray tray, IPageContext renderContext) {
        if (!tray.isCollapsed()) {
            TrayDesign design = tray.getDesign();
            String suffix = design.equals(TrayDesign.BORDERLESS) ? "Hdr" : (design.equals(TrayDesign.FORM) ? "Frm" : (design.equals(TrayDesign.TEXT) ? "Bg" : "Box"));
            RenderUtil.renderPixelGifSpan(tray.getWidth(), renderContext, 0);
            renderContext.write("</div>");
            renderContext.write("</td></tr><tr><td><div width=\"100%\" class=\"sapTrcFt");
            renderContext.write(suffix);
            renderContext.write("\"></div>");
            renderContext.write("</td></tr>");
        }
        renderContext.write("</table>");
    }
}

