/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering.nn4;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.TextView;
import com.sapportals.htmlb.enum.TextViewDesign;
import com.sapportals.htmlb.enum.TextViewLayout;
import com.sapportals.htmlb.hovermenu.HoverMenu;
import com.sapportals.htmlb.rendering.AtomHtmlbRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.RenderUtil;

public class NN4TextViewRenderer
extends AtomHtmlbRenderer {
    public void render(Component component, IPageContext rc) {
        if (component instanceof TextView) {
            String id;
            String tooltip;
            String tag;
            TextView tv = (TextView)component;
            TextViewLayout myLayout = tv.getLayout();
            if (myLayout == TextViewLayout.PARAGRAPH) {
                rc.write("<p class=\"");
                tag = "</p>";
            } else if (myLayout == TextViewLayout.BLOCK) {
                rc.write("<div class=\"");
                tag = "</div>";
            } else {
                rc.write("<span class=\"");
                tag = "</span>";
            }
            TextViewDesign myDesign = tv.getDesign();
            String design = myDesign == TextViewDesign.HEADER1 ? "sapTxtH1" : (myDesign == TextViewDesign.HEADER2 ? "sapTxtH2" : (myDesign == TextViewDesign.HEADER3 ? "sapTxtH3" : (myDesign == TextViewDesign.HEADER4 ? "sapTxtH4" : (myDesign == TextViewDesign.EMPHASIZED ? "sapTxtEmph" : (myDesign == TextViewDesign.STANDARD ? "sapTxtStd" : (myDesign == TextViewDesign.LABEL ? "sapTxtLbl" : (myDesign == TextViewDesign.LABELSMALL ? "sapTxtLblSml" : (myDesign == TextViewDesign.LEGEND ? "sapTxtLeg" : (myDesign == TextViewDesign.REFERENCE ? "sapTxtRef" : (myDesign == TextViewDesign.ERROR ? "sapTxtErr" : "sapTxtStd"))))))))));
            rc.write(design);
            String width = tv.getWidth();
            if (width != null) {
                rc.write("\" style=\"width:");
                rc.write(width);
                rc.write(";");
            }
            if ((tooltip = tv.getTooltip()) != null) {
                rc.write("\" title=\"");
                rc.writeEncoded(tooltip);
            }
            if ((id = tv.getId()) != null) {
                rc.write("\" id=\"");
                rc.write(id);
            } else if (tv.getHoverMenu() != null) {
                throw new IllegalArgumentException("A Textview used together with a HoverMenu must have an id");
            }
            HoverMenu menu = tv.getHoverMenu();
            if (menu != null) {
                rc.write("\">");
                rc.write("<a href=\"#\" style=\"underline:none;\" onclick=\"htmlbIntCalledMenuLevel=1;htmlbHoverRootComponentId='");
                rc.write(tv.getId());
                rc.write("';htmlbEventobj='");
                rc.write(rc.getParamIdForComponent(menu));
                rc.write("';\">");
                tag = "</a>" + tag;
            } else {
                rc.write("\">");
            }
            if (!tv.isWrapping()) {
                rc.write("<nobr>");
            }
            if (tv.isEncode()) {
                rc.write(RenderUtil.encodeForHtmlDisplay(tv.getText()));
            } else {
                rc.write(tv.getText());
            }
            if (tv.isRequired()) {
                rc.write("<span class=\"sapTxtReq\">*</span>");
            }
            if (myDesign == TextViewDesign.LABEL || myDesign == TextViewDesign.LABELSMALL) {
                rc.write("<span class=\"");
                rc.write(design);
                rc.write("\">&nbsp;</span>");
            }
            if (!tv.isWrapping()) {
                rc.write("</nobr>");
            }
            rc.write(tag);
            if (menu != null) {
                rc.getCurrentForm().registerHoverMenu(menu);
            }
        }
    }
}

