/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering.nn4;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.Form;
import com.sapportals.htmlb.enum.CellHAlign;
import com.sapportals.htmlb.enum.CellVAlign;
import com.sapportals.htmlb.enum.DataType;
import com.sapportals.htmlb.enum.TableCellStyle;
import com.sapportals.htmlb.enum.TableColumnType;
import com.sapportals.htmlb.enum.TableNavigationMode;
import com.sapportals.htmlb.enum.TableSelectionMode;
import com.sapportals.htmlb.enum.TableViewDesign;
import com.sapportals.htmlb.event.TableCellClickEvent;
import com.sapportals.htmlb.event.TableHeaderClickEvent;
import com.sapportals.htmlb.event.TableNavigationEvent;
import com.sapportals.htmlb.event.TableRowSelectionEvent;
import com.sapportals.htmlb.rendering.HtmlbRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.RenderUtil;
import com.sapportals.htmlb.table.IFooterRenderer;
import com.sapportals.htmlb.table.IHeaderCellRenderer;
import com.sapportals.htmlb.table.IHeaderRenderer;
import com.sapportals.htmlb.table.IRowRenderer;
import com.sapportals.htmlb.table.SpanInfo;
import com.sapportals.htmlb.table.TableColumn;
import com.sapportals.htmlb.table.TableView;

public class NN4TableViewRenderer
implements HtmlbRenderer {
    static /* synthetic */ Class class$com$sapportals$htmlb$event$TableCellClickEvent;

    public void render(Component component, IPageContext rendererContext) {
        if (component instanceof TableView) {
            IHeaderRenderer headerRenderer;
            TableView tableView = (TableView)component;
            int columnCount = tableView.getColumnCount();
            int rowCount = tableView.getRowCount();
            int visibleRowCount = tableView.getVisibleRowCount();
            int visibleFirstRow = tableView.getVisibleFirstRow();
            boolean fillUpEmptyRows = tableView.isFillUpEmptyRows();
            this.renderBegin(tableView, rendererContext);
            this.renderHeadBegin(tableView, rendererContext);
            if (tableView.isHeaderVisible() && (headerRenderer = tableView.getHeaderRenderer()).willRenderHeader(tableView, rendererContext)) {
                this.renderHeadBeginTitle(tableView, rendererContext);
                headerRenderer.renderHeader(tableView, rendererContext);
                this.renderHeadEndTitle(tableView, rendererContext);
            }
            if (tableView.isCellHeaderVisible()) {
                this.renderBeginColumnHeaders(tableView, rendererContext);
                int i = 1;
                while (i <= columnCount) {
                    this.renderHeadCellBegin(tableView, rendererContext);
                    IHeaderCellRenderer myHeaderCellRenderer = tableView.getHeaderCellRenderer(i);
                    myHeaderCellRenderer.renderHeaderCell(i, tableView, rendererContext);
                    this.renderHeadCellEnd(tableView, rendererContext);
                    ++i;
                }
                this.renderEndColumnHeaders(tableView, rendererContext);
            }
            this.renderHeadEnd(tableView, rendererContext);
            this.renderContentBegin(tableView, rendererContext);
            int startRow = visibleFirstRow;
            int endRow = startRow + visibleRowCount - 1;
            if (endRow > rowCount) {
                endRow = rowCount;
            }
            if (rowCount == 0) {
                if (fillUpEmptyRows) {
                    startRow = 1;
                    endRow = visibleRowCount;
                    int i = startRow;
                    while (i <= endRow) {
                        this.renderContRowBegin(tableView, rendererContext);
                        IRowRenderer myRowRenderer = tableView.getRowRenderer(i);
                        myRowRenderer.renderRow(i, tableView, rendererContext);
                        this.renderContRowEnd(tableView, rendererContext);
                        ++i;
                    }
                } else {
                    String emptyTableText = tableView.getEmptyTableText();
                    if (emptyTableText != null && !emptyTableText.equals("")) {
                        this.renderEmptyTableText(tableView, rendererContext, emptyTableText);
                    }
                }
            } else {
                int i = startRow;
                while (i <= endRow) {
                    this.renderContRowBegin(tableView, rendererContext);
                    IRowRenderer myRowRenderer = tableView.getRowRenderer(i);
                    myRowRenderer.renderRow(i, tableView, rendererContext);
                    this.renderContRowEnd(tableView, rendererContext);
                    ++i;
                }
                if (fillUpEmptyRows) {
                    int oldStartRow = startRow;
                    startRow = endRow + 1;
                    endRow = oldStartRow + visibleRowCount;
                    int i2 = startRow;
                    while (i2 < endRow) {
                        this.renderContRowBegin(tableView, rendererContext);
                        IRowRenderer myRowRenderer = tableView.getRowRenderer(i2);
                        myRowRenderer.renderRow(i2, tableView, rendererContext);
                        this.renderContRowEnd(tableView, rendererContext);
                        ++i2;
                    }
                }
            }
            this.renderContentEnd(tableView, rendererContext);
            if (tableView.isFooterVisible()) {
                this.renderFooterBegin(tableView, rendererContext);
                IFooterRenderer myFooterRenderer = tableView.getFooterRenderer();
                myFooterRenderer.renderFooter(tableView, rendererContext);
                this.renderFooterEnd(tableView, rendererContext);
            }
            this.renderEnd(tableView, rendererContext);
        }
    }

    public void render(Component component, int selector, IPageContext renderContext) {
        TableView myTableView = (TableView)component;
        switch (selector) {
            case 1: {
                this.renderBegin(myTableView, renderContext);
                break;
            }
            case 8: {
                this.renderContCellBegin(myTableView, renderContext);
                break;
            }
            case 6: {
                this.renderContentBegin(myTableView, renderContext);
                break;
            }
            case 7: {
                this.renderContRowBegin(myTableView, renderContext);
                break;
            }
            case 12: {
                this.renderFooterBegin(myTableView, renderContext);
                break;
            }
            case 2: {
                this.renderHeadBegin(myTableView, renderContext);
                break;
            }
            case 17: {
                this.renderHeadBeginTitle(myTableView, renderContext);
                break;
            }
            case 18: {
                this.renderHeadEndTitle(myTableView, renderContext);
                break;
            }
            case 19: {
                this.renderBeginColumnHeaders(myTableView, renderContext);
                break;
            }
            case 20: {
                this.renderEndColumnHeaders(myTableView, renderContext);
                break;
            }
            case 3: {
                this.renderHeadCellBegin(myTableView, renderContext);
                break;
            }
            case 16: {
                this.renderEnd(myTableView, renderContext);
                break;
            }
            case 9: {
                this.renderContCellEnd(myTableView, renderContext);
                break;
            }
            case 11: {
                this.renderContentEnd(myTableView, renderContext);
                break;
            }
            case 10: {
                this.renderContRowEnd(myTableView, renderContext);
                break;
            }
            case 15: {
                this.renderFooterEnd(myTableView, renderContext);
                break;
            }
            case 5: {
                this.renderHeadEnd(myTableView, renderContext);
                break;
            }
            case 4: {
                this.renderHeadCellEnd(myTableView, renderContext);
                break;
            }
            case 13: {
                this.renderFooterNavigation(myTableView, renderContext);
                break;
            }
            case 14: {
                this.renderFooterPositionIndicator(myTableView, renderContext);
            }
        }
    }

    public boolean tableRequiresOnClickHandler(TableView tableView) {
        int columnCount = tableView.getColumnCount();
        int i = 1;
        while (i <= columnCount) {
            String onCellClick = tableView.getColumn(i).getOnCellClick();
            if (onCellClick != null && onCellClick.length() > 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void renderBegin(TableView tableView, IPageContext rc) {
        TableViewDesign design = tableView.getDesign();
        rc.write("<div");
        if (design.equals(TableViewDesign.ALTERNATING)) {
            rc.write(" class=\"sapTbvAlt\"");
        } else if (design.equals(TableViewDesign.TRANSPARENT)) {
            rc.write(" class=\"sapTbvTrans\"");
        } else {
            rc.write(" class=\"sapTbvStd\"");
        }
        String width = tableView.getWidth();
        if (width != null) {
            rc.write(" width=\"");
            rc.write(width);
            rc.write("\"");
        }
        rc.write(">");
        rc.write("<table cellspacing=\"1px\" cellpadding=\"0\" border=\"0\"");
        if (tableView.getSummary() != null) {
            rc.write(" summary=\"" + tableView.getSummary() + "\"");
        }
        rc.write(" onclick=\"");
        if (this.tableRequiresOnClickHandler(tableView)) {
            rc.write(TableCellClickEvent.renderEventCall(rc, tableView));
        } else {
            rc.write("\"");
        }
        int columnCount = tableView.getColumnCount();
        int i = 1;
        while (i <= columnCount) {
            String onCellClick = tableView.getColumn(i).getOnCellClick();
            if (onCellClick != null && onCellClick.length() > 0) {
                rc.write(" colEvt");
                rc.write(i);
                rc.write("=\"");
                rc.write(rc.getCurrentForm().getIdForEvent(onCellClick));
                rc.write("\"");
            }
            ++i;
        }
        if (design.equals(TableViewDesign.ALTERNATING)) {
            rc.write(" class=\"sapTbvAlt\"");
        } else if (design.equals(TableViewDesign.TRANSPARENT)) {
            rc.write(" class=\"sapTbvTrans\"");
        } else {
            rc.write(" class=\"sapTbvStd\"");
        }
        rc.write(" height=\"\"");
        if (width != null) {
            rc.write(" width=\"");
            rc.write(width);
            rc.write("\"");
        }
        rc.write(">");
        String fullFormId = rc.getParamIdForComponent(tableView);
    }

    public void renderHeadBegin(TableView tableView, IPageContext rc) {
        rc.write("<thead>");
    }

    public void renderHeadBeginTitle(TableView tableView, IPageContext rc) {
        rc.write("<tr>");
        rc.write("<td colspan=\"");
        if (tableView.getSelectionMode().equals(TableSelectionMode.NONE)) {
            rc.write(tableView.getColumnCount());
        } else {
            rc.write(tableView.getColumnCount() + 1);
        }
        TableViewDesign design = tableView.getDesign();
        if (design.equals(TableViewDesign.ALTERNATING)) {
            rc.write("\" class=\"sapTbvTitAlt\" align=\"left\">");
        } else if (design.equals(TableViewDesign.TRANSPARENT)) {
            rc.write("\" class=\"sapTbvTitTrans\" align=\"left\">");
        } else {
            rc.write("\" class=\"sapTbvTitStd\" align=\"left\">");
        }
    }

    public void renderHeadEndTitle(TableView tableView, IPageContext rc) {
        rc.write("</td></tr>");
    }

    public void renderBeginColumnHeaders(TableView tableView, IPageContext rc) {
        TableViewDesign design = tableView.getDesign();
        if (design.equals(TableViewDesign.ALTERNATING)) {
            rc.write("<tr class=\"sapTbvHdrAlt\">");
        } else if (design.equals(TableViewDesign.TRANSPARENT)) {
            rc.write("<tr class=\"sapTbvHdrTrans\">");
        } else {
            rc.write("<tr class=\"sapTbvHdrStd\">");
        }
        if (!tableView.getSelectionMode().equals(TableSelectionMode.NONE) && (tableView.getRowCount() != 0 || tableView.isFillUpEmptyRows())) {
            this.renderHeadCellBegin(tableView, rc);
            rc.write("&nbsp;");
            this.renderHeadCellEnd(tableView, rc);
        }
        tableView.setCurrentColumnIndex(0);
    }

    public void renderEndColumnHeaders(TableView tableView, IPageContext rc) {
        rc.write("</tr>");
    }

    public void renderHeadEnd(TableView tableView, IPageContext rc) {
        rc.write("</thead>");
    }

    public void renderHeadCellBegin(TableView tableView, IPageContext rc) {
        int currentColumnIndex = tableView.getCurrentColumnIndex() + 1;
        tableView.setCurrentColumnIndex(currentColumnIndex);
        rc.write("<th class=\"sapTbvHdrStd\"");
        String onHeaderClick = tableView.getOnHeaderClick();
        if (onHeaderClick != null) {
            rc.write("><a href=\"#\" style=\"text-decoration:none;\" class=\"sapTbvHdrStd\" onClick=\"");
            rc.write(TableHeaderClickEvent.renderEventCall(rc, tableView, currentColumnIndex));
            rc.write("\"");
        }
        rc.write(">");
    }

    public void renderHeadCellEnd(TableView tableView, IPageContext rc) {
        String onHeaderClick;
        int currentCol = tableView.getCurrentColumnIndex();
        if (tableView.getColumnName(currentCol) == "" || tableView.getColumnName(currentCol) == null) {
            RenderUtil.renderOneByOneGif(rc);
        }
        if ((onHeaderClick = tableView.getOnHeaderClick()) != null) {
            rc.write("</a>");
        }
        rc.write("</th>");
    }

    public void renderContentBegin(TableView tableView, IPageContext rc) {
        tableView.setCurrentColumnIndex(0);
        tableView.setColspanForCurrentColumn(1);
        tableView.setCurrentRowIndex(0);
        int columnCount = tableView.getColumnCount();
        tableView.prepareSpanInfoBuffer();
        rc.write("<tbody>");
    }

    public void renderContRowBegin(TableView tableView, IPageContext rc) {
        int currentRow = tableView.getCurrentRowIndex() + 1;
        tableView.setCurrentRowIndex(currentRow);
        tableView.setCurrentColumnIndex(1);
        tableView.setColspanForCurrentColumn(0);
        int firstVisibleRow = tableView.getVisibleFirstRow();
        TableViewDesign design = tableView.getDesign();
        if (design.equals(TableViewDesign.ALTERNATING)) {
            if ((firstVisibleRow + currentRow) % 2 == 0) {
                rc.write("<TR class=\"sapTbvCellAlt\" rr=\"");
            } else {
                rc.write("<TR class=\"sapTbvCellStd\" rr=\"");
            }
        } else if (design.equals(TableViewDesign.TRANSPARENT)) {
            rc.write("<TR class=\"sapTbvCellTrans\" rr=\"");
        } else {
            rc.write("<TR class=\"sapTbvCellStd\" rr=\"");
        }
        rc.write(currentRow + "\">");
        TableSelectionMode mySelectionMode = tableView.getSelectionMode();
        int rowCount = tableView.getRowCount();
        if (rowCount != 0 || tableView.isFillUpEmptyRows()) {
            int rowIndexInModel = currentRow + firstVisibleRow - 1;
            if (mySelectionMode.equals(TableSelectionMode.MULTISELECT)) {
                String id = rc.getParamIdForComponent(tableView);
                rc.write("<td style=\"width:1\">");
                rc.write("<input type='checkbox' name='");
                rc.write(id);
                rc.write("-chk");
                rc.write(currentRow);
                rc.write("'");
                if (!tableView.isRowSelectable(rowIndexInModel) || rowIndexInModel > rowCount) {
                    rc.write(" disabled=\"\"");
                } else if (tableView.isRowSelected(rowIndexInModel)) {
                    rc.write(" checked=\"\"");
                }
                rc.write("></td>");
            } else if (mySelectionMode.equals(TableSelectionMode.SINGLESELECT)) {
                String id = rc.getParamIdForComponent(tableView);
                rc.write("<td style=\"width:1\">");
                rc.write("<input type='radio' name='");
                rc.write(id);
                rc.write("-chk' value='");
                rc.write(currentRow);
                rc.write("'");
                if (!tableView.isRowSelectable(rowIndexInModel) || rowIndexInModel > rowCount) {
                    rc.write(" disabled=\"\"");
                } else {
                    String rowSelection = tableView.getOnRowSelection();
                    if (rowSelection != null && rowSelection.length() > 0) {
                        rc.write(" onClick=");
                        rc.write(TableRowSelectionEvent.renderEventCall(rc, tableView, currentRow));
                    }
                    if (tableView.isRowSelected(rowIndexInModel)) {
                        rc.write(" checked=\"\"");
                    }
                }
                rc.write("></td>");
            }
        }
        rc.getCurrentForm().pushEventModifier(tableView);
    }

    public void renderContCellBegin(TableView tableView, IPageContext rc) {
        int colIndex = tableView.getCurrentColumnIndex() + tableView.getColspanForCurrentColumn();
        tableView.setCurrentColumnIndex(colIndex);
        int rowIndex = tableView.getCurrentRowIndex() + tableView.getVisibleFirstRow() - 1;
        int colspan = tableView.getColspanForCell(rowIndex, colIndex);
        int rowspan = tableView.getRowspanForCell(rowIndex, colIndex);
        SpanInfo spanInfo = tableView.getSpanInfoForCell(rowIndex, colIndex);
        CellHAlign hAlignment = tableView.getCellHAlignment(rowIndex, colIndex);
        if (hAlignment == null && spanInfo != null) {
            hAlignment = tableView.getCellHAlignment(spanInfo.originalRow, spanInfo.originalColumn);
        }
        CellVAlign vAlignment = tableView.getCellVAlignment(rowIndex, colIndex);
        tableView.setColspanForCurrentColumn(colspan);
        TableColumn column = tableView.getColumn(colIndex);
        rc.write("<td ");
        if (!column.isWrapping()) {
            rc.write("nowrap=\"\" ");
        }
        TableViewDesign design = tableView.getDesign();
        int firstVisibleRow = tableView.getVisibleFirstRow();
        int currentRow = tableView.getCurrentRowIndex();
        if (design.equals(TableViewDesign.ALTERNATING)) {
            if ((firstVisibleRow + currentRow) % 2 == 0) {
                rc.write(" class=\"sapTbvCellAlt\" ");
            } else {
                rc.write(" class=\"sapTbvCellStd\" ");
            }
        } else if (design.equals(TableViewDesign.TRANSPARENT)) {
            rc.write(" class=\"sapTbvCellTrans\" ");
        } else {
            rc.write(" class=\"sapTbvCellStd\" ");
        }
        TableColumnType columnType = column.getType();
        DataType columnDataType = column.getDataType();
        if (hAlignment != null) {
            rc.write("align=\"" + hAlignment + "\" ");
        } else if (columnType != TableColumnType.USER && columnDataType.equals(DataType.BCD)) {
            rc.write("align=\"right\" ");
        } else if (columnType != TableColumnType.USER && columnDataType.equals(DataType.INTEGER)) {
            rc.write("align=\"right\" ");
        } else {
            rc.write("align=\"left\" ");
        }
        if (vAlignment != null) {
            rc.write("valign=\"" + vAlignment + "\" ");
        }
        if (colspan > 1) {
            rc.write("colspan=\"" + colspan + "\"");
        } else if (spanInfo != null && spanInfo.colspan > 1 && rowIndex == tableView.getVisibleFirstRow()) {
            rc.write("colspan=\"" + spanInfo.colspan + "\"");
        }
        if (rowspan > 1) {
            rc.write(" rowspan=\"" + rowspan + "\"");
        } else if (spanInfo != null && spanInfo.rowspan > 1 && rowIndex == tableView.getVisibleFirstRow()) {
            rc.write(" rowspan=\"" + spanInfo.rowspan + "\"");
        }
        TableCellStyle style = tableView.getStyleForCell(rowIndex, colIndex);
        if (TableCellStyle.NEGATIVE.equals(style)) {
            rc.write(" class=\"sapTbvCellNeg\"");
        } else if (TableCellStyle.POSITIVE.equals(style)) {
            rc.write(" class=\"sapTbvCellPos\"");
        } else if (TableCellStyle.MARKED.equals(style)) {
            rc.write(" class=\"sapTbvCellMarked\"");
        } else if (TableCellStyle.SUBTOTAL.equals(style)) {
            rc.write(" class=\"sapTbvCellSubtot\"");
        } else if (TableCellStyle.SUBTOTAL_LIGHT.equals(style)) {
            rc.write(" class=\"sapTbvCellSubtotLight\"");
        } else if (TableCellStyle.TOTAL.equals(style)) {
            rc.write(" class=\"sapTbvCellTot\"");
        } else if (TableCellStyle.BADVALUE_DARK.equals(style)) {
            rc.write(" class=\"sapTbvCellBadDark\"");
        } else if (TableCellStyle.BADVALUE_MEDIUM.equals(style)) {
            rc.write(" class=\"sapTbvCellBadMedium\"");
        } else if (TableCellStyle.BADVALUE_LIGHT.equals(style)) {
            rc.write(" class=\"sapTbvCellBadLight\"");
        } else if (TableCellStyle.CRITICALVALUE_DARK.equals(style)) {
            rc.write(" class=\"sapTbvCellCritDark\"");
        } else if (TableCellStyle.CRITICALVALUE_MEDIUM.equals(style)) {
            rc.write(" class=\"sapTbvCellCritMedium\"");
        } else if (TableCellStyle.CRITICALVALUE_LIGHT.equals(style)) {
            rc.write(" class=\"sapTbvCellCritLight\"");
        } else if (TableCellStyle.GOODVALUE_DARK.equals(style)) {
            rc.write(" class=\"sapTbvCellGoodDark\"");
        } else if (TableCellStyle.GOODVALUE_MEDIUM.equals(style)) {
            rc.write(" class=\"sapTbvCellGoodMedium\"");
        } else if (TableCellStyle.GOODVALUE_LIGHT.equals(style)) {
            rc.write(" class=\"sapTbvCellGoodLight\"");
        } else if (TableCellStyle.GROUP_HIGHLIGHTED.equals(style)) {
            rc.write(" class=\"sapTbvCellGrpHL\"");
        } else if (TableCellStyle.GROUP_HIGHLIGHTED_LIGHT.equals(style)) {
            rc.write(" class=\"sapTbvCellGrpHLLight\"");
        } else if (TableCellStyle.GROUP_LEVEL1.equals(style)) {
            rc.write(" class=\"sapTbvCellGrpLvl1\"");
        } else if (TableCellStyle.GROUP_LEVEL2.equals(style)) {
            rc.write(" class=\"sapTbvCellGrpLvl2\"");
        } else if (TableCellStyle.GROUP_LEVEL3.equals(style)) {
            rc.write(" class=\"sapTbvCellGrpLvl3\"");
        } else if (TableCellStyle.KEY_MEDIUM.equals(style)) {
            rc.write(" class=\"sapTbvCellKeyMedium\"");
        }
        String onClick = column.getOnCellClick();
        String width = column.getWidth();
        if (onClick != null) {
            rc.write(" style=\"cursor:hand;");
            if (columnType == TableColumnType.IMAGE || columnType == TableColumnType.IMAGELINK) {
                rc.write("width:1;");
            } else if (width != null && width.length() <= 0) {
                rc.write("width:" + width + ";");
            }
            rc.write("\" cc=\"");
            rc.write(colIndex);
            rc.write("\"");
        } else if (columnType == TableColumnType.IMAGE || columnType == TableColumnType.IMAGELINK) {
            rc.write(" style=\"width:1;\"");
        } else if (width != null && !width.equals("")) {
            rc.write(" style=\"width:" + width + ";\"");
        }
        rc.write(">");
        if (onClick != null) {
            rc.write("<a href=\"#\" onClick=\"");
            rc.write("htmlbTbvCellClick(");
            rc.write(colIndex + ", ");
            rc.write(rowIndex + ", '");
            rc.write(rc.getCurrentFormId());
            rc.write("', ");
            Form myForm = rc.getCurrentForm();
            rc.write(myForm.getIndexOfElement(tableView));
            rc.write(", ");
            rc.write(myForm.getIdForEvent((class$com$sapportals$htmlb$event$TableCellClickEvent == null ? (class$com$sapportals$htmlb$event$TableCellClickEvent = NN4TableViewRenderer.class$("com.sapportals.htmlb.event.TableCellClickEvent")) : class$com$sapportals$htmlb$event$TableCellClickEvent).getName()));
            rc.write(", ");
            String onCellClick = tableView.getColumn(colIndex).getOnCellClick();
            if (onCellClick != null) {
                int tableOnCellClick = rc.getCurrentForm().getIdForEvent(onCellClick);
                rc.write(tableOnCellClick);
            }
            rc.write(")\">");
        }
    }

    public void renderContCellEnd(TableView tableView, IPageContext rc) {
        int colIndex;
        TableColumn column;
        String onClick;
        if (tableView.getModel().getValueAt(tableView.getCurrentRowIndex(), tableView.getCurrentColumnIndex()) == null) {
            RenderUtil.renderOneByOneGif(rc);
        }
        if ((onClick = (column = tableView.getColumn(colIndex = tableView.getCurrentColumnIndex())).getOnCellClick()) != null) {
            rc.write("</a>");
        }
        rc.write("</td>");
    }

    public void renderContRowEnd(TableView tableView, IPageContext rc) {
        rc.write("</tr>");
        rc.getCurrentForm().popEventModifier();
    }

    public void renderContentEnd(TableView tableView, IPageContext rc) {
        rc.write("</tbody>");
    }

    public void renderFooterBegin(TableView tableView, IPageContext rc) {
        TableViewDesign design = tableView.getDesign();
        if (design.equals(TableViewDesign.ALTERNATING)) {
            rc.write("<tr><td align=\"left\" class=\"sapTbvHdrAlt\" colspan=\"");
        } else if (design.equals(TableViewDesign.TRANSPARENT)) {
            rc.write("<tr><td align=\"left\" class=\"sapTbvHdrTrans\" colspan=\"");
        } else {
            rc.write("<tr><td align=\"left\" class=\"sapTbvHdrStd\" colspan=\"");
        }
        if (tableView.getSelectionMode().equals(TableSelectionMode.NONE)) {
            rc.write(tableView.getColumnCount());
        } else {
            rc.write(tableView.getColumnCount() + 1);
        }
        rc.write("\" nowrap>");
        rc.write("<table border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\"><tr>");
    }

    public void renderFooterNavigation(TableView tableView, IPageContext rc) {
        int rowCount = tableView.getRowCount();
        int visibleRowCount = tableView.getVisibleRowCount();
        boolean navByLine = tableView.getNavigationMode().equals(TableNavigationMode.BYLINE);
        boolean isLastPage = visibleRowCount == rowCount;
        boolean isFirstRowVisible = tableView.getVisibleFirstRow() == 1;
        boolean isLastRowVisible = tableView.getVisibleLastRow() >= rowCount;
        rc.write("<td><table cellspacing=\"0\" cellpadding=\"2\" border=\"0\"><tr>");
        rc.write("<td>");
        if (isFirstRowVisible) {
            RenderUtil.renderGif(rc, "tableview", "top_off.gif", "", "");
            rc.write("</td>");
        } else {
            rc.write("<a href=\"#\" onClick=\"");
            rc.write(TableNavigationEvent.renderEventCall(rc, tableView, "top"));
            rc.write("\">");
            RenderUtil.renderGif(rc, "tableview", "top.gif", "", "");
            rc.write("</a></TD>");
        }
        rc.write("<td>");
        if (isFirstRowVisible) {
            RenderUtil.renderGif(rc, "tableview", "pageup_off.gif", "", "");
            rc.write("</td>");
        } else {
            rc.write("<a href=\"#\" onClick=\"");
            rc.write(TableNavigationEvent.renderEventCall(rc, tableView, "pageUp"));
            rc.write("\">");
            RenderUtil.renderGif(rc, "tableview", "pageup.gif", "", "");
            rc.write("</a></td>");
        }
        if (navByLine) {
            if (isFirstRowVisible) {
                rc.write("<td>");
                RenderUtil.renderGif(rc, "tableview", "up_off.gif", "", "");
                rc.write("</td>");
            } else {
                rc.write("<td><a href=\"#\" onClick=\"");
                rc.write(TableNavigationEvent.renderEventCall(rc, tableView, "lineUp"));
                rc.write("\">");
                RenderUtil.renderGif(rc, "tableview", "up.gif", "", "");
                rc.write("</td>");
            }
            if (isLastRowVisible) {
                rc.write("<td>");
                RenderUtil.renderGif(rc, "tableview", "down_off.gif", "", "");
                rc.write("</td>");
            } else {
                rc.write("<td><a href=\"#\" onClick=\"");
                rc.write(TableNavigationEvent.renderEventCall(rc, tableView, "lineDown"));
                rc.write("\">");
                RenderUtil.renderGif(rc, "tableview", "down.gif", "", "");
                rc.write("</a></TD>");
            }
        }
        if (isLastPage || isLastRowVisible) {
            rc.write("<td>");
            RenderUtil.renderGif(rc, "tableview", "pagedown_off.gif", "", "");
            rc.write("</td>");
        } else {
            rc.write("<td><a href=\"#\" onClick=\"");
            rc.write(TableNavigationEvent.renderEventCall(rc, tableView, "pageDown"));
            rc.write("\">");
            RenderUtil.renderGif(rc, "tableview", "pagedown.gif", "", "");
            rc.write("</a></TD>");
        }
        if (isLastPage || isLastRowVisible) {
            rc.write("<td>");
            RenderUtil.renderGif(rc, "tableview", "bottom_off.gif", "", "");
            rc.write("</td>");
        } else {
            rc.write("<td><a href=\"#\" onClick=\"");
            rc.write(TableNavigationEvent.renderEventCall(rc, tableView, "bottom"));
            rc.write("\">");
            RenderUtil.renderGif(rc, "tableview", "bottom.gif", "", "");
            rc.write("</a></td>");
        }
        rc.write("</tr></table></td>");
    }

    public void renderFooterPositionIndicator(TableView tableView, IPageContext rc) {
        int visibleRowCount = tableView.getVisibleRowCount();
        int visibleFirstRow = tableView.getVisibleFirstRow();
        TableViewDesign design = tableView.getDesign();
        if (design.equals(TableViewDesign.ALTERNATING)) {
            rc.write("<TD align=\"right\" class=\"sapTbvHdrAlt\">");
        } else if (design.equals(TableViewDesign.TRANSPARENT)) {
            rc.write("<TD align=\"right\" class=\"sapTbvHdrTrans\">");
        } else {
            rc.write("<TD align=\"right\" class=\"sapTbvHdrStd\">");
        }
        TableNavigationMode navigationMode = tableView.getNavigationMode();
        if (navigationMode.equals(TableNavigationMode.BYLINE)) {
            if (tableView.getRowCount() != 0) {
                rc.write(visibleFirstRow);
            } else {
                rc.write("0");
            }
            rc.write("/");
            rc.write(tableView.getRowCount());
        } else if (visibleRowCount != 0) {
            int pageCount = tableView.getRowCount() % visibleRowCount != 0 ? tableView.getRowCount() / visibleRowCount + 1 : tableView.getRowCount() / visibleRowCount;
            int currentPageIndex = tableView.getCurrentPageIndex();
            rc.write(currentPageIndex);
            rc.write("/");
            rc.write(pageCount);
        }
        rc.write("</TD>");
    }

    public void renderFooterEnd(TableView tableView, IPageContext rc) {
        rc.write("</tr></table></td></tr>");
    }

    public void renderEnd(TableView tableView, IPageContext rc) {
        rc.write("</table></div>");
        String encodedKeys = tableView.encodeInternalData();
        rc.write("<input type=\"hidden\" name=\"");
        rc.write(rc.getParamIdForComponent(tableView));
        rc.write("-keys\" value=\"");
        rc.write(encodedKeys);
        rc.write("\">");
    }

    public void renderEmptyTableText(TableView tableView, IPageContext rc, String emptyTableText) {
        rc.write("<tr class=\"sapTbvCellAlt\">");
        rc.write("<td colspan=\"");
        if (tableView.getSelectionMode().equals(TableSelectionMode.NONE)) {
            rc.write(tableView.getColumnCount());
        } else {
            rc.write(tableView.getColumnCount() + 1);
        }
        rc.write("\">");
        rc.write(emptyTableText);
        rc.write("</td></tr>");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

