/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering.nn4;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.TabStrip;
import com.sapportals.htmlb.TabStripItem;
import com.sapportals.htmlb.enum.CellHAlign;
import com.sapportals.htmlb.enum.CellVAlign;
import com.sapportals.htmlb.event.TabSelectEvent;
import com.sapportals.htmlb.rendering.HtmlbRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.RenderUtil;
import java.util.Iterator;

public class NN4TabStripRenderer
implements HtmlbRenderer {
    private static int idcounter;

    public void render(Component component, IPageContext renderContext) {
        if (component instanceof TabStrip) {
            TabStripItem myItem;
            TabStrip myTabStrip = (TabStrip)component;
            int max = myTabStrip.getItemCount();
            if (myTabStrip.getIndexPosition(myTabStrip.getSelection()) < 0) {
                myTabStrip.setSelection(myTabStrip.getItems().getFirstIndex());
            }
            this.renderHeadBegin(myTabStrip, renderContext);
            Iterator items = myTabStrip.getItems().values();
            boolean i = false;
            while (items.hasNext()) {
                myItem = (TabStripItem)items.next();
                myTabStrip.setCurrentIndex(myItem.getIndex());
                if (myItem == null) continue;
                this.renderHeadItemBegin(myTabStrip, renderContext);
                Component header = myItem.getHeader();
                if (header != null) {
                    header.render(renderContext);
                } else {
                    String title = myItem.getTitle();
                    if (title != null) {
                        renderContext.writeEncoded(title);
                    }
                }
                this.renderHeadItemEnd(myTabStrip, renderContext);
                this.renderHeadItemSeparator(myTabStrip, renderContext);
            }
            this.renderHeadEnd(myTabStrip, renderContext);
            this.renderContentBegin(myTabStrip, renderContext);
            items = myTabStrip.getItems().values();
            i = false;
            while (items.hasNext()) {
                myItem = (TabStripItem)items.next();
                myTabStrip.setCurrentIndex(myItem.getIndex());
                if (myItem == null || myTabStrip.getSelection() != myItem.getIndex()) continue;
                this.renderContentItemBegin(myTabStrip, renderContext);
                RenderUtil.renderContainerContent(myItem, renderContext);
                this.renderContentItemEnd(myTabStrip, renderContext);
            }
            this.renderContentEnd(myTabStrip, renderContext);
        }
    }

    public void render(Component component, int selector, IPageContext renderContext) {
        if (component instanceof TabStrip) {
            TabStrip myTabStrip = (TabStrip)component;
            switch (selector) {
                case 0: {
                    this.renderHeadBegin(myTabStrip, renderContext);
                    break;
                }
                case 1: {
                    this.renderHeadItemBegin(myTabStrip, renderContext);
                    break;
                }
                case 2: {
                    this.renderHeadItemEnd(myTabStrip, renderContext);
                    break;
                }
                case 3: {
                    this.renderHeadItemSeparator(myTabStrip, renderContext);
                    break;
                }
                case 4: {
                    this.renderHeadEnd(myTabStrip, renderContext);
                    break;
                }
                case 5: {
                    this.renderContentBegin(myTabStrip, renderContext);
                    break;
                }
                case 6: {
                    this.renderContentItemBegin(myTabStrip, renderContext);
                    break;
                }
                case 7: {
                    this.renderContentItemEnd(myTabStrip, renderContext);
                    break;
                }
                case 8: {
                    this.renderContentEnd(myTabStrip, renderContext);
                }
            }
        }
    }

    public void renderHeadBegin(TabStrip tabStrip, IPageContext rc) {
        String name = tabStrip.getId();
        String fullId = rc.getParamIdForComponent(tabStrip);
        rc.write("<input name=\"");
        rc.write(fullId);
        rc.write("_num\" id=\"");
        rc.write(fullId);
        rc.write("_num\" type=\"hidden\" value=\"");
        rc.write(tabStrip.getItemCount());
        rc.write("\">");
        rc.write("<input name=\"");
        rc.write(fullId);
        rc.write("_sel\" id=\"");
        rc.write(fullId);
        rc.write("_sel\" type=\"hidden\" value=\"");
        rc.write(tabStrip.getIndexPosition(tabStrip.getSelection()));
        rc.write("\">");
        rc.write("<input name=\"");
        rc.write(fullId);
        rc.write("_idx\" id=\"");
        rc.write(fullId);
        rc.write("_idx\" type=\"hidden\" value=\"");
        rc.write(tabStrip.getSelection());
        rc.write("\">");
        rc.write("<table border=\"0\" cellspacing=\"0\" cellpadding=\"1\" class=\"sapGrcWhl");
        String width = tabStrip.getWidth();
        if (width == null) {
            rc.write("\" width=\"1");
        } else {
            rc.write("\" width=\"" + width);
        }
        String tooltip = tabStrip.getTooltip();
        if (tooltip != null) {
            rc.write("\" title=\"");
            rc.writeEncoded(tooltip);
        }
        rc.write("\"><tr><td class=\"sapTbsBorderDivNN4\">");
        rc.write("<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\"><tr>");
    }

    public void renderHeadItemBegin(TabStrip tabStrip, IPageContext rc) {
        String tooltip;
        int selection = tabStrip.getSelection();
        int index = tabStrip.getCurrentIndex();
        int indexPos = tabStrip.getIndexPosition(index);
        String name = rc.getCurrentFormId();
        rc.write("<td id=\"");
        rc.write(name);
        rc.write("tab");
        rc.write(indexPos);
        rc.write("\" class=\"");
        rc.write(index == selection ? "sapTbsTabSel" : "sapTbsTab");
        TabStripItem myItem = tabStrip.getItem(index);
        String onSelect = myItem.getOnSelect();
        rc.write("\" nowrap align=\"center\">&nbsp;<a href=\"#\" onclick=\"");
        if (onSelect == null) {
            myItem.setOnSelect("TabSelectionChanged");
        }
        rc.write(TabSelectEvent.renderEventCall(rc, tabStrip, myItem));
        rc.write("\" style=\"text-decoration:none\"><span class=\"sapTxtStd");
        myItem = tabStrip.getItem(index);
        myItem.setOnSelect("TabStripSelection");
        if (myItem != null && (tooltip = myItem.getTooltip()) != null) {
            rc.write("\" title=\"");
            rc.writeEncoded(tooltip);
        }
        rc.write("\"><nobr>");
    }

    public void renderHeadItemEnd(TabStrip tabStrip, IPageContext rc) {
        rc.write("</nobr></span></a>&nbsp;</td>");
    }

    public void renderHeadItemSeparator(TabStrip tabStrip, IPageContext rc) {
        int index = tabStrip.getCurrentIndex();
        int selection = tabStrip.getSelection();
        String name = rc.getParamIdForComponent(tabStrip);
        rc.write("<td id=\"");
        rc.write(name);
        rc.write("tbsImg");
        rc.write(tabStrip.getIndexPosition(index));
        rc.write("\" class=\"sapTbsSpc");
        if (index == 1) {
            if (selection == index) {
                rc.write("FrOn");
            } else {
                rc.write("FrOff");
            }
        } else if (index == selection) {
            rc.write("OffOn");
        } else if (index == selection + 1) {
            rc.write("OnOff");
        } else {
            rc.write("OffOff");
        }
        rc.write("\"></td>");
    }

    public void renderHeadEnd(TabStrip tabStrip, IPageContext rc) {
        String name = rc.getParamIdForComponent(tabStrip);
        rc.write("<td nowrap id=\"");
        rc.write(name);
        rc.write("tbsImg");
        rc.write(tabStrip.getItemCount() + 1);
        rc.write("\" class=\"sapTbsSpcBkOff\"></td><td nowrap class=\"sapTbsTabBlk\" width=\"100%\">&nbsp;</td></tr></table>");
    }

    public void renderContentBegin(TabStrip tabStrip, IPageContext rc) {
        String height = tabStrip.getBodyHeight();
        rc.write("<table height=\"" + height + "\" class=\"sapTbsWhl\" border=\"0\" cellspacing=\"0\" cellpadding=\"5\" width=\"100%\">");
        rc.write("<tr>");
        rc.write("<td class=\"sapTbsDsp\" align=\"");
        CellHAlign hAlign = tabStrip.getHAlign();
        if (hAlign == CellHAlign.CENTER) {
            rc.write("center");
        } else if (hAlign == CellHAlign.LEFT) {
            rc.write("left");
        } else if (hAlign == CellHAlign.RIGHT) {
            rc.write("right");
        } else if (hAlign == CellHAlign.JUSTIFY) {
            rc.write("justify");
        } else if (hAlign == CellHAlign.CHAR) {
            rc.write("char");
        }
        rc.write("\" valign=\"");
        CellVAlign vAlign = tabStrip.getVAlign();
        if (vAlign == CellVAlign.BASELINE) {
            rc.write("baseline");
        } else if (vAlign == CellVAlign.BOTTOM) {
            rc.write("bottom");
        } else if (vAlign == CellVAlign.TOP) {
            rc.write("top");
        } else if (vAlign == CellVAlign.MIDDLE) {
            rc.write("middle");
        }
        rc.write("\">");
    }

    public void renderContentItemBegin(TabStrip tabStrip, IPageContext rc) {
    }

    public void renderContentItemEnd(TabStrip tabStrip, IPageContext rc) {
    }

    public void renderContentEnd(TabStrip tabStrip, IPageContext rc) {
        rc.write("</td></tr></table>");
        rc.write("</td></tr></table>");
    }
}

