/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering.nn4;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.TextView;
import com.sapportals.htmlb.enum.LinkDesign;
import com.sapportals.htmlb.enum.LinkFontSize;
import com.sapportals.htmlb.enum.TextViewDesign;
import com.sapportals.htmlb.hovermenu.HoverMenu;
import com.sapportals.htmlb.hovermenu.LinkForHoverMenu;
import com.sapportals.htmlb.rendering.AtomHtmlbRenderer;
import com.sapportals.htmlb.rendering.IPageContext;

public class NN4LinkForHoverMenuRenderer
extends AtomHtmlbRenderer {
    public void render(Component component, IPageContext renderContext) {
        if (component instanceof LinkForHoverMenu) {
            LinkForHoverMenu link = (LinkForHoverMenu)component;
            HoverMenu menu = link.getHoverMenu();
            renderContext.write("<A href=\"#\" class=\"sapLnk");
            if (!link.getLinkDesign().equals(LinkDesign.DRILLDOWN)) {
                if (link.getLinkDesign().equals(LinkDesign.FUNCTION)) {
                    renderContext.write("Function");
                } else if (link.getLinkDesign().equals(LinkDesign.REPORTING)) {
                    renderContext.write("Report");
                } else if (link.getLinkDesign().equals(LinkDesign.RESULT)) {
                    renderContext.write("Result");
                }
            }
            renderContext.write("\" name=\"");
            renderContext.write(link.getId());
            renderContext.write("\" href=\"#\" onclick=\"htmlbIntCalledMenuLevel=1;htmlbHoverRootComponentId='");
            renderContext.write(link.getId());
            renderContext.write("';htmlbEventobj='");
            renderContext.write(renderContext.getParamIdForComponent(menu));
            renderContext.write("';\">");
            TextViewDesign design = link.getDesign();
            if (design != null) {
                TextView text = new TextView(link.getText());
                text.setDesign(design);
                renderContext.render(text);
            } else {
                LinkFontSize fontSize = link.getFontSize();
                if (fontSize != null && fontSize.equals(LinkFontSize.SMALL)) {
                    TextView text = new TextView(link.getText());
                    text.setDesign(TextViewDesign.LEGEND);
                    renderContext.render(text);
                } else {
                    renderContext.write(link.getText());
                }
            }
            renderContext.write("</A>");
            if (menu != null) {
                renderContext.getCurrentForm().registerHoverMenu(menu);
            }
        }
    }
}

