/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering.nn4;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.Label;
import com.sapportals.htmlb.enum.TextViewDesign;
import com.sapportals.htmlb.rendering.AtomHtmlbRenderer;
import com.sapportals.htmlb.rendering.IPageContext;

public class NN4LabelRenderer
extends AtomHtmlbRenderer {
    public void render(Component component, IPageContext rc) {
        if (component instanceof Label) {
            String tooltip;
            Label label = (Label)component;
            rc.write("<span class=\"");
            TextViewDesign myDesign = label.getDesign();
            String design = myDesign == TextViewDesign.HEADER1 ? "sapTxtH1" : (myDesign == TextViewDesign.HEADER2 ? "sapTxtH2" : (myDesign == TextViewDesign.HEADER3 ? "sapTxtH3" : (myDesign == TextViewDesign.EMPHASIZED ? "sapTxtEmph" : (myDesign == TextViewDesign.STANDARD ? "sapTxtStd" : (myDesign == TextViewDesign.LABEL ? "sapTxtLbl" : (myDesign == TextViewDesign.LABELSMALL ? "sapTxtLblSml" : (myDesign == TextViewDesign.LEGEND ? "sapTxtLeg" : (myDesign == TextViewDesign.REFERENCE ? "sapTxtRef" : "sapTxtStd"))))))));
            rc.write(design);
            String width = label.getWidth();
            if (width != null) {
                rc.write("\" style=\"width:");
                rc.write(width);
                rc.write(";");
            }
            if ((tooltip = label.getTooltip()) != null) {
                rc.write("\" title=\"");
                rc.writeEncoded(tooltip);
            }
            rc.write("\">");
            if (!label.isWrapping()) {
                rc.write("<nobr>");
            }
            if (label.isEncode()) {
                rc.writeEncoded(label.getText());
            } else {
                rc.write(label.getText());
            }
            if (label.isRequired()) {
                rc.write("<span class=\"sapTxtReq\">*</span>");
            }
            if (myDesign == TextViewDesign.LABEL || myDesign == TextViewDesign.LABELSMALL) {
                rc.write("<span class=\"");
                rc.write(design);
                rc.write("\">&nbsp;</span>");
            }
            if (!label.isWrapping()) {
                rc.write("</nobr>");
            }
            rc.write("</span>");
        }
    }
}

