/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering.nn4;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.ItemList;
import com.sapportals.htmlb.rendering.HtmlbRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.RenderUtil;
import java.util.Iterator;

public class NN4ItemListRenderer
implements HtmlbRenderer {
    public void render(Component component, int selector, IPageContext renderContext) {
        if (component instanceof ItemList) {
            ItemList myItemList = (ItemList)component;
            switch (selector) {
                case 0: {
                    this.renderBegin(myItemList, renderContext);
                    break;
                }
                case 1: {
                    this.renderItemBegin(myItemList, renderContext);
                    break;
                }
                case 2: {
                    this.renderNext(myItemList, renderContext);
                    break;
                }
                case 3: {
                    this.renderItemEnd(myItemList, renderContext);
                    break;
                }
                case 4: {
                    this.renderEnd(myItemList, renderContext);
                }
            }
        }
    }

    public void render(Component component, IPageContext pageContext) {
        if (component instanceof ItemList) {
            ItemList myItemList = (ItemList)component;
            this.renderBegin(myItemList, pageContext);
            Iterator it = myItemList.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (o instanceof ItemList) {
                    RenderUtil.renderContentObject(o, pageContext);
                    continue;
                }
                this.renderItemBegin(myItemList, o, pageContext);
                RenderUtil.renderContentObject(o, pageContext);
                this.renderItemEnd(myItemList, pageContext);
            }
            this.renderEnd(myItemList, pageContext);
        }
    }

    private void renderBegin(ItemList itemList, IPageContext pc) {
        if (itemList.isOrdered()) {
            pc.write("<ol class=\"sapLicOl\">");
        } else {
            pc.write("<ul class=\"sapLicUl\">");
        }
    }

    private void renderItemBegin(ItemList itemList, IPageContext pc) {
        this.renderItemBegin(itemList, null, pc);
    }

    private void renderItemBegin(ItemList itemList, Object comp, IPageContext pc) {
        if (itemList.isOrdered()) {
            pc.write("<li>");
        } else {
            pc.write("<li class=\"sapLicItem\">");
            String bullet = null;
            if (comp != null) {
                bullet = itemList.getComponentBulletUri(comp);
            }
            if (bullet == null) {
                bullet = itemList.getBulletUri();
            }
            if (bullet == null || bullet.length() == 0) {
                RenderUtil.renderGif(pc, "listlayout", "listcube.gif", "", "");
            } else {
                pc.write("<img src=\"" + bullet + "\" border=\"0\">");
            }
            pc.write("&nbsp;&nbsp;&nbsp;");
        }
    }

    private void renderNext(ItemList itemList, IPageContext pc) {
        this.renderItemEnd(itemList, pc);
        this.renderItemBegin(itemList, pc);
    }

    private void renderItemEnd(ItemList itemList, IPageContext pc) {
        pc.write("</li><br>");
    }

    private void renderEnd(ItemList itemList, IPageContext pc) {
        if (itemList.isOrdered()) {
            pc.write("</ol>");
        } else {
            pc.write("</ul>");
        }
    }
}

