/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering.nn4;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.EventValidationComponent;
import com.sapportals.htmlb.InputField;
import com.sapportals.htmlb.enum.DataType;
import com.sapportals.htmlb.enum.EventTrigger;
import com.sapportals.htmlb.enum.InputFieldDesign;
import com.sapportals.htmlb.rendering.DefaultInputFieldRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.RenderUtil;
import com.sapportals.htmlb.rendering.nn4.NN4EventValidationRenderer;
import com.sapportals.htmlb.type.AbstractDataType;
import com.sapportals.htmlb.type.TypeFormatter;
import java.text.SimpleDateFormat;
import java.util.HashSet;

public class NN4InputFieldRenderer
extends NN4EventValidationRenderer {
    private static HashSet validationTriggers = new HashSet();
    static /* synthetic */ Class class$com$sapportals$htmlb$event$Event;

    public boolean getDefaultClientEventReturnValue(EventTrigger trigger, EventValidationComponent component) {
        return trigger == EventTrigger.ON_CHANGE;
    }

    public void render(Component component, IPageContext rc) {
        if (component instanceof InputField) {
            String valueString;
            boolean showDateHelp;
            InputField inf = (InputField)component;
            DataType type = inf.getType();
            boolean bl = showDateHelp = DataType.DATE.equals(type) && inf.isShowHelp();
            if (showDateHelp) {
                rc.write("\n<script language=\"javascript\">\n");
                rc.write("var javaScriptPath='");
                rc.write(rc.getJavascriptPath());
                rc.write("';");
                String[] dayNames = RenderUtil.getDayAbbreviations(rc.getLocale());
                if (dayNames.length != 7) {
                    throw new IllegalStateException("Only locales with 7 days are supported!");
                }
                rc.write("var htmlbDayNames = new Array('");
                int i = 0;
                while (i < 6) {
                    rc.write(dayNames[i]);
                    rc.write("','");
                    ++i;
                }
                rc.write(dayNames[6]);
                rc.write("');\n");
                rc.write("var htmlbMonthNames = new Array('");
                String[] monthNames = RenderUtil.getMonthNames(rc.getLocale());
                int i2 = 0;
                while (i2 < 11) {
                    rc.write(monthNames[i2]);
                    rc.write("','");
                    ++i2;
                }
                rc.write(monthNames[11]);
                rc.write("');\n");
                rc.write("</script>");
                rc.write("<table cellspacing=\u0000\" cellpadding=\"0\" border=\"0\" id=\"");
                rc.write("\"><tr><td>");
            }
            if (inf.isVisible()) {
                String tooltip;
                String value;
                int maxlength;
                if (inf.isPassword()) {
                    rc.write("<input type=\"password\" class=\"sapEdf");
                } else {
                    rc.write("<input type=\"text\" class=\"sapEdf");
                }
                if (inf.isRequired()) {
                    rc.write("Req");
                } else {
                    rc.write("Txt");
                }
                if (!inf.isEnabled()) {
                    rc.write("Dsbl");
                } else {
                    rc.write("Enbl");
                }
                if (inf.getDesign() == InputFieldDesign.SMALL) {
                    rc.write("Sml");
                }
                rc.write("\" autocomplete=\"off");
                int mySize = inf.getSize();
                if (mySize > 0) {
                    rc.write("\" size=\"");
                    rc.write(mySize);
                }
                if ((maxlength = inf.getMaxlength()) > 0) {
                    rc.write("\" maxlength =\"");
                    rc.write(maxlength);
                }
                if ((value = inf.getWidth()) != null && !"".equals(value)) {
                    rc.write("\" style=\"width:");
                    rc.write(value);
                    rc.write(";");
                }
                if ((tooltip = inf.getTooltip()) != null) {
                    rc.write("\" title=\"");
                    rc.writeEncoded(tooltip);
                }
                if (!inf.isEnabled()) {
                    rc.write("\" readonly=\"");
                }
            } else {
                rc.write("<input type=\"hidden");
            }
            rc.write("\" name=\"");
            String uniqueName = rc.getParamIdForComponent(inf);
            rc.write(uniqueName);
            if (inf.isLabeled()) {
                rc.write("\" id=\"");
                rc.write(uniqueName);
            }
            Object value = inf.getValue();
            if (!inf.isEnabled()) {
                if (value != null) {
                    valueString = null;
                    if (value instanceof AbstractDataType) {
                        AbstractDataType dataValue = (AbstractDataType)value;
                        if (dataValue != null) {
                            valueString = dataValue.toString(rc);
                        }
                    } else {
                        valueString = value.toString();
                    }
                    rc.write("\" onKeydown=\"this.value='");
                    rc.write(RenderUtil.encodeForJS(valueString));
                    rc.write("';return false;");
                } else {
                    rc.write("\" onKeydown=\"this.value='';return false;");
                }
            }
            rc.write("\"");
            this.renderEventValidationHandlers(class$com$sapportals$htmlb$event$Event == null ? (class$com$sapportals$htmlb$event$Event = NN4InputFieldRenderer.class$("com.sapportals.htmlb.event.Event")) : class$com$sapportals$htmlb$event$Event, validationTriggers, false, inf, rc);
            rc.write(" value=\"");
            if (value != null) {
                valueString = null;
                if (value instanceof AbstractDataType) {
                    AbstractDataType dataValue = (AbstractDataType)value;
                    if (dataValue != null) {
                        valueString = dataValue.toString(rc);
                    }
                } else {
                    valueString = value.toString();
                }
                if (inf.getValueEncode()) {
                    rc.writeEncoded(valueString);
                } else {
                    rc.write(DefaultInputFieldRenderer.encodeQuots(valueString));
                }
            }
            rc.write("\">");
            if (!inf.isValid()) {
                rc.write("<span class=\"sapTxtErr\">&nbsp;!");
                rc.write("</span>");
            }
            if (showDateHelp) {
                rc.write("</td><td>");
                rc.write("<a href=\"#\" onClick=\"");
                rc.write("sapHelpDate('");
                rc.write(uniqueName);
                rc.write("','htmlbDayNames','htmlbMonthNames','" + inf.getFirstDayOfWeek() + "','");
                SimpleDateFormat sdf = (SimpleDateFormat)TypeFormatter.getFormat(rc.getLocale(), DataType.DATE);
                String pattern = sdf.toPattern();
                String dateFormat = "2";
                if ("dd.MM.yyyy".equals(pattern)) {
                    dateFormat = "1";
                } else if ("MM/dd/yyyy".equals(pattern)) {
                    dateFormat = "2";
                } else if ("yyyy-MM-dd".equals(pattern)) {
                    dateFormat = "6";
                }
                rc.write(dateFormat);
                rc.write("','");
                rc.write(rc.getStylesheetUrl());
                rc.write("','");
                rc.write(rc.getCurrentFormId());
                rc.write("')\">");
                String gifString = "";
                gifString = inf.getDesign() == InputFieldDesign.SMALL ? "helpsmall.gif" : "help.gif";
                RenderUtil.renderGif(rc, "inputfield", gifString, component.getId(), "");
                rc.write("</a></td></tr></table>");
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        validationTriggers.add(EventTrigger.ON_BLUR);
        validationTriggers.add(EventTrigger.ON_CHANGE);
    }
}

