/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering.nn4;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.Group;
import com.sapportals.htmlb.enum.GroupDesign;
import com.sapportals.htmlb.rendering.HtmlbRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.RenderUtil;

public class NN4GroupRenderer
implements HtmlbRenderer {
    public void render(Component component, int selector, IPageContext renderContext) {
        if (component instanceof Group) {
            Group myGroup = (Group)component;
            switch (selector) {
                case 0: {
                    NN4GroupRenderer.renderBegin(myGroup, renderContext);
                    break;
                }
                case 1: {
                    NN4GroupRenderer.renderEnd(myGroup, renderContext);
                }
            }
        }
    }

    public void render(Component component, IPageContext renderContext) {
        if (component instanceof Group) {
            Group myGroup = (Group)component;
            NN4GroupRenderer.renderBegin(myGroup, renderContext);
            RenderUtil.renderContainerContent(myGroup, renderContext);
            NN4GroupRenderer.renderEnd(myGroup, renderContext);
        }
    }

    public static void renderBegin(Group group, IPageContext pc) {
        GroupDesign design = group.getDesign();
        String width = group.getWidth();
        String title = group.getTitle();
        String tooltip = group.getTooltip();
        Component headerComponent = group.getHeaderComponent();
        pc.write("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">");
        if (design == GroupDesign.PRIMARYCOLOR) {
            pc.write("<tr><td valign=\"top\" nowrap class=\"sapGrpTtlWeb1\">");
            if (headerComponent != null) {
                pc.write(title);
                pc.render(headerComponent);
            } else {
                RenderUtil.renderPixelGifSpan("3", pc, 0);
                pc.write(title);
                pc.write("<br>");
                RenderUtil.renderPixelGifSpan("1", pc, 1);
            }
            pc.write("</td></tr><tr class=\"sapGrpBdyWeb1\"><td><div class=\"sapGrpBdyNoBorderDiv\">");
        } else if (design == GroupDesign.SECONDARYCOLOR) {
            pc.write("<tr><td valign=\"top\" nowrap class=\"sapGrpTtlWeb2\">");
            if (headerComponent != null) {
                pc.write(title);
                pc.render(headerComponent);
            } else {
                RenderUtil.renderPixelGifSpan("3", pc, 0);
                pc.write(title);
                pc.write("<br>");
                RenderUtil.renderPixelGifSpan("1", pc, 1);
            }
            pc.write("</td></tr><tr class=\"sapGrpBdyWeb2\"><td><div class=\"sapGrpBdyNoBorderDiv\">");
        } else if (design == GroupDesign.SAPCOLOR) {
            pc.write("<tr><td valign=\"top\" nowrap class=\"sapGrpTtlBox\">");
            if (headerComponent != null) {
                pc.write(title);
                pc.render(headerComponent);
            } else {
                RenderUtil.renderPixelGifSpan("3", pc, 0);
                pc.write(title);
                pc.write("<br>");
                RenderUtil.renderPixelGifSpan("1", pc, 1);
            }
            pc.write("</td></tr><tr><td><div class=\"sapGrpBdyBoxBorderDiv\" width=\"100%\">");
        } else if (design == GroupDesign.SECONDARYBOX) {
            pc.write("<tr><td valign=\"top\" nowrap class=\"sapGrpTtlBoxNoBorder\">");
            if (headerComponent != null) {
                pc.write(title);
                pc.render(headerComponent);
            } else {
                RenderUtil.renderPixelGifSpan("3", pc, 0);
                pc.write(title);
                pc.write("<br>");
                RenderUtil.renderPixelGifSpan("1", pc, 1);
            }
            pc.write("</td></tr><tr class=\"sapGrpBdyBoxNoBorder\"><td><div class=\"sapGrpBdyNoBorderDiv\">");
        } else if (design == GroupDesign.SECONDARYBOXCOLOR) {
            pc.write("<tr><td valign=\"top\" nowrap class=\"sapGrpTtlBoxNoBorder\">");
            if (headerComponent != null) {
                pc.write(title);
                pc.render(headerComponent);
            } else {
                RenderUtil.renderPixelGifSpan("3", pc, 0);
                pc.write(title);
                pc.write("<br>");
                RenderUtil.renderPixelGifSpan("1", pc, 1);
            }
            pc.write("</td></tr><tr class=\"sapGrpBdyBoxBgColor\"><td><div class=\"sapGrpBdyNoBorderDiv\">");
        }
    }

    public static void renderEnd(Group group, IPageContext pc) {
        GroupDesign design = group.getDesign();
        String width = group.getWidth();
        if (width != null) {
            RenderUtil.renderPixelGifSpan(width, pc, 0);
        }
        pc.write("</div>");
        pc.write("</td></tr><tr><td><span class=\"sapGrpFt\"></span></td></tr></table>");
    }
}

