/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering.nn4;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.GridLayout;
import com.sapportals.htmlb.GridLayoutCell;
import com.sapportals.htmlb.rendering.HtmlbRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.RenderUtil;

public class NN4GridLayoutRenderer
implements HtmlbRenderer {
    public void render(Component component, int selector, IPageContext renderContext) {
        int rowIndex = 0;
        int columnIndex = 0;
        if (component instanceof GridLayout) {
            GridLayout myGridLayout = (GridLayout)component;
            GridLayoutCell cell = null;
            switch (selector) {
                case 0: {
                    rowIndex = 0;
                    this.renderContainerBegin(myGridLayout, renderContext);
                    break;
                }
                case 1: {
                    this.renderContainerEnd(myGridLayout, renderContext);
                    break;
                }
                case 2: {
                    ++rowIndex;
                    columnIndex = 0;
                    this.renderRowBegin(myGridLayout, renderContext);
                    break;
                }
                case 3: {
                    this.renderRowEnd(myGridLayout, renderContext);
                    break;
                }
                case 4: {
                    cell = myGridLayout.getCell(rowIndex, ++columnIndex);
                    this.renderCellBegin(myGridLayout, cell, renderContext);
                    break;
                }
                case 5: {
                    cell = myGridLayout.getCell(rowIndex, columnIndex);
                    this.renderCellEnd(myGridLayout, cell, renderContext);
                    break;
                }
                case 6: {
                    cell = myGridLayout.getCell(rowIndex, columnIndex);
                    this.renderCellContent(myGridLayout, cell, renderContext);
                }
            }
        }
    }

    public void render(Component component, IPageContext renderContext) {
        if (component instanceof GridLayout) {
            int colSpan = 1;
            GridLayout myGridLayout = (GridLayout)component;
            Object[][] cells = myGridLayout.getCells();
            if (cells[1].length == 2) {
                int rowIndex = 1;
                while (rowIndex < cells.length) {
                    GridLayoutCell cell = myGridLayout.getCell(rowIndex, 1);
                    renderContext.write("<div>");
                    int height = myGridLayout.getCellPadding() + myGridLayout.getCellSpacing();
                    RenderUtil.renderPixelGifSpan(Integer.toString(height), renderContext, 1);
                    this.renderCellContent(myGridLayout, cell, renderContext);
                    height = myGridLayout.getCellPadding();
                    RenderUtil.renderPixelGifSpan(Integer.toString(height), renderContext, 1);
                    renderContext.write("</div>");
                    ++rowIndex;
                }
            } else {
                this.renderContainerBegin(myGridLayout, renderContext);
                int rowIndex = 1;
                while (rowIndex < cells.length) {
                    Object[] row = cells[rowIndex];
                    this.renderRowBegin(myGridLayout, renderContext);
                    boolean cellWithContentExist = false;
                    int columnIndex = 1;
                    while (columnIndex < row.length) {
                        GridLayoutCell cell = myGridLayout.getCell(rowIndex, columnIndex);
                        this.renderCellBegin(myGridLayout, cell, renderContext);
                        this.renderCellContent(myGridLayout, cell, renderContext);
                        this.renderCellEnd(myGridLayout, cell, renderContext);
                        if (cell != null && (colSpan = cell.getColSpan()) > 1) {
                            columnIndex += --colSpan;
                        }
                        if (cell != null && cell.getContent() != null) {
                            cellWithContentExist = true;
                        }
                        ++columnIndex;
                    }
                    this.renderRowEnd(myGridLayout, renderContext);
                    ++rowIndex;
                }
                this.renderContainerEnd(myGridLayout, renderContext);
            }
        }
    }

    public void renderContainerBegin(GridLayout grid, IPageContext renderContext) {
        String cellPadding = String.valueOf(grid.getCellPadding());
        String cellSpacing = String.valueOf(grid.getCellSpacing());
        String border = grid.hasDebugMode() ? "1" : "0";
        if (!grid.isNN4Optimized()) {
            renderContext.write("<table border=\"" + border + "\" cellpadding=\"" + cellPadding + "\" cellspacing=\"" + cellSpacing + "\"");
            String width = grid.getWidth();
            String height = grid.getHeight();
            if (width != null) {
                renderContext.write(" width=\"");
                renderContext.write(width);
                renderContext.write("\"");
            }
            if (height != null) {
                renderContext.write(" height=\"");
                renderContext.write(height);
                renderContext.write("\"");
            }
            renderContext.write(">");
        }
    }

    public void renderContainerEnd(GridLayout grid, IPageContext renderContext) {
        if (!grid.isNN4Optimized()) {
            renderContext.write("</table>");
        }
    }

    public void renderRowBegin(GridLayout grid, IPageContext renderContext) {
        if (grid.isNN4Optimized()) {
            renderContext.write("<div>");
            int height = grid.getCellPadding() + grid.getCellSpacing();
            RenderUtil.renderPixelGifSpan(Integer.toString(height), renderContext, 1);
        } else {
            renderContext.write("<tr>");
        }
    }

    public void renderRowEnd(GridLayout grid, IPageContext renderContext) {
        if (grid.isNN4Optimized()) {
            int height = grid.getCellPadding();
            RenderUtil.renderPixelGifSpan(Integer.toString(height), renderContext, 1);
            renderContext.write("</div>");
        } else {
            renderContext.write("</tr>");
        }
    }

    public void renderCellBegin(GridLayout grid, GridLayoutCell cell, IPageContext renderContext) {
        if (!grid.isNN4Optimized()) {
            renderContext.write("<td");
            if (cell != null) {
                if (cell.getStyle() != null) {
                    renderContext.write(" class=\"" + cell.getStyle() + "\" ");
                }
                if (cell.getColSpan() > 1) {
                    renderContext.write(" colspan=\"" + String.valueOf(cell.getColSpan()) + "\" ");
                }
                if (cell.getHAlignment() != null) {
                    renderContext.write(" align=\"" + cell.getHAlignment() + "\" ");
                }
                if (cell.getVAlignment() != null) {
                    renderContext.write(" valign=\"" + cell.getVAlignment() + "\" ");
                }
                String width = cell.getWidth();
                String height = cell.getHeight();
                if (width != null || height != null) {
                    renderContext.write(" style=\"");
                    if (width != null) {
                        renderContext.write("width:" + width + ";");
                    }
                    if (height != null) {
                        renderContext.write("height:" + height + ";");
                    }
                    renderContext.write("\"");
                }
            }
            renderContext.write(">");
        }
    }

    public void renderCellEnd(GridLayout grid, GridLayoutCell cell, IPageContext renderContext) {
        if (!grid.isNN4Optimized()) {
            renderContext.write("</td>");
        }
    }

    public void renderCellContent(GridLayout grid, GridLayoutCell cell, IPageContext renderContext) {
        if (cell != null) {
            Object object = cell.getContent();
            if (object instanceof String) {
                String cellString = (String)object;
                renderContext.write(cellString);
            }
            if (object instanceof Component) {
                Component cellComponent = (Component)object;
                cellComponent.render(renderContext);
            }
        }
    }
}

