/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering.nn4;

import com.sapportals.htmlb.Button;
import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.Form;
import com.sapportals.htmlb.IJavascriptComponent;
import com.sapportals.htmlb.InputField;
import com.sapportals.htmlb.JavascriptFragment;
import com.sapportals.htmlb.MessageBar;
import com.sapportals.htmlb.hovermenu.HoverMenu;
import com.sapportals.htmlb.rendering.HtmlbRenderer;
import com.sapportals.htmlb.rendering.IFormRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.RenderUtil;
import com.sapportals.htmlb.util.Log;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;

public class NN4FormRenderer
implements HtmlbRenderer,
IFormRenderer {
    static /* synthetic */ Class class$com$sapportals$htmlb$event$HoverItemClickEvent;

    public void render(Component component, int selector, IPageContext renderContext) {
        if (component instanceof Form) {
            Form myForm = (Form)component;
            switch (selector) {
                case 0: {
                    this.renderBegin(myForm, renderContext);
                    this.renderParameterFields(myForm, renderContext);
                    break;
                }
                case 1: {
                    this.renderEnd(myForm, renderContext);
                }
            }
        }
    }

    public void render(Component component, IPageContext renderContext) {
        if (component instanceof Form) {
            Form myForm = (Form)component;
            this.renderBegin(myForm, renderContext);
            this.renderParameterFields(myForm, renderContext);
            RenderUtil.renderContainerContent(myForm, renderContext);
            this.renderEnd(myForm, renderContext);
        }
    }

    public void renderBegin(Form form, IPageContext renderContext) {
        String myId;
        renderContext.setCurrentForm(form);
        if (!form.isMessageBarAtFormEnd()) {
            renderContext.render(form.getMessageBar());
        }
        renderContext.write("<form name=\"");
        String value = myId = renderContext.getCurrentFormId();
        if (value != null) {
            renderContext.write(value);
            renderContext.write("\" id=\"");
            renderContext.write(value);
        }
        if ((value = form.getMethod()) != null) {
            renderContext.write("\" method=\"");
            renderContext.write(value);
        }
        if ((value = form.getAction()) == null) {
            value = renderContext.getActionUrl();
        }
        if (value != null) {
            renderContext.write("\" action=\"");
            renderContext.write(value);
        }
        if ((value = form.getTarget()) != null) {
            renderContext.write("\" target=\"");
            renderContext.write(value);
        }
        if ((value = form.getEncodingType()) != null) {
            renderContext.write("\" enctype=\"");
            renderContext.write(value);
        }
        if ((value = form.getLanguage()) != null) {
            renderContext.write("\" lang=\"");
            renderContext.write(value);
        }
        if (myId != null) {
            renderContext.write("\" onsubmit=\"return htmlbCheckSubmit('");
            renderContext.write(myId);
            renderContext.write("');");
        }
        renderContext.write("\" ondragover=\"htmlbFormDragOver()");
        renderContext.write("\" ondragleave=\"htmlbFormDragLeave()");
        renderContext.write("\">");
    }

    protected void renderParameterFields(Form form, IPageContext pc) {
        String id = pc.getCurrentFormId();
        pc.write("<input type=\"hidden\" name=\"htmlbevt_ty\">");
        pc.write("<input type=\"hidden\" name=\"htmlbdoc_id\" value=\"");
        pc.write(pc.getDocument().getDocumentId());
        pc.write("\">");
        pc.write("<input type=\"hidden\" name=\"htmlbevt_frm\" value=\"");
        pc.write(id);
        pc.write("\">");
        pc.write("<input type=\"hidden\" name=\"htmlbevt_oid\">");
        pc.write("<input type=\"hidden\" name=\"htmlbevt_id\">");
        pc.write("<input type=\"hidden\" name=\"htmlbevt_cnt\">");
        pc.write("<input type=\"hidden\" name=\"htmlbevt_par1\">");
        pc.write("<input type=\"hidden\" name=\"htmlbevt_par2\">");
        pc.write("<input type=\"hidden\" name=\"htmlbevt_par3\">");
        pc.write("<input type=\"hidden\" name=\"htmlbevt_par4\">");
        pc.write("<input type=\"hidden\" name=\"htmlbevt_par5\">");
        pc.write("<input type=\"hidden\" name=\"htmlbevt_par6\">");
        pc.write("<input type=\"hidden\" name=\"htmlbevt_par7\">");
        pc.write("<input type=\"hidden\" name=\"htmlbevt_par8\">");
        pc.write("<input type=\"hidden\" name=\"htmlbevt_par9\">");
        pc.write("<input type=\"submit\" name=\"htmlb_submit\" style=\"display:none;\">");
    }

    private void renderHoverMenus(Form form, IPageContext pc) {
        StringBuffer subMenusAsString;
        pc.write("<layer bgcolor=\"000000\" name=\"heightlayer\" top=\"0\" left=\"0\" visibility=\"hide\">");
        pc.write("<table bgcolor=\"c0c0c0\" border=\"0\" cellpadding=\"4\" cellspacing=\"1\">");
        pc.write("<tr><td colspan=\"2\"><span class=\"sapDropDwnItem\"><nobr>heightlayer</nobr></span></td></tr>");
        pc.write("</table></layer>");
        pc.write("<script language=\"javascript\" defer>");
        pc.write("<!--\n");
        pc.write("htmlbSetEvents();\n");
        pc.write("htmlbGetLineHeight();\n");
        pc.write("//-->");
        pc.write("</script>");
        HashSet hoverMenus = form.getHoverMenus();
        if (hoverMenus != null) {
            Iterator hoverIt = hoverMenus.iterator();
            while (hoverIt.hasNext()) {
                HoverMenu menu = (HoverMenu)hoverIt.next();
                pc.render(menu);
            }
        }
        if ((subMenusAsString = pc.getCurrentForm().getStandAloneHoverMenusAsString()) != null) {
            pc.write(subMenusAsString.toString());
        }
    }

    public void renderEnd(Form form, IPageContext pc) {
        String formId = pc.getCurrentFormId();
        form.getIdForEvent((class$com$sapportals$htmlb$event$HoverItemClickEvent == null ? (class$com$sapportals$htmlb$event$HoverItemClickEvent = NN4FormRenderer.class$("com.sapportals.htmlb.event.HoverItemClickEvent")) : class$com$sapportals$htmlb$event$HoverItemClickEvent).getName());
        HashSet menus = form.getHoverMenus();
        if (menus != null && !menus.isEmpty()) {
            Iterator hoverIt = menus.iterator();
            while (hoverIt.hasNext()) {
                HoverMenu hoverMenu = (HoverMenu)hoverIt.next();
                pc.getParamIdForComponent(hoverMenu);
                form.getIdForEvent(hoverMenu.getOnHoverMenuClick());
            }
        }
        this.renderEncodedElements(form, pc);
        Button defaultButton = form.getDefaultButton();
        if (defaultButton != null) {
            pc.write("<input type=\"hidden\" id=\"");
            pc.write(formId);
            pc.write("_dflt\" code=\"");
            pc.write(pc.getParamIdForComponent(defaultButton));
            pc.write("\">");
        }
        pc.write("<input type=\"hidden\" id=\"");
        pc.write(formId);
        pc.write("_complete\" code=\"OK\">");
        if (pc.getCurrentForm().isScrollingToLastPosition()) {
            String htmlbScrollY;
            pc.write("<script defer>");
            String htmlbScrollX = pc.getParameter("htmlbScrollX");
            int xPos = 0;
            int yPos = 0;
            if (htmlbScrollX != null && !htmlbScrollX.equals("")) {
                xPos = Integer.parseInt(htmlbScrollX);
            }
            if ((htmlbScrollY = pc.getParameter("htmlbScrollY")) != null && !htmlbScrollY.equals("")) {
                yPos = Integer.parseInt(htmlbScrollY);
            }
            pc.write("window.scrollTo(" + xPos + "," + yPos + ")");
            pc.write("</script>");
        }
        if (form.isMessageBarAtFormEnd()) {
            pc.render(form.getMessageBar());
        }
        if (form.getFocusedControl() != null && form.getFocusedControl() instanceof InputField) {
            pc.write("<script defer>");
            pc.write("document.forms['" + pc.getCurrentFormId() + "']." + pc.getParamIdForComponent(form.getFocusedControl()) + ".focus()");
            pc.write("</script>");
        }
        this.renderHoverMenus(form, pc);
        pc.write("</form>");
        this.renderJavascripts(form, pc);
        pc.setCurrentForm(null);
    }

    public void renderEncodedElements(Form form, IPageContext pc) {
        String formId = pc.getCurrentFormId();
        String encodedString = form.encodeFormElements();
        if (encodedString != null) {
            int len = encodedString.length();
            int numPerLine = 120;
            int i = 0;
            while (i < len) {
                pc.write("<input type=\"hidden\" name=\"htmlbfrm_");
                pc.write(formId);
                pc.write("_");
                pc.write(i / numPerLine);
                pc.write("\" value=\"");
                String substring = encodedString.substring(i, i + numPerLine > len ? len : i + numPerLine);
                pc.write(substring);
                pc.write("\">");
                i += numPerLine;
            }
        }
    }

    public String getEncodedElements(IPageContext pc) {
        String formId = pc.getParameter("htmlbevt_frm");
        if (formId != null) {
            String paramValue;
            StringBuffer sb = new StringBuffer();
            String paramName = "htmlbfrm_" + formId + "_";
            int i = 0;
            do {
                if ((paramValue = pc.getParameter(paramName + Integer.toString(i))) != null) {
                    sb.append(paramValue);
                }
                ++i;
            } while (paramValue != null);
            return sb.toString();
        }
        return null;
    }

    public void renderJavascripts(Form form, IPageContext pc) {
        String formId = pc.getCurrentFormId();
        pc.write("<script defer>");
        pc.write("var ");
        pc.write(formId);
        pc.write("_htmlb_inputfields = new Array();");
        pc.write("var ");
        pc.write(formId);
        pc.write("_htmlb_buttons = new Array();");
        pc.write("</script>");
        HashMap<String, String> jsComponents = new HashMap<String, String>();
        TreeMap<String, Component> reverseMap = form.getForceJavascriptInterface();
        if (reverseMap == null) {
            reverseMap = new TreeMap<String, Component>();
        }
        MessageBar mb = form.getMessageBar();
        String mbgenid = pc.getParamIdForComponent(mb);
        jsComponents.put(mb.getId(), mbgenid);
        reverseMap.put(mbgenid, mb);
        ArrayList javascripts = form.getFormEndJavascripts();
        if (javascripts == null) {
            return;
        }
        pc.write("<script defer>");
        Iterator it = ((AbstractList)javascripts).iterator();
        while (it.hasNext()) {
            JavascriptFragment js = (JavascriptFragment)it.next();
            Component component = js.getComponent();
            if (component == null) {
                jsComponents.put("this", "_");
            } else {
                String newid = js.getGeneratedId();
                jsComponents.put("this", newid);
                jsComponents.put(component.getId(), newid);
                reverseMap.put(newid, component);
            }
            String codeFragment = js.getJavascript();
            int i = 0;
            while (i < codeFragment.length()) {
                int k;
                char c = codeFragment.charAt(i);
                switch (c) {
                    case '\"': 
                    case '\'': {
                        k = codeFragment.length();
                        while (++i < k) {
                            if (codeFragment.charAt(i) == c) {
                                k = ++i;
                                continue;
                            }
                            if (codeFragment.charAt(i) != '\\') continue;
                            ++i;
                        }
                        break;
                    }
                    default: {
                        if (!Character.isJavaIdentifierStart(c)) {
                            k = i + 1;
                            break;
                        }
                        k = i + 1;
                        while (k < codeFragment.length() && Character.isJavaIdentifierPart(codeFragment.charAt(k))) {
                            ++k;
                        }
                        String id = codeFragment.substring(i, k);
                        String newid = null;
                        newid = (String)jsComponents.get(id);
                        if (newid == null) {
                            newid = "_";
                            Component comp = form.getComponentById(id);
                            if (comp != null) {
                                try {
                                    IJavascriptComponent jsComponent = (IJavascriptComponent)((Object)comp);
                                    newid = pc.getParamIdForComponent(comp);
                                    reverseMap.put(newid, comp);
                                }
                                catch (Exception ex) {
                                    Log.getLogLocation(false).debugT("NN4FormRenderer", "renderJavascripts");
                                }
                            }
                            jsComponents.put(id, newid);
                        }
                        if (newid.equals("_")) break;
                        String newFragment = codeFragment.substring(0, i) + newid;
                        i = newFragment.length();
                        codeFragment = newFragment + codeFragment.substring(k);
                        k = i;
                    }
                }
                i = k;
            }
            pc.write(codeFragment);
        }
        form.clearFormEndJavascripts();
        form.clearForceJavascriptInterface();
        Iterator it2 = reverseMap.keySet().iterator();
        while (it2.hasNext()) {
            String id = (String)it2.next();
            IJavascriptComponent jsComponent = (IJavascriptComponent)reverseMap.get(id);
            jsComponent.renderJavascriptInterface(pc, id);
        }
        this.renderFullIdElements(pc, form);
        pc.write("</script>");
    }

    public void renderFullIdElements(IPageContext pc, Form form) {
        StringBuffer buffer = new StringBuffer();
        HashMap fullIdFormElements = form.getFullIdFormElements();
        if (!fullIdFormElements.isEmpty()) {
            buffer.append("var htmlbElements = new Array();");
            Iterator keys = fullIdFormElements.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String value = (String)fullIdFormElements.get(key);
                buffer.append("htmlbElements['");
                buffer.append(key);
                buffer.append("']='");
                buffer.append(value);
                buffer.append("';");
            }
            buffer.append("function ");
            buffer.append(pc.getCurrentFormId());
            buffer.append("_getHtmlbElementId(componentId){");
            buffer.append("return htmlbElements[componentId];");
            buffer.append("}");
        }
        pc.write(buffer.toString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

