/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering.nn4;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.Document;
import com.sapportals.htmlb.rendering.HtmlbRenderer;
import com.sapportals.htmlb.rendering.IPageContext;

public class NN4DocumentRenderer
implements HtmlbRenderer {
    public void render(Component component, int selector, IPageContext renderContext) {
        if (component instanceof Document) {
            Document myDocument = (Document)component;
            switch (selector) {
                case 0: {
                    this.renderBegin(myDocument, renderContext);
                    break;
                }
                case 1: {
                    this.renderEnd(myDocument, renderContext);
                    break;
                }
                case 5: {
                    this.renderDocBegin(myDocument, renderContext);
                    break;
                }
                case 6: {
                    this.renderDocEnd(myDocument, renderContext);
                    break;
                }
                case 7: {
                    this.renderHeadBegin(myDocument, renderContext);
                    break;
                }
                case 8: {
                    this.renderHeadEnd(myDocument, renderContext);
                    break;
                }
                case 9: {
                    this.renderBodyBegin(myDocument, renderContext);
                    break;
                }
                case 10: {
                    this.renderBodyEnd(myDocument, renderContext);
                    break;
                }
                case 11: {
                    this.renderHead(myDocument, renderContext);
                    break;
                }
                case 12: {
                    this.renderDocType(myDocument, renderContext);
                }
            }
        }
    }

    public void render(Component component, IPageContext renderContext) {
        if (component instanceof Document) {
            Document myDocument = (Document)component;
            this.renderBegin(myDocument, renderContext);
            this.renderEnd(myDocument, renderContext);
        }
    }

    public void renderDocType(Document document, IPageContext rc) {
    }

    public void renderBegin(Document document, IPageContext rc) {
        rc.write("<html><body bgcolor=\"FFFFFF\"><font face=\"arial\"><b>");
        rc.write("This browser version is not supported!</b></font></body></html>");
    }

    public void renderEnd(Document document, IPageContext rc) {
    }

    public void renderDocBegin(Document document, IPageContext pc) {
        pc.startDocument();
    }

    public void renderDocEnd(Document document, IPageContext pc) {
        pc.endDocument();
    }

    public void renderHeadBegin(Document document, IPageContext pc) {
        String myTitle = document.getTitle();
        pc.startDocumentHead(myTitle);
    }

    public void renderHeadEnd(Document document, IPageContext pc) {
        pc.endDocumentHead();
    }

    public void renderHead(Document document, IPageContext rc) {
        rc.startDocumentHead(document.getTitle());
        rc.writeHeadIncludes();
        String rawHeadText = document.getHeadRawText();
        if (rawHeadText != null) {
            rc.write(rawHeadText);
        }
        rc.endDocumentHead();
    }

    public void renderBodyBegin(Document document, IPageContext pc) {
        pc.startDocumentBody();
    }

    public void renderBodyEnd(Document document, IPageContext pc) {
        pc.endDocumentBody();
    }
}

