/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering.ie6;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.Tree;
import com.sapportals.htmlb.TreeNode;
import com.sapportals.htmlb.event.TreeNodeCloseEvent;
import com.sapportals.htmlb.event.TreeNodeExpandEvent;
import com.sapportals.htmlb.event.TreeNodeSelectEvent;
import com.sapportals.htmlb.rendering.HtmlbRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.Section508Utils;
import java.util.Enumeration;

public class IE6TreeRenderer
implements HtmlbRenderer {
    public void render(Component component, int selector, IPageContext renderContext) {
        if (component instanceof Tree) {
            Tree tree = (Tree)component;
            String componentID = renderContext.getParamIdForComponent(tree);
            if (componentID == null) {
                componentID = renderContext.getParamIdForComponent(component);
            }
            switch (selector) {
                case 0: {
                    this.renderTreeBegin(tree, renderContext);
                    break;
                }
                case 1: {
                    this.renderTreeEnd(tree, renderContext);
                }
            }
        }
    }

    public void render(Component component, IPageContext renderContext) {
        if (component instanceof Tree) {
            Tree tree = (Tree)component;
            String componentID = renderContext.getParamIdForComponent(component);
            tree.setCurrentNodeId(1);
            String nodeID = this.getNodeID(tree, componentID);
            this.renderTreeBegin(tree, renderContext);
            int startLevel = 1;
            if (tree.isRootNodeVisible()) {
                this.renderRootNodeBegin(tree, nodeID, renderContext);
                startLevel = 2;
            }
            this.renderTreeLevel(tree, tree.getRootNode(), nodeID, startLevel, renderContext);
            if (tree.isRootNodeVisible()) {
                this.renderRootNodeEnd(tree, renderContext);
            }
            this.renderTreeEnd(tree, renderContext);
        }
    }

    private void renderTreeBegin(Tree tree, IPageContext renderContext) {
        String componentID = renderContext.getParamIdForComponent(tree);
        renderContext.write("<input type=\"hidden\" name=\"" + componentID + "Eln" + "\" value=\"" + tree.getRootNode().getNodeStatus() + "\">");
        String nodes = tree.getEncodedTreeHierachy();
        int charsPerLine = 120;
        int i = 0;
        int len = nodes.length();
        String part = null;
        int counter = 0;
        i = 0;
        while (i < len) {
            part = nodes.substring(i, i + charsPerLine > len ? len : i + charsPerLine);
            renderContext.write("<input type=\"hidden\" name=\"" + componentID + "Nodes" + "_" + counter + "\" value=\"" + part + "\">");
            ++counter;
            i += charsPerLine;
        }
        renderContext.write("<table cellpadding=\"0\" cellspacing=\"0\" class=\"sapTreWhl");
        String tooltip = tree.getTooltip();
        if (tooltip != null) {
            renderContext.write("\" title=\"");
            renderContext.writeEncoded(tooltip);
        }
        renderContext.write("\" style=\"width:100%;");
        if (tree.getHeight() != null) {
            renderContext.write("height:");
            renderContext.write(tree.getHeight());
        }
        renderContext.write("\"><tr><td valign=\"top\">");
        renderContext.write("   <DIV class=\"sapTreTit\" style=\"white-space:nowrap\">" + tree.getTitle() + "</DIV>");
    }

    private void renderTreeEnd(Tree tree, IPageContext renderContext) {
        renderContext.write("</td></tr></table>");
    }

    private void renderRootNodeBegin(Tree tree, String nodeID, IPageContext renderContext) {
        TreeNode root = tree.getRootNode();
        renderContext.write("<DIV id=\"" + nodeID + "\" status=\"" + this.getStatus(root));
        String tooltip508 = Section508Utils.getTreeNodeTooltip(root, renderContext, 0);
        if (tooltip508 != null) {
            renderContext.write("\" title=\"");
            renderContext.writeEncoded(tooltip508);
        }
        renderContext.write("\" nowrap>");
        renderContext.write("   <span style=\"float:left;\" id=\"" + nodeID.concat(":exp") + "\" class=\"" + this.getClass(root) + "\" ondragenter=\"sapTreDragEnter(this)\" onclick=\"sapTreExpClk(this)\">&nbsp;</span>");
        renderContext.write("   <span nowrap class=\"sapTreNoDsbl\"" + this.getOnClick(renderContext, tree, root) + ">");
        if (root.isEncode()) {
            renderContext.writeEncoded(this.getContent(renderContext, root));
        } else {
            renderContext.write(this.getContent(renderContext, root));
        }
        renderContext.write("</span></DIV>");
    }

    private void renderRootNodeEnd(Tree tree, IPageContext renderContext) {
    }

    private void renderTreeLevelBegin(int level, String nodeID, String status, IPageContext renderContext) {
        String style = " style=\"display:none;\"";
        if (status.equals("open")) {
            style = "";
        }
        String levelClass = level == 1 ? "" : (level == 2 ? "sapTreNl2" : (level == 3 ? "sapTreNl3" : "sapTreNl4"));
        renderContext.write("<NOBR>");
        renderContext.write("<DIV id=\"" + nodeID.concat(":children") + "\" class=\"" + levelClass + "\"" + style + ">");
    }

    private void renderTreeLevelEnd(int level, IPageContext renderContext) {
        renderContext.write("</DIV>");
        renderContext.write("</NOBR>");
    }

    private void renderTreeNodeBegin(Tree tree, TreeNode node, String nodeID, int level, IPageContext renderContext) {
        String tooltip;
        String offset = String.valueOf(20 + (level - 2) * 20);
        renderContext.write("<NOBR>");
        renderContext.write("<DIV id=\"" + nodeID + "\" status=\"" + this.getStatus(node) + "\" nowrap>");
        renderContext.write("    <SPAN nowrap id=\"" + nodeID.concat(":exp") + "\" class=\"" + this.getClass(node) + "\" style=\"margin-left:" + offset + "px;float:left");
        String onNodeExpand = node.getOnNodeExpand();
        String onNodeClose = node.getOnNodeClose();
        if (node.hasChildren()) {
            if (onNodeExpand != null && !onNodeExpand.equals("") && !node.isOpen()) {
                renderContext.write("\" onkeypress=\" htmlbInvokeClick()\" onclick=\"");
                renderContext.write(TreeNodeExpandEvent.renderEventCall(renderContext, tree, node));
                renderContext.write("\"");
            } else if (onNodeClose != null && !onNodeClose.equals("") && node.isOpen()) {
                renderContext.write("\" onkeypress=\" htmlbInvokeClick()\" onclick=\"");
                renderContext.write(TreeNodeCloseEvent.renderEventCall(renderContext, tree, node));
                renderContext.write("\"");
            } else {
                renderContext.write("\" onkeypress=\"htmlbInvokeClick()\" onclick=\"sapTreExpClk(this)");
            }
        }
        if ((tooltip = Section508Utils.getTreeNodeTooltip(node, renderContext, 0)) != null) {
            renderContext.write("\" title=\"");
            renderContext.writeEncoded(tooltip);
        }
        renderContext.write("\"> </SPAN>");
        renderContext.write("    <SPAN nowrap class=\"sapTreNoDsbl\"" + this.getOnClick(renderContext, tree, node) + ">");
        if (node.isEncode()) {
            renderContext.writeEncoded(this.getContent(renderContext, node));
        } else {
            renderContext.write(this.getContent(renderContext, node));
        }
        renderContext.write("</SPAN></DIV></NOBR>");
    }

    private void renderTreeNodeEnd(TreeNode node, int level, IPageContext renderContext) {
    }

    private void renderTreeLevel(Tree tree, TreeNode parent, String nodeID, int level, IPageContext renderContext) {
        this.renderTreeLevelBegin(level, nodeID, this.getStatus(parent), renderContext);
        String componentID = renderContext.getParamIdForComponent(tree);
        Enumeration children = parent.getChildNodes();
        while (children.hasMoreElements()) {
            TreeNode child = (TreeNode)children.nextElement();
            String childNodeID = this.getNodeID(tree, componentID);
            this.renderTreeNodeBegin(tree, child, childNodeID, level, renderContext);
            this.renderTreeLevel(tree, child, childNodeID, level + 1, renderContext);
            this.renderTreeNodeEnd(child, level, renderContext);
        }
        this.renderTreeLevelEnd(level, renderContext);
    }

    private String getNodeID(Tree tree, String componentID) {
        int nodeId = tree.getCurrentNodeId();
        tree.setCurrentNodeId(nodeId + 1);
        String id = String.valueOf(nodeId);
        return componentID.concat("-").concat(id);
    }

    private String getStatus(TreeNode node) {
        if (node.isOpen()) {
            return "open";
        }
        return "closed";
    }

    private String getClass(TreeNode node) {
        if (!node.hasChildren()) {
            return "sapTreExpNc";
        }
        if (node.isOpen()) {
            return "sapTreExpOp";
        }
        return "sapTreExpClo";
    }

    private String getContent(IPageContext renderContext, TreeNode node) {
        Object content = node.getContent();
        if (content instanceof String) {
            return content.toString();
        }
        Component c = (Component)content;
        return c.renderAsString(renderContext);
    }

    private String getOnClick(IPageContext renderContext, Tree tree, TreeNode node) {
        String onTreeClick = tree.getOnTreeClick();
        String onNodeClick = node.getOnNodeClick();
        if (onNodeClick != null || onTreeClick != null) {
            StringBuffer onClick = new StringBuffer();
            onClick.append(" onclick=\"");
            onClick.append(TreeNodeSelectEvent.renderEventCall(renderContext, tree, node));
            onClick.append("\" style=\"cursor:Pointer;\"");
            return onClick.toString();
        }
        return "";
    }
}

