/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering.ie6;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.TabStrip;
import com.sapportals.htmlb.TabStripItem;
import com.sapportals.htmlb.enum.CellHAlign;
import com.sapportals.htmlb.enum.CellVAlign;
import com.sapportals.htmlb.event.TabSelectEvent;
import com.sapportals.htmlb.rendering.HtmlbRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.RenderUtil;
import com.sapportals.htmlb.rendering.Section508Utils;
import java.util.Iterator;

public class IE6TabStripRenderer
implements HtmlbRenderer {
    private static int idcounter;

    public void render(Component component, IPageContext renderContext) {
        if (component instanceof TabStrip) {
            TabStripItem myItem;
            TabStrip myTabStrip = (TabStrip)component;
            int max = myTabStrip.getItemCount();
            if (myTabStrip.getIndexPosition(myTabStrip.getSelection()) < 0) {
                myTabStrip.setSelection(myTabStrip.getItems().getFirstIndex());
            }
            this.renderHeadBegin(myTabStrip, renderContext);
            Iterator items = myTabStrip.getItems().values();
            boolean i = false;
            while (items.hasNext()) {
                myItem = (TabStripItem)items.next();
                myTabStrip.setCurrentIndex(myItem.getIndex());
                if (myItem == null) continue;
                this.renderHeadItemBegin(myTabStrip, renderContext);
                Component header = myItem.getHeader();
                if (header != null) {
                    header.render(renderContext);
                } else {
                    String title = myItem.getTitle();
                    if (title != null) {
                        renderContext.writeEncoded(title);
                    }
                }
                this.renderHeadItemEnd(myTabStrip, renderContext);
                this.renderHeadItemSeparator(myTabStrip, renderContext);
            }
            this.renderHeadEnd(myTabStrip, renderContext);
            this.renderContentBegin(myTabStrip, renderContext);
            items = myTabStrip.getItems().values();
            i = false;
            while (items.hasNext()) {
                myItem = (TabStripItem)items.next();
                myTabStrip.setCurrentIndex(myItem.getIndex());
                if (myItem == null) continue;
                this.renderContentItemBegin(myTabStrip, renderContext);
                RenderUtil.renderContainerContent(myItem, renderContext);
                this.renderContentItemEnd(myTabStrip, renderContext);
            }
            this.renderContentEnd(myTabStrip, renderContext);
        }
    }

    public void render(Component component, int selector, IPageContext renderContext) {
        if (component instanceof TabStrip) {
            TabStrip myTabStrip = (TabStrip)component;
            switch (selector) {
                case 0: {
                    this.renderHeadBegin(myTabStrip, renderContext);
                    break;
                }
                case 1: {
                    this.renderHeadItemBegin(myTabStrip, renderContext);
                    break;
                }
                case 2: {
                    this.renderHeadItemEnd(myTabStrip, renderContext);
                    break;
                }
                case 3: {
                    this.renderHeadItemSeparator(myTabStrip, renderContext);
                    break;
                }
                case 4: {
                    this.renderHeadEnd(myTabStrip, renderContext);
                    break;
                }
                case 5: {
                    this.renderContentBegin(myTabStrip, renderContext);
                    break;
                }
                case 6: {
                    this.renderContentItemBegin(myTabStrip, renderContext);
                    break;
                }
                case 7: {
                    this.renderContentItemEnd(myTabStrip, renderContext);
                    break;
                }
                case 8: {
                    this.renderContentEnd(myTabStrip, renderContext);
                }
            }
        }
    }

    public void renderHeadBegin(TabStrip tabStrip, IPageContext rc) {
        String tooltip;
        String name = tabStrip.getId();
        String fullId = rc.getParamIdForComponent(tabStrip);
        rc.write("<input name=\"");
        rc.write(fullId);
        rc.write("_num\" id=\"");
        rc.write(fullId);
        rc.write("_num\" type=\"hidden\" value=\"");
        rc.write(tabStrip.getItemCount());
        rc.write("\">");
        rc.write("<input name=\"");
        rc.write(fullId);
        rc.write("_sel\" id=\"");
        rc.write(fullId);
        rc.write("_sel\" type=\"hidden\" value=\"");
        rc.write(tabStrip.getIndexPosition(tabStrip.getSelection()));
        rc.write("\">");
        rc.write("<input name=\"");
        rc.write(fullId);
        rc.write("_idx\" id=\"");
        rc.write(fullId);
        rc.write("_idx\" type=\"hidden\" value=\"");
        rc.write(tabStrip.getSelection());
        rc.write("\">");
        rc.write("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"");
        String width = tabStrip.getWidth();
        if (width != null && !width.equals("")) {
            rc.write(" width=\"");
            rc.write(width);
        }
        if ((tooltip = tabStrip.getTooltip()) != null) {
            rc.write("\" title=\"");
            rc.writeEncoded(tooltip);
        }
        rc.write("\"><tr><td>");
        rc.write("<table style=\"");
        if (width != null && !width.equals("")) {
            rc.write("width:");
            rc.write(width);
            rc.write(";");
        }
        rc.write("\"><tr valign=\"top\"><td><table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" style=\"margin-left:1px\"><tr>");
    }

    public void renderHeadItemBegin(TabStrip tabStrip, IPageContext rc) {
        int selection = tabStrip.getSelection();
        int index = tabStrip.getCurrentIndex();
        int indexPos = tabStrip.getIndexPosition(index);
        String name = rc.getParamIdForComponent(tabStrip);
        rc.write("<td id=\"");
        rc.write(name);
        rc.write("tab");
        rc.write(indexPos);
        rc.write("\" class=\"");
        rc.write(index == selection ? "sapTbsTabSel" : "sapTbsTab");
        rc.write("\"><a href=\"#\" onclick=\"");
        TabStripItem myItem = tabStrip.getItem(index);
        String tooltip508 = "";
        String onSelect = myItem.getOnSelect();
        if (onSelect == null) {
            rc.write("sapTbs_switch(");
            rc.write(indexPos);
            rc.write(",");
            rc.write(index);
            rc.write(",'");
            rc.write(name);
            rc.write("'); return false;");
        } else {
            rc.write(TabSelectEvent.renderEventCall(rc, tabStrip, myItem));
        }
        rc.write("\" style=\"text-decoration:none\"><span class=\"sapTxtStd");
        tooltip508 = Section508Utils.getTabStripItemTooltip(myItem, rc, selection);
        myItem = tabStrip.getItem(index);
        if (myItem != null) {
            String tooltip = myItem.getTooltip();
            if (tooltip508 != null || tooltip != null) {
                rc.write("\" title=\"");
                if (tooltip508 != null) {
                    rc.writeEncoded(tooltip508);
                    rc.write(" ");
                }
                if (tooltip != null) {
                    rc.writeEncoded(tooltip);
                }
            }
        }
        rc.write("\"><nobr>");
    }

    public void renderHeadItemEnd(TabStrip tabStrip, IPageContext rc) {
        rc.write("</nobr></span></a></td>");
    }

    public void renderHeadItemSeparator(TabStrip tabStrip, IPageContext rc) {
        int index = tabStrip.getCurrentIndex();
        int selection = tabStrip.getSelection();
        String name = rc.getParamIdForComponent(tabStrip);
        rc.write("<td id=\"");
        rc.write(name);
        rc.write("tbsImg");
        rc.write(tabStrip.getIndexPosition(index));
        rc.write("\" class=\"sapTbsSpc");
        if (index == 1) {
            if (selection == index) {
                rc.write("FrOn");
            } else {
                rc.write("FrOff");
            }
        } else if (index == selection) {
            rc.write("OffOn");
        } else if (index == selection + 1) {
            rc.write("OnOff");
        } else {
            rc.write("OffOff");
        }
        rc.write("\"></td>");
    }

    public void renderHeadEnd(TabStrip tabStrip, IPageContext rc) {
        String name = rc.getParamIdForComponent(tabStrip);
        rc.write("<td nowrap id=\"");
        rc.write(name);
        rc.write("tbsImg");
        rc.write(tabStrip.getItemCount() + 1);
        rc.write("\" class=\"sapTbsSpcBkOff\"></td><td nowrap class=\"sapTbsTabBlk\">&nbsp;</td></tr></table>");
    }

    public void renderContentBegin(TabStrip tabStrip, IPageContext rc) {
        rc.write("<table cellpadding=\"6\" cellspacing=\"0\" border=\"0\" class=\"sapTbsWhl\" width=\"");
        String width = tabStrip.getWidth();
        if (width != null) {
            rc.write(width);
        }
        rc.write("\" height=\"");
        String height = tabStrip.getBodyHeight();
        if (height != null) {
            rc.write(height);
        }
        rc.write("\"><tr><td align=\"");
        CellHAlign hAlign = tabStrip.getHAlign();
        if (hAlign == CellHAlign.CENTER) {
            rc.write("center");
        } else if (hAlign == CellHAlign.LEFT) {
            rc.write("left");
        } else if (hAlign == CellHAlign.RIGHT) {
            rc.write("right");
        } else if (hAlign == CellHAlign.JUSTIFY) {
            rc.write("justify");
        } else if (hAlign == CellHAlign.CHAR) {
            rc.write("char");
        }
        rc.write("\" valign=\"");
        CellVAlign vAlign = tabStrip.getVAlign();
        if (vAlign == CellVAlign.BASELINE) {
            rc.write("baseline");
        } else if (vAlign == CellVAlign.BOTTOM) {
            rc.write("bottom");
        } else if (vAlign == CellVAlign.TOP) {
            rc.write("top");
        } else if (vAlign == CellVAlign.MIDDLE) {
            rc.write("middle");
        }
        rc.write("\">");
    }

    public void renderContentItemBegin(TabStrip tabStrip, IPageContext rc) {
        String height;
        int selection = tabStrip.getSelection();
        int index = tabStrip.getCurrentIndex();
        String name = rc.getParamIdForComponent(tabStrip);
        rc.write("<div id=\"");
        rc.write(name);
        rc.write("content");
        rc.write(tabStrip.getIndexPosition(index));
        rc.write("\" class=\"sapTbsDsp\"");
        rc.write(" style=\"");
        String width = tabStrip.getWidth();
        if (width != null) {
            rc.write("width:");
            rc.write(width);
            rc.write(";");
        }
        if ((height = tabStrip.getBodyHeight()) != null) {
            rc.write("height:");
            rc.write(height);
            rc.write(";");
        }
        if (selection == index) {
            rc.write("display:block;overflow:auto");
        }
        rc.write("\">");
    }

    public void renderContentItemEnd(TabStrip tabStrip, IPageContext rc) {
        rc.write("</div>");
    }

    public void renderContentEnd(TabStrip tabStrip, IPageContext rc) {
        rc.write("</td></tr></table></td></tr></table>");
        rc.write("</td></tr></table>");
    }
}

