/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering.ie4;

import com.sapportals.htmlb.Button;
import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.enum.ButtonDesign;
import com.sapportals.htmlb.event.ButtonClickEvent;
import com.sapportals.htmlb.rendering.AtomHtmlbRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.Section508Utils;

public class IE4ButtonRenderer
extends AtomHtmlbRenderer {
    public void render(Component component, IPageContext rc) {
        if (component instanceof Button) {
            Button myButton = (Button)component;
            boolean disabled = !myButton.isEnabled();
            boolean noHandler = false;
            if (myButton.getOnClick() == null && myButton.getOnClientClick() == null) {
                noHandler = true;
                disabled = true;
            }
            if (!disabled) {
                rc.write(ButtonClickEvent.renderJSFunction(rc, myButton));
            }
            rc.write("<TABLE");
            String value = myButton.getWidth();
            if (value != null) {
                rc.write(" style=\"width:");
                rc.write(value);
                rc.write("\"");
            }
            rc.write("><TR><TD onClick=\"");
            if (noHandler) {
                rc.write("return false;");
            } else {
                rc.write(ButtonClickEvent.renderEventCall(rc, myButton));
            }
            rc.write("\" class=\"sapBtn");
            ButtonDesign myButtonDesign = myButton.getDesign();
            if (myButtonDesign.equals(ButtonDesign.EMPHASIZED)) {
                rc.write("Emph");
            } else if (myButtonDesign.equals(ButtonDesign.SMALL)) {
                rc.write("Sml");
            } else {
                rc.write("Std");
            }
            if (disabled) {
                rc.write("Dsbl");
            }
            rc.write("\"");
            String tooltip508 = Section508Utils.getButtonTooltip(myButton, rc);
            String tooltip = myButton.getTooltip();
            if (tooltip != null || tooltip508 != null) {
                rc.write(" title=\"");
                rc.writeEncoded(tooltip508);
                rc.writeEncoded(tooltip);
                rc.write("\"");
            }
            rc.write("><A");
            rc.write(" class=\"sapBtn");
            if (myButtonDesign.equals(ButtonDesign.EMPHASIZED)) {
                rc.write("Emph");
            } else if (myButtonDesign.equals(ButtonDesign.SMALL)) {
                rc.write("Sml");
            } else {
                rc.write("Std");
            }
            if (disabled) {
                rc.write("Dsbl");
            }
            rc.write("\"><nobr>");
            if (myButton.isEncode()) {
                rc.writeEncoded(myButton.getText());
            } else {
                rc.write(myButton.getText());
            }
            rc.write("</nobr></A></TD></TR></TABLE>\n");
        }
    }
}

