/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering;

import com.sapportals.htmlb.BreadCrumb;
import com.sapportals.htmlb.Button;
import com.sapportals.htmlb.TabStripItem;
import com.sapportals.htmlb.Tray;
import com.sapportals.htmlb.TreeNode;
import com.sapportals.htmlb.enum.BreadCrumbBehavior;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.util.Log;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Section508Utils {
    public static String getButtonTooltip(Button theButton, IPageContext pageContext) {
        String result = null;
        if (pageContext.requiresSection508Rendering()) {
            ResourceBundle localeBundle = Section508Utils.getResourceBundle(pageContext);
            String fullmessage = Section508Utils.getString(localeBundle, "TXT_HTMLB_BUTTON_WHOLE");
            String state = Section508Utils.getString(localeBundle, theButton.isEnabled() ? "TXT_HTMLB_BUTTON_ENABLED" : "TXT_HTMLB_BUTTON_DISABLED");
            result = MessageFormat.format(fullmessage, theButton.getText(), state);
        }
        return result;
    }

    public static String getTreeNodeTooltip(TreeNode theNode, IPageContext pageContext, int level) {
        String result = null;
        if (pageContext.requiresSection508Rendering()) {
            ResourceBundle localeBundle = Section508Utils.getResourceBundle(pageContext);
            boolean isFolder = theNode.hasChildren();
            String fullmessage = Section508Utils.getString(localeBundle, isFolder ? "TXT_HTMLB_TREENODE_FOLDER" : "TXT_HTMLB_TREENODE_ITEM");
            if (isFolder) {
                String state = Section508Utils.getString(localeBundle, theNode.isOpen() ? "TXT_HTMLB_TREENODE_OPENED" : "TXT_HTMLB_TREENODE_CLOSED");
                result = MessageFormat.format(fullmessage, Integer.toString(level), theNode.getText(), state);
            } else {
                result = MessageFormat.format(fullmessage, Integer.toString(level), theNode.getText());
            }
        }
        return result;
    }

    public static String getBreadCrumbTooltip(BreadCrumb bc, IPageContext pageContext) {
        String result = null;
        String orgTooltip = bc.getTooltip();
        if (pageContext.requiresSection508Rendering()) {
            ResourceBundle localeBundle = Section508Utils.getResourceBundle(pageContext);
            result = Section508Utils.getString(localeBundle, "TXT_HTMLB_BREADCRUMB_WHOLE");
            String keystring = "";
            if (BreadCrumbBehavior.SINGLELINK.equals(bc.getBehavior())) {
                int counter = 0;
                while (counter < bc.getModel().size() - 1) {
                    keystring = keystring.concat(bc.getModel().getTextByIndex(counter));
                    keystring = keystring.concat(" ");
                    ++counter;
                }
            } else {
                keystring = bc.getModel().getTextByIndex(0);
            }
            if (orgTooltip != null) {
                result = result.concat(" " + orgTooltip);
            }
            result = result.concat(" " + keystring);
        } else {
            result = orgTooltip;
        }
        return result;
    }

    public static String getBreadCrumbSelectedTooltip(BreadCrumb bc, IPageContext pageContext) {
        String result = null;
        if (pageContext.requiresSection508Rendering()) {
            ResourceBundle localeBundle = Section508Utils.getResourceBundle(pageContext);
            String fullmessage = Section508Utils.getString(localeBundle, "TXT_HTMLB_BREADCRUMB_PATH");
            String state = Section508Utils.getString(localeBundle, "TXT_HTMLB_BREADCRUMB_SELECTED");
            result = MessageFormat.format(fullmessage, bc.getModel().getTextByIndex(bc.getModel().size() - 1), state);
        }
        return result;
    }

    public static String getTabStripItemTooltip(TabStripItem tsi, IPageContext pageContext, int selected) {
        String result = null;
        if (pageContext.requiresSection508Rendering()) {
            ResourceBundle localeBundle = Section508Utils.getResourceBundle(pageContext);
            String component = Section508Utils.getString(localeBundle, "TXT_HTMLB_TABSTRIP_WHOLE");
            String item = Section508Utils.getString(localeBundle, "TXT_HTMLB_TABSTRIP_PAGE");
            String state = Section508Utils.getString(localeBundle, "TXT_HTMLB_TABSTRIP_SELECTED");
            result = tsi.getIndex() == 0 ? component + " " + MessageFormat.format(item, tsi.getTitle()) : MessageFormat.format(item, tsi.getTitle());
            result = selected == tsi.getIndex() ? MessageFormat.format(result, "", state) : MessageFormat.format(result, "", "");
        }
        return result;
    }

    public static String getTrayTooltip(Tray theTray, IPageContext pageContext) {
        String result = null;
        if (pageContext.requiresSection508Rendering()) {
            ResourceBundle localeBundle = Section508Utils.getResourceBundle(pageContext);
            String fullmessage = Section508Utils.getString(localeBundle, "TXT_HTMLB_TRAY_WHOLE");
            String state = Section508Utils.getString(localeBundle, theTray.isCollapsed() ? "TXT_HTMLB_TRAY_CLOSED" : "TXT_HTMLB_TRAY_OPENED");
            result = MessageFormat.format(fullmessage, theTray.getTitle(), state);
        }
        return result;
    }

    public static String getTrayIconTooltip(Tray theTray, IPageContext pageContext, String theIcon) {
        String result = null;
        if (pageContext.requiresSection508Rendering()) {
            ResourceBundle localeBundle = Section508Utils.getResourceBundle(pageContext);
            String fullmessage = "";
            if (theIcon.equalsIgnoreCase("PERSONALIZE")) {
                fullmessage = Section508Utils.getString(localeBundle, "TXT_HTMLB_TRAY_ICON_PERSONALIZE");
            }
            if (theIcon.equalsIgnoreCase("CLOSE")) {
                fullmessage = Section508Utils.getString(localeBundle, "TXT_HTMLB_TRAY_ICON_CLOSE");
            }
            if (theIcon.equalsIgnoreCase("OPEN")) {
                fullmessage = Section508Utils.getString(localeBundle, "TXT_HTMLB_TRAY_ICON_OPEN");
            }
            if (theIcon.equalsIgnoreCase("REMOVE")) {
                fullmessage = Section508Utils.getString(localeBundle, "TXT_HTMLB_TRAY_ICON_REMOVE");
            }
            if (theIcon.equalsIgnoreCase("EXPAND")) {
                fullmessage = Section508Utils.getString(localeBundle, "TXT_HTMLB_TRAY_ICON_EXPAND");
            }
            if (theIcon.equalsIgnoreCase("REFRESH")) {
                fullmessage = Section508Utils.getString(localeBundle, "TXT_HTMLB_TRAY_ICON_REFRESH");
            }
            result = fullmessage;
        }
        return result;
    }

    private static String getString(ResourceBundle theBundle, String key) {
        String result;
        if (theBundle != null) {
            try {
                result = theBundle.getString(key);
            }
            catch (MissingResourceException e) {
                Log.getLogLocation(false).debugT("Section508Utils", "getString");
                result = key;
            }
        } else {
            result = key;
        }
        return result;
    }

    private static ResourceBundle getResourceBundle(IPageContext pageContext) {
        ResourceBundle result = null;
        try {
            result = ResourceBundle.getBundle("com.sapportals.htmlb.Localization", pageContext.getLocale());
        }
        catch (Exception e) {
            Log.getLogLocation(false).debugT("Section508Utils", "getResourceBundle");
        }
        return result;
    }
}

