/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering;

import com.sapportals.htmlb.enum.BrowserType;
import com.sapportals.htmlb.rendering.DefaultEventRenderer;
import com.sapportals.htmlb.rendering.HtmlbRenderer;
import com.sapportals.htmlb.rendering.IEventRenderer;
import com.sapportals.htmlb.util.Log;
import java.util.Hashtable;
import java.util.Vector;

public class RendererManager {
    private static String defaultMimePath = "/htmlb/mimes/common/";
    private static String defaultJSPath = "/htmlb/jslib/";
    private static String defaultStylePath = "/htmlb/mimes/ur/";
    static Vector classIdVector;
    static Object[] browserDefaults;
    static Object[] uiDefaults;
    static Object[] NetscapeDefault;
    static Object[] uiBrowserSpecificRenderer;
    static Object[] eventBrowserSpecifics;
    static Hashtable viewClassHash;
    static Hashtable cssHash;
    static Hashtable jsHash;
    static Hashtable uiIdHash;
    static Hashtable eventHash;
    static Hashtable urMapiHash;
    static Hashtable urPopupHash;
    static IEventRenderer defaultEventRenderer;

    public static void addRenderer(String componentID, BrowserType bt, Class rendererClass) {
        if (viewClassHash == null) {
            viewClassHash = new Hashtable(50);
        }
        String key = componentID + bt.toString();
        HtmlbRenderer myRenderer = null;
        try {
            myRenderer = (HtmlbRenderer)rendererClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(rendererClass.toString() + " could not be instantiated");
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(rendererClass.toString() + " could not be accessed");
        }
        viewClassHash.put(key, myRenderer);
    }

    public static void addBrowser(BrowserType bt, String styleSheetName, String javaScriptName, String urMapiScriptName, String urPopupScriptName) {
        if (cssHash == null) {
            RendererManager.initialize();
        }
        cssHash.put(bt, styleSheetName);
        jsHash.put(bt, javaScriptName);
        urMapiHash.put(bt, urMapiScriptName);
        urPopupHash.put(bt, urPopupScriptName);
    }

    private static void createUIDefaults(Object[] keyValueList) {
        if (viewClassHash == null) {
            viewClassHash = new Hashtable(50);
            int i = 0;
            while (i < keyValueList.length) {
                try {
                    Class<?> renderClass = Class.forName((String)keyValueList[i + 1]);
                    RendererManager.addRenderer((String)keyValueList[i], BrowserType.DEFAULT, renderClass);
                }
                catch (ClassNotFoundException e) {
                    Log.getLogLocation(false).debugT("RendererManager class not found", (String)keyValueList[i + 1]);
                }
                i += 2;
            }
        }
    }

    private static void createEventDefaults(Object[] eventList) {
        if (eventHash == null) {
            int i = 0;
            while (i < eventList.length) {
                try {
                    Class<?> renderClass = Class.forName((String)eventList[i + 1]);
                    RendererManager.addEventRenderer((BrowserType)eventList[i], renderClass);
                }
                catch (ClassNotFoundException e) {
                    Log.getLogLocation(false).debugT("RendererManager class not found", (String)eventList[i + 1]);
                }
                i += 2;
            }
        }
    }

    private static void createUIBrowserRenderer(Object[] keyBrowserValueList) {
        if (viewClassHash == null) {
            viewClassHash = new Hashtable(50);
        }
        if (viewClassHash != null) {
            int i = 0;
            while (i < keyBrowserValueList.length) {
                BrowserType bt = (BrowserType)keyBrowserValueList[i];
                Object[] renderer = (Object[])keyBrowserValueList[i + 1];
                int j = 0;
                while (j < renderer.length) {
                    try {
                        Class<?> renderClass = Class.forName((String)renderer[j + 1]);
                        RendererManager.addRenderer((String)renderer[j], bt, renderClass);
                    }
                    catch (ClassNotFoundException e) {
                        Log.getLogLocation(false).debugT("RendererManager class not found", (String)renderer[j + 1]);
                    }
                    j += 2;
                }
                i += 2;
            }
        }
    }

    private static void createBrowserDefaults(Object[] keyValueList) {
        if (cssHash == null) {
            cssHash = new Hashtable(keyValueList.length / 5);
            jsHash = new Hashtable(keyValueList.length / 5);
            urMapiHash = new Hashtable(keyValueList.length / 5);
            urPopupHash = new Hashtable(keyValueList.length / 5);
            int i = 0;
            while (i < keyValueList.length) {
                RendererManager.addBrowser((BrowserType)keyValueList[i], (String)keyValueList[i + 1], (String)keyValueList[i + 2], (String)keyValueList[i + 3], (String)keyValueList[i + 4]);
                i += 5;
            }
        }
    }

    private static synchronized void initialize() {
        RendererManager.createUIDefaults(uiDefaults);
        RendererManager.createUIBrowserRenderer(uiBrowserSpecificRenderer);
        RendererManager.createBrowserDefaults(browserDefaults);
        RendererManager.createEventDefaults(eventBrowserSpecifics);
    }

    public static HtmlbRenderer getRenderer(String uiId, BrowserType browserId) {
        Object renderClass;
        if (viewClassHash == null) {
            RendererManager.initialize();
        }
        if ((renderClass = viewClassHash.get(uiId + browserId.toString())) instanceof HtmlbRenderer) {
            return (HtmlbRenderer)renderClass;
        }
        renderClass = viewClassHash.get(uiId + BrowserType.DEFAULT.toString());
        if (renderClass instanceof HtmlbRenderer) {
            return (HtmlbRenderer)renderClass;
        }
        return null;
    }

    public static String getCssFileName(BrowserType browserId) {
        if (cssHash == null) {
            RendererManager.initialize();
        }
        if (browserId != null) {
            return (String)cssHash.get(browserId);
        }
        throw new IllegalArgumentException("RendererManager.getCssFileName: BrowserType must not be null");
    }

    public static String getJavascriptFileName(BrowserType browserId) {
        if (jsHash == null) {
            RendererManager.initialize();
        }
        if (browserId != null) {
            return (String)jsHash.get(browserId);
        }
        throw new IllegalArgumentException("RendererManager.getJavascriptFileName: BrowserType must not be null");
    }

    public static String getUrMapiJavascriptFileName(BrowserType browserId) {
        if (urMapiHash == null) {
            RendererManager.initialize();
        }
        if (browserId != null) {
            return (String)urMapiHash.get(browserId);
        }
        throw new IllegalArgumentException("RendererManager.getUrMapiJavascriptFileName: BrowserType must not be null");
    }

    public static String getUrPopupJavascriptFileName(BrowserType browserId) {
        if (urPopupHash == null) {
            RendererManager.initialize();
        }
        if (browserId != null) {
            return (String)urPopupHash.get(browserId);
        }
        throw new IllegalArgumentException("RendererManager.getUrPopupJavascriptFileName: BrowserType must not be null");
    }

    public static String getDefaultMimePath() {
        return defaultMimePath;
    }

    public static String getDefaultStylePath() {
        return defaultStylePath;
    }

    public static String getDefaultJavascriptPath() {
        return defaultJSPath;
    }

    public static void setDefaultMimePath(String mimePath) {
        defaultMimePath = mimePath;
    }

    public static void setDefaultStylePath(String stylePath) {
        defaultStylePath = stylePath;
    }

    public static void setDefaultJavascriptPath(String jsPath) {
        defaultJSPath = jsPath;
    }

    public static void addEventRenderer(BrowserType browser, Class rendererClass) {
        if (eventHash == null) {
            eventHash = new Hashtable();
        }
        IEventRenderer myInstance = null;
        try {
            myInstance = (IEventRenderer)rendererClass.newInstance();
            eventHash.put(browser, myInstance);
        }
        catch (InstantiationException e) {
            Log.getLogLocation(false).debugT("RendererManager", "Could not get EventRenderer" + rendererClass.getName());
        }
        catch (IllegalAccessException e) {
            Log.getLogLocation(false).debugT("RendererManager", "Could not get EventRenderer" + rendererClass.getName());
        }
    }

    public static IEventRenderer getEventRenderer(BrowserType browser) {
        IEventRenderer result;
        if (eventHash != null && (result = (IEventRenderer)eventHash.get(browser)) != null) {
            return result;
        }
        return defaultEventRenderer;
    }

    public static String getBrowserAbbreviation(BrowserType type) {
        if (type == BrowserType.DEFAULT) {
            return "ie5";
        }
        if (type == BrowserType.MAC_NETSCAPE_6) {
            return "nn6";
        }
        if (type == BrowserType.NETSCAPE_6) {
            return "nn6";
        }
        if (type == BrowserType.NETSCAPE_7) {
            return "nn7";
        }
        if (type == BrowserType.MSIE5) {
            return "ie5";
        }
        if (type == BrowserType.MSIE55) {
            return "ie5";
        }
        if (type == BrowserType.MSIE6) {
            return "ie6";
        }
        return "ie5";
    }

    static {
        browserDefaults = new Object[]{BrowserType.DEFAULT, "controls_default.css", "controls_default.js", "sapUrMapi_ie5.js", "popup_ie5.js", BrowserType.NETSCAPE_4, "controls_nn4.css", "controls_nn4.js", "", "", BrowserType.NETSCAPE_6, "ur_nn6.css", "controls_nn6.js", "sapUrMapi_nn6.js", "popup_nn6.js", BrowserType.NETSCAPE_7, "ur_nn7.css", "controls_nn6.js", "sapUrMapi_nn7.js", "popup_nn7.js", BrowserType.MAC_NETSCAPE_6, "ur_nn6.css", "controls_nn6.js", "sapUrMapi_nn6.js", "popup_nn6.js", BrowserType.MSIE4, "controls_ie4.css", "controls_ie4.js", "", "", BrowserType.MSIE5, "ur_ie5.css", "controls_ie5.js", "sapUrMapi_ie5.js", "popup_ie5.js", BrowserType.MSIE55, "ur_ie5.css", "controls_ie5.js", "sapUrMapi_ie5.js", "popup_ie5.js", BrowserType.MSIE6, "ur_ie6.css", "controls_ie5.js", "sapUrMapi_ie6.js", "popup_ie6.js", BrowserType.MOBILE_HTML, "", "", "", "", BrowserType.MOBILE_WML, "", "", "", "", BrowserType.MOBILE_VOICE, "", "", "", ""};
        uiDefaults = new Object[]{"ItemList", "com.sapportals.htmlb.unifiedrendering.ie5.ItemListRenderer", "InputField", "com.sapportals.htmlb.unifiedrendering.ie5.InputFieldRenderer", "Includes", "com.sapportals.htmlb.rendering.DefaultIncludesRenderer", "Button", "com.sapportals.htmlb.unifiedrendering.ie5.ButtonRenderer", "DropdownListBox", "com.sapportals.htmlb.unifiedrendering.ie5.DropDownListBoxRenderer", "ListBox", "com.sapportals.htmlb.unifiedrendering.ie5.ListBoxRenderer", "TextEdit", "com.sapportals.htmlb.unifiedrendering.ie5.TextEditRenderer", "Group", "com.sapportals.htmlb.unifiedrendering.ie5.GroupRenderer", "Checkbox", "com.sapportals.htmlb.unifiedrendering.ie5.CheckBoxRenderer", "CheckboxGroup", "com.sapportals.htmlb.unifiedrendering.ie5.CheckBoxGroupRenderer", "RadioButton", "com.sapportals.htmlb.unifiedrendering.ie5.RadioButtonRenderer", "RadioButtonGroup", "com.sapportals.htmlb.unifiedrendering.ie5.RadioButtonGroupRenderer", "Tray", "com.sapportals.htmlb.unifiedrendering.ie5.TrayRenderer", "Form", "com.sapportals.htmlb.rendering.DefaultFormRenderer", "TabStrip", "com.sapportals.htmlb.unifiedrendering.ie5.TabStripRenderer", "Document", "com.sapportals.htmlb.rendering.DefaultDocumentRenderer", "Image", "com.sapportals.htmlb.unifiedrendering.ie5.ImageRenderer", "TableView", "com.sapportals.htmlb.unifiedrendering.ie5.TableViewRenderer", "FileUpload", "com.sapportals.htmlb.unifiedrendering.ie5.FileUploadRenderer", "GridLayout", "com.sapportals.htmlb.unifiedrendering.ie5.GridLayoutRenderer", "TextView", "com.sapportals.htmlb.unifiedrendering.ie5.TextViewRenderer", "Tree", "com.sapportals.htmlb.unifiedrendering.ie5.TreeRenderer", "Link", "com.sapportals.htmlb.unifiedrendering.ie5.LinkRenderer", "BreadCrumb", "com.sapportals.htmlb.unifiedrendering.ie5.BreadCrumbRenderer", "DateNavigator", "com.sapportals.htmlb.unifiedrendering.ie5.DateNavigatorRenderer", "Chart", "com.sapportals.htmlb.rendering.DefaultChartRenderer", "HTMLFragment", "com.sapportals.htmlb.rendering.DefaultHTMLFragmentRenderer", "FlowLayout", "com.sapportals.htmlb.rendering.DefaultFlowLayoutRenderer", "FormLayout", "com.sapportals.htmlb.unifiedrendering.ie5.GridLayoutRenderer", "Label", "com.sapportals.htmlb.unifiedrendering.ie5.LabelRenderer", "DragSource", "com.sapportals.htmlb.rendering.DefaultDragSourceRenderer", "DropTarget", "com.sapportals.htmlb.rendering.DefaultDropTargetRenderer", "IsolatedHtmlContainer", "com.sapportals.htmlb.unifiedrendering.ie5.IframeRenderer", "NonIsolatedHtmlContainer", "com.sapportals.htmlb.rendering.DefaultNonIsolatedHtmlContainerRenderer", "HoverMenu", "com.sapportals.htmlb.unifiedrendering.ie5.PopupMenuRenderer", "LinkForHoverMenu", "com.sapportals.htmlb.unifiedrendering.ie5.LinkRenderer", "MenuBar", "com.sapportals.htmlb.unifiedrendering.ie5.MenuBarRenderer", "MessageBar", "com.sapportals.htmlb.unifiedrendering.ie5.MessageBarRenderer", "ImageMap", "com.sapportals.htmlb.rendering.DefaultImageMapRenderer", "HtmlEdit", "com.sapportals.htmlb.rendering.nn6.NN6HtmlEditRenderer", "ScrollContainer", "com.sapportals.htmlb.unifiedrendering.ie5.ScrollContainerRenderer", "Timer", "com.sapportals.htmlb.rendering.DefaultTimerRenderer", "AppletContainer", "com.sapportals.htmlb.unifiedrendering.ie5.AppletContainerRenderer", "EventContainer", "com.sapportals.htmlb.rendering.DefaultClientEventContainerRenderer", "Bookmark", "com.sapportals.htmlb.rendering.DefaultBookmarkRenderer", "ExtSub", "com.sapportals.htmlb.rendering.DefaultExternalSubmitRenderer", "StyleContainer", "com.sapportals.htmlb.rendering.DefaultStyleContainerRenderer", "RasterLayout", "com.sapportals.htmlb.unifiedrendering.ie5.RasterLayoutRenderer", "PopupTrigger", "com.sapportals.htmlb.unifiedrendering.ie5.PopupTriggerRenderer", "Toolbar", "com.sapportals.htmlb.unifiedrendering.ie5.ToolbarRenderer", "ToolbarSeparator", "com.sapportals.htmlb.unifiedrendering.ie5.ToolbarSeparatorRenderer", "ToolbarInputField", "com.sapportals.htmlb.unifiedrendering.ie5.ToolbarInputFieldRenderer", "ToolbarButton", "com.sapportals.htmlb.unifiedrendering.ie5.ToolbarButtonRenderer", "ToolbarDropDownListBox", "com.sapportals.htmlb.unifiedrendering.ie5.ToolbarDropDownListBoxRenderer", "ProgressIndicator", "com.sapportals.htmlb.unifiedrendering.ie5.ProgressIndicatorRenderer", "ButtonRow", "com.sapportals.htmlb.unifiedrendering.ie5.ButtonRowRenderer", "DataTransferComponent", "com.sapportals.htmlb.rendering.DefaultDataTransferComponentRenderer", "RoadMap", "com.sapportals.htmlb.unifiedrendering.ie5.RoadMapRenderer"};
        NetscapeDefault = new Object[]{"Button", "com.sapportals.htmlb.unifiedrendering.nn6.ButtonRenderer", "Document", "com.sapportals.htmlb.rendering.nn6.NN6DocumentRenderer", "DragSource", "com.sapportals.htmlb.rendering.nn6.NN6DragSourceRenderer", "DropTarget", "com.sapportals.htmlb.rendering.nn6.NN6DropTargetRenderer", "Form", "com.sapportals.htmlb.rendering.nn6.NN6FormRenderer", "ItemList", "com.sapportals.htmlb.unifiedrendering.nn6.ItemListRenderer", "HoverMenu", "com.sapportals.htmlb.unifiedrendering.nn6.PopupMenuRenderer", "Label", "com.sapportals.htmlb.unifiedrendering.nn6.LabelRenderer", "GridLayout", "com.sapportals.htmlb.unifiedrendering.nn6.GridLayoutRenderer", "FormLayout", "com.sapportals.htmlb.unifiedrendering.nn6.GridLayoutRenderer", "ScrollContainer", "com.sapportals.htmlb.unifiedrendering.nn6.ScrollContainerRenderer", "Tray", "com.sapportals.htmlb.unifiedrendering.nn6.TrayRenderer", "Group", "com.sapportals.htmlb.unifiedrendering.nn6.GroupRenderer", "TabStrip", "com.sapportals.htmlb.unifiedrendering.nn6.TabStripRenderer", "ToolbarSeparator", "com.sapportals.htmlb.unifiedrendering.nn6.ToolbarSeparatorRenderer", "ToolbarInputField", "com.sapportals.htmlb.unifiedrendering.nn6.ToolbarInputFieldRenderer", "ToolbarButton", "com.sapportals.htmlb.unifiedrendering.nn6.ToolbarButtonRenderer", "ToolbarDropDownListBox", "com.sapportals.htmlb.unifiedrendering.nn6.ToolbarDropDownListBoxRenderer", "ProgressIndicator", "com.sapportals.htmlb.unifiedrendering.nn6.ProgressIndicatorRenderer"};
        uiBrowserSpecificRenderer = new Object[]{BrowserType.NETSCAPE_6, NetscapeDefault, BrowserType.NETSCAPE_7, NetscapeDefault, BrowserType.NETSCAPE_4, new Object[]{"Document", "com.sapportals.htmlb.rendering.nn6.NN6DocumentRenderer", "DragSource", "com.sapportals.htmlb.rendering.nn6.NN6DragSourceRenderer", "DropTarget", "com.sapportals.htmlb.rendering.nn6.NN6DropTargetRenderer", "Form", "com.sapportals.htmlb.rendering.nn6.NN6FormRenderer", "ItemList", "com.sapportals.htmlb.unifiedrendering.nn6.ItemListRenderer", "HoverMenu", "com.sapportals.htmlb.unifiedrendering.nn6.PopupMenuRenderer"}, BrowserType.NETSCAPE_7, new Object[]{"Document", "com.sapportals.htmlb.rendering.nn6.NN6DocumentRenderer", "DragSource", "com.sapportals.htmlb.rendering.nn6.NN6DragSourceRenderer", "DropTarget", "com.sapportals.htmlb.rendering.nn6.NN6DropTargetRenderer", "Form", "com.sapportals.htmlb.rendering.nn6.NN6FormRenderer", "ItemList", "com.sapportals.htmlb.unifiedrendering.nn6.ItemListRenderer", "IsolatedHtmlContainer", "com.sapportals.htmlb.unifiedrendering.nn6.IframeRenderer", "HoverMenu", "com.sapportals.htmlb.unifiedrendering.nn6.PopupMenuRenderer", "Label", "com.sapportals.htmlb.unifiedrendering.nn6.LabelRenderer", "GridLayout", "com.sapportals.htmlb.unifiedrendering.nn6.GridLayoutRenderer", "FormLayout", "com.sapportals.htmlb.unifiedrendering.nn6.GridLayoutRenderer", "ProgressIndicator", "com.sapportals.htmlb.unifiedrendering.nn6.ProgressIndicatorRenderer"}, BrowserType.MSIE4, new Object[0], BrowserType.MSIE55, new Object[]{"HtmlEdit", "com.sapportals.htmlb.rendering.DefaultHtmlEditRenderer"}, BrowserType.MSIE6, new Object[]{"HtmlEdit", "com.sapportals.htmlb.rendering.DefaultHtmlEditRenderer"}, BrowserType.MOBILE_HTML, new Object[]{"BreadCrumb", "com.sap.mobile.htmlb.rendering.html.HtmlBreadCrumbRenderer", "Button", "com.sap.mobile.htmlb.rendering.html.HtmlButtonRenderer", "CheckboxGroup", "com.sap.mobile.htmlb.rendering.html.HtmlCheckboxGroupRenderer", "Checkbox", "com.sap.mobile.htmlb.rendering.html.HtmlCheckboxRenderer", "DateNavigator", "com.sap.mobile.htmlb.rendering.html.HtmlDateNavigatorRenderer", "Document", "com.sap.mobile.htmlb.rendering.html.HtmlDocumentRenderer", "DropdownListBox", "com.sap.mobile.htmlb.rendering.html.HtmlDropdownListBoxRenderer", "FlowLayout", "com.sap.mobile.htmlb.rendering.html.HtmlFlowLayoutRenderer", "Form", "com.sap.mobile.htmlb.rendering.html.HtmlFormRenderer", "GridLayout", "com.sap.mobile.htmlb.rendering.html.HtmlGridLayoutRenderer", "Group", "com.sap.mobile.htmlb.rendering.html.HtmlGroupRenderer", "Image", "com.sap.mobile.htmlb.rendering.html.HtmlImageRenderer", "Includes", "com.sap.mobile.htmlb.rendering.html.HtmlIncludesRenderer", "InputField", "com.sap.mobile.htmlb.rendering.html.HtmlInputFieldRenderer", "ItemList", "com.sap.mobile.htmlb.rendering.html.HtmlItemListRenderer", "Label", "com.sap.mobile.htmlb.rendering.html.HtmlLabelRenderer", "Link", "com.sap.mobile.htmlb.rendering.html.HtmlLinkRenderer", "ListBox", "com.sap.mobile.htmlb.rendering.html.HtmlListBoxRenderer", "RadioButtonGroup", "com.sap.mobile.htmlb.rendering.html.HtmlRadioButtonGroupRenderer", "RadioButton", "com.sap.mobile.htmlb.rendering.html.HtmlRadioButtonRenderer", "TableView", "com.sap.mobile.htmlb.rendering.html.HtmlTableViewRenderer", "TabStrip", "com.sap.mobile.htmlb.rendering.html.HtmlTabStripRenderer", "TextEdit", "com.sap.mobile.htmlb.rendering.html.HtmlTextEditRenderer", "TextView", "com.sap.mobile.htmlb.rendering.html.HtmlTextViewRenderer", "Tray", "com.sap.mobile.htmlb.rendering.html.HtmlTrayRenderer", "Tree", "com.sap.mobile.htmlb.rendering.html.HtmlTreeRenderer"}, BrowserType.MOBILE_WML, new Object[]{"BreadCrumb", "com.sap.mobile.htmlb.rendering.wml.WmlBreadCrumbRenderer", "Button", "com.sap.mobile.htmlb.rendering.wml.WmlButtonRenderer", "CheckboxGroup", "com.sap.mobile.htmlb.rendering.wml.WmlCheckboxGroupRenderer", "Checkbox", "com.sap.mobile.htmlb.rendering.wml.WmlCheckboxRenderer", "DateNavigator", "com.sap.mobile.htmlb.rendering.wml.WmlDateNavigatorRenderer", "Document", "com.sap.mobile.htmlb.rendering.wml.WmlDocumentRenderer", "DropdownListBox", "com.sap.mobile.htmlb.rendering.wml.WmlDropdownListBoxRenderer", "Form", "com.sap.mobile.htmlb.rendering.wml.WmlFormRenderer", "GridLayout", "com.sap.mobile.htmlb.rendering.wml.WmlGridLayoutRenderer", "Group", "com.sap.mobile.htmlb.rendering.wml.WmlGroupRenderer", "Image", "com.sap.mobile.htmlb.rendering.wml.WmlImageRenderer", "InputField", "com.sap.mobile.htmlb.rendering.wml.WmlInputFieldRenderer", "ItemList", "com.sap.mobile.htmlb.rendering.wml.WmlItemListRenderer", "Label", "com.sap.mobile.htmlb.rendering.wml.WmlLabelRenderer", "Link", "com.sap.mobile.htmlb.rendering.wml.WmlLinkRenderer", "ListBox", "com.sap.mobile.htmlb.rendering.wml.WmlListBoxRenderer", "RadioButtonGroup", "com.sap.mobile.htmlb.rendering.wml.WmlRadioButtonGroupRenderer", "RadioButton", "com.sap.mobile.htmlb.rendering.wml.WmlRadioButtonRenderer", "TableView", "com.sap.mobile.htmlb.rendering.wml.WmlTableViewRenderer", "TabStrip", "com.sap.mobile.htmlb.rendering.wml.WmlTabStripRenderer", "TextEdit", "com.sap.mobile.htmlb.rendering.wml.WmlTextEditRenderer", "TextView", "com.sap.mobile.htmlb.rendering.wml.WmlTextViewRenderer", "Tray", "com.sap.mobile.htmlb.rendering.wml.WmlTrayRenderer"}};
        eventBrowserSpecifics = new Object[]{BrowserType.MOBILE_WML, "com.sap.mobile.htmlb.rendering.wml.WmlEventRenderer"};
        viewClassHash = null;
        cssHash = null;
        jsHash = null;
        uiIdHash = null;
        eventHash = null;
        urMapiHash = null;
        urPopupHash = null;
        defaultEventRenderer = new DefaultEventRenderer();
    }
}

