/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.Container;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.type.DataString;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;

public class RenderUtil {
    private static final String XSS_TOKEN_JS = "javascript:";

    public static void renderContainerContent(Container container, IPageContext pageContext) {
        Iterator it = container.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            RenderUtil.renderContentObject(o, pageContext);
        }
    }

    public static void renderOneByOneGif(IPageContext pc) {
        pc.write("<img src=\"");
        pc.write(pc.getMimePath());
        pc.write("1x1.gif\">");
    }

    public static void renderGif(IPageContext pc, String compName, String gifName, String CompId, String alt) {
        pc.write("<img src=\"");
        pc.write(pc.getMimePath());
        pc.write(compName);
        pc.write("/");
        pc.write(gifName);
        pc.write("\" border=\"0\" id=\"");
        pc.write(CompId);
        if (alt != null) {
            pc.write("\" alt=\"");
            pc.write(alt);
        }
        pc.write("\">");
    }

    public static void renderPixelGifSpan(String HiWi, IPageContext pc, int HoriVerti) {
        pc.write("<img src=\"");
        pc.write(pc.getMimePath());
        pc.write("1x1.gif");
        pc.write("\" border=\"0\"");
        if (HoriVerti == 0) {
            pc.write(" width=\"");
            pc.write(HiWi);
            pc.write("\" height=\"1\">");
        } else if (HoriVerti == 1) {
            pc.write(" height=\"");
            pc.write(HiWi);
            pc.write("\" width=\"1\">");
        } else {
            pc.write(" height=\"1\" width=\"1\">");
        }
    }

    public static void renderContentObject(Object o, IPageContext pageContext) {
        if (o instanceof Component) {
            Component myComponent = (Component)o;
            myComponent.render(pageContext);
        } else if (o instanceof String) {
            pageContext.write((String)o);
        } else if (o instanceof DataString) {
            String value = ((DataString)o).getValue();
            if (((DataString)o).isEncode()) {
                pageContext.writeEncoded(value);
            } else {
                pageContext.write(value);
            }
        }
    }

    public static String[] getDayAbbreviations(Locale locale) {
        ResourceBundle r = ResourceBundle.getBundle("java.text.resources.LocaleElements", locale);
        String[] dayAbbreviations = (String[])r.getObject("DayAbbreviations");
        int i = 0;
        while (i < dayAbbreviations.length) {
            if (dayAbbreviations[i].length() > 2) {
                dayAbbreviations[i] = dayAbbreviations[i].substring(0, 2);
            }
            ++i;
        }
        return dayAbbreviations;
    }

    public static String[] getMonthNames(Locale locale) {
        ResourceBundle r = ResourceBundle.getBundle("java.text.resources.LocaleElements", locale);
        String[] monthNames = (String[])r.getObject("MonthNames");
        return monthNames;
    }

    public static String encodeJavascriptString(String text) {
        int length = 0;
        length = text.length();
        StringBuffer s = new StringBuffer(length + 20);
        s.append("\"");
        int i = 0;
        while (i < length) {
            char c = text.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    s.append("\\");
                }
            }
            s.append(c);
            ++i;
        }
        s.append("\"");
        return s.toString();
    }

    public static String encodeForHtml(String text) {
        return RenderUtil.encodeForHtml(text, true);
    }

    public static String encodeForHtml(String text, boolean escapeAll) {
        return RenderUtil.encodeForHtml(text, escapeAll, false);
    }

    public static String encodeForHtmlDisplay(String text) {
        return RenderUtil.encodeForHtml(text, true, true);
    }

    private static String encodeForHtml(String text, boolean escapeAll, boolean withBlanks) {
        if (text == null) {
            return "";
        }
        if (escapeAll && !withBlanks) {
            return RenderUtil.encodeForHtmlEscapeAllNoBlanks(text);
        }
        StringBuffer sb = new StringBuffer(text.length() + 50);
        boolean handled = false;
        int spaceHandler = 0;
        char c = ' ';
        int length = text.length();
        int i = 0;
        while (i < length) {
            if (c == ' ') {
                ++spaceHandler;
            }
            c = text.charAt(i);
            handled = false;
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    handled = true;
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    handled = true;
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    handled = true;
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    handled = true;
                }
            }
            if (!handled) {
                if (escapeAll) {
                    switch (c) {
                        case '\u00e0': {
                            sb.append("&agrave;");
                            break;
                        }
                        case '\u00c0': {
                            sb.append("&Agrave;");
                            break;
                        }
                        case '\u00e2': {
                            sb.append("&acirc;");
                            break;
                        }
                        case '\u00e4': {
                            sb.append("&auml;");
                            break;
                        }
                        case '\u00c4': {
                            sb.append("&Auml;");
                            break;
                        }
                        case '\u00c2': {
                            sb.append("&Acirc;");
                            break;
                        }
                        case '\u00e5': {
                            sb.append("&aring;");
                            break;
                        }
                        case '\u00c5': {
                            sb.append("&Aring;");
                            break;
                        }
                        case '\u00e6': {
                            sb.append("&aelig;");
                            break;
                        }
                        case '\u00c6': {
                            sb.append("&AElig;");
                            break;
                        }
                        case '\u00e7': {
                            sb.append("&ccedil;");
                            break;
                        }
                        case '\u00c7': {
                            sb.append("&Ccedil;");
                            break;
                        }
                        case '\u00e9': {
                            sb.append("&eacute;");
                            break;
                        }
                        case '\u00c9': {
                            sb.append("&Eacute;");
                            break;
                        }
                        case '\u00e8': {
                            sb.append("&egrave;");
                            break;
                        }
                        case '\u00c8': {
                            sb.append("&Egrave;");
                            break;
                        }
                        case '\u00ea': {
                            sb.append("&ecirc;");
                            break;
                        }
                        case '\u00ca': {
                            sb.append("&Ecirc;");
                            break;
                        }
                        case '\u00eb': {
                            sb.append("&euml;");
                            break;
                        }
                        case '\u00cb': {
                            sb.append("&Euml;");
                            break;
                        }
                        case '\u00ef': {
                            sb.append("&iuml;");
                            break;
                        }
                        case '\u00cf': {
                            sb.append("&Iuml;");
                            break;
                        }
                        case '\u00f4': {
                            sb.append("&ocirc;");
                            break;
                        }
                        case '\u00d4': {
                            sb.append("&Ocirc;");
                            break;
                        }
                        case '\u00f6': {
                            sb.append("&ouml;");
                            break;
                        }
                        case '\u00d6': {
                            sb.append("&Ouml;");
                            break;
                        }
                        case '\u00f8': {
                            sb.append("&oslash;");
                            break;
                        }
                        case '\u00d8': {
                            sb.append("&Oslash;");
                            break;
                        }
                        case '\u00df': {
                            sb.append("&szlig;");
                            break;
                        }
                        case '\u00f9': {
                            sb.append("&ugrave;");
                            break;
                        }
                        case '\u00d9': {
                            sb.append("&Ugrave;");
                            break;
                        }
                        case '\u00fb': {
                            sb.append("&ucirc;");
                            break;
                        }
                        case '\u00db': {
                            sb.append("&Ucirc;");
                            break;
                        }
                        case '\u00fc': {
                            sb.append("&uuml;");
                            break;
                        }
                        case '\u00dc': {
                            sb.append("&Uuml;");
                            break;
                        }
                        case '\u00ae': {
                            sb.append("&reg;");
                            break;
                        }
                        case '\u00a9': {
                            sb.append("&copy;");
                            break;
                        }
                        case '\u00ac': {
                            sb.append("&euro;");
                            break;
                        }
                        case '\u00a0': {
                            sb.append("&nbsp;");
                            break;
                        }
                        case ' ': {
                            if (withBlanks) {
                                if (spaceHandler == 1) {
                                    sb.append("&nbsp;");
                                    break;
                                }
                                if (spaceHandler == 2) {
                                    spaceHandler = 0;
                                    sb.append(c);
                                    break;
                                }
                                sb.append(c);
                                break;
                            }
                            sb.append(c);
                            break;
                        }
                        default: {
                            sb.append(c);
                            spaceHandler = 0;
                            break;
                        }
                    }
                } else {
                    spaceHandler = 0;
                    sb.append(c);
                }
            } else {
                spaceHandler = 0;
            }
            ++i;
        }
        String source = sb.toString();
        String preResult = sb.toString().toLowerCase();
        String result = "";
        int xssIndex = 0;
        int xssLastIndex = 0;
        while ((xssIndex = preResult.indexOf(XSS_TOKEN_JS, xssLastIndex)) >= 0) {
            result = result + source.substring(xssLastIndex, xssIndex);
            xssLastIndex = xssIndex += XSS_TOKEN_JS.length();
        }
        if (xssLastIndex < source.length()) {
            result = result + source.substring(xssLastIndex, preResult.length());
        }
        return result;
    }

    private static StringBuffer replace(String text, StringBuffer buffer, String replacement, int unreplaced, int pos) {
        if (buffer == null) {
            buffer = new StringBuffer(text.length() + 10);
        }
        if (unreplaced > 0) {
            buffer.append(text.substring(pos - unreplaced, pos));
        }
        buffer.append(replacement);
        return buffer;
    }

    private static String encodeForHtmlEscapeAllNoBlanks(String text) {
        if (text == null) {
            return "";
        }
        int length = text.length();
        if (length == 0) {
            return "";
        }
        StringBuffer sb = null;
        String replacement = null;
        int unhandled = 0;
        int i = 0;
        while (i < length) {
            char c = text.charAt(i);
            if (c < '\u00a0') {
                if ('\"' <= c && c <= '&') {
                    switch (c) {
                        case '\"': {
                            replacement = "&quot;";
                            break;
                        }
                        case '&': {
                            replacement = "&amp;";
                            break;
                        }
                        default: {
                            replacement = null;
                            ++unhandled;
                        }
                    }
                    if (replacement != null) {
                        sb = RenderUtil.replace(text, sb, replacement, unhandled, i);
                        unhandled = 0;
                    }
                } else if ('<' <= c && c <= '>') {
                    switch (c) {
                        case '<': {
                            replacement = "&lt;";
                            break;
                        }
                        case '>': {
                            replacement = "&gt;";
                            break;
                        }
                        default: {
                            replacement = null;
                            ++unhandled;
                        }
                    }
                    if (replacement != null) {
                        sb = RenderUtil.replace(text, sb, replacement, unhandled, i);
                        unhandled = 0;
                    }
                } else {
                    ++unhandled;
                }
            } else {
                switch (c) {
                    case '\u00e0': {
                        replacement = "&agrave;";
                        break;
                    }
                    case '\u00c0': {
                        replacement = "&Agrave;";
                        break;
                    }
                    case '\u00e2': {
                        replacement = "&acirc;";
                        break;
                    }
                    case '\u00e4': {
                        replacement = "&auml;";
                        break;
                    }
                    case '\u00c4': {
                        replacement = "&Auml;";
                        break;
                    }
                    case '\u00c2': {
                        replacement = "&Acirc;";
                        break;
                    }
                    case '\u00e5': {
                        replacement = "&aring;";
                        break;
                    }
                    case '\u00c5': {
                        replacement = "&Aring;";
                        break;
                    }
                    case '\u00e6': {
                        replacement = "&aelig;";
                        break;
                    }
                    case '\u00c6': {
                        replacement = "&AElig;";
                        break;
                    }
                    case '\u00e7': {
                        replacement = "&ccedil;";
                        break;
                    }
                    case '\u00c7': {
                        replacement = "&Ccedil;";
                        break;
                    }
                    case '\u00e9': {
                        replacement = "&eacute;";
                        break;
                    }
                    case '\u00c9': {
                        replacement = "&Eacute;";
                        break;
                    }
                    case '\u00e8': {
                        replacement = "&egrave;";
                        break;
                    }
                    case '\u00c8': {
                        replacement = "&Egrave;";
                        break;
                    }
                    case '\u00ea': {
                        replacement = "&ecirc;";
                        break;
                    }
                    case '\u00ca': {
                        replacement = "&Ecirc;";
                        break;
                    }
                    case '\u00eb': {
                        replacement = "&euml;";
                        break;
                    }
                    case '\u00cb': {
                        replacement = "&Euml;";
                        break;
                    }
                    case '\u00ef': {
                        replacement = "&iuml;";
                        break;
                    }
                    case '\u00cf': {
                        replacement = "&Iuml;";
                        break;
                    }
                    case '\u00f4': {
                        replacement = "&ocirc;";
                        break;
                    }
                    case '\u00d4': {
                        replacement = "&Ocirc;";
                        break;
                    }
                    case '\u00f6': {
                        replacement = "&ouml;";
                        break;
                    }
                    case '\u00d6': {
                        replacement = "&Ouml;";
                        break;
                    }
                    case '\u00f8': {
                        replacement = "&oslash;";
                        break;
                    }
                    case '\u00d8': {
                        replacement = "&Oslash;";
                        break;
                    }
                    case '\u00df': {
                        replacement = "&szlig;";
                        break;
                    }
                    case '\u00f9': {
                        replacement = "&ugrave;";
                        break;
                    }
                    case '\u00d9': {
                        replacement = "&Ugrave;";
                        break;
                    }
                    case '\u00fb': {
                        replacement = "&ucirc;";
                        break;
                    }
                    case '\u00db': {
                        replacement = "&Ucirc;";
                        break;
                    }
                    case '\u00fc': {
                        replacement = "&uuml;";
                        break;
                    }
                    case '\u00dc': {
                        replacement = "&Uuml;";
                        break;
                    }
                    case '\u00ae': {
                        replacement = "&reg;";
                        break;
                    }
                    case '\u00a9': {
                        replacement = "&copy;";
                        break;
                    }
                    case '\u00ac': {
                        replacement = "&euro;";
                        break;
                    }
                    case '\u00a0': {
                        replacement = "&nbsp;";
                        break;
                    }
                    default: {
                        replacement = null;
                        ++unhandled;
                    }
                }
                if (replacement != null) {
                    sb = RenderUtil.replace(text, sb, replacement, unhandled, i);
                    unhandled = 0;
                }
            }
            ++i;
        }
        if (sb != null) {
            if (unhandled > 0) {
                sb = RenderUtil.replace(text, sb, "", unhandled, length);
            }
            return sb.toString();
        }
        return text;
    }

    public static void renderJavascriptInterface(IPageContext pageContext, Component component, String generatedId, String params) {
        pageContext.write("var ");
        pageContext.write(generatedId);
        pageContext.write("= new _htmlb");
        pageContext.write(component.getUI());
        pageContext.write("(\"");
        pageContext.write(pageContext.getCurrentFormId());
        pageContext.write("\",\"");
        pageContext.write(generatedId);
        pageContext.write("\"");
        if (params != null && !params.equals("")) {
            pageContext.write(",");
            pageContext.write(params);
        }
        pageContext.write(");");
    }

    public static void renderJavascriptInterface(IPageContext pageContext, Component component, String generatedId) {
        RenderUtil.renderJavascriptInterface(pageContext, component, generatedId, null);
    }

    public static void renderJavascriptInterface(IPageContext pageContext, Component component, String generatedId, boolean bool) {
        RenderUtil.renderJavascriptInterface(pageContext, component, generatedId, bool ? "true" : "false");
    }

    public static String encodeForJS(String text) {
        if (text == null) {
            return "";
        }
        int length = text.length();
        if (length == 0) {
            return "";
        }
        StringBuffer sb = null;
        String replacement = null;
        int unhandled = 0;
        int i = 0;
        while (i < length) {
            char c = text.charAt(i);
            if (c < '\u00a0') {
                if ('\"' <= c && c <= '\'') {
                    switch (c) {
                        case '\"': {
                            replacement = "&quot;";
                            break;
                        }
                        case '\'': {
                            replacement = "\\'";
                            break;
                        }
                        default: {
                            replacement = null;
                            ++unhandled;
                        }
                    }
                    if (replacement != null) {
                        sb = RenderUtil.replace(text, sb, replacement, unhandled, i);
                        unhandled = 0;
                    }
                } else if ('<' <= c && c <= '>') {
                    switch (c) {
                        case '\n': {
                            replacement = "\\n";
                            break;
                        }
                        case '\t': {
                            replacement = "\\t";
                            break;
                        }
                        case '\r': {
                            replacement = "\\r";
                            break;
                        }
                        case '\f': {
                            replacement = "\\f";
                            break;
                        }
                        case '\b': {
                            replacement = "\\b";
                            break;
                        }
                        default: {
                            replacement = null;
                            ++unhandled;
                        }
                    }
                    if (replacement != null) {
                        sb = RenderUtil.replace(text, sb, replacement, unhandled, i);
                        unhandled = 0;
                    }
                } else if (c == '\\') {
                    sb = RenderUtil.replace(text, sb, "\\\\", unhandled, i);
                    unhandled = 0;
                } else {
                    ++unhandled;
                }
            } else {
                ++unhandled;
            }
            ++i;
        }
        if (sb != null) {
            if (unhandled > 0) {
                sb = RenderUtil.replace(text, sb, "", unhandled, length);
            }
            return sb.toString();
        }
        return text;
    }

    public static String encodeForTagParam(String text) {
        if (text == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(text.length() + 50);
        char c = ' ';
        int length = text.length();
        int i = 0;
        while (i < length) {
            c = text.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }
}

