/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering;

import com.sap.mobile.clientinfo.ClientInfo;
import com.sap.mobile.clientinfo.ClientInfoFactory;
import com.sap.tc.logging.Location;
import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.Container;
import com.sapportals.htmlb.Document;
import com.sapportals.htmlb.Form;
import com.sapportals.htmlb.IUserDataComponent;
import com.sapportals.htmlb.Includes;
import com.sapportals.htmlb.VersionInfo;
import com.sapportals.htmlb.enum.BrowserType;
import com.sapportals.htmlb.enum.ResourceType;
import com.sapportals.htmlb.enum.TrayDesign;
import com.sapportals.htmlb.event.Event;
import com.sapportals.htmlb.event.EventManager;
import com.sapportals.htmlb.hovermenu.HoverMenu;
import com.sapportals.htmlb.mmparser.AbstractPart;
import com.sapportals.htmlb.mmparser.FilePart;
import com.sapportals.htmlb.mmparser.MimeMultipartParser;
import com.sapportals.htmlb.mmparser.ParamPart;
import com.sapportals.htmlb.rendering.FileParam;
import com.sapportals.htmlb.rendering.HtmlbRenderer;
import com.sapportals.htmlb.rendering.IFileParam;
import com.sapportals.htmlb.rendering.IFormRenderer;
import com.sapportals.htmlb.rendering.IJavascriptRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.MobileEventInterceptor;
import com.sapportals.htmlb.rendering.MobileWmlCard;
import com.sapportals.htmlb.rendering.RenderUtil;
import com.sapportals.htmlb.rendering.RendererManager;
import com.sapportals.htmlb.type.AbstractDataType;
import com.sapportals.htmlb.type.DataBoolean;
import com.sapportals.htmlb.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Stack;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class PageContext
implements IPageContext {
    String mimePath;
    String stylePath;
    String javascriptPath;
    String actionUrl;
    HttpServletRequest httpServletRequest;
    HttpServletResponse httpServletResponse;
    PrintWriter out;
    BrowserType browserId;
    Event currentEvent;
    String documentId;
    protected Document document;
    boolean isMultiPartMime;
    boolean requires508Rendering;
    protected Hashtable parametersMultiPart;
    protected MobileWmlCard hiddenCard;
    Form currentForm;
    Form oldSubmittedForm;
    boolean relaxDomain = true;
    private static final String UTF8_PROPERTY = "htmlb.useUTF8";
    private boolean cvUseUTF8Encoding;
    private boolean messageBarAtBodyEnd = false;
    private ClientInfo clientInfo;
    private ClassLoader classLoader;
    private Locale locale;
    protected HashMap newParamList = null;
    protected HashMap oldParamList = null;
    private boolean useSession = false;
    private boolean invalidSession = false;
    private boolean testMode = System.getProperty("htmlb.testMode") != null;
    private Object parent = null;
    private HashMap components = new HashMap();
    private Component[] comps = null;
    private TrayDesign trayDesign = null;
    private boolean debug = false;
    transient HashSet styleSheets = new HashSet();
    private boolean rtl = false;
    private boolean advancedAlignment = false;
    private HashSet perfCounter = null;
    MobileEventInterceptor eventInterceptor = null;
    Stack myStack = new Stack();
    private HashMap rendererMap = new HashMap(20);
    static /* synthetic */ Class class$com$sapportals$htmlb$AbstractCompositeComponent;

    public PageContext(Object request, Object response) {
        this.init(request, response);
    }

    protected void init(Object request, Object response) {
        String sid;
        Locale tmpLocale;
        TrayDesign trayDesign;
        String relaxDomain;
        String stylePath;
        String actionUrl;
        String mimePath;
        String jsPath;
        this.httpServletRequest = (HttpServletRequest)request;
        try {
            ClientInfoFactory factory = ClientInfoFactory.newInstance();
            this.clientInfo = factory.newClientInfo();
            this.clientInfo.load((Object)this.httpServletRequest);
        }
        catch (Exception e) {
            this.clientInfo = null;
            Log.getLogLocation(false).debugT("PageContext", "Could not initialize Clientinfo");
        }
        this.cvUseUTF8Encoding = true;
        this.detectUserAgent(this.httpServletRequest);
        this.setResponse(response);
        String contentType = this.httpServletRequest.getContentType();
        this.isMultiPartMime = contentType != null && contentType.startsWith("multipart/form-data");
        this.rtl = this.queryRTL();
        this.setMimePath(RendererManager.getDefaultMimePath());
        this.setStylePath(RendererManager.getDefaultStylePath());
        this.setJavascriptPath(RendererManager.getDefaultJavascriptPath());
        DataBoolean db = new DataBoolean(System.getProperty("htmlb.section508"));
        this.setSection508Rendering(db.getValue());
        String sec508 = (String)this.httpServletRequest.getAttribute("htmlb.section508");
        if (sec508 != null && sec508.length() > 0) {
            db = new DataBoolean(sec508);
            this.setSection508Rendering(db.getValue());
        }
        if ((jsPath = (String)this.httpServletRequest.getAttribute("htmlb.jsPath")) != null && jsPath.length() > 0) {
            this.setJavascriptPath(jsPath);
        }
        if ((mimePath = (String)this.httpServletRequest.getAttribute("htmlb.mimePath")) != null && mimePath.length() > 0) {
            this.setMimePath(mimePath);
        }
        if ((actionUrl = (String)this.httpServletRequest.getAttribute("htmlb.actionUrl")) != null && actionUrl.length() > 0) {
            this.setActionUrl(actionUrl);
        }
        if ((stylePath = (String)this.httpServletRequest.getAttribute("htmlb.stylePath")) != null && stylePath.length() > 0) {
            this.setStylePath(stylePath);
        }
        if ((relaxDomain = (String)this.httpServletRequest.getAttribute("htmlb.relaxDomain")) != null && relaxDomain.length() > 0) {
            this.setDomainRelaxation(true);
        }
        if ((trayDesign = (TrayDesign)this.httpServletRequest.getAttribute("htmlb.traydesign")) != null) {
            this.setTrayDesign(trayDesign);
        }
        if ((tmpLocale = (Locale)this.httpServletRequest.getAttribute("htmlb.locale")) != null) {
            this.setLocale(tmpLocale);
        }
        if ((sid = this.getParameter("htmlb_sid")) != null && sid.length() > 0) {
            this.readOldParamList(sid);
            if (this.oldParamList == null || this.oldParamList.size() == 0) {
                this.invalidSession = true;
            }
        }
        this.debug = System.getProperty("htmlb.debug") != null;
    }

    public Component getComponentForId(String elementId) {
        Component comp = null;
        comp = (Component)this.components.get(elementId);
        if (comp == null) {
            if (this.oldSubmittedForm == null) {
                this.checkFormElements();
            }
            if (this.oldSubmittedForm != null) {
                String paramName = this.oldSubmittedForm.getFullIdForComponent(elementId);
                if (this.testMode) {
                    paramName = this.magleID(paramName);
                }
                if (paramName != null) {
                    String shortId = this.oldSubmittedForm.getClassIdForComponent(elementId);
                    comp = Component.initializeFromId(elementId, shortId, this, paramName);
                    this.components.put(elementId, comp);
                }
            }
        }
        return comp;
    }

    public Component getTableComponentForId(String tableId, String elementId, int row) {
        String paramName;
        if (this.oldSubmittedForm == null) {
            this.checkFormElements();
        }
        if (this.oldSubmittedForm != null && (paramName = this.oldSubmittedForm.getFullIdForComponent(tableId, elementId, row)) != null) {
            String shortId = this.oldSubmittedForm.getClassIdForComponent(tableId, elementId);
            Component c = Component.initializeFromId(elementId, shortId, this, paramName);
            return c;
        }
        return null;
    }

    public String getParameterForId(String elementId) {
        String[] values = this.getParameterValuesForId(elementId);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public String[] getParameterValuesForId(String elementId) {
        String paramName;
        String[] result = null;
        if (this.oldSubmittedForm == null) {
            this.checkFormElements();
        }
        if (this.oldSubmittedForm != null && (paramName = this.oldSubmittedForm.getFullIdForComponent(elementId)) != null) {
            result = this.getParameterValues(paramName);
        }
        return result;
    }

    public AbstractDataType getDataForComponentId(String elementId) {
        Component c = this.getComponentForId(elementId);
        if (c != null && c instanceof IUserDataComponent) {
            return ((IUserDataComponent)((Object)c)).getValueAsDataType();
        }
        return null;
    }

    public AbstractDataType getDataForComponentId(String tableId, String elementId, int row) {
        Component c = this.getTableComponentForId(tableId, elementId, row);
        if (c != null && c instanceof IUserDataComponent) {
            return ((IUserDataComponent)((Object)c)).getValueAsDataType();
        }
        return null;
    }

    public void cleanUp() {
        Enumeration enumParams = this.getParameterNames();
        while (enumParams.hasMoreElements()) {
            IFileParam fp;
            File file;
            String key = (String)enumParams.nextElement();
            if (!this.isFileParam(key) || (file = (fp = this.getFileParam(key)).getFile()) == null) continue;
            file.delete();
        }
    }

    protected void checkForCurrentEvent() {
        String eventType = this.getParameter("htmlbevt_ty");
        if (eventType != null) {
            Form oldForm = this.getOldForm();
            String componentName = this.getParameter("htmlbevt_oid");
            String eventId = this.getParameter("htmlbevt_id");
            int paramCount = 0;
            try {
                paramCount = Integer.parseInt(this.getParameter("htmlbevt_cnt"));
            }
            catch (NumberFormatException e) {
                Log.getLogLocation(false).debugT("PageContext", "checkForCurrentEvent");
            }
            String[] params = null;
            if (paramCount > 9) {
                paramCount = 9;
            }
            if (paramCount != 0) {
                params = new String[paramCount];
                int i = 0;
                while (i < paramCount) {
                    params[i] = this.getParameter("htmlbevt_par" + Integer.toString(i + 1));
                    ++i;
                }
            }
            try {
                this.setCurrentEvent(EventManager.createEvent(this, eventType, eventId, componentName, params));
            }
            catch (Exception e) {
                Log.getLogLocation(false).debugT("PageContext", "setCurrentEvent failed");
            }
        }
    }

    protected void checkFormElements() {
        String formId = this.getParameter("htmlbevt_frm");
        if (formId != null) {
            this.oldSubmittedForm = new Form(formId);
            HtmlbRenderer renderer = RendererManager.getRenderer(this.oldSubmittedForm.getUI(), this.browserId);
            if (renderer instanceof IFormRenderer) {
                String encodedData = ((IFormRenderer)((Object)renderer)).getEncodedElements(this);
                this.oldSubmittedForm.decodeFormElements(encodedData);
            }
        }
    }

    protected void detectUserAgent(HttpServletRequest httpServletRequest) {
        String accept;
        String userAgent = httpServletRequest.getHeader("User-Agent");
        if (userAgent != null) {
            String userAgentUP = (userAgent = userAgent.toUpperCase()).toUpperCase();
            int msie_start_pos = userAgentUP.indexOf("MSIE");
            if (msie_start_pos >= 0 && userAgent.indexOf("OPERA") < 0) {
                String msie_part;
                int msie_end_pos = userAgentUP.indexOf(";", msie_start_pos);
                String string = msie_part = msie_end_pos >= 0 ? userAgentUP.substring(msie_start_pos, msie_end_pos) : userAgentUP.substring(msie_start_pos);
                if (msie_part.indexOf("5.01") >= 0) {
                    this.setBrowserId(BrowserType.MSIE5);
                } else if (msie_part.indexOf("5.0") >= 0) {
                    this.setBrowserId(BrowserType.MSIE5);
                } else if (msie_part.indexOf("5.5") >= 0) {
                    this.setBrowserId(BrowserType.MSIE55);
                } else if (msie_part.indexOf("6.0") >= 0) {
                    this.setBrowserId(BrowserType.MSIE6);
                } else if (userAgentUP.indexOf("; WINDOWS CE") >= 0) {
                    this.setBrowserId(BrowserType.MOBILE_HTML);
                } else {
                    this.setBrowserId(BrowserType.MSIE4);
                }
            } else if (userAgent.indexOf("OPERA") >= 0) {
                this.setBrowserId(BrowserType.NETSCAPE_6);
            } else if (userAgent.indexOf("NETSCAPE/7") >= 0) {
                if (userAgent.indexOf("MACINTOSH") >= 0) {
                    this.setBrowserId(BrowserType.NETSCAPE_7);
                } else {
                    this.setBrowserId(BrowserType.NETSCAPE_7);
                }
            } else if (userAgent.indexOf("MOZILLA/5.0") >= 0) {
                if (userAgent.indexOf("MACINTOSH") >= 0) {
                    this.setBrowserId(BrowserType.NETSCAPE_6);
                } else {
                    this.setBrowserId(BrowserType.NETSCAPE_6);
                }
            } else if (userAgent.indexOf("PALM") >= 0) {
                this.setBrowserId(BrowserType.MOBILE_HTML);
            } else if (userAgent.indexOf("EPOC32-WTL/") >= 0) {
                this.setBrowserId(BrowserType.MOBILE_HTML);
            } else if (userAgent.indexOf("MOZILLA/4.7") >= 0) {
                if (userAgent.indexOf("MACINTOSH") >= 0) {
                    this.setBrowserId(BrowserType.NETSCAPE_4);
                } else {
                    this.setBrowserId(BrowserType.NETSCAPE_4);
                }
            } else {
                this.setBrowserId(BrowserType.NETSCAPE_6);
            }
        } else {
            this.setBrowserId(BrowserType.NETSCAPE_6);
        }
        if (this.getBrowserId().equals(BrowserType.NETSCAPE_6) && (accept = httpServletRequest.getHeader("Accept")) != null) {
            if ((accept = accept.toUpperCase()).indexOf("WML") >= 0) {
                this.setBrowserId(BrowserType.MOBILE_WML);
                boolean noCacheSupported = this.clientInfo != null && this.clientInfo.getContentTypeVersion().indexOf("1.3") != -1;
                this.hiddenCard = new MobileWmlCard("hiddenCard", noCacheSupported);
            } else if (accept.indexOf("VXML") >= 0) {
                this.setBrowserId(BrowserType.MOBILE_VOICE);
            }
        }
    }

    public void setCurrentEvent(Event currentEvent) {
        this.currentEvent = currentEvent;
    }

    public Event getCurrentEvent() {
        if (this.currentEvent == null) {
            this.checkForCurrentEvent();
        }
        return this.currentEvent;
    }

    protected boolean isMultiPartMime() {
        return this.isMultiPartMime;
    }

    protected void setMultiPartMime(boolean multiPartMime) {
        this.isMultiPartMime = multiPartMime;
    }

    protected Hashtable getParametersMultiPart() {
        return this.parametersMultiPart;
    }

    public Enumeration getParameterNames() {
        if (this.isMultiPartMime) {
            this.initMultiPartMime();
            return this.parametersMultiPart.keys();
        }
        return this.httpServletRequest.getParameterNames();
    }

    public String getParameter(String name) {
        String value = null;
        if (this.invalidSession) {
            return null;
        }
        if (this.getBrowserId().equals(BrowserType.MOBILE_HTML)) {
            if (this.eventInterceptor == null) {
                this.eventInterceptor = new MobileEventInterceptor(this.getHttpServletRequest());
            }
            if (this.eventInterceptor != null) {
                return this.eventInterceptor.getParameter(name);
            }
            return null;
        }
        if (this.isMultiPartMime) {
            this.initMultiPartMime();
            Object param = this.parametersMultiPart.get(name);
            value = param instanceof String[] ? ((String[])param)[0] : null;
        } else {
            String s;
            value = s = this.httpServletRequest.getParameter(name);
        }
        if (value == null && this.oldParamList != null) {
            value = (String)this.oldParamList.get(name);
        }
        return this.attemptUTF8Encoding(value);
    }

    public String[] getParameterValues(String name) {
        String[] values = null;
        if (this.isMultiPartMime) {
            this.initMultiPartMime();
            Object param = this.parametersMultiPart.get(name);
            values = param instanceof String[] ? (String[])param : null;
        } else {
            values = this.httpServletRequest.getParameterValues(name);
        }
        if (values != null) {
            int i = 0;
            while (i < values.length) {
                values[i] = this.attemptUTF8Encoding(values[i]);
                ++i;
            }
        }
        return values;
    }

    public boolean isFileParam(String name) {
        if (this.isMultiPartMime) {
            this.initMultiPartMime();
            Object param = this.parametersMultiPart.get(name);
            return param instanceof IFileParam;
        }
        return false;
    }

    public IFileParam getFileParam(String name) {
        if (this.isMultiPartMime) {
            this.initMultiPartMime();
            Object param = this.parametersMultiPart.get(name);
            return param instanceof IFileParam ? (IFileParam)param : null;
        }
        return null;
    }

    protected void initMultiPartMime() {
        long start = 0L;
        if (this.debug) {
            start = System.currentTimeMillis();
        }
        if (this.parametersMultiPart == null) {
            try {
                this.parametersMultiPart = new Hashtable();
                MimeMultipartParser parameterParser = new MimeMultipartParser(this.httpServletRequest);
                AbstractPart part = parameterParser.nextPart();
                ParamPart paramPart = null;
                FilePart filePart = null;
                String partName = null;
                while (part != null) {
                    partName = part.getName();
                    if (partName != null && partName.length() > 0) {
                        if (part instanceof ParamPart) {
                            paramPart = (ParamPart)part;
                            Object param = this.parametersMultiPart.get(partName);
                            if (param == null) {
                                String[] a = new String[]{paramPart.getStringValue()};
                                this.parametersMultiPart.put(partName, a);
                            } else if (param instanceof String[]) {
                                String[] old = (String[])param;
                                String[] a = new String[old.length + 1];
                                System.arraycopy(old, 0, a, 0, old.length);
                                a[old.length] = paramPart.getStringValue();
                                this.parametersMultiPart.put(partName, a);
                            }
                        } else if (part instanceof FilePart) {
                            filePart = (FilePart)part;
                            String fileName = filePart.getFileName();
                            fileName = this.attemptUTF8Encoding(fileName);
                            InputStream in = filePart.getInputStream();
                            File file = null;
                            if (fileName != null && in != null) {
                                StringBuffer tmpName = new StringBuffer("_htmlb");
                                tmpName.append(System.currentTimeMillis());
                                try {
                                    file = File.createTempFile(tmpName.toString(), null);
                                }
                                catch (IOException e) {
                                    String tmp = System.getProperty("java.io.tmpdir").trim();
                                    if (!tmp.substring(tmp.length() - 1).equals(File.separator)) {
                                        tmp = tmp + File.separator;
                                    }
                                    tmp = tmp + tmpName.toString() + ".tmp";
                                    file = new File(tmp);
                                    try {
                                        file.createNewFile();
                                    }
                                    catch (IOException x) {
                                        Log.getLogLocation(false).debugT("PageContext", "New temp file>" + tmp + "<");
                                        Log.getLogLocation(false).debugT("PageContext", "Temp file creation failed!\nPlease set <java.io.tmpdir> to an existing directory.");
                                    }
                                }
                                FileOutputStream out = new FileOutputStream(file);
                                byte[] buffer = new byte[2048];
                                int read = 0;
                                while ((read = in.read(buffer)) != -1) {
                                    out.write(buffer, 0, read);
                                }
                                out.close();
                                String longFileName = filePart.getHeader().getHeaderField("content-disposition");
                                if (longFileName != null) {
                                    int pos2 = longFileName.lastIndexOf(";");
                                    if (pos2 > -1) {
                                        int pos1 = longFileName.indexOf("filename=\"", pos2 - 1);
                                        if (pos1 > -1) {
                                            longFileName = longFileName.substring(pos1 + 10, longFileName.length() - 1);
                                            longFileName = this.attemptUTF8Encoding(longFileName);
                                        } else {
                                            longFileName = fileName;
                                        }
                                    } else {
                                        longFileName = fileName;
                                    }
                                } else {
                                    longFileName = fileName;
                                }
                                FileParam fp = new FileParam(fileName, file, filePart.getHeader().getHeaderField("content-type"), longFileName);
                                this.parametersMultiPart.put(partName, fp);
                            }
                        }
                    } else {
                        System.err.println("omitting empty formfields!" + part.toString());
                    }
                    part = parameterParser.nextPart();
                }
            }
            catch (IOException e) {
                Log.getLogLocation(false).debugT("PageContext", "Mulitpart parsing was aborted. Resetting buffer.");
                this.parametersMultiPart = new Hashtable();
            }
        }
        if (this.debug) {
            start = System.currentTimeMillis() - start;
            this.addPerfCounter("Multipart parsing: " + start + "ms");
        }
    }

    public boolean isSingleValueParameter(String name) {
        String[] params = this.getParameterValues(name);
        return params != null && params.length == 1;
    }

    public String getActionUrl() {
        return this.actionUrl;
    }

    public void setActionUrl(String actionUrl) {
        this.actionUrl = actionUrl;
    }

    public String getMimePath() {
        return this.mimePath;
    }

    public void setMimePath(String mimePath) {
        int i;
        this.mimePath = mimePath;
        if (this.getIsRTL() && (i = this.mimePath.indexOf("/r/common")) < 0) {
            i = this.mimePath.indexOf("/common");
            this.mimePath = this.mimePath.substring(0, i) + "/r" + this.mimePath.substring(i);
        }
    }

    public void setStylePath(String stylePath) {
        int i;
        this.stylePath = stylePath;
        if (this.getIsRTL() && (i = this.stylePath.indexOf("/r/ur")) < 0) {
            i = this.stylePath.indexOf("/ur");
            this.stylePath = this.stylePath.substring(0, i) + "/r" + this.stylePath.substring(i);
        }
    }

    public String getStylePath() {
        return this.stylePath;
    }

    public String getJavascriptPath() {
        return this.javascriptPath;
    }

    public void setJavascriptPath(String javascriptPath) {
        this.javascriptPath = javascriptPath;
    }

    public String getSpaceGif() {
        return this.getMimePath() + "1x1.gif";
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.httpServletRequest;
    }

    protected void setHttpServletRequest(HttpServletRequest httpServletRequest) {
        this.httpServletRequest = httpServletRequest;
    }

    public Object getRequest() {
        return this.httpServletRequest;
    }

    public void setRequest(Object request) {
        this.httpServletRequest = (HttpServletRequest)request;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.httpServletResponse;
    }

    protected void setHttpServletResponse(HttpServletResponse httpServletResponse) {
        this.httpServletResponse = httpServletResponse;
    }

    public Object getResponse() {
        return this.httpServletResponse;
    }

    public void setResponse(Object response) {
        this.httpServletResponse = (HttpServletResponse)response;
        try {
            if (this.httpServletResponse != null) {
                if (this.cvUseUTF8Encoding) {
                    this.httpServletResponse.setContentType("text/html; charset=utf-8");
                } else {
                    this.httpServletResponse.setContentType("text/html");
                }
                if (this.getBrowserId().equals(BrowserType.MOBILE_WML)) {
                    this.httpServletResponse.setContentType("text/vnd.wap.wml");
                } else if (this.getBrowserId().equals(BrowserType.MOBILE_VOICE)) {
                    this.httpServletResponse.setContentType("text/x-vxml");
                }
                this.setWriter(new BufferedWriter(this.httpServletResponse.getWriter()));
            }
        }
        catch (IOException e) {
            Log.getLogLocation(false).debugT("PageContext", e.getMessage());
        }
    }

    public BrowserType getBrowserId() {
        return this.browserId;
    }

    public void setBrowserId(BrowserType browserId) {
        this.browserId = browserId;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            this.setLocale(this.httpServletRequest.getLocale());
        }
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.rtl = this.queryRTL();
    }

    public Enumeration getLocales() {
        return this.httpServletRequest.getLocales();
    }

    public Writer getWriter() {
        return this.out;
    }

    public void setWriter(Writer writer) {
        this.out = writer instanceof PrintWriter ? (PrintWriter)writer : new UnbufferedWriter(writer);
    }

    public void write(String text) {
        if (text != null) {
            this.out.write(text);
        }
    }

    public void writeEncoded(String text) {
        String s = null;
        if (text != null) {
            s = RenderUtil.encodeForHtml(text, true);
        }
        if (s != null) {
            this.out.write(s);
        }
    }

    public void writeHeadBegin(String text) {
        if (text != null && this.out instanceof BufferedWriter) {
            ((BufferedWriter)this.out).writeHeadBegin(text);
        } else if (text != null && this.out instanceof UnbufferedWriter) {
            this.out.write(text);
        }
    }

    public void writeHeadIncludes(String text) {
        if (text != null && this.out instanceof BufferedWriter) {
            ((BufferedWriter)this.out).writeHeadIncludes(text);
        } else if (text != null && this.out instanceof UnbufferedWriter) {
            this.out.write(text);
        }
    }

    public void write(int i) {
        this.out.write(Integer.toString(i));
    }

    public void push(Container container) {
        this.myStack.push(this.out);
        this.myStack.push(container);
        StringWriter sw = new StringWriter();
        this.myStack.push(sw.getBuffer());
        this.out = new UnbufferedWriter(sw);
    }

    public void pop() {
        StringBuffer sb = (StringBuffer)this.myStack.pop();
        Container c = (Container)this.myStack.pop();
        c.addRawText(sb.toString());
        this.out = (PrintWriter)this.myStack.pop();
    }

    private HtmlbRenderer getRenderer(String uiId) {
        HtmlbRenderer result = (HtmlbRenderer)this.rendererMap.get(uiId);
        if (result == null) {
            result = RendererManager.getRenderer(uiId, this.browserId);
            this.rendererMap.put(uiId, result);
        }
        return result;
    }

    public void render() {
        if (this.document != null) {
            HttpServletRequest rq;
            HttpSession session;
            Object request;
            if (this.isUsingSession() && (request = this.getRequest()) instanceof HttpServletRequest && (session = (rq = (HttpServletRequest)request).getSession(true)) == null) {
                this.setUsingSession(false);
            }
            long start = 0L;
            StringBuffer dbg = null;
            if (this.debug) {
                dbg = new StringBuffer();
                start = System.currentTimeMillis();
            }
            this.document.preRender(this);
            if (this.debug) {
                start = System.currentTimeMillis() - start;
                Iterator iter = this.perfCounter.iterator();
                while (iter.hasNext()) {
                    dbg.append((String)iter.next());
                }
                dbg.append("HTMLB: PreRendering took ");
                dbg.append(start);
                dbg.append("ms");
                start = System.currentTimeMillis();
            }
            this.render(this.document);
            if (this.debug) {
                start = System.currentTimeMillis() - start;
                dbg.append("\nHTMLB: Rendering took ");
                dbg.append(start);
                dbg.append("ms\n-->\n");
                if (this.getResponse() instanceof HttpServletResponse) {
                    HttpServletResponse r = (HttpServletResponse)this.getResponse();
                    try {
                        r.getWriter().write(dbg.toString());
                    }
                    catch (IOException t) {
                        Log.getLogLocation(false).debugT("PageContext", "Writing response failed");
                    }
                }
            }
        }
    }

    public void render(Component component) {
        HtmlbRenderer renderer = this.getRenderer(component.getUI());
        if (renderer != null) {
            renderer.render(component, this);
        }
    }

    public void render(Component component, int selector) {
        HtmlbRenderer renderer = this.getRenderer(component.getUI());
        if (renderer != null) {
            renderer.render(component, selector, this);
        }
    }

    public void renderJavascriptInterface(Component component, String generatedId) {
        HtmlbRenderer renderer = RendererManager.getRenderer(component.getUI(), this.browserId);
        if (renderer != null) {
            IJavascriptRenderer jsrenderer = (IJavascriptRenderer)((Object)renderer);
            jsrenderer.renderJavascriptInterface(this, component, generatedId);
        }
    }

    public String getJavascriptUrl() {
        return this.getJavascriptPath() + RendererManager.getJavascriptFileName(this.browserId);
    }

    public String getStylesheetUrl() {
        String fileName = RendererManager.getCssFileName(this.browserId);
        return this.getStylePath() + fileName;
    }

    public Document createDocument(String title) {
        this.document = new Document(title);
        Includes documentIncludes = new Includes();
        documentIncludes.addHeadResource(ResourceType.JAVASCRIPT, "DEFAULT_JS", this.getJavascriptUrl());
        if (!this.getUrMapiJavascriptUrl().equals(this.getJavascriptPath())) {
            documentIncludes.addHeadResource(ResourceType.JAVASCRIPT, "SAP_UR_MAPI_JS", this.getUrMapiJavascriptUrl());
        }
        if (!this.getUrPopupJavascriptUrl().equals(this.getJavascriptPath())) {
            documentIncludes.addHeadResource(ResourceType.JAVASCRIPT, "SAP_UR_POPUP_JS", this.getUrPopupJavascriptUrl());
        }
        if (this.requiresSection508Rendering()) {
            String myUrl = this.getJavascriptPath() + "htmlb_texts_" + this.getLocale().getLanguage() + ".js";
            documentIncludes.addHeadResource(ResourceType.JAVASCRIPT, "HTMLB508TEXTS_JS", myUrl);
        }
        this.document.setIncludes(documentIncludes);
        return this.document;
    }

    public Form createFormDocument(String title) {
        Document myDocument = this.createDocument(title);
        Form myForm = this.createForm();
        return myForm;
    }

    public Form createForm() {
        if (this.document == null) {
            throw new IllegalStateException("Cannot create form without document. Use createDocument first.");
        }
        Form myForm = new Form();
        this.setFormDefaults(myForm);
        this.document.addComponent(myForm);
        myForm.setFormId(this.document.getNewElementId());
        return myForm;
    }

    public void setFormDefaults(Form form) {
    }

    public boolean requiresSection508Rendering() {
        return this.requires508Rendering;
    }

    public void setSection508Rendering(boolean requires508) {
        this.requires508Rendering = requires508;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getParamIdForComponent(Component c) {
        String componentId;
        if (this.document == null) {
            throw new IllegalStateException("No document available. Create a document first.");
        }
        Form myForm = this.getCurrentForm();
        String result = null;
        if (c.requiresForm()) {
            if (myForm == null) throw new IllegalStateException("Component " + c.getId() + " of " + c.getClass() + " cannot be used without a surrounding form.");
            result = this.document.getDocumentId() + "_" + myForm.getFullIdForComponent(c);
            if (this.testMode) {
                result = result + "x" + this.magleID(c.getId());
            }
        } else {
            result = this.document.getElementId(c);
            if (this.testMode) {
                result = result + "x" + this.magleID(c.getId());
            }
        }
        if ((componentId = c.getId()) == null || myForm == null || !c.isJsObjectNeeded()) return result;
        myForm.addFullIdFormElement(componentId, result);
        return result;
    }

    private String magleID(String s) {
        if (s == null) {
            return null;
        }
        int l = s.length();
        if (l == 0) {
            return "";
        }
        char c = '\u0000';
        StringBuffer b = new StringBuffer(l);
        int i = 0;
        while (i < l) {
            c = s.charAt(i);
            if (c >= '0' && c <= '9') {
                b.append(c);
            } else if (c >= '@' && c <= 'Z') {
                b.append(c);
            } else if (c >= 'a' && c <= 'z') {
                b.append(c);
            } else if (c >= '~') {
                b.append(c);
            } else {
                b.append('_');
            }
            ++i;
        }
        return b.toString();
    }

    public String getParamIdForComponent(String componentId) {
        Form myForm = this.getOldForm();
        String result = null;
        if (myForm == null) {
            throw new IllegalStateException("Component " + componentId + " not found in old form.");
        }
        result = myForm.getFullIdForComponent(componentId);
        if (this.testMode) {
            result = this.magleID(result);
        }
        return result;
    }

    public void startDocument() {
        if (this.getWriter() instanceof UnbufferedWriter) {
            this.getDocument().getIncludes().addHeadResource(ResourceType.CSS, "DEFAULT_CSS", this.getStylesheetUrl());
        }
        this.writeHeadBegin("<!-- ");
        this.writeHeadBegin(VersionInfo.getVersion());
        this.writeHeadBegin(" -->\n");
        this.render(this.document, 12);
        this.writeHeadBegin("<html");
        if (this.getIsRTL()) {
            this.writeHeadBegin(" dir=\"rtl\"");
        }
        this.writeHeadBegin(">");
        if (this.getDomainRelaxation()) {
            this.writeHeadBegin("<SCRIPT> var x = location.hostname.indexOf('.')+1;if (x>0) document.domain = location.hostname.substring(x);</script>");
        }
    }

    public void startDocumentHead(String title) {
        this.writeHeadBegin("<head><title>");
        this.writeHeadBegin(title);
        this.writeHeadBegin("</title>");
    }

    public void writeHeadIncludes() {
        this.writeHeadBegin("<SCRIPT language=\"JavaScript\">ur_system = {doc : window.document , mimepath :\"");
        this.writeHeadBegin(this.getMimePath());
        this.writeHeadBegin("\", stylepath : \"");
        this.writeHeadBegin(this.getStylePath());
        this.writeHeadBegin("\", emptyhoverurl : \"");
        this.writeHeadBegin(this.getJavascriptPath());
        this.writeHeadBegin("emptyhover.html");
        if (this.getIsRTL()) {
            this.writeHeadBegin("\", direction : \"rtl");
        }
        this.writeHeadBegin("\", is508 : " + this.getIs508() + ",domainrelaxing : \"MINIMAL\"};");
        this.writeHeadBegin("ur_language=\"" + this.getLocale().toString() + "\";");
        this.writeHeadBegin("</SCRIPT>");
        this.writeHeadBegin("<SCRIPT language=\"JavaScript\">var popup_emptydoc = \"");
        this.writeHeadBegin(this.getJavascriptPath());
        this.writeHeadBegin("emptyhover.html\";");
        this.writeHeadBegin("</SCRIPT>");
        if (this.cvUseUTF8Encoding) {
            this.writeHeadBegin("<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=utf-8\">");
        }
        this.document.render(2, this);
    }

    public void endDocumentHead() {
        this.write("</head>");
    }

    public void setMessageBarAtBodyEnd(boolean messageBarAtBodyEnd) {
        this.messageBarAtBodyEnd = messageBarAtBodyEnd;
    }

    public void startDocumentBody() {
        if (this.getTrayDesign() != null) {
            this.write("<body class=\"urBdyStd ");
            this.write(TrayDesign.getDesignClass(this.getTrayDesign()));
            this.write("\">");
        } else {
            this.write("<body class=\"urBdyStd\">");
        }
        this.document.render(3, this);
    }

    public void endDocumentBody() {
        HashSet menus = this.document.getHoverMenus();
        int maxDepth = 0;
        HashSet hoverMenus = this.document.getHoverMenus();
        if (menus != null && !menus.isEmpty()) {
            Iterator hoverIt = hoverMenus.iterator();
            while (hoverIt.hasNext()) {
                HoverMenu menu = (HoverMenu)hoverIt.next();
                int tempDepth = menu.getMenuDepth();
                if (maxDepth < tempDepth) {
                    maxDepth = tempDepth;
                }
                this.render(menu);
            }
        }
        this.document.render(4, this);
        this.write("</body>");
    }

    public void endDocument() {
        if (this.getWriter() instanceof BufferedWriter) {
            Includes documentIncludes = new Includes();
            HashSet stylesheets = this.getStylesheets();
            Iterator it = stylesheets.iterator();
            String devider = "_";
            String stylepath = null;
            String styleroot = this.getStylePath();
            while (it.hasNext()) {
                stylepath = styleroot + it.next().toString() + '_' + RendererManager.getBrowserAbbreviation(this.getBrowserId()) + ".css";
                documentIncludes.addHeadResource(ResourceType.CSS, "DEFAULT_CSS", stylepath);
            }
            documentIncludes.render(0, this);
        }
        this.write("</html>");
        this.flush();
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocumentId(String documentId) {
        if (this.document == null) {
            throw new IllegalStateException("Cannot set the document ID without creating a document first.");
        }
        this.document.setDocumentId(documentId);
    }

    public String getCurrentFormId() {
        if (this.document != null && this.currentForm != null) {
            return this.document.getDocumentId() + "_" + this.currentForm.getFormId();
        }
        return null;
    }

    public Form getCurrentForm() {
        return this.currentForm;
    }

    public Form getOldForm() {
        if (this.oldSubmittedForm == null) {
            this.checkFormElements();
        }
        return this.oldSubmittedForm;
    }

    public void setCurrentForm(Form form) {
        this.currentForm = form;
    }

    public void setAttribute(String key, Object value) {
        HttpSession mySession = this.httpServletRequest.getSession(true);
        mySession.setAttribute(key, value);
    }

    public Object getAttribute(String key) {
        HttpSession mySession = this.httpServletRequest.getSession(false);
        if (mySession != null) {
            return mySession.getAttribute(key);
        }
        return null;
    }

    public ResourceBundle getResourceBundle(String baseName, Locale locale) {
        if (locale == null) {
            locale = this.getLocale();
        }
        return ResourceBundle.getBundle(baseName, locale);
    }

    protected String attemptUTF8Encoding(String value) {
        String oldValue = null;
        String encoding = this.getHttpServletRequest().getCharacterEncoding();
        boolean decode = true;
        if (encoding != null && !this.isMultiPartMime() && (encoding.equalsIgnoreCase("UTF-8") || encoding.equalsIgnoreCase("UTF8"))) {
            decode = false;
        }
        if (this.cvUseUTF8Encoding && value != null && decode) {
            oldValue = value;
            try {
                int len = value.length();
                char[] chars = value.toCharArray();
                byte[] temp = new byte[len];
                int i = 0;
                while (i < chars.length) {
                    if ((chars[i] & 0xFF00) != 0) {
                        return oldValue;
                    }
                    temp[i] = (byte)chars[i];
                    ++i;
                }
                value = new String(temp, "UTF8");
            }
            catch (UnsupportedEncodingException e) {
                Log.getLogLocation(false).debugT("PageContext", "Decode UTF failed");
                return oldValue;
            }
        }
        return value;
    }

    protected void setUTF8Encoding(boolean encode) {
        this.cvUseUTF8Encoding = encode;
    }

    protected boolean getUTF8Encoding() {
        return this.cvUseUTF8Encoding;
    }

    public String getComponentIdForLabel(String id) {
        return this.getDocument().getDocumentId() + "_" + this.getCurrentForm().getComponentIdForLabel(id);
    }

    public ClientInfo getClientInfo() {
        return this.clientInfo;
    }

    public MobileWmlCard getHiddenCard() {
        return this.hiddenCard;
    }

    public String getUrMapiJavascriptUrl() {
        return this.getJavascriptPath() + RendererManager.getUrMapiJavascriptFileName(this.browserId);
    }

    public String getUrPopupJavascriptUrl() {
        return this.getJavascriptPath() + RendererManager.getUrPopupJavascriptFileName(this.browserId);
    }

    public boolean getIs508() {
        return this.requiresSection508Rendering();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public boolean getDomainRelaxation() {
        return this.relaxDomain;
    }

    public void setDomainRelaxation(boolean relaxDomain) {
        this.relaxDomain = relaxDomain;
    }

    public HashMap getParamList() {
        return this.newParamList;
    }

    public void setUsingSession(boolean useSession) {
        this.useSession = useSession;
    }

    public boolean isUsingSession() {
        return this.useSession;
    }

    protected void readOldParamList(String formId) {
        HttpServletRequest rq;
        HttpSession session;
        Object request = this.getRequest();
        if (request instanceof HttpServletRequest && (session = (rq = (HttpServletRequest)request).getSession(false)) != null) {
            this.oldParamList = (HashMap)session.getAttribute(formId);
        }
    }

    public void storeParametersInSession(String formId) {
        HttpServletRequest rq;
        HttpSession session;
        Object request = this.getRequest();
        if (request instanceof HttpServletRequest && (session = (rq = (HttpServletRequest)request).getSession(true)) != null) {
            this.newParamList = new HashMap();
            session.setAttribute(formId, (Object)this.newParamList);
        }
    }

    public Object getParent() {
        return this.parent;
    }

    public void setParent(Object parent) {
        this.parent = parent;
    }

    public void rebuildComponents() {
        long start = 0L;
        if (this.debug) {
            start = System.currentTimeMillis();
        }
        String id = null;
        HashSet<Component> collector = new HashSet<Component>();
        Component c = null;
        Form oldForm = this.getOldForm();
        if (oldForm != null) {
            oldForm.setClassLoader(this.getClassLoader());
            HashMap elements = oldForm.getRegisteredElements();
            HashMap composites = new HashMap();
            if (elements != null && elements.size() > 0) {
                int intId;
                Class myClass;
                int i;
                String componentId;
                Iterator iterElements = oldForm.getRegisteredElementNames();
                Form.FormElement element = null;
                while (iterElements.hasNext()) {
                    id = (String)iterElements.next();
                    element = (Form.FormElement)elements.get(id);
                    if (id == null || element == null) continue;
                    try {
                        componentId = element.getComponentClass();
                        i = componentId.indexOf("_");
                        if (i >= 0) {
                            componentId = componentId.substring(0, i);
                        }
                        myClass = null;
                        if ((class$com$sapportals$htmlb$AbstractCompositeComponent == null ? PageContext.class$("com.sapportals.htmlb.AbstractCompositeComponent") : class$com$sapportals$htmlb$AbstractCompositeComponent).isAssignableFrom(myClass = oldForm.getClassForId(intId = Integer.parseInt(componentId))) || (c = this.getComponentForId(id)) == null) continue;
                        collector.add(c);
                    }
                    catch (Exception e) {
                        Log.getLogLocation(false).debugT("PageContext", e.getMessage());
                    }
                }
                iterElements = oldForm.getRegisteredElementNames();
                while (iterElements.hasNext()) {
                    id = (String)iterElements.next();
                    element = (Form.FormElement)elements.get(id);
                    if (id == null || element == null) continue;
                    try {
                        componentId = element.getComponentClass();
                        i = componentId.indexOf("_");
                        if (i >= 0) {
                            componentId = componentId.substring(0, i);
                        }
                        myClass = null;
                        if (!(class$com$sapportals$htmlb$AbstractCompositeComponent == null ? PageContext.class$("com.sapportals.htmlb.AbstractCompositeComponent") : class$com$sapportals$htmlb$AbstractCompositeComponent).isAssignableFrom(myClass = oldForm.getClassForId(intId = Integer.parseInt(componentId))) || (c = this.getComponentForId(id)) == null) continue;
                        collector.add(c);
                    }
                    catch (Exception e) {
                        Log.getLogLocation(false).debugT("PageContext", e.getMessage());
                    }
                }
                Iterator colIter = collector.iterator();
                this.comps = new Component[collector.size()];
                int count = 0;
                while (colIter.hasNext()) {
                    c = (Component)colIter.next();
                    if (c == null) continue;
                    this.comps[count] = c;
                    ++count;
                }
            }
        }
        if (this.debug) {
            start = System.currentTimeMillis() - start;
            this.addPerfCounter("Rebuild components: " + start + "ms");
        }
    }

    public Component[] getComponents() {
        return this.comps;
    }

    public TrayDesign getTrayDesign() {
        return this.trayDesign;
    }

    public void setTrayDesign(TrayDesign trayDesign) {
        this.trayDesign = trayDesign;
    }

    public void flush() {
        if (this.getWriter() instanceof BufferedWriter) {
            ((BufferedWriter)this.getWriter()).writeBuffer();
        }
    }

    public void registerStylesheet(String key) {
        this.styleSheets.add(key);
    }

    public HashSet getStylesheets() {
        return this.styleSheets;
    }

    public boolean getIsRTL() {
        return this.rtl;
    }

    public void setRTL(boolean rtl) {
        this.rtl = rtl;
    }

    protected boolean queryRTL() {
        String language;
        Locale l = this.getLocale();
        return l != null && ((language = l.getLanguage()).equalsIgnoreCase("ar") || language.equalsIgnoreCase("he") || language.equalsIgnoreCase("iw"));
    }

    public Location getLogLocation() {
        return Log.getLogLocation(this.debug);
    }

    public String getDevice() {
        return "";
    }

    public boolean getHasAdvancedAlignment() {
        return this.advancedAlignment;
    }

    public void setAdvancedAlignment(boolean advancedAlignment) {
        this.advancedAlignment = advancedAlignment;
    }

    public void addPerfCounter(String line) {
        if (this.debug) {
            if (this.perfCounter == null) {
                this.perfCounter = new HashSet();
            }
            this.perfCounter.add(line + '\n');
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class BufferedWriter
    extends PrintWriter {
        private StringBuffer bodyContent = new StringBuffer();
        private StringBuffer headBegin = new StringBuffer();
        private StringBuffer headIncludes = new StringBuffer();

        public BufferedWriter(Writer w) {
            super(w);
        }

        public void write(char[] chars) {
            this.bodyContent.append(chars);
        }

        public void write(char[] chars, int off, int len) {
            this.bodyContent.append(chars, off, len);
        }

        public void write(int ch) {
            this.bodyContent.append((char)ch);
        }

        public void write(String s) {
            this.bodyContent.append(s);
        }

        public void writeHeadBegin(String s) {
            this.headBegin.append(s);
        }

        public void writeHeadIncludes(String s) {
            this.headIncludes.append(s);
        }

        public void writeBuffer() {
            try {
                Object object = this.lock;
                synchronized (object) {
                    int size = 0;
                    long start = 0L;
                    StringBuffer dbg = null;
                    if (PageContext.this.debug) {
                        dbg = new StringBuffer(50);
                        size = this.headBegin.length() + this.headIncludes.length() + this.bodyContent.length();
                        dbg.append("\n<!--\nHTMLB: Writing ");
                        dbg.append(size);
                        dbg.append("Bytes");
                        start = System.currentTimeMillis();
                    }
                    this.out.write(this.headBegin.toString());
                    this.out.write(this.headIncludes.toString());
                    this.out.write(this.bodyContent.toString());
                    if (PageContext.this.debug) {
                        start = System.currentTimeMillis() - start;
                        dbg.append("\nHTMLB: Writing took ");
                        dbg.append(start);
                        dbg.append("ms\n");
                        this.out.write(dbg.toString());
                    }
                }
            }
            catch (InterruptedIOException x) {
                Thread.currentThread().interrupt();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected class UnbufferedWriter
    extends PrintWriter {
        public UnbufferedWriter(Writer w) {
            super(w);
        }

        public void write(String s) {
            try {
                Object object = this.lock;
                synchronized (object) {
                    this.out.write(s);
                }
            }
            catch (InterruptedIOException x) {
                Thread.currentThread().interrupt();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void write(int c) {
            char[] chars = new char[]{(char)c};
            try {
                Object object = this.lock;
                synchronized (object) {
                    this.out.write(chars, 0, 1);
                }
            }
            catch (InterruptedIOException x) {
                Thread.currentThread().interrupt();
            }
            catch (IOException x) {
                // empty catch block
            }
        }
    }
}

