/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering;

import java.util.HashMap;
import java.util.Iterator;

public class MobileWmlCard {
    private String id;
    private String action = "#";
    private HashMap postFields;
    private boolean noCacheSupported;

    public MobileWmlCard(String id, boolean noCacheSupported) {
        this.id = id;
        this.noCacheSupported = noCacheSupported;
        this.postFields = new HashMap();
    }

    public void addPostField(String name, String value) {
        PostField postField = new PostField(name, value);
        this.postFields.put(name, postField);
    }

    public String getId() {
        return this.id;
    }

    public void putId(String id) {
        this.id = id;
    }

    public String getAction() {
        return this.action;
    }

    public void putAction(String action) {
        this.action = action;
    }

    public String toString() {
        String strCard = "<card title=\"post\" id=\"" + this.id + "\"><onevent type=\"onenterbackward\"><prev/></onevent>" + "<onevent type=\"onenterforward\"><go href=\"" + this.action + "\" method=\"post\"";
        if (this.noCacheSupported) {
            strCard = strCard + " cache-control=\"no-cache\"";
        }
        strCard = strCard + ">";
        Iterator it = this.postFields.values().iterator();
        while (it.hasNext()) {
            PostField current = (PostField)it.next();
            strCard = strCard + "<postfield name=\"" + current.name + "\" value=\"" + current.value + "\"/>";
        }
        strCard = strCard + "</go></onevent></card>";
        return strCard;
    }

    class PostField {
        public String name;
        public String value;

        PostField(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

