/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering;

import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;

public class MobileEventInterceptor {
    private HttpServletRequest request;

    public MobileEventInterceptor(HttpServletRequest request) {
        this.request = request;
    }

    public String getParameter(String name) {
        String value = this.request.getParameter(name);
        if (value == null || value.trim().length() <= 0) {
            String httpSubmit = this.getSubmit();
            if (httpSubmit != null) {
                if (name.indexOf("htmlbevt_ty") != -1) {
                    return this.getEvtTy(httpSubmit);
                }
                if (name.indexOf("htmlbevt_oid") != -1) {
                    return this.getEvtOid(httpSubmit);
                }
                if (name.indexOf("htmlbevt_id") != -1) {
                    return this.getEvtId(httpSubmit);
                }
                if (name.indexOf("htmlbevt_cnt") != -1) {
                    return this.getEvtCnt(httpSubmit);
                }
                if (name.indexOf("htmlbevt_par") != -1) {
                    return this.getEvtPar(httpSubmit, name);
                }
            }
        } else {
            return value;
        }
        return null;
    }

    public String getEvtTy(String httpSubmit) {
        int ibeg = this.indexOfOccur(httpSubmit, 44, 3) + 2;
        int iend = httpSubmit.indexOf(39, ibeg);
        return httpSubmit.substring(ibeg, iend);
    }

    public String getEvtOid(String httpSubmit) {
        int ibeg = this.indexOfOccur(httpSubmit, 44, 5) + 1;
        int iend = httpSubmit.indexOf(44, ibeg);
        return httpSubmit.substring(ibeg, iend);
    }

    public String getEvtId(String httpSubmit) {
        int ibeg = this.indexOfOccur(httpSubmit, 44, 6) + 1;
        int iend = httpSubmit.indexOf(44, ibeg);
        return httpSubmit.substring(ibeg, iend);
    }

    public String getEvtCnt(String httpSubmit) {
        int ibeg = this.indexOfOccur(httpSubmit, 44, 7) + 1;
        int iend = httpSubmit.indexOf(44, ibeg);
        if (iend == -1) {
            iend = httpSubmit.indexOf(41, ibeg);
        }
        return httpSubmit.substring(ibeg, iend);
    }

    public String getEvtPar(String httpSubmit, String name) {
        int parNumber = Integer.parseInt(name.substring(name.length() - 1));
        int ibeg = this.indexOfOccur(httpSubmit, 44, parNumber + 7) + 1;
        int iend = httpSubmit.indexOf(44, ibeg);
        if (iend == -1) {
            iend = httpSubmit.indexOf(41, ibeg);
        }
        return httpSubmit.substring(ibeg + 1, iend - 1);
    }

    private int indexOfOccur(String str, int ch, int num) {
        int idx = -1;
        int i = 0;
        while (i < num) {
            if ((idx = str.indexOf(ch, idx + 1)) < 0) break;
            ++i;
        }
        return idx;
    }

    private String getSubmit() {
        Enumeration enumeration = this.request.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String paramName = (String)enumeration.nextElement();
            if (paramName.indexOf("htmlbDoEvent(") != -1) {
                return paramName;
            }
            if (paramName.indexOf("htmlbSubmitElement") == -1 || this.request.getParameter("htmlbSubmitElement").indexOf("htmlbDoEvent(") == -1) continue;
            return this.decodeSingleQuote(this.request.getParameter("htmlbSubmitElement"));
        }
        return null;
    }

    private String encodeSingleQuote(String str) {
        return str.replace('\'', '#');
    }

    private String decodeSingleQuote(String str) {
        return str.replace('#', '\'');
    }
}

